/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;

public class XMLResourceImpl
extends ResourceImpl
implements XMLResource {
    protected Map idToEObjectMap;
    protected Map eObjectToIDMap;
    protected String encoding;
    protected boolean useZip;
    protected XMLLoad xmlLoad;
    protected XMLSaveImpl xmlSave;

    public XMLResourceImpl() {
        this.init();
    }

    public XMLResourceImpl(URI uRI) {
        super(uRI);
        this.init();
    }

    protected void init() {
        this.encoding = "ASCII";
    }

    protected boolean useIDs() {
        return true;
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
        }
        return this.defaultSaveOptions;
    }

    public Map getDefaultLoadOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    protected XMLHelper createXMLHelper() {
        return new XMLHelperImpl(this);
    }

    protected XMLLoad createXMLLoad() {
        return new XMLLoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new XMLSaveImpl(this.createXMLHelper());
    }

    public void doLoad(InputStream inputStream, Map map) throws IOException {
        XMLLoad xMLLoad = this.createXMLLoad();
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        xMLLoad.load(this, inputStream, map);
    }

    public void doSave(OutputStream outputStream, Map map) throws IOException {
        XMLSave xMLSave = this.createXMLSave();
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        xMLSave.save(this, outputStream, map);
    }

    public boolean useZip() {
        return this.useZip;
    }

    public void setUseZip(boolean bl) {
        this.useZip = bl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public Map getIDToEObjectMap() {
        if (this.idToEObjectMap == null) {
            this.idToEObjectMap = new HashMap();
        }
        return this.idToEObjectMap;
    }

    public Map getEObjectToIDMap() {
        if (this.eObjectToIDMap == null) {
            this.eObjectToIDMap = new HashMap();
        }
        return this.eObjectToIDMap;
    }

    public String getID(EObject eObject) {
        if (this.eObjectToIDMap == null) {
            return null;
        }
        return (String)this.eObjectToIDMap.get(eObject);
    }

    public void setID(EObject eObject, String string) {
        String string2 = this.getEObjectToIDMap().put(eObject, string);
        if (string2 != null) {
            this.getIDToEObjectMap().remove(string2);
        }
        this.getIDToEObjectMap().put(string, eObject);
    }

    public String getURIFragment(EObject eObject) {
        String string = this.getID(eObject);
        if (string != null) {
            return string;
        }
        return super.getURIFragment(eObject);
    }

    protected EObject getEObjectByID(String string) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(string)) != null) {
            return eObject;
        }
        return super.getEObjectByID(string);
    }

    protected boolean isPath(String string) {
        return string.startsWith("/");
    }

    public void attached(EObject eObject) {
        if (this.useIDs()) {
            String string;
            if (this.modificationTrackingAdapter != null) {
                eObject.eAdapters().add(this.modificationTrackingAdapter);
            }
            if ((string = this.getID(eObject)) != null) {
                this.getIDToEObjectMap().put(string, eObject);
            }
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject2 = (EObject)treeIterator.next();
                String string2 = this.getID(eObject2);
                if (string2 != null) {
                    this.getIDToEObjectMap().put(string2, eObject2);
                }
                if (this.modificationTrackingAdapter == null) continue;
                eObject2.eAdapters().add(this.modificationTrackingAdapter);
            }
        } else {
            super.attached(eObject);
        }
    }

    public void detached(EObject eObject) {
        if (this.useIDs()) {
            eObject.eAdapters().remove(this.modificationTrackingAdapter);
            if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                this.idToEObjectMap.remove(this.eObjectToIDMap.remove(eObject));
            }
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject2 = (EObject)treeIterator.next();
                if (this.idToEObjectMap != null && this.eObjectToIDMap != null) {
                    this.idToEObjectMap.remove(this.eObjectToIDMap.remove(eObject2));
                }
                eObject2.eAdapters().remove(this.modificationTrackingAdapter);
            }
        } else {
            super.detached(eObject);
        }
    }

    protected void doUnload() {
        super.doUnload();
        if (this.idToEObjectMap != null) {
            this.idToEObjectMap.clear();
        }
        if (this.eObjectToIDMap != null) {
            this.eObjectToIDMap.clear();
        }
    }

    public String toKeyString() {
        StringBuffer stringBuffer = new StringBuffer("Key type: ");
        stringBuffer.append(this.getClass().toString());
        if (this.idToEObjectMap != null) {
            Object object;
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Iterator iterator = this.idToEObjectMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                treeMap.put(object.toString(), object);
            }
            object = treeMap.values().iterator();
            while (object.hasNext()) {
                Object e = object.next();
                Object v = this.idToEObjectMap.get(e);
                stringBuffer.append("\r\n\t[Key=" + e + ", Value=" + v + "]");
            }
        }
        return stringBuffer.toString();
    }
}

