/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLString;

public class XMLSaveImpl
implements XMLSave {
    protected XMLHelper helper;
    protected XMLString doc;
    protected boolean declareXSI;
    protected boolean useEncodedAttributeStyle;
    protected boolean declareXML;
    protected Escape escape;
    protected Lookup featureTable;
    protected String encoding;
    protected String idAttributeName = "id";
    protected String processDanglingHREF;
    protected boolean declareSchemaLocation;
    protected static final int SKIP = 0;
    protected static final int SAME_DOC = 1;
    protected static final int CROSS_DOC = 2;
    protected static final int TRANSIENT = 0;
    protected static final int DATATYPE_SINGLE = 1;
    protected static final int DATATYPE_ELEMENT_SINGLE = 2;
    protected static final int DATATYPE_CONTENT_SINGLE = 3;
    protected static final int DATATYPE_SINGLE_NILLABLE = 4;
    protected static final int DATATYPE_MANY = 5;
    protected static final int OBJECT_CONTAIN_SINGLE = 6;
    protected static final int OBJECT_CONTAIN_MANY = 7;
    protected static final int OBJECT_HREF_SINGLE = 8;
    protected static final int OBJECT_HREF_MANY = 9;
    protected static final int OBJECT_CONTAIN_SINGLE_UNSETTABLE = 10;
    protected static final int OBJECT_CONTAIN_MANY_UNSETTABLE = 11;
    protected static final int OBJECT_HREF_SINGLE_UNSETTABLE = 12;
    protected static final int OBJECT_HREF_MANY_UNSETTABLE = 13;
    protected static final int OBJECT_ELEMENT_SINGLE = 14;
    protected static final int OBJECT_ELEMENT_MANY = 15;
    protected static final String XML_VERSION = "1.0";
    protected static final String XSI_NIL = "xsi:nil";
    protected static final String XSI_TYPE_NS = "xsi:type";
    protected static final String XSI_XMLNS = "xmlns:xsi";
    protected static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    protected static final String XSI_NO_NAMESPACE_SCHEMA_LOCATION = "xsi:noNamespaceSchemaLocation";
    protected static final int EMPTY_ELEMENT = 1;
    protected static final int CONTENT_ELEMENT = 2;

    public XMLSaveImpl(XMLHelper xMLHelper) {
        this.helper = xMLHelper;
    }

    public XMLSaveImpl(Map map, XMLHelper xMLHelper, String string) {
        this.helper = xMLHelper;
        this.init(xMLHelper.getResource(), map);
        this.encoding = string;
    }

    public void save(XMLResource xMLResource, OutputStream outputStream, Map map) throws IOException {
        Object object;
        this.init(xMLResource, map);
        this.traverse(xMLResource.getContents());
        if (this.encoding.equals("US-ASCII") || this.encoding.equals("ASCII")) {
            this.writeAscii(outputStream);
            outputStream.flush();
        } else {
            object = new OutputStreamWriter(outputStream, this.helper.getJavaEncoding(this.encoding));
            this.write((OutputStreamWriter)object);
            ((OutputStreamWriter)object).flush();
        }
        this.featureTable = null;
        this.doc = null;
        if ((this.processDanglingHREF == null || "THROW".equals(this.processDanglingHREF)) && (object = this.helper.getDanglingHREFException()) != null) {
            this.helper = null;
            throw new Resource.IOWrappedException((Exception)object);
        }
        this.helper = null;
    }

    protected void init(XMLResource xMLResource, Map map) {
        this.declareXSI = false;
        this.useEncodedAttributeStyle = Boolean.TRUE.equals(map.get("USE_ENCODED_ATTRIBUTE_STYLE"));
        this.declareXML = !Boolean.FALSE.equals(map.get("DECLARE_XML"));
        this.declareSchemaLocation = Boolean.TRUE.equals(map.get("SCHEMA_LOCATION"));
        Integer n = (Integer)map.get("LINE_WIDTH");
        this.doc = new XMLString(n == null ? Integer.MAX_VALUE : n);
        Escape escape = this.escape = Boolean.TRUE.equals(map.get("SKIP_ESCAPE")) ? null : new Escape();
        if (map.containsKey("ENCODING")) {
            this.encoding = (String)map.get("ENCODING");
        } else if (xMLResource != null) {
            this.encoding = xMLResource.getEncoding();
        }
        this.processDanglingHREF = (String)map.get("PROCESS_DANGLING_HREF");
        this.helper.setProcessDanglingHREF(this.processDanglingHREF);
        XMLResource.XMLMap xMLMap = (XMLResource.XMLMap)map.get("XML_MAP");
        if (xMLMap != null) {
            this.helper.setXMLMap(xMLMap);
            if (xMLMap.getIDAttributeName() != null) {
                this.idAttributeName = xMLMap.getIDAttributeName();
            }
        }
        this.featureTable = new Lookup(xMLMap);
    }

    public void traverse(List list) {
        int n;
        if (this.declareXML) {
            this.doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.doc.addLine();
        }
        Object object = (n = list.size()) == 1 ? this.writeTopObject((EObject)list.get(0)) : this.writeTopObjects(list);
        this.doc.resetToMark(object);
        this.addNamespaceDeclarations();
    }

    protected Object writeTopObject(EObject eObject) {
        EClass eClass = eObject.eClass();
        String string = this.helper.getQName(eClass);
        this.doc.startElement(string);
        Object object = this.doc.mark();
        this.saveElementID(eObject);
        return object;
    }

    protected Object writeTopObjects(List list) {
        EObject eObject = (EObject)list.get(0);
        EClass eClass = eObject.eClass();
        String string = this.helper.getQName(eClass);
        this.doc.startElement(string);
        Object object = this.doc.mark();
        this.saveElementID(eObject);
        return object;
    }

    protected void addNamespaceDeclarations() {
        Object object;
        Object object2;
        EPackage ePackage;
        int n;
        EPackage ePackage2 = this.helper.getNoNamespacePackage();
        EPackage[] ePackageArray = this.helper.packages();
        StringBuffer stringBuffer = null;
        String string = null;
        if (this.declareSchemaLocation) {
            n = 0;
            while (n < ePackageArray.length) {
                ePackage = ePackageArray[n];
                object2 = EcoreUtil.getRootContainer(ePackage);
                if (object2 instanceof EPackage) {
                    object = (EPackage)object2;
                    if (ePackage2 == object) {
                        this.declareXSI = true;
                        string = this.helper.getHREF((EObject)object);
                    } else {
                        Resource resource = object.eResource();
                        if (resource != null) {
                            URI uRI = resource.getURI();
                            String string2 = object.getNsURI();
                            boolean bl = uRI == null ? string2 != null : !uRI.toString().equals(string2);
                            if (bl) {
                                this.declareXSI = true;
                                if (stringBuffer == null) {
                                    stringBuffer = new StringBuffer();
                                } else {
                                    stringBuffer.append(' ');
                                }
                                stringBuffer.append(string2);
                                stringBuffer.append(' ');
                                stringBuffer.append(this.helper.getHREF((EObject)object));
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (this.declareXSI) {
            this.doc.addAttribute(XSI_XMLNS, "http://www.w3.org/2001/XMLSchema-instance");
        }
        n = 0;
        while (n < ePackageArray.length) {
            ePackage = ePackageArray[n];
            if (ePackage != ePackage2) {
                object2 = ePackage.getNsURI();
                object = ePackage.getNsPrefix();
                this.doc.addAttributeNS("xmlns", (String)object, (String)object2);
            }
            ++n;
        }
        if (stringBuffer != null) {
            this.doc.addAttribute(XSI_SCHEMA_LOCATION, stringBuffer.toString());
        }
        if (string != null) {
            this.doc.addAttribute(XSI_NO_NAMESPACE_SCHEMA_LOCATION, string);
        }
    }

    public void write(OutputStreamWriter outputStreamWriter) throws IOException {
        char[] cArray = new char[8192];
        int n = 0;
        Iterator iterator = this.doc.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.length();
            if (n2 + n >= cArray.length) {
                outputStreamWriter.write(cArray, 0, n);
                n = 0;
                if (n2 > cArray.length) {
                    cArray = new char[n2];
                }
            }
            string.getChars(0, n2, cArray, n);
            n += n2;
        }
        outputStreamWriter.write(cArray, 0, n);
        outputStreamWriter.flush();
    }

    public void writeAscii(OutputStream outputStream) throws IOException {
        char[] cArray = new char[8192];
        byte[] byArray = new byte[8192];
        int n = 0;
        Iterator iterator = this.doc.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.length();
            if (n2 + n >= cArray.length) {
                int n3 = 0;
                while (n3 < n) {
                    byArray[n3] = (byte)(cArray[n3] & 0xFF);
                    ++n3;
                }
                outputStream.write(byArray, 0, n);
                n = 0;
                if (n2 > cArray.length) {
                    cArray = new char[n2];
                    byArray = new byte[n2];
                }
            }
            string.getChars(0, n2, cArray, n);
            n += n2;
        }
        int n4 = 0;
        while (n4 < n) {
            byArray[n4] = (byte)(cArray[n4] & 0xFF);
            ++n4;
        }
        outputStream.write(byArray, 0, n);
        outputStream.flush();
    }

    public char[] toChar() {
        int n = this.doc.getLength();
        char[] cArray = new char[n];
        this.doc.getChars(cArray, 0);
        return cArray;
    }

    protected void saveElement(EObject eObject, EStructuralFeature eStructuralFeature) {
        XMLResource.XMLMap xMLMap = this.helper.getXMLMap();
        EClass eClass = eObject.eClass();
        XMLResource.XMLInfo xMLInfo = xMLMap == null ? null : xMLMap.getInfo(eClass);
        boolean bl = true;
        if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 0) {
            String string = this.helper.getQName(eClass);
            this.doc.startElement(string);
            bl = false;
        } else {
            String string = this.helper.getQName(eStructuralFeature);
            this.doc.startElement(string);
        }
        if (bl && eClass != eStructuralFeature.getEType()) {
            this.saveTypeAttribute(eClass);
        }
        this.saveElementID(eObject);
    }

    protected void saveTypeAttribute(EClass eClass) {
        this.declareXSI = true;
        this.doc.addAttribute(XSI_TYPE_NS, this.helper.getQName(eClass));
    }

    protected boolean saveFeatures(EObject eObject) {
        EClass eClass = eObject.eClass();
        EStructuralFeature[] eStructuralFeatureArray = this.featureTable.getFeatures(eClass);
        int[] nArray = this.featureTable.getKinds(eClass, eStructuralFeatureArray);
        int[] nArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < eStructuralFeatureArray.length) {
            int n3 = nArray[n2];
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
            if (n3 != 0 && eObject.eIsSet(eStructuralFeature)) {
                switch (n3) {
                    case 2: {
                        if (nArray2 == null) {
                            nArray2 = new int[eStructuralFeatureArray.length];
                        }
                        nArray2[n++] = n2;
                        break;
                    }
                    case 1: {
                        this.saveDataTypeSingle(eObject, eStructuralFeature);
                        break;
                    }
                    case 4: {
                        if (this.isNil(eObject, eStructuralFeature)) {
                            if (nArray2 == null) {
                                nArray2 = new int[eStructuralFeatureArray.length];
                            }
                            nArray2[n++] = n2;
                            break;
                        }
                        this.saveDataTypeSingle(eObject, eStructuralFeature);
                        break;
                    }
                    case 12: {
                        if (this.isNil(eObject, eStructuralFeature)) {
                            if (nArray2 == null) {
                                nArray2 = new int[eStructuralFeatureArray.length];
                            }
                            nArray2[n++] = n2;
                            break;
                        }
                    }
                    case 8: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectSingle(eObject, eStructuralFeature);
                            break;
                        }
                        switch (this.sameDocSingle(eObject, eStructuralFeature)) {
                            case 1: {
                                this.saveIDRefSingle(eObject, eStructuralFeature);
                                break;
                            }
                            case 2: {
                                if (nArray2 == null) {
                                    nArray2 = new int[eStructuralFeatureArray.length];
                                }
                                nArray2[n++] = n2;
                            }
                        }
                        break;
                    }
                    case 13: {
                        if (this.isEmpty(eObject, eStructuralFeature)) {
                            this.saveManyEmpty(eStructuralFeature);
                            break;
                        }
                    }
                    case 9: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectMany(eObject, eStructuralFeature);
                            break;
                        }
                        switch (this.sameDocMany(eObject, eStructuralFeature)) {
                            case 1: {
                                this.saveIDRefMany(eObject, eStructuralFeature);
                                break;
                            }
                            case 2: {
                                if (nArray2 == null) {
                                    nArray2 = new int[eStructuralFeatureArray.length];
                                }
                                nArray2[n++] = n2;
                            }
                        }
                        break;
                    }
                    case 5: 
                    case 11: {
                        if (this.isEmpty(eObject, eStructuralFeature)) {
                            this.saveManyEmpty(eStructuralFeature);
                            break;
                        }
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: {
                        if (nArray2 == null) {
                            nArray2 = new int[eStructuralFeatureArray.length];
                        }
                        nArray2[n++] = n2;
                    }
                }
            }
            ++n2;
        }
        String string = this.getContent(eObject, eStructuralFeatureArray);
        if (nArray2 == null) {
            if (string == null) {
                this.endSaveFeatures(eObject, 1, null);
                return false;
            }
            this.endSaveFeatures(eObject, 2, string);
            return true;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = nArray[nArray2[n4]];
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[nArray2[n4]];
            switch (n5) {
                case 4: {
                    this.saveNil(eStructuralFeature);
                    break;
                }
                case 5: {
                    this.saveDataTypeMany(eObject, eStructuralFeature);
                    break;
                }
                case 2: {
                    this.saveDataTypeElementSingle(eObject, eStructuralFeature);
                    break;
                }
                case 10: {
                    if (this.isNil(eObject, eStructuralFeature)) {
                        this.saveNil(eStructuralFeature);
                        break;
                    }
                }
                case 6: {
                    this.saveContainedSingle(eObject, eStructuralFeature);
                    break;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(eObject, eStructuralFeature);
                    break;
                }
                case 12: {
                    if (this.isNil(eObject, eStructuralFeature)) {
                        this.saveNil(eStructuralFeature);
                        break;
                    }
                }
                case 8: {
                    this.saveHRefSingle(eObject, eStructuralFeature);
                    break;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(eObject, eStructuralFeature);
                    break;
                }
                case 14: {
                    this.saveElementReferenceSingle(eObject, eStructuralFeature);
                    break;
                }
                case 15: {
                    this.saveElementReferenceMany(eObject, eStructuralFeature);
                }
            }
            ++n4;
        }
        this.endSaveFeatures(eObject, 0, null);
        return true;
    }

    protected void endSaveFeatures(EObject eObject, int n, String string) {
        switch (n) {
            case 1: {
                this.doc.endEmptyElement();
                break;
            }
            case 2: {
                this.doc.endContentElement(string);
                break;
            }
            default: {
                this.doc.endElement();
            }
        }
    }

    protected void saveDataTypeSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EDataType eDataType = (EDataType)eStructuralFeature.getEType();
        EPackage ePackage = eDataType.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        Object object = this.helper.getValue(eObject, eStructuralFeature);
        if (object != null) {
            String string = eFactory.convertToString(eDataType, object);
            if (this.escape != null) {
                string = this.escape.convert(string);
            }
            this.doc.addAttribute(this.helper.getQName(eStructuralFeature), string);
        }
    }

    protected boolean isNil(EObject eObject, EStructuralFeature eStructuralFeature) {
        return this.helper.getValue(eObject, eStructuralFeature) == null;
    }

    protected boolean isEmpty(EObject eObject, EStructuralFeature eStructuralFeature) {
        return ((List)this.helper.getValue(eObject, eStructuralFeature)).isEmpty();
    }

    protected void saveNil(EStructuralFeature eStructuralFeature) {
        String string = this.helper.getQName(eStructuralFeature);
        this.doc.startElement(string);
        this.doc.addAttribute(XSI_NIL, "true");
        this.doc.endEmptyElement();
        this.declareXSI = true;
    }

    protected void saveManyEmpty(EStructuralFeature eStructuralFeature) {
        this.doc.addAttribute(this.helper.getQName(eStructuralFeature), "");
    }

    protected void saveDataTypeMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        EDataType eDataType = (EDataType)eStructuralFeature.getEType();
        EPackage ePackage = eDataType.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        List list = (List)this.helper.getValue(eObject, eStructuralFeature);
        int n = list.size();
        if (n > 0) {
            String string = this.helper.getQName(eStructuralFeature);
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (e == null) {
                    this.doc.startElement(string);
                    this.doc.addAttribute(XSI_NIL, "true");
                    this.doc.endEmptyElement();
                    this.declareXSI = true;
                } else {
                    this.doc.startElement(string);
                    String string2 = eFactory.convertToString(eDataType, e);
                    if (this.escape != null) {
                        string2 = this.escape.convert(string2);
                    }
                    this.doc.endContentElement(string2);
                }
                ++n2;
            }
        }
    }

    protected void saveEObjectSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eObject2 = (EObject)this.helper.getValue(eObject, eStructuralFeature);
        if (eObject2 != null) {
            String string = this.helper.getQName(eStructuralFeature);
            String string2 = this.helper.getHREF(eObject2);
            if (string2 != null) {
                EClass eClass;
                EClass eClass2;
                this.doc.startAttribute(string);
                if (!string2.startsWith("#") && (eClass2 = eObject2.eClass()) != (eClass = (EClass)eStructuralFeature.getEType()) && eClass.isAbstract()) {
                    this.doc.addAttributeContent(this.helper.getQName(eClass2));
                    this.doc.addAttributeContent(" ");
                }
                this.doc.addAttributeContent(string2);
                this.doc.endAttribute();
            }
        }
    }

    protected void saveEObjectMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)this.helper.getValue(eObject, eStructuralFeature);
        if (!internalEList.isEmpty()) {
            String string = this.helper.getQName(eStructuralFeature);
            this.doc.startAttribute(string);
            Iterator iterator = internalEList.basicIterator();
            while (true) {
                EObject eObject2;
                String string2;
                if ((string2 = this.helper.getHREF(eObject2 = (EObject)iterator.next())) != null) {
                    EClass eClass;
                    EClass eClass2;
                    if (!string2.startsWith("#") && (eClass2 = eObject2.eClass()) != (eClass = (EClass)eStructuralFeature.getEType()) && eClass.isAbstract()) {
                        this.doc.addAttributeContent(this.helper.getQName(eClass2));
                        this.doc.addAttributeContent(" ");
                    }
                    this.doc.addAttributeContent(string2);
                }
                if (!iterator.hasNext()) break;
                this.doc.addAttributeContent(" ");
            }
            this.doc.endAttribute();
        }
    }

    protected void saveIDRefSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eObject2 = (EObject)this.helper.getValue(eObject, eStructuralFeature);
        if (eObject2 != null) {
            String string = this.helper.getQName(eStructuralFeature);
            String string2 = this.helper.getIDREF(eObject2);
            this.doc.addAttribute(string, string2);
        }
    }

    protected void saveIDRefMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)this.helper.getValue(eObject, eStructuralFeature);
        if (!internalEList.isEmpty()) {
            String string = this.helper.getQName(eStructuralFeature);
            StringBuffer stringBuffer = new StringBuffer(internalEList.size() * 10);
            Iterator iterator = internalEList.basicIterator();
            while (true) {
                EObject eObject2 = (EObject)iterator.next();
                String string2 = this.helper.getIDREF(eObject2);
                stringBuffer.append(string2);
                if (!iterator.hasNext()) break;
                stringBuffer.append(" ");
            }
            this.doc.addAttribute(string, stringBuffer.toString());
        }
    }

    protected void saveElementReference(EObject eObject, EStructuralFeature eStructuralFeature) {
        String string = this.helper.getQName(eStructuralFeature);
        String string2 = this.helper.getHREF(eObject);
        if (string2 != null) {
            this.doc.startElement(string);
            this.doc.endContentElement(string2);
        }
    }

    protected void saveElementReferenceSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eObject2 = (EObject)this.helper.getValue(eObject, eStructuralFeature);
        if (eObject2 != null) {
            this.saveElementReference(eObject2, eStructuralFeature);
        }
    }

    protected void saveElementReferenceMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)this.helper.getValue(eObject, eStructuralFeature);
        int n = internalEList.size();
        int n2 = 0;
        while (n2 < n) {
            this.saveElementReference((EObject)internalEList.get(n2), eStructuralFeature);
            ++n2;
        }
    }

    protected void saveHref(EObject eObject, EStructuralFeature eStructuralFeature) {
        String string = this.helper.getQName(eStructuralFeature);
        String string2 = this.helper.getHREF(eObject);
        if (string2 != null) {
            this.doc.startElement(string);
            EClass eClass = eObject.eClass();
            EClass eClass2 = (EClass)eStructuralFeature.getEType();
            if (eClass != eClass2 && eClass2.isAbstract()) {
                this.saveTypeAttribute(eClass);
            }
            this.doc.addAttribute("href", string2);
            this.doc.endEmptyElement();
        }
    }

    protected void saveHRefSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eObject2 = (EObject)this.helper.getValue(eObject, eStructuralFeature);
        if (eObject2 != null) {
            this.saveHref(eObject2, eStructuralFeature);
        }
    }

    protected void saveHRefMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)this.helper.getValue(eObject, eStructuralFeature);
        int n = internalEList.size();
        int n2 = 0;
        while (n2 < n) {
            this.saveHref((EObject)internalEList.get(n2), eStructuralFeature);
            ++n2;
        }
    }

    protected void saveContainedSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        EObject eObject2 = (EObject)this.helper.getValue(eObject, eStructuralFeature);
        if (eObject2 != null) {
            this.saveElement(eObject2, eStructuralFeature);
        }
    }

    protected void saveContainedMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        List list = (List)this.helper.getValue(eObject, eStructuralFeature);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            EObject eObject2 = (EObject)list.get(n2);
            if (eObject2 != null) {
                this.saveElement(eObject2, eStructuralFeature);
            }
            ++n2;
        }
    }

    protected int sameDocSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEObject internalEObject = (InternalEObject)this.helper.getValue(eObject, eStructuralFeature);
        if (internalEObject == null) {
            return 0;
        }
        if (internalEObject.eIsProxy()) {
            return 2;
        }
        Resource resource = internalEObject.eResource();
        return resource == this.helper.getResource() ? 1 : 2;
    }

    protected int sameDocMany(EObject eObject, EStructuralFeature eStructuralFeature) {
        InternalEList internalEList = (InternalEList)this.helper.getValue(eObject, eStructuralFeature);
        if (internalEList.isEmpty()) {
            return 0;
        }
        Iterator iterator = internalEList.basicIterator();
        while (iterator.hasNext()) {
            InternalEObject internalEObject = (InternalEObject)iterator.next();
            if (!internalEObject.eIsProxy() && internalEObject.eResource() == this.helper.getResource()) continue;
            return 2;
        }
        return 1;
    }

    protected String getContent(EObject eObject, EStructuralFeature[] eStructuralFeatureArray) {
        XMLResource.XMLMap xMLMap = this.helper.getXMLMap();
        if (xMLMap == null) {
            return null;
        }
        int n = 0;
        while (n < eStructuralFeatureArray.length) {
            XMLResource.XMLInfo xMLInfo = xMLMap.getInfo(eStructuralFeatureArray[n]);
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 2) {
                Object object = this.helper.getValue(eObject, eStructuralFeatureArray[n]);
                if (object == null) {
                    return null;
                }
                EDataType eDataType = (EDataType)eStructuralFeatureArray[n].getEType();
                EPackage ePackage = eDataType.getEPackage();
                EFactory eFactory = ePackage.getEFactoryInstance();
                String string = eFactory.convertToString(eDataType, object);
                if (this.escape != null) {
                    string = this.escape.convert(string);
                }
                return string;
            }
            ++n;
        }
        return null;
    }

    protected void saveDataTypeElementSingle(EObject eObject, EStructuralFeature eStructuralFeature) {
        String string = this.helper.getQName(eStructuralFeature);
        Object object = this.helper.getValue(eObject, eStructuralFeature);
        if (object == null) {
            this.doc.startElement(string);
            this.doc.addAttribute(XSI_NIL, "true");
            this.doc.endEmptyElement();
            this.declareXSI = true;
        } else {
            EDataType eDataType = (EDataType)eStructuralFeature.getEType();
            EPackage ePackage = eDataType.getEPackage();
            EFactory eFactory = ePackage.getEFactoryInstance();
            this.doc.startElement(string);
            String string2 = eFactory.convertToString(eDataType, object);
            if (this.escape != null) {
                string2 = this.escape.convert(string2);
            }
            this.doc.endContentElement(string2);
        }
    }

    protected void saveElementID(EObject eObject) {
        String string = this.helper.getID(eObject);
        if (string != null) {
            this.doc.addAttribute(this.idAttributeName, string);
        }
        this.saveFeatures(eObject);
    }

    protected static class Escape {
        protected char[] value;
        protected final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
        protected final char[] LESS = new char[]{'&', 'l', 't', ';'};
        protected final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        protected final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
        protected final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
        protected final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};

        Escape() {
            this.value = new char[100];
        }

        public String convert(String string) {
            boolean bl = false;
            int n = string.length();
            this.grow(n);
            string.getChars(0, n, this.value, 0);
            int n2 = 0;
            while (n-- > 0) {
                switch (this.value[n2]) {
                    case '&': {
                        n2 = this.replace(n2, this.AMP, n);
                        bl = true;
                        break;
                    }
                    case '<': {
                        n2 = this.replace(n2, this.LESS, n);
                        bl = true;
                        break;
                    }
                    case '\"': {
                        n2 = this.replace(n2, this.QUOTE, n);
                        bl = true;
                        break;
                    }
                    case '\n': {
                        n2 = this.replace(n2, this.LF, n);
                        bl = true;
                        break;
                    }
                    case '\r': {
                        n2 = this.replace(n2, this.CR, n);
                        bl = true;
                        break;
                    }
                    case '\t': {
                        n2 = this.replace(n2, this.TAB, n);
                        bl = true;
                        break;
                    }
                    default: {
                        ++n2;
                    }
                }
            }
            return bl ? new String(this.value, 0, n2) : string;
        }

        protected int replace(int n, char[] cArray, int n2) {
            int n3 = cArray.length;
            int n4 = n + n3;
            this.grow(n4 + n2);
            System.arraycopy(this.value, n + 1, this.value, n4, n2);
            System.arraycopy(cArray, 0, this.value, n, n3);
            return n4;
        }

        protected void grow(int n) {
            int n2 = this.value.length;
            if (n2 < n) {
                char[] cArray = new char[n + n / 2];
                System.arraycopy(this.value, 0, cArray, 0, n2);
                this.value = cArray;
            }
        }
    }

    protected static class Lookup {
        protected static final int SIZE = 4095;
        protected EClass[] classes;
        protected EStructuralFeature[][] features;
        protected int[][] featureKinds;
        protected XMLResource.XMLMap map;

        Lookup(XMLResource.XMLMap xMLMap) {
            this.map = xMLMap;
            this.classes = new EClass[4096];
            this.features = new EStructuralFeature[4096][];
            this.featureKinds = new int[4096][];
        }

        public EStructuralFeature[] getFeatures(EClass eClass) {
            int n = eClass.hashCode() & 0xFFF;
            EClass eClass2 = this.classes[n];
            if (eClass2 == eClass) {
                return this.features[n];
            }
            EStructuralFeature[] eStructuralFeatureArray = this.listFeatures(eClass);
            if (eClass2 == null) {
                this.classes[n] = eClass;
                this.features[n] = eStructuralFeatureArray;
                this.featureKinds[n] = this.listKinds(eStructuralFeatureArray);
            }
            return eStructuralFeatureArray;
        }

        public int[] getKinds(EClass eClass, EStructuralFeature[] eStructuralFeatureArray) {
            int n = eClass.hashCode() & 0xFFF;
            EClass eClass2 = this.classes[n];
            if (eClass2 == eClass) {
                return this.featureKinds[n];
            }
            int[] nArray = this.listKinds(eStructuralFeatureArray);
            if (eClass2 == null) {
                this.classes[n] = eClass;
                this.features[n] = eStructuralFeatureArray;
                this.featureKinds[n] = nArray;
            }
            return nArray;
        }

        protected EStructuralFeature[] listFeatures(EClass eClass) {
            EList eList = this.map == null ? eClass.getEAllStructuralFeatures() : this.map.getFeatures(eClass);
            return eList.toArray(new EStructuralFeature[eList.size()]);
        }

        protected int[] listKinds(EStructuralFeature[] eStructuralFeatureArray) {
            int[] nArray = new int[eStructuralFeatureArray.length];
            int n = eStructuralFeatureArray.length - 1;
            while (n >= 0) {
                nArray[n] = this.featureKind(eStructuralFeatureArray[n]);
                --n;
            }
            return nArray;
        }

        protected int featureKind(EStructuralFeature eStructuralFeature) {
            if (eStructuralFeature.isTransient()) {
                return 0;
            }
            boolean bl = eStructuralFeature.isMany();
            boolean bl2 = eStructuralFeature.isUnsettable();
            if (eStructuralFeature instanceof EReference) {
                XMLResource.XMLInfo xMLInfo;
                EReference eReference = (EReference)eStructuralFeature;
                if (eReference.isContainment()) {
                    return bl ? (bl2 ? 11 : 7) : (bl2 ? 10 : 6);
                }
                EReference eReference2 = eReference.getEOpposite();
                if (eReference2 != null && eReference2.isContainment()) {
                    return 0;
                }
                if (this.map != null && (xMLInfo = this.map.getInfo(eStructuralFeature)) != null && xMLInfo.getXMLRepresentation() == 0) {
                    return bl ? 15 : 14;
                }
                return bl ? (bl2 ? 13 : 9) : (bl2 ? 12 : 8);
            }
            EDataType eDataType = (EDataType)eStructuralFeature.getEType();
            if (!eDataType.isSerializable()) {
                return 0;
            }
            if (bl) {
                return 5;
            }
            if (bl2 && this.map == null) {
                return 4;
            }
            if (this.map == null) {
                return 1;
            }
            XMLResource.XMLInfo xMLInfo = this.map.getInfo(eStructuralFeature);
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 0) {
                return 2;
            }
            if (xMLInfo != null && xMLInfo.getXMLRepresentation() == 2) {
                return 3;
            }
            if (bl2) {
                return 4;
            }
            return 1;
        }
    }
}

