/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.xmi.impl.StringSegment;

public class XMLString
extends StringSegment {
    protected List elementNames;
    protected List indents;
    protected int lineWidth;
    protected int markedLineWidth;
    protected int currentLineWidth;
    protected boolean lastElementIsStart;

    public XMLString(int n) {
        this.lineWidth = n;
        this.elementNames = new BasicEList();
        this.indents = new BasicEList();
        this.indents.add("");
    }

    public void startElement(String string) {
        if (this.lastElementIsStart) {
            this.closeStartElement();
        }
        this.elementNames.add(string);
        this.add(this.getElementIndent());
        this.add("<");
        this.add(string);
        this.lastElementIsStart = true;
    }

    public void addAttribute(String string, String string2) {
        if (this.currentLineWidth > this.lineWidth) {
            this.addLine();
            this.add(this.getAttributeIndent());
        } else {
            this.add(" ");
        }
        this.add(string);
        this.add("=\"");
        this.add(string2);
        this.add("\"");
    }

    public void addAttributeNS(String string, String string2, String string3) {
        if (this.currentLineWidth > this.lineWidth) {
            this.addLine();
            this.add(this.getAttributeIndent());
        } else {
            this.add(" ");
        }
        this.add(string);
        this.add(":");
        this.add(string2);
        this.add("=\"");
        this.add(string3);
        this.add("\"");
    }

    public void startAttribute(String string) {
        if (this.currentLineWidth > this.lineWidth) {
            this.addLine();
            this.add(this.getAttributeIndent());
        } else {
            this.add(" ");
        }
        this.add(string);
        this.add("=\"");
    }

    public void addAttributeContent(String string) {
        this.add(string);
    }

    public void endAttribute() {
        this.add("\"");
    }

    protected void closeStartElement() {
        this.add(">");
        this.addLine();
    }

    public void endEmptyElement() {
        this.removeLast();
        this.add("/>");
        this.addLine();
        this.lastElementIsStart = false;
    }

    public void endContentElement(String string) {
        this.add(">");
        this.add(string);
        this.add("</");
        String string2 = this.removeLast();
        this.add(string2);
        this.add(">");
        this.addLine();
        this.lastElementIsStart = false;
    }

    public void endElement() {
        if (this.lastElementIsStart) {
            this.endEmptyElement();
        } else {
            this.add(this.getElementIndent());
            this.add("</");
            String string = this.removeLast();
            this.add(string);
            this.add(">");
            this.addLine();
            this.lastElementIsStart = false;
        }
    }

    protected String removeLast() {
        int n = this.elementNames.size();
        return (String)this.elementNames.remove(n - 1);
    }

    protected String getElementIndent() {
        int n = this.elementNames.size() - 1;
        int n2 = this.indents.size() - 1;
        while (n2 < n) {
            this.indents.add(this.indents.get(n2) + "  ");
            ++n2;
        }
        return (String)this.indents.get(n);
    }

    protected String getAttributeIndent() {
        int n = this.elementNames.size() + 1;
        int n2 = this.indents.size() - 1;
        while (n2 < n) {
            this.indents.add(this.indents.get(n2) + "  ");
            ++n2;
        }
        return (String)this.indents.get(n);
    }

    public void add(String string) {
        if (this.lineWidth != Integer.MAX_VALUE) {
            this.currentLineWidth += string.length();
        }
        super.add(string);
    }

    public void addLine() {
        super.addLine();
        this.currentLineWidth = 0;
    }

    public Object mark() {
        this.markedLineWidth = this.currentLineWidth;
        this.currentLineWidth = this.lineWidth - 2;
        return super.mark();
    }

    public void resetToMark(Object object) {
        super.resetToMark(object);
        this.elementNames.add("mark");
        this.currentLineWidth = this.markedLineWidth;
    }
}

