/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.activity;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityCoordinatorImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.TimeoutRangeException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;

class ActivityTimeoutMgr {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$activity$ActivityTimeoutMgr == null ? (class$com$ibm$ws$activity$ActivityTimeoutMgr = ActivityTimeoutMgr.class$("com.ibm.ws.activity.ActivityTimeoutMgr")) : class$com$ibm$ws$activity$ActivityTimeoutMgr), (String)"ActivityService", (String)"com.ibm.ws.activity.resources.activityMessages");
    private static ActivityTimeoutMgr _instance = new ActivityTimeoutMgr();
    private HashMap _coordinatorLookup = new HashMap();
    private TreeMap _processSequence = new TreeMap();
    private boolean _serverActive = true;
    private ActivityMonitorThread _activityMonitor = null;
    private final int DEFAULT_WAIT_TIME = 86400000;
    private final int SERVER_DEFAULT_TIMEOUT = 600;
    static /* synthetic */ Class class$com$ibm$ws$activity$ActivityTimeoutMgr;

    protected static ActivityTimeoutMgr instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instance");
            Tr.exit((TraceComponent)tc, (String)"instance", (Object)_instance);
        }
        return _instance;
    }

    private ActivityTimeoutMgr() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ActivityTimeoutMgr");
        }
        this._activityMonitor = new ActivityMonitorThread();
        this._activityMonitor.setName("ActivityMonitorThread");
        this._activityMonitor.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ActivityTimeoutMgr", (Object)"");
        }
    }

    protected synchronized void createTimer(ActivityCoordinatorImpl activityCoordinatorImpl, int n) throws TimeoutRangeException, IllegalArgumentException, InvalidActivityException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTimer(ActivityCoordinatorImpl, timeout)", (Object)new Object[]{activityCoordinatorImpl, new Integer(n)});
        }
        if (activityCoordinatorImpl == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Null coordinator reference passed. Throwing IllegalArgumentException");
            }
            Object[] objectArray = new Object[]{"createTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", illegalArgumentException};
            Tr.error((TraceComponent)tc, (String)"ERR_INT_ERROR", (Object)objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTimer", (Object)illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        if (n != -1) {
            if (n == 0) {
                n = 600;
            }
            if (n < -1 || n > 1000000000) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Invalid timeout value. Throwing TimeoutRangeException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createTimer", (Object)"TimeoutRangeException");
                }
                throw new TimeoutRangeException();
            }
            ActivityTimer activityTimer = (ActivityTimer)this._coordinatorLookup.get(activityCoordinatorImpl);
            if (activityTimer != null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Activity Timer already exists. Throwing InvalidActivityException");
                }
                InvalidActivityException invalidActivityException = new InvalidActivityException();
                Object[] objectArray = new Object[]{"createTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", invalidActivityException};
                Tr.error((TraceComponent)tc, (String)"ERR_INT_ERROR, parms");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createTimer", (Object)((Object)invalidActivityException));
                }
                throw invalidActivityException;
            }
            try {
                activityTimer = new ActivityTimer();
                activityTimer._coordinator = activityCoordinatorImpl;
                activityTimer._timeout = n;
                activityTimer._todTimeout = new Long(System.currentTimeMillis() + (long)n * 1000L);
                this._coordinatorLookup.put(activityTimer._coordinator, activityTimer);
                ActivityTimer activityTimer2 = (ActivityTimer)this._processSequence.get(activityTimer._todTimeout);
                if (activityTimer2 != null) {
                    while (activityTimer2._sameTimeTimer != null) {
                        activityTimer2 = activityTimer2._sameTimeTimer;
                    }
                    activityTimer2._sameTimeTimer = activityTimer;
                    activityTimer._parentTimer = activityTimer2;
                } else {
                    this._processSequence.put(activityTimer._todTimeout, activityTimer);
                }
                this.notify();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.createTimer", (String)"226", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unknown exception caught");
                }
                Object[] objectArray = new Object[]{"createTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", exception};
                Tr.error((TraceComponent)tc, (String)"ERR_UNEXP_EXCPN", (Object)objectArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createTimer", (Object)"SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTimer()");
        }
    }

    protected synchronized boolean removeTimer(ActivityCoordinatorImpl activityCoordinatorImpl) throws IllegalArgumentException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeTimer(ActivityCoordinatorImpl)", (Object)activityCoordinatorImpl);
        }
        boolean bl = false;
        if (activityCoordinatorImpl == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Null coordinator reference passed. Throwing IllegalArgumentException");
            }
            Object[] objectArray = new Object[]{"removeTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", illegalArgumentException};
            Tr.error((TraceComponent)tc, (String)"ERR_INT_ERROR", (Object)objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeTimer", (Object)illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        try {
            ActivityTimer activityTimer = (ActivityTimer)this._coordinatorLookup.get(activityCoordinatorImpl);
            if (activityTimer != null) {
                if (activityTimer._parentTimer != null) {
                    activityTimer._parentTimer._sameTimeTimer = activityTimer._sameTimeTimer;
                    if (activityTimer._sameTimeTimer != null) {
                        activityTimer._sameTimeTimer._parentTimer = activityTimer._parentTimer;
                    }
                } else {
                    this._processSequence.remove(activityTimer._todTimeout);
                    if (activityTimer._sameTimeTimer != null) {
                        activityTimer._sameTimeTimer._parentTimer = null;
                        this._processSequence.put(activityTimer._todTimeout, activityTimer._sameTimeTimer);
                    }
                }
                this._coordinatorLookup.remove(activityCoordinatorImpl);
                bl = true;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.removeTimer", (String)"318", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unknown exception caught");
            }
            Object[] objectArray = new Object[]{"removeTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", exception};
            Tr.error((TraceComponent)tc, (String)"ERR_UNEXP_EXCPN", (Object)objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeTimer", (Object)"SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeTimer", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected synchronized void monitorTimers() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"monitorTimers");
        }
        Long l = new Long(1L);
        ActivityTimer activityTimer = null;
        try {
            while (this._serverActive) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.monitorTimers", (String)"372", (Object)this);
                }
                l = new Long(86400000L);
                Long l2 = null;
                try {
                    l2 = (Long)this._processSequence.firstKey();
                }
                catch (NoSuchElementException noSuchElementException) {
                    l2 = null;
                }
                while (l2 != null && this._serverActive) {
                    Long l3 = new Long(System.currentTimeMillis());
                    if (l3 >= l2) {
                        activityTimer = (ActivityTimer)this._processSequence.get(l2);
                        while (activityTimer._sameTimeTimer != null) {
                            activityTimer = activityTimer._sameTimeTimer;
                        }
                        while (activityTimer != null) {
                            try {
                                if (!this.removeTimer(activityTimer._coordinator)) continue;
                                ActivityTimeoutThread activityTimeoutThread = new ActivityTimeoutThread(activityTimer);
                                activityTimeoutThread.setName("ActivityTimeoutThread");
                                activityTimeoutThread.start();
                                activityTimer = activityTimer._parentTimer;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.monitorTimers", (String)"430", (Object)this);
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"timer.coordinator is null. Re-throwing IllegalArgumentException");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"monitorTimer", (Object)illegalArgumentException);
                                }
                                throw illegalArgumentException;
                            }
                            catch (SystemException systemException) {
                                FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.monitorTimers", (String)"436", (Object)this);
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"SystemException received");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"monitorTimer", (Object)((Object)systemException));
                                }
                                throw systemException;
                            }
                        }
                        try {
                            l2 = (Long)this._processSequence.firstKey();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.monitorTimers", (String)"452", (Object)this);
                            l2 = null;
                        }
                        continue;
                    }
                    l = new Long(l2 - l3);
                    l2 = null;
                }
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.monitorTimers", (String)"469", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"SystemException received");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"monitorTimer", (Object)((Object)systemException));
            }
            throw systemException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.monitorTimers", (String)"477", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unknown exception caught");
            }
            Object[] objectArray = new Object[]{"monitorTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", exception};
            Tr.error((TraceComponent)tc, (String)"ERR_UNEXP_EXCPN", (Object)objectArray);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"monitorTimer", (Object)"SystemException");
            }
            throw new SystemException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"monitorTimers");
        }
    }

    private synchronized void serverShuttingDown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverShuttingDown");
        }
        this._serverActive = false;
        this.notify();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverShuttingDown");
        }
    }

    protected void timeoutTimer(ActivityTimer activityTimer) throws SystemException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"timeoutTimer");
            }
            try {
                if (activityTimer._coordinator.timeout() != 1) break block14;
                try {
                    this.createTimer(activityTimer._coordinator, activityTimer._timeout * 2);
                }
                catch (TimeoutRangeException timeoutRangeException) {
                    FFDCFilter.processException((Throwable)timeoutRangeException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.timeoutTimer", (String)"562", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Timeout value too large to recreate timer for coordinator " + activityTimer._coordinator));
                        Tr.debug((TraceComponent)tc, (String)"Activity Timer will now be ignored.");
                    }
                }
                catch (InvalidActivityException invalidActivityException) {
                    FFDCFilter.processException((Throwable)invalidActivityException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.timeoutTimer", (String)"568", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Activity Timer already exists for this Activity Coordinator " + activityTimer._coordinator.toString()));
                    }
                }
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.timeoutTimer", (String)"575", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"SystemException received");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"timeoutTimer", (Object)((Object)systemException));
                }
                throw systemException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.timeoutTimer", (String)"583", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unknown exception caught");
                }
                Object[] objectArray = new Object[]{"timeoutTimer", "com.ibm.ws.activity.ActivityTimeoutMgr", exception};
                Tr.error((TraceComponent)tc, (String)"ERR_UNEXP_EXCPN", (Object)objectArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"timeoutTimer", (Object)"SystemException");
                }
                throw new SystemException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"timeoutTimer");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ActivityMonitorThread
    extends Thread {
        private ActivityMonitorThread() {
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            try {
                ActivityTimeoutMgr.instance().monitorTimers();
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.run", (String)"698", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"!!!Exception: run() - SystemException received");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.run", (String)"705", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"!!!Exception: run() - Unknown exception thrown");
                }
                Object[] objectArray = new Object[]{"run", "com.ibm.ws.activity.ActivityTimeoutMgr", exception};
                Tr.error((TraceComponent)tc, (String)"ERR_UNEXP_EXCPN", (Object)objectArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }

    private class ActivityTimeoutThread
    extends Thread {
        private ActivityTimer _timer;

        protected ActivityTimeoutThread(ActivityTimer activityTimer) {
            this._timer = activityTimer;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            try {
                ActivityTimeoutMgr.instance().timeoutTimer(this._timer);
            }
            catch (SystemException systemException) {
                FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.run", (String)"656", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"!!!Exception: run() - SystemException received");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.activity.ActivityTimeoutMgr.run", (String)"663", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"!!!Exception: run() - Unknown exception thrown");
                }
                Object[] objectArray = new Object[]{"run", "com.ibm.ws.activity.ActivityTimeoutMgr", exception};
                Tr.error((TraceComponent)tc, (String)"ERR_UNEXP_EXCPN", (Object)objectArray);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }

    private class ActivityTimer {
        protected ActivityCoordinatorImpl _coordinator;
        protected int _timeout;
        protected Long _todTimeout;
        protected ActivityTimer _sameTimeTimer;
        protected ActivityTimer _parentTimer;

        protected ActivityTimer() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ActivityTimer");
            }
            this._sameTimeTimer = null;
            this._parentTimer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ActivityTimer");
            }
        }
    }
}

