/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.help.ui.internal.WorkbenchHelpPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenHelpSearchPageAction
implements IWorkbenchWindowActionDelegate {
    private static final String HELP_SEARCH_PAGE_ID = "org.eclipse.help.ui.searchPage";
    private IWorkbenchWindow fWindow;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (this.fWindow == null || this.fWindow.getActivePage() == null) {
            this.beep();
            WorkbenchHelpPlugin.logError("Could not open the search dialog - for some reason the window handle was null", null);
            return;
        }
        SearchUI.openSearchDialog((IWorkbenchWindow)this.fWindow, (String)HELP_SEARCH_PAGE_ID);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.fWindow = null;
    }

    protected void beep() {
        Shell shell = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            shell = window.getShell();
        }
        if (shell != null && shell.getDisplay() != null) {
            shell.getDisplay().beep();
        }
    }
}

