/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.util.IErrorUtil;
import org.eclipse.help.internal.workingset.PropertyChange;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.help.ui.internal.workingset.HelpWorkingSetSynchronizer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchHelpPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.help.ui";
    public static boolean DEBUG = false;
    public static boolean DEBUG_IE_ADAPTER = false;
    public static boolean DEBUG_IE_ADAPTER_IN_PROCESS = false;
    public static boolean DEBUG_INFOPOP = false;
    private static WorkbenchHelpPlugin plugin;
    private HelpWorkingSetSynchronizer workingSetListener;

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (HelpPlugin.DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpPlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public WorkbenchHelpPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static WorkbenchHelpPlugin getDefault() {
        return plugin;
    }

    public void shutdown() throws CoreException {
        if (HelpSystem.getMode() == 0) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this.workingSetListener);
            HelpSystem.getWorkingSetManager().removePropertyChangeListener((PropertyChange.IPropertyChangeListener)this.workingSetListener);
        }
        super.shutdown();
    }

    public void startup() {
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_IE_ADAPTER = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/ieadapter"));
            DEBUG_IE_ADAPTER_IN_PROCESS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/ieadapter/inprocess"));
            DEBUG_INFOPOP = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/infopop"));
        }
        HelpSystem.setDefaultErrorUtil((IErrorUtil)new ErrorUtil());
        if (HelpSystem.getMode() == 0) {
            this.workingSetListener = new HelpWorkingSetSynchronizer();
            PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this.workingSetListener);
            HelpSystem.getWorkingSetManager().addPropertyChangeListener((PropertyChange.IPropertyChangeListener)this.workingSetListener);
        }
    }

    public IBrowser getHelpBrowser() {
        return HelpSystem.getHelpBrowser();
    }

    public HelpWorkingSetSynchronizer getWorkingSetSynchronizer() {
        return this.workingSetListener;
    }
}

