/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.IHelp;
import org.eclipse.help.internal.HelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.ui.internal.DefaultHelp;
import org.eclipse.help.ui.internal.WorkbenchHelpPlugin;
import org.eclipse.help.ui.internal.search.SearchQueryData;
import org.eclipse.help.ui.internal.util.WorkbenchResources;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchOperation
extends WorkspaceModifyOperation {
    private static final ImageDescriptor IMAGE_DSCR_SEARCH = ImageDescriptor.createFromURL((URL)WorkbenchResources.getImagePath("search_menu.gif"));
    private static final ImageDescriptor IMAGE_DSCR_TOPIC = ImageDescriptor.createFromURL((URL)WorkbenchResources.getImagePath("topic.gif"));
    private static final IResource resource = ResourcesPlugin.getWorkspace().getRoot();
    private static ImageRegistry imgRegistry = null;
    private SearchQueryData queryData = null;

    public SearchOperation(SearchQueryData data) {
        if (imgRegistry == null) {
            imgRegistry = WorkbenchHelpPlugin.getDefault().getImageRegistry();
            imgRegistry.put("search_icon", IMAGE_DSCR_SEARCH);
            imgRegistry.put("s_topic_icon", IMAGE_DSCR_TOPIC);
        }
        this.queryData = data;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            ArrayList<String> scope = null;
            if (this.queryData.isBookFiltering()) {
                scope = new ArrayList<String>();
                IWorkingSet[] workingSets = this.queryData.getSelectedWorkingSets();
                int i = 0;
                while (i < workingSets.length) {
                    scope.add(workingSets[i].getName());
                    ++i;
                }
            }
            SearchResults results = new SearchResults(scope, this.queryData.getMaxHits(), this.queryData.getLocale());
            HelpSystem.getSearchManager().search(this.queryData.getSearchQuery(), (ISearchHitCollector)results, monitor);
            this.displayResults(results.getSearchHits());
        }
        catch (OperationCanceledException oce) {
            monitor.done();
            throw oce;
        }
        catch (Exception e) {
            WorkbenchHelpPlugin.logError(WorkbenchResources.getString("WE021"), e);
        }
        monitor.done();
    }

    private void displayResults(SearchHit[] searchHits) {
        ISearchResultView sView = SearchUI.getSearchResultView();
        if (sView != null) {
            sView.searchStarted(null, WorkbenchResources.getString("singleSearchResult", this.queryData.getSearchWord()), WorkbenchResources.getString("multipleSearchResult", this.queryData.getSearchWord(), "{0}"), IMAGE_DSCR_SEARCH, "org.eclipse.help.ui.searchPage", (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ISearchResultViewEntry) {
                        try {
                            ISearchResultViewEntry entry = (ISearchResultViewEntry)element;
                            return (String)entry.getSelectedMarker().getAttribute("label");
                        }
                        catch (CoreException coreException) {}
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    if (element instanceof ISearchResultViewEntry) {
                        return imgRegistry.get("s_topic_icon");
                    }
                    return null;
                }
            }, (IAction)new Action(){

                public void run() {
                    ISearchResultView view = SearchUI.getSearchResultView();
                    view.getSelection();
                    ISelection selection = view.getSelection();
                    Object element = null;
                    if (selection instanceof IStructuredSelection) {
                        element = ((IStructuredSelection)selection).getFirstElement();
                    }
                    if (element instanceof ISearchResultViewEntry) {
                        ISearchResultViewEntry entry = (ISearchResultViewEntry)element;
                        try {
                            IHelp ihelp = WorkbenchHelp.getHelpSupport();
                            if (ihelp instanceof DefaultHelp) {
                                ((DefaultHelp)ihelp).displaySearch(SearchOperation.this.queryData.toURLQuery(), (String)entry.getSelectedMarker().getAttribute("href"));
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e);
                        }
                    }
                }
            }, new IGroupByKeyComputer(){

                public Object computeGroupByKey(IMarker marker) {
                    try {
                        if (marker.getAttribute("href") != null) {
                            return marker.getAttribute("href");
                        }
                    }
                    catch (CoreException coreException) {}
                    return "UNKNOWN";
                }
            }, (IRunnableWithProgress)this);
        }
        try {
            resource.deleteMarkers("org.eclipse.help.ui.helpsearchhit", true, 2);
        }
        catch (CoreException coreException) {}
        this.createResultsMarkers(searchHits, sView);
        sView.searchFinished();
    }

    private void createResultsMarkers(SearchHit[] searchHits, ISearchResultView sView) {
        int i = 0;
        while (i < searchHits.length) {
            try {
                IMarker marker = null;
                marker = resource.createMarker("org.eclipse.help.ui.helpsearchhit");
                marker.setAttribute("href", (Object)searchHits[i].getHref());
                marker.setAttribute("resultfof", (Object)this.queryData.toURLQuery());
                float score = searchHits[i].getScore();
                NumberFormat percentFormat = NumberFormat.getPercentInstance();
                String scoreString = percentFormat.format(score);
                String label = String.valueOf(scoreString) + " " + searchHits[i].getLabel();
                marker.setAttribute("label", (Object)label);
                marker.setAttribute("order", (Object)new Integer(i).toString());
                sView.addMatch(searchHits[i].getLabel(), marker.getAttribute("href"), resource, marker);
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }
}

