/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.net.URLEncoder;
import java.util.Iterator;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchQueryData {
    private SearchQuery searchQuery = new SearchQuery();
    private static int MAX_HITS = 500;
    private int maxHits = MAX_HITS;
    private boolean bookFiltering;
    private IWorkingSet[] workingSets;

    public SearchQueryData() {
        String workingSetName = HelpPlugin.getDefault().getPluginPreferences().getString("workingSet");
        if (workingSetName == null || workingSetName.length() == 0) {
            this.bookFiltering = false;
            this.workingSets = new IWorkingSet[0];
        } else {
            IWorkingSet iws = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName);
            if (iws == null) {
                this.bookFiltering = false;
                this.workingSets = new IWorkingSet[0];
            } else {
                this.bookFiltering = true;
                this.workingSets = new IWorkingSet[]{iws};
            }
        }
    }

    public ISearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.bookFiltering) {
            return this.workingSets;
        }
        return null;
    }

    public String getLocale() {
        return this.searchQuery.getLocale();
    }

    public boolean isBookFiltering() {
        return this.bookFiltering;
    }

    public void setBookFiltering(boolean enable) {
        this.bookFiltering = enable;
        if (enable) {
            this.workingSets.getClass();
        }
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    public void setFieldsSearch(boolean fieldSearch) {
        this.searchQuery.setFieldSearch(fieldSearch);
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public String toURLQuery() {
        String q = "searchWord=" + URLCoder.encode((String)this.searchQuery.getSearchWord()) + "&maxHits=" + this.maxHits + "&lang=" + this.searchQuery.getLocale();
        if (!this.searchQuery.getFieldNames().isEmpty()) {
            Iterator iterator = this.searchQuery.getFieldNames().iterator();
            while (iterator.hasNext()) {
                String field = (String)iterator.next();
                q = String.valueOf(q) + "&field=" + URLEncoder.encode(field);
            }
        }
        q = this.searchQuery.isFieldSearch() ? String.valueOf(q) + "&fieldSearch=true" : String.valueOf(q) + "&fieldSearch=false";
        if (this.bookFiltering) {
            int i = 0;
            while (i < this.workingSets.length) {
                q = String.valueOf(q) + "&scope=" + URLCoder.encode((String)this.workingSets[i].getName());
                ++i;
            }
        }
        return q;
    }

    public String getSearchWord() {
        return this.searchQuery.getSearchWord();
    }

    public void setSearchWord(String searchWord) {
        this.searchQuery.setSearchWord(searchWord);
    }

    public int getMaxHits() {
        return this.maxHits;
    }
}

