/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.associations;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.PMTxInfo;
import com.ibm.ws.ejbpersistence.associations.AssociationLink;
import com.ibm.ws.ejbpersistence.associations.BackwardLinkId;
import com.ibm.ws.ejbpersistence.associations.BackwardOneToOneLinkImpl;
import com.ibm.ws.ejbpersistence.associations.ForwardManyToOneLinkImpl;
import com.ibm.ws.ejbpersistence.associations.ForwardOneToOneLinkImpl;
import com.ibm.ws.ejbpersistence.associations.LinkImpl;
import com.ibm.ws.ejbpersistence.associations.LinkMetadata;
import com.ibm.ws.ejbpersistence.associations.LinkSource;
import com.ibm.ws.ejbpersistence.associations.ManyToManyLinkImpl;
import com.ibm.ws.ejbpersistence.associations.OneToManyLinkImpl;
import com.ibm.ws.ejbpersistence.cache.TransactionListenerImpl;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerException;
import java.util.HashSet;
import java.util.Set;

public class LinkFactory {
    private boolean _txValid = true;
    private TransactionListenerImpl txListener;
    private Set bLinkRegistry;
    private static TraceComponent tc = PMLogger.registerTC(class$com$ibm$ws$ejbpersistence$associations$LinkFactory == null ? (class$com$ibm$ws$ejbpersistence$associations$LinkFactory = LinkFactory.class$("com.ibm.ws.ejbpersistence.associations.LinkFactory")) : class$com$ibm$ws$ejbpersistence$associations$LinkFactory);
    static /* synthetic */ Class class$com$ibm$ws$ejbpersistence$associations$LinkFactory;

    public LinkFactory(TransactionListenerImpl transactionListenerImpl) {
        this.txListener = transactionListenerImpl;
        this.bLinkRegistry = new HashSet();
    }

    public static LinkFactory getLinkFactory(PMTxInfo pMTxInfo) {
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        return transactionListenerImpl.getLinkFactory();
    }

    public void enlistForOptionA(Object object) {
        if (object instanceof ForwardOneToOneLinkImpl) {
            ((ForwardOneToOneLinkImpl)object).enlistForOptionA(this);
        } else if (object instanceof BackwardOneToOneLinkImpl) {
            this.registerBackwardLink((BackwardOneToOneLinkImpl)object);
        } else if (object instanceof OneToManyLinkImpl) {
            ((OneToManyLinkImpl)object).enlistForOptionA(this);
            this.registerBackwardLink((OneToManyLinkImpl)object);
        } else if (object instanceof ForwardManyToOneLinkImpl) {
            ((ForwardManyToOneLinkImpl)object).enlistForOptionA(this);
        } else if (object instanceof ManyToManyLinkImpl) {
            ((ManyToManyLinkImpl)object).enlistForOptionA(this);
        }
    }

    public AssociationLink createLink(LinkSource linkSource, LinkMetadata linkMetadata, Object object) throws PersistenceManagerException {
        if (linkMetadata.isForwardOneToOne()) {
            return new ForwardOneToOneLinkImpl(linkSource, linkMetadata, object, this);
        }
        if (linkMetadata.isBackwardOneToOne()) {
            BackwardOneToOneLinkImpl backwardOneToOneLinkImpl = new BackwardOneToOneLinkImpl(linkSource, linkMetadata);
            if (linkSource.afterEJBCreate()) {
                this.registerBackwardLink(backwardOneToOneLinkImpl);
            }
            return backwardOneToOneLinkImpl;
        }
        if (linkMetadata.isBackwardOneToMany()) {
            OneToManyLinkImpl oneToManyLinkImpl = new OneToManyLinkImpl(linkSource, linkMetadata, this);
            if (linkSource.afterEJBCreate()) {
                this.registerBackwardLink(oneToManyLinkImpl);
            }
            return oneToManyLinkImpl;
        }
        if (linkMetadata.isForwardManyToOne()) {
            return new ForwardManyToOneLinkImpl(linkSource, linkMetadata, object, this);
        }
        if (linkMetadata.isManyToMany()) {
            return new ManyToManyLinkImpl(linkSource, linkMetadata, this);
        }
        PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR2000: Link metadata does not contain a valid link type");
        Tr.error(tc, "error in createLink", (Object)persistenceManagerException);
        throw persistenceManagerException;
    }

    public boolean isBackwardLinkRegistered(Object object, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBackwardLinkRegistered", new Object[]{object, string});
        }
        BackwardLinkId backwardLinkId = new BackwardLinkId(object, string);
        boolean bl = this.bLinkRegistry.contains(backwardLinkId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBackwardLinkRegistered", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    public boolean isTxValid() {
        boolean bl = true;
        if (!this._txValid) {
            bl = false;
        } else if (this.txListener.getCurrentTransaction() != this.txListener.getRelatedTransaction()) {
            bl = false;
        }
        return bl;
    }

    private void registerBackwardLink(LinkImpl linkImpl) {
        BackwardLinkId backwardLinkId = new BackwardLinkId(linkImpl.getKey(), linkImpl.metadata.getName());
        this.bLinkRegistry.add(backwardLinkId);
    }

    public void postEJBCreate(Object object, Object object2) {
        LinkImpl linkImpl = (LinkImpl)object2;
        if (linkImpl.metadata.isBackwardOneToMany() || linkImpl.metadata.isBackwardOneToOne()) {
            BackwardLinkId backwardLinkId = new BackwardLinkId(object, linkImpl.metadata.getName());
            this.bLinkRegistry.add(backwardLinkId);
        }
    }

    public void setTxInvalid() {
        this._txValid = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

