/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.associations;

import com.ibm.ws.ejbpersistence.associations.LinkSetSource;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LinkSet
extends AbstractSet {
    private LinkSetSource sourceLink;
    private boolean isComplete = false;
    private Set items = null;

    protected LinkSet(LinkSetSource linkSetSource) {
        this.sourceLink = linkSetSource;
    }

    public boolean add(Object object) {
        if (this.sourceLink.validateArgument(object)) {
            this.checkValidTx();
            return this.sourceLink.userAdd(object);
        }
        return false;
    }

    protected void deferredAdd(Object object) {
        if (this.isComplete) {
            this.items.add(object);
        }
    }

    protected void deferredRemove(Object object) {
        if (this.isComplete) {
            this.items.remove(object);
        }
    }

    private Collection fetchTarget() {
        return this.sourceLink.fetchTarget();
    }

    private void hydrate() {
        this.items = new HashSet();
        Collection collection = this.fetchTarget();
        if (collection != null) {
            this.sourceLink.setAccessIntent(collection);
            this.items.addAll(collection);
        }
        this.isComplete = true;
    }

    public Iterator iterator() {
        this.checkValidTx();
        if (!this.isComplete) {
            this.hydrate();
        }
        return new Itr();
    }

    protected boolean privateAdd(Object object) {
        if (!this.isComplete) {
            this.hydrate();
        }
        return this.items.add(object);
    }

    protected boolean privateRemove(Object object) {
        if (!this.isComplete) {
            this.hydrate();
        }
        boolean bl = this.items.remove(object);
        return bl;
    }

    public boolean remove(Object object) {
        if (this.sourceLink.validateRemoveArgument(object)) {
            this.checkValidTx();
            return this.sourceLink.userRemove(object);
        }
        return false;
    }

    public int size() {
        this.checkValidTx();
        if (!this.isComplete) {
            this.hydrate();
        }
        return this.items.size();
    }

    public String toString() {
        if (!this.isComplete) {
            return "Unhydrated Link collection";
        }
        return super.toString();
    }

    private void checkValidTx() {
        if (!this.sourceLink.isTxValid()) {
            throw new IllegalStateException();
        }
    }

    private class Itr
    implements Iterator {
        Iterator itemsItr;
        Object next;

        public Itr() {
            this.itemsItr = LinkSet.this.items.iterator();
        }

        public boolean hasNext() {
            LinkSet.this.checkValidTx();
            return this.itemsItr.hasNext();
        }

        public Object next() {
            LinkSet.this.checkValidTx();
            this.next = this.itemsItr.next();
            return this.next;
        }

        public void remove() {
            LinkSet.this.checkValidTx();
            LinkSet.this.sourceLink.iteratorRemove(this.next);
            this.itemsItr.remove();
        }
    }
}

