/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.cache;

import com.ibm.ejs.jms.JMSSessionHandleInterface;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ejbpersistence.cache.AssociationsCache;
import com.ibm.ws.ejbpersistence.cache.AssociationsCacheSynchedImpl;
import com.ibm.ws.ejbpersistence.cache.DataCacheEntry;
import com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener;
import com.ibm.ws.ejbpersistence.cache.TransactionScopedCache;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ClassScopedCache
extends TransactionScopedCache {
    private static PMCacheInvalidationMessageListener topicListener = null;
    TopicConnection topicConnection;
    private static boolean isCacheInvalidationEnabled;
    private static int invalMsgListenerUsageCount;
    private static final String topicConnectionFactoryUri = "com.ibm.websphere.ejbpersistence.InvalidateTCF";
    private static final String topicString = "com.ibm.websphere.ejbpersistence.invalidate";
    private static final boolean NON_TRANSACTIONAL_SESSION = false;
    private static TraceComponent mytc;
    static /* synthetic */ Class class$com$ibm$ws$ejbpersistence$cache$ClassScopedCache;

    public ClassScopedCache() {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "ClassScopedCache()");
        }
        if (isCacheInvalidationEnabled) {
            ++invalMsgListenerUsageCount;
            if (topicListener == null) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "Setting up a singleton PMCacheInvalidationMessageListener as a JMS topic listener.");
                }
                try {
                    InitialContext initialContext = new InitialContext();
                    TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)initialContext.lookup(topicConnectionFactoryUri);
                    Topic topic = (Topic)initialContext.lookup(topicString);
                    this.topicConnection = topicConnectionFactory.createTopicConnection();
                    TopicSession topicSession = this.topicConnection.createTopicSession(false, 1);
                    TopicSession topicSession2 = (TopicSession)((JMSSessionHandleInterface)topicSession).getSession();
                    TopicSubscriber topicSubscriber = topicSession2.createSubscriber(topic);
                    topicListener = new PMCacheInvalidationMessageListener();
                    topicListener.setTopicSession(topicSession);
                    topicSubscriber.setMessageListener(topicListener);
                    this.topicConnection.start();
                }
                catch (JMSException jMSException) {
                    FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.ejbpersistence.cache.ClassScopedCache.constructor", (String)"20", (Object)this);
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", jMSException);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                    try {
                        if (this.topicConnection != null) {
                            this.topicConnection.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.ejbpersistence.cache.ClassScopedCache.constructor", (String)"30", (Object)this);
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", namingException);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.ejbpersistence.cache.ClassScopedCache.constructor", (String)"40", (Object)this);
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR1000E: Exception occurred :", throwable);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                }
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "ClassScopedCache()");
        }
    }

    public DataCacheEntry getEntry(Object object, boolean bl) {
        DataCacheEntry dataCacheEntry = super.getEntry(object, false);
        if (dataCacheEntry != null) {
            if (dataCacheEntry.getLifetime() != -1L && dataCacheEntry.getLifetime() < System.currentTimeMillis()) {
                this.removeEntry(object);
                this.removeAssociation(object);
                dataCacheEntry = null;
            } else if (dataCacheEntry.getLoadTimeAccessIntent().getAccessType() == 1) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "ClassScopedCache.getEntry(...) called by potential updater, returning a clone of the entry.");
                }
                dataCacheEntry = dataCacheEntry.getClone();
            }
        }
        return dataCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCacheEntry removeEntry(Object object) {
        ClassScopedCache classScopedCache = this;
        synchronized (classScopedCache) {
            return super.removeEntry(object);
        }
    }

    public AssociationsCache getAssociationsCache() {
        if (this.associationsCache == null) {
            this.associationsCache = new AssociationsCacheSynchedImpl();
        }
        return this.associationsCache;
    }

    public void unInstall() {
        if (--invalMsgListenerUsageCount == 0 && this.topicConnection != null) {
            try {
                this.topicConnection.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized boolean beanWasRemoved(Object object) {
        return super.beanWasRemoved(object);
    }

    public synchronized boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    public synchronized void putEntry(Object object, DataCacheEntry dataCacheEntry) {
        super.putEntry(object, dataCacheEntry);
    }

    public synchronized void clearDataCacheEntries() {
        super.clearDataCacheEntries();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nClassScopedCache: ");
        stringBuffer.append("\n  isCacheInvalidationEnabled = " + isCacheInvalidationEnabled);
        stringBuffer.append("\n  invalMsgListenerUsageCount = " + invalMsgListenerUsageCount);
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mytc = PMLogger.registerTC(class$com$ibm$ws$ejbpersistence$cache$ClassScopedCache == null ? (class$com$ibm$ws$ejbpersistence$cache$ClassScopedCache = ClassScopedCache.class$("com.ibm.ws.ejbpersistence.cache.ClassScopedCache")) : class$com$ibm$ws$ejbpersistence$cache$ClassScopedCache);
        String string = null;
        String string2 = null;
        try {
            string = System.getProperty("com.ibm.ws.ejbpersistence.cacheinvalidation");
            string2 = System.getProperty("com.ibm.ws.ejbpersistence.cacheinvalidatation");
        }
        catch (Throwable throwable) {
            Tr.error(mytc, throwable.getMessage());
            Tr.error(mytc, "Property com.ibm.ws.ejbpersistence.cacheinvalidation");
        }
        if (string != null) {
            isCacheInvalidationEnabled = new Boolean(string);
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "Property com.ibm.ws.ejbpersistence.cacheinvalidation:" + isCacheInvalidationEnabled);
            }
        } else if (string2 != null) {
            isCacheInvalidationEnabled = new Boolean(string2);
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "Property com.ibm.ws.ejbpersistence.cacheinvalidation:" + isCacheInvalidationEnabled);
            }
        } else if (mytc.isDebugEnabled()) {
            Tr.debug(mytc, "Property com.ibm.ws.ejbpersistence.cacheinvalidation not specified, default is false");
        }
    }
}

