/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpmi.PMBeanInfo;
import com.ibm.websphere.cpmi.PersistenceManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ejbpersistence.PMCacheInvalidationRequest;
import com.ibm.ws.ejbpersistence.associations.ForwardOneToOneLinkImpl;
import com.ibm.ws.ejbpersistence.associations.LinkImpl;
import com.ibm.ws.ejbpersistence.beanextensions.ConcreteBeanClassExtension;
import com.ibm.ws.ejbpersistence.beanextensions.PersistenceManagerImpl;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.cache.InputStreamWithClassLoader;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerException;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class PMCacheInvalidationMessageListener
implements MessageListener {
    private static LinkImpl helper = new ForwardOneToOneLinkImpl(null, null, null, null);
    private static PMCacheInvalidationMessageListener singletonSelf;
    private PersistenceManagerImpl ourpm;
    private EJBContainer ejbContainer;
    private TopicSession topicSession = null;
    private static TraceComponent mytc;
    static /* synthetic */ Class class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener;

    public static void staticOnMessage(Message message) {
        if (singletonSelf == null) {
            singletonSelf = new PMCacheInvalidationMessageListener();
        }
        singletonSelf.onMessage(message);
    }

    public void onMessage(Message message) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "onMessage(javax.jms.Message msg)", new Object[]{message});
        }
        PMCacheInvalidationRequest pMCacheInvalidationRequest = null;
        try {
            ObjectMessage objectMessage = (ObjectMessage)message;
            pMCacheInvalidationRequest = (PMCacheInvalidationRequest)objectMessage.getObject();
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "PMCacheInvalidationRequest from msg = " + pMCacheInvalidationRequest);
            }
            this.invalidate(pMCacheInvalidationRequest);
            Topic topic = (Topic)objectMessage.getJMSReplyTo();
            if (topic != null) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "About to send (publish) invalidation ACK to (non-null) reply-to Destination: " + topic);
                }
                TopicPublisher topicPublisher = this.topicSession.createPublisher(topic);
                Message message2 = this.topicSession.createMessage();
                message2.setJMSType("cycle");
                message2.setJMSCorrelationID(message.getJMSCorrelationID());
                topicPublisher.publish(message2);
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"2", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5021E: PM's invalidation listener received a message but the message parameter was not a PMCacheInvalidationRequest object as required.");
            PMExceptionHandler.logException(mytc, persistenceManagerException);
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"10", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PMCacheInvalidation error: " + exception});
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
            return;
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "onMessage(javax.jms.Message msg)");
        }
    }

    public void invalidate(byte[] byArray) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "invalidate(byte[] requestInWireFormat)", new Object[]{byArray});
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "invalidate(byte[] requestInWireFormat)");
        }
    }

    public void invalidate(PMCacheInvalidationRequest pMCacheInvalidationRequest) {
        PersistenceManager[] persistenceManagerArray;
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "invalidate(PMCacheInvalidationRequest request)", new Object[]{pMCacheInvalidationRequest});
        }
        if (this.ourpm == null) {
            this.ejbContainer = helper.getContainerInterface();
            persistenceManagerArray = this.ejbContainer.getPersistenceManagers();
            for (int i = 0; i < persistenceManagerArray.length; ++i) {
                if (!(persistenceManagerArray[i] instanceof PersistenceManagerImpl)) continue;
                this.ourpm = (PersistenceManagerImpl)persistenceManagerArray[i];
                break;
            }
            if (this.ourpm == null) {
                PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PersistenceManagerImpl==null"});
                FFDCFilter.processException((Throwable)((Object)persistenceManagerInternalError), (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"20", (Object)this);
                PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                return;
            }
        }
        try {
            persistenceManagerArray = this.ourpm.getPMHomeInfo(pMCacheInvalidationRequest.getBeanHomeJNDIName());
            J2EEName j2EEName = persistenceManagerArray.getJ2EEName();
            PMBeanInfo pMBeanInfo = persistenceManagerArray.getPMBeanInfo();
            CacheManager cacheManager = ((ConcreteBeanClassExtension)pMBeanInfo).getCacheManager();
            switch (pMCacheInvalidationRequest.getInvalidationType()) {
                case 0: {
                    ClassLoader classLoader = this.ejbContainer.getClassLoader(j2EEName);
                    InputStreamWithClassLoader inputStreamWithClassLoader = new InputStreamWithClassLoader(classLoader, pMCacheInvalidationRequest.getKeyAsByteArray());
                    Serializable serializable = (Serializable)inputStreamWithClassLoader.readObject();
                    cacheManager.ejbInvalidate(serializable);
                    break;
                }
                case 1: {
                    ClassLoader classLoader = this.ejbContainer.getClassLoader(j2EEName);
                    InputStreamWithClassLoader inputStreamWithClassLoader = new InputStreamWithClassLoader(classLoader, pMCacheInvalidationRequest.getKeyAsByteArray());
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    try {
                        while (true) {
                            Object object = inputStreamWithClassLoader.readObject();
                            arrayList.add(object);
                        }
                    }
                    catch (EOFException eOFException) {
                        cacheManager.ejbInvalidate(arrayList);
                        break;
                    }
                }
                case 2: {
                    cacheManager.ejbInvalidateAll();
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"52", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5024E: IOException while accessing byte-array-ized key object {0}", new Object[]{pMCacheInvalidationRequest.getKeyAsByteArray()}, iOException);
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"53", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5025E: ClassNotFoundException while deserializing bean primary key object passed by client code. Key object is not of the correct class for bean type with home JNDI name = {0}.", new Object[]{pMCacheInvalidationRequest.getBeanHomeJNDIName()}, classNotFoundException);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "invalidate(PMCacheInvalidationRequest request)");
        }
    }

    public void setTopicSession(TopicSession topicSession) {
        this.topicSession = topicSession;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mytc = PMLogger.registerTC(class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener == null ? (class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener = PMCacheInvalidationMessageListener.class$("com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener")) : class$com$ibm$ws$ejbpersistence$cache$PMCacheInvalidationMessageListener);
    }
}

