/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.DataException;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.SelectStatement;
import com.ibm.db.StatementMetaData;
import com.ibm.db.StatementResult;
import com.ibm.db.StatementResultRow;
import com.ibm.db.StatementResultValueChangeEventMulticaster;
import com.ibm.db.StatementResultValueChangeListener;
import com.ibm.db.Utilities;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseTypeField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SelectResult
extends StatementResult {
    protected int fieldCurrentRow = 0;
    protected int fieldCurrentRowInCache = 0;
    protected int fieldNumPacketsInCache = 0;
    protected int fieldNumRowsInCache = 0;
    protected SelectStatement statement;
    protected StatementMetaData metaData = null;
    protected Vector rows;
    protected transient Vector changes;
    protected DatabaseRow columnDefaults;
    protected transient DatabaseResultTable singleRowResult;
    protected transient DatabaseResultTable currentStatement;
    protected transient boolean dataChangesPending = false;
    protected transient boolean moreRows = true;
    protected transient boolean previousRows = false;
    protected transient int fetchDirection = 1;
    protected transient boolean leavingRow = false;
    protected transient boolean nextOrPrev = false;
    protected boolean deferUpdates = false;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected transient StatementResultValueChangeListener aStatementResultValueChangeListener = null;
    private static final long serialVersionUID = -419344625505717772L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 2000.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    static Class class$array1$$byte;
    static Class class$java$lang$Short;
    static Class class$java$sql$Time;
    static Class class$java$lang$String;
    static Class class$java$lang$Float;
    static Class class$java$sql$Timestamp;
    static Class class$java$net$URL;
    static Class class$java$lang$Double;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Long;
    static Class class$java$sql$Date;
    static Class class$java$lang$Integer;
    static Class class$java$sql$Clob;
    static Class class$java$io$InputStream;
    static Class class$java$sql$Blob;
    static Class class$java$math$BigDecimal;

    public SelectResult() {
    }

    public SelectResult(SelectStatement selectStatement) {
        this.statement = selectStatement;
        if (selectStatement != null) {
            this.metaData = selectStatement.getMetaData();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    public void addStatementResultValueChangeListener(StatementResultValueChangeListener statementResultValueChangeListener) {
        this.aStatementResultValueChangeListener = StatementResultValueChangeEventMulticaster.add(this.aStatementResultValueChangeListener, statementResultValueChangeListener);
    }

    protected void apply() throws DataException {
        if (this.statement != null && this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"apply"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string, 215);
        }
        StatementResultRow statementResultRow = null;
        try {
            if (this.changes != null) {
                while (true) {
                    statementResultRow = (StatementResultRow)this.changes.firstElement();
                    switch (statementResultRow.getAction()) {
                        case 1: {
                            this.applyUpdate(statementResultRow);
                            break;
                        }
                        case 2: {
                            this.applyDelete(statementResultRow);
                            break;
                        }
                        case 3: {
                            this.applyInsert(statementResultRow);
                            break;
                        }
                    }
                    this.changes.removeElementAt(0);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (DataException dataException) {
            this.restoreChanges();
            throw dataException;
        }
        catch (RuntimeException runtimeException) {
            this.restoreChanges();
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void applyDelete(StatementResultRow statementResultRow) throws DataException {
        DatabaseRow databaseRow = null;
        String string = null;
        DatabaseResultTable databaseResultTable = null;
        DatabaseConnection databaseConnection = this.statement.getConnection();
        if (!statementResultRow.isInDatabase()) {
            return;
        }
        if (databaseConnection.databaseName.equals("Microsoft SQL Server") || databaseConnection.databaseName.equals("SQL Server") || databaseConnection.databaseName.equals("Sybase SQL Server") || databaseConnection.databaseName.startsWith("Oracle") || !databaseConnection.supportsPositionedDelete || this.statement.isForceSearchedUpdate()) {
            DatabaseQuerySpec databaseQuerySpec = this.generateSearchedDeleteSpec(statementResultRow);
            databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
            DatabaseRow databaseRow2 = this.generateHostVars(databaseQuerySpec, databaseRow);
            try {
                try {
                    databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                    databaseResultTable.setTimeout(this.statement.getTimeout());
                    this.currentStatement = databaseResultTable;
                    databaseResultTable.execute(databaseRow2);
                    this.currentStatement = null;
                    int n = databaseResultTable.getUpdateCount();
                    if (n == 0) {
                        string = Utilities.logMessage(IBMDBMessages.rowChanged);
                        throw new DataException(string, 237);
                    }
                    if (n > 1) {
                        string = Utilities.logMessage(IBMDBMessages.multipleRowsChanged);
                    }
                }
                catch (SQLException sQLException) {
                    StatementResult.handleSQLException(sQLException);
                }
                catch (com.ibm.db.base.DataException dataException) {
                    Utilities.logBaseException(dataException);
                    throw new DataException(dataException.getMessage(), dataException.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                Object var8_19 = null;
                this.currentStatement = null;
                if (databaseResultTable == null) throw throwable;
                try {
                    try {
                        databaseResultTable.closeStatement();
                    }
                    catch (SQLException sQLException) {}
                }
                catch (Throwable throwable2) {
                    Object var10_26 = null;
                    databaseResultTable = null;
                    throw throwable2;
                }
                Object var10_27 = null;
                databaseResultTable = null;
                throw throwable;
            }
            Object var8_20 = null;
            this.currentStatement = null;
            if (databaseResultTable == null) return;
            try {}
            catch (Throwable throwable) {
                Object var10_28 = null;
                databaseResultTable = null;
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                return;
            }
            databaseResultTable.closeStatement();
            return;
        }
        if (!this.isRowLocked()) {
            this.applyLock(statementResultRow);
        }
        DatabaseQuerySpec databaseQuerySpec = new DatabaseQuerySpec(this.generatePositionedDeleteSQL());
        try {
            try {
                this.leavingRow = true;
                databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                databaseResultTable.setTimeout(this.statement.getTimeout());
                this.currentStatement = databaseResultTable;
                databaseResultTable.execute();
            }
            catch (SQLException sQLException) {
                this.leavingRow = false;
                StatementResult.handleSQLException(sQLException);
            }
            catch (com.ibm.db.base.DataException dataException) {
                this.leavingRow = false;
                Utilities.logBaseException(dataException);
                throw new DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.currentStatement = null;
            if (this.leavingRow || !this.statement.isLockRows()) {
                this.unlockRow();
            }
            this.leavingRow = false;
            if (databaseResultTable == null) throw throwable;
            try {
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable3) {
                Object var9_15 = null;
                databaseResultTable = null;
                throw throwable3;
            }
            Object var9_16 = null;
            databaseResultTable = null;
            throw throwable;
        }
        Object var7_10 = null;
        this.currentStatement = null;
        if (this.leavingRow || !this.statement.isLockRows()) {
            this.unlockRow();
        }
        this.leavingRow = false;
        if (databaseResultTable == null) return;
        try {}
        catch (Throwable throwable) {
            Object var9_17 = null;
            databaseResultTable = null;
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            return;
        }
        databaseResultTable.closeStatement();
    }

    protected void applyInsert(StatementResultRow statementResultRow) throws DataException {
        DatabaseResultTable databaseResultTable = null;
        DatabaseQuerySpec databaseQuerySpec = this.generateInsertSpec(statementResultRow);
        DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
        DatabaseRow databaseRow2 = this.generateInsertHostVars(databaseQuerySpec, databaseRow);
        try {
            try {
                databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                databaseResultTable.setTimeout(this.statement.getTimeout());
                this.currentStatement = databaseResultTable;
                databaseResultTable.execute(databaseRow2);
            }
            catch (SQLException sQLException) {
                StatementResult.handleSQLException(sQLException);
            }
            catch (com.ibm.db.base.DataException dataException) {
                Utilities.logBaseException(dataException);
                throw new DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.currentStatement = null;
            if (databaseResultTable != null) {
                try {
                    try {
                        databaseResultTable.closeStatement();
                    }
                    catch (SQLException sQLException) {}
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    databaseResultTable = null;
                    throw throwable2;
                }
                Object var8_14 = null;
                databaseResultTable = null;
            }
            throw throwable;
        }
        Object var6_10 = null;
        this.currentStatement = null;
        if (databaseResultTable != null) {
            try {
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                databaseResultTable = null;
                throw throwable;
            }
            Object var8_16 = null;
            databaseResultTable = null;
        }
        if (!this.leavingRow && this.statement.isLockRows()) {
            this.applyLock(statementResultRow);
        }
    }

    protected void applyLock(StatementResultRow statementResultRow) throws DataException {
        boolean bl = false;
        if (this.isRowLocked()) {
            return;
        }
        if (!statementResultRow.isInDatabase()) {
            String string = Utilities.logMessage(IBMDBMessages.rowNotInDatabase);
            throw new DataException(string, 217);
        }
        if (statementResultRow.status == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new DataException(string, 240);
        }
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        DatabaseQuerySpec databaseQuerySpec = this.generateSelectSpec(databaseRow, true);
        DatabaseRow databaseRow2 = this.generateHostVars(databaseQuerySpec, databaseRow);
        try {
            try {
                this.singleRowResult = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                this.singleRowResult.setTimeout(this.statement.getTimeout());
                this.currentStatement = this.singleRowResult;
                this.singleRowResult.execute(databaseRow2);
                bl = this.singleRowResult.nextRow();
            }
            catch (SQLException sQLException) {
                if (this.singleRowResult != null) {
                    try {
                        try {
                            this.singleRowResult.closeStatement();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    catch (Throwable throwable) {
                        Object var8_15 = null;
                        this.singleRowResult = null;
                        throw throwable;
                    }
                    Object var8_16 = null;
                    this.singleRowResult = null;
                }
                StatementResult.handleSQLException(sQLException);
            }
            catch (com.ibm.db.base.DataException dataException) {
                if (this.singleRowResult != null) {
                    try {
                        try {
                            this.singleRowResult.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    catch (Throwable throwable) {
                        Object var8_17 = null;
                        this.singleRowResult = null;
                        throw throwable;
                    }
                    Object var8_18 = null;
                    this.singleRowResult = null;
                }
                Utilities.logBaseException(dataException);
                throw new DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var6_20 = null;
            this.currentStatement = null;
            throw throwable;
        }
        String string = null;
        this.currentStatement = null;
        if (!bl) {
            try {
                try {
                    this.singleRowResult.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.singleRowResult = null;
                throw throwable;
            }
            Object var7_12 = null;
            this.singleRowResult = null;
            if (this.leavingRow) {
                string = Utilities.logMessage(IBMDBMessages.rowChanged);
                throw new DataException(string, 237);
            }
            string = Utilities.logMessage(IBMDBMessages.rowNotFound);
            throw new DataException(string, 205);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void applyUpdate(StatementResultRow statementResultRow) throws DataException {
        block37: {
            DatabaseQuerySpec databaseQuerySpec = null;
            DatabaseResultTable databaseResultTable = null;
            DatabaseConnection databaseConnection = this.statement.getConnection();
            String string = null;
            if (databaseConnection.databaseName.equals("Microsoft SQL Server") || databaseConnection.databaseName.equals("SQL Server") || databaseConnection.databaseName.equals("Sybase SQL Server") || databaseConnection.databaseName.startsWith("Oracle") || !databaseConnection.supportsPositionedUpdate || this.statement.isForceSearchedUpdate()) {
                databaseQuerySpec = this.generateSearchedUpdateSpec(statementResultRow);
                if (databaseQuerySpec == null) {
                    return;
                }
                try {
                    try {
                        DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
                        DatabaseRow databaseRow2 = statementResultRow.getPreviousColumnValues();
                        if (databaseRow2 == null) {
                            databaseRow2 = databaseRow;
                        }
                        DatabaseRow databaseRow3 = this.generateSearchedUpdateHostVars(databaseQuerySpec, databaseRow, databaseRow2);
                        databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                        databaseResultTable.setTimeout(this.statement.getTimeout());
                        this.currentStatement = databaseResultTable;
                        databaseResultTable.execute(databaseRow3);
                        this.currentStatement = null;
                        int n = databaseResultTable.getUpdateCount();
                        if (n == 0) {
                            string = Utilities.logMessage(IBMDBMessages.rowChanged);
                            throw new DataException(string, 237);
                        }
                        if (n > 1) {
                            string = Utilities.logMessage(IBMDBMessages.multipleRowsChanged);
                        }
                    }
                    catch (SQLException sQLException) {
                        StatementResult.handleSQLException(sQLException);
                    }
                    catch (com.ibm.db.base.DataException dataException) {
                        Utilities.logBaseException(dataException);
                        throw new DataException(dataException.getMessage(), dataException.getErrorCode());
                    }
                }
                catch (Throwable throwable) {
                    Object var9_19 = null;
                    this.currentStatement = null;
                    if (databaseResultTable == null) throw throwable;
                    try {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    catch (Throwable throwable2) {
                        Object var11_28 = null;
                        databaseResultTable = null;
                        throw throwable2;
                    }
                    Object var11_29 = null;
                    databaseResultTable = null;
                    throw throwable;
                }
                Object var9_20 = null;
                this.currentStatement = null;
                if (databaseResultTable == null) return;
                try {}
                catch (Throwable throwable) {
                    Object var11_30 = null;
                    databaseResultTable = null;
                    throw throwable;
                }
                try {}
                catch (SQLException sQLException) {
                    return;
                }
                databaseResultTable.closeStatement();
                return;
            }
            if (!this.isRowLocked()) {
                boolean bl = this.leavingRow;
                this.leavingRow = true;
                this.applyLock(statementResultRow);
                this.leavingRow = bl;
            }
            if ((databaseQuerySpec = this.generatePositionedUpdateSpec(statementResultRow)) == null) {
                return;
            }
            DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
            DatabaseRow databaseRow4 = statementResultRow.getPreviousColumnValues();
            if (databaseRow4 == null) {
                databaseRow4 = databaseRow;
            }
            DatabaseRow databaseRow5 = this.generatePositionedUpdateHostVars(databaseQuerySpec, databaseRow, databaseRow4);
            try {
                try {
                    databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                    databaseResultTable.setTimeout(this.statement.getTimeout());
                    this.currentStatement = databaseResultTable;
                    databaseResultTable.execute(databaseRow5);
                }
                catch (SQLException sQLException) {
                    this.leavingRow = false;
                    StatementResult.handleSQLException(sQLException);
                }
                catch (com.ibm.db.base.DataException dataException) {
                    this.leavingRow = false;
                    Utilities.logBaseException(dataException);
                    throw new DataException(dataException.getMessage(), dataException.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                Object var9_22 = null;
                this.currentStatement = null;
                if (databaseResultTable != null) {
                    try {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    catch (Throwable throwable3) {
                        Object var11_32 = null;
                        databaseResultTable = null;
                        throw throwable3;
                    }
                    Object var11_33 = null;
                    databaseResultTable = null;
                }
                if (!this.leavingRow) {
                    if (this.statement.isLockRows()) throw throwable;
                }
                this.unlockRow();
                throw throwable;
            }
            Object var9_23 = null;
            this.currentStatement = null;
            if (databaseResultTable == null) break block37;
            try {}
            catch (Throwable throwable) {
                Object var11_34 = null;
                databaseResultTable = null;
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            databaseResultTable.closeStatement();
            Object var11_35 = null;
            databaseResultTable = null;
        }
        if (!this.leavingRow) {
            if (this.statement.isLockRows()) return;
        }
        this.unlockRow();
    }

    public void cancelAction() throws DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        this.checkConnection();
        if (this.currentStatement == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuting);
            throw new DataException(string, 246);
        }
        try {
            this.currentStatement.cancel();
            try {
                try {
                    this.currentStatement.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.currentStatement = null;
                throw throwable;
            }
            Object var2_5 = null;
            this.currentStatement = null;
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    protected void checkConnection() throws DataException {
        if (this.statement.getConnection() == null || !this.statement.getConnection().isConnected()) {
            this.statement.disconnect();
            String string = Utilities.logMessage(IBMDBMessages.noActiveConnection);
            throw new DataException(string, 226);
        }
    }

    public synchronized void close() throws DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        this.statement.close();
    }

    protected void closeInternal(boolean bl) throws DataException {
        if (!bl) {
            this.updateRowBeforeLeaving();
        }
        if (this.statement.getConnection() == null || !this.statement.getConnection().isConnected()) {
            this.statement.disconnect();
        } else {
            block9: {
                try {
                    try {
                        if (this.rt != null) {
                            this.rt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (bl) {
                            Utilities.logSQLException(sQLException);
                            break block9;
                        }
                        StatementResult.handleSQLException(sQLException);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    this.moreRows = false;
                    this.previousRows = false;
                    this.rt = null;
                    throw throwable;
                }
            }
            Object var2_5 = null;
            this.moreRows = false;
            this.previousRows = false;
            this.rt = null;
        }
    }

    public synchronized void closeResult() throws DataException {
        this.fireAboutToClose(new DataEvent(this));
        this.closeInternal(false);
        this.fireClosed(new DataEvent(this));
    }

    public Enumeration columnNames() throws DataException {
        if (this.metaData == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        return this.metaData.getColumnNames();
    }

    public synchronized void deleteRow() throws DataException {
        StatementResultRow statementResultRow;
        block9: {
            statementResultRow = this.getCurrentRowObject();
            try {
                this.checkConnection();
            }
            catch (DataException dataException) {
                if (statementResultRow.getStatus() == 2 && dataException.getErrorCode() == 226) break block9;
                throw dataException;
            }
        }
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"deleteRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string, 215);
        }
        if (statementResultRow.getStatus() == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new DataException(string, 240);
        }
        this.fireAboutToDeleteRow(new DataEvent(this));
        this.changes.addElement(statementResultRow);
        statementResultRow.setNumberWhenChanged(this.fieldCurrentRow);
        statementResultRow.setAction(2);
        this.rows.removeElementAt(this.fieldCurrentRowInCache - 1);
        --this.fieldNumRows;
        --this.fieldNumRowsInCache;
        if (!this.deferUpdates) {
            this.apply();
        }
        Integer n = null;
        Integer n2 = null;
        if (this.moreRows) {
            this.fetchNextRow();
            this.fireCacheRowsChanged(new DataEvent(this, 2));
        } else {
            this.fireCacheRowsChanged(new DataEvent(this, 1));
            if (this.fieldCurrentRow > this.fieldNumRows) {
                n = new Integer(this.fieldCurrentRow);
                n2 = new Integer(this.fieldCurrentRowInCache);
                --this.fieldCurrentRow;
                --this.fieldCurrentRowInCache;
            }
        }
        if (this.statement.isLockRows() && this.fieldCurrentRow != 0) {
            this.lockRow();
        }
        this.firePropertyChange("currentRow", n, new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", n2, new Integer(this.fieldCurrentRowInCache));
        this.fireDeletedRow(new DataEvent(this));
    }

    protected String delimitName(String string) throws DataException {
        int n;
        String string2;
        String string3 = string2 = "\"";
        if (this.statement.getConnection().supportsMixedCaseIdentifiers || !this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            return string;
        }
        int n2 = 0;
        while ((n = string.indexOf(".", n2)) >= 0) {
            string3 = String.valueOf(string3) + string.substring(n2, n);
            string3 = String.valueOf(string3) + string2 + "." + string2;
            n2 = n + 1;
        }
        string3 = String.valueOf(string3) + string.substring(n2);
        string3 = String.valueOf(string3) + string2;
        return string3;
    }

    protected void disconnect() {
        this.rt = null;
        this.moreRows = false;
        this.previousRows = false;
        this.singleRowResult = null;
    }

    protected void fetchNextPacket() throws DataException {
        int n;
        if (!this.moreRows) {
            return;
        }
        if (this.rt == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldNumPacketsInCache == this.statement.getMaximumPacketsInCache() && this.statement.getMaximumPacketsInCache() > 0) {
            if (this.fieldCurrentRowInCache <= this.statement.getPacketSize() && this.fieldCurrentRowInCache > 0) {
                this.updateRowBeforeLeaving();
            }
            n = 0;
            while (n < this.statement.getPacketSize()) {
                this.rows.removeElementAt(0);
                --this.fieldNumRowsInCache;
                --this.fieldCurrentRowInCache;
                ++n;
            }
            --this.fieldNumPacketsInCache;
        }
        if ((n = this.statement.getPacketSize()) < 1) {
            n = 1;
        }
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if (!this.moreRows) break;
            this.fetchNextRow();
            ++n2;
        }
        if (n2 > 0) {
            ++this.fieldNumPacketsInCache;
        }
    }

    protected void fetchNextRow() throws DataException {
        int n = this.fieldCurrentRow - this.fieldCurrentRowInCache + this.fieldNumRowsInCache;
        if (!this.moreRows) {
            return;
        }
        if (this.fetchDirection != 1) {
            try {
                this.rt.absoluteRow(n);
                this.previousRows = true;
                if (!this.rt.nextRow()) {
                    this.moreRows = false;
                }
                this.fetchDirection = 1;
            }
            catch (SQLException sQLException) {
                StatementResult.handleSQLException(sQLException);
            }
        }
        if (!this.moreRows) {
            return;
        }
        try {
            DatabaseRow databaseRow;
            DatabaseRow databaseRow2 = databaseRow = this.rt.getRow();
            StatementResultRow statementResultRow = new StatementResultRow(databaseRow2);
            SQLWarning sQLWarning = this.rt.getWarnings();
            while (sQLWarning != null) {
                if (sQLWarning.getSQLState().equals("01004")) {
                    statementResultRow.setStatus(3);
                    break;
                }
                sQLWarning = sQLWarning.getNextWarning();
            }
            this.rows.addElement(statementResultRow);
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        catch (com.ibm.db.base.DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new DataException(dataException.getMessage(), dataException.getErrorCode());
        }
        ++this.fieldNumRowsInCache;
        try {
            if (this.rt.nextRow()) {
                this.previousRows = true;
            } else {
                this.moreRows = false;
            }
            this.fetchDirection = 1;
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        n = this.fieldCurrentRow - this.fieldCurrentRowInCache + this.fieldNumRowsInCache;
        if (n > this.fieldNumRows) {
            this.fieldNumRows = n;
        }
        if (n >= this.statement.getMaximumRows() && this.statement.getMaximumRows() > 0) {
            this.moreRows = false;
        }
    }

    protected void fetchPreviousPacket() throws DataException {
        int n;
        int n2;
        if (!this.previousRows) {
            return;
        }
        if (this.rt == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        int n3 = this.statement.getPacketSize();
        if (n3 < 1) {
            n3 = 1;
        }
        if (this.fieldNumPacketsInCache == (n2 = this.statement.getMaximumPacketsInCache()) && n2 > 0) {
            if (this.fieldNumRowsInCache - this.fieldCurrentRowInCache < this.statement.getPacketSize() && this.fieldCurrentRowInCache > 0) {
                this.updateRowBeforeLeaving();
            }
            n = (n2 - 1) * n3;
            int n4 = this.rows.size();
            int n5 = n;
            while (n5 < n4) {
                this.rows.removeElementAt(n);
                --this.fieldNumRowsInCache;
                ++n5;
            }
            --this.fieldNumPacketsInCache;
        }
        n = 0;
        n = 0;
        while (n < n3) {
            if (!this.previousRows) break;
            this.fetchPreviousRow();
            ++this.fieldCurrentRowInCache;
            ++n;
        }
        if (n > 0) {
            ++this.fieldNumPacketsInCache;
        }
    }

    protected void fetchPreviousRow() throws DataException {
        if (!this.previousRows) {
            return;
        }
        if (this.fetchDirection != -1) {
            try {
                int n = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
                this.rt.absoluteRow(n);
                this.moreRows = true;
                if (!this.rt.previousRow()) {
                    this.previousRows = false;
                }
                this.fetchDirection = -1;
            }
            catch (SQLException sQLException) {
                StatementResult.handleSQLException(sQLException);
            }
        }
        if (!this.previousRows) {
            return;
        }
        try {
            DatabaseRow databaseRow;
            DatabaseRow databaseRow2 = databaseRow = this.rt.getRow();
            StatementResultRow statementResultRow = new StatementResultRow(databaseRow2);
            SQLWarning sQLWarning = this.rt.getWarnings();
            while (sQLWarning != null) {
                if (sQLWarning.getSQLState().equals("01004")) {
                    statementResultRow.setStatus(3);
                    break;
                }
                sQLWarning = sQLWarning.getNextWarning();
            }
            this.rows.insertElementAt(statementResultRow, 0);
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        catch (com.ibm.db.base.DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new DataException(dataException.getMessage(), dataException.getErrorCode());
        }
        ++this.fieldNumRowsInCache;
        try {
            if (this.rt.previousRow()) {
                this.moreRows = true;
            } else {
                this.previousRows = false;
            }
            this.fetchDirection = -1;
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void fireAboutToSetColumnValue(PropertyChangeEvent propertyChangeEvent) {
        if (this.aStatementResultValueChangeListener == null) {
            return;
        }
        this.aStatementResultValueChangeListener.aboutToSetColumnValue(propertyChangeEvent);
    }

    protected void fireCacheRowsChanged(DataEvent dataEvent) {
        if (this.aStatementResultAfterListener == null) {
            return;
        }
        this.aStatementResultAfterListener.cacheRowsChanged(dataEvent);
    }

    protected void fireColumnValueSet(PropertyChangeEvent propertyChangeEvent) {
        if (this.aStatementResultValueChangeListener == null) {
            return;
        }
        this.aStatementResultValueChangeListener.columnValueSet(propertyChangeEvent);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    public void firstRow() throws DataException {
        this.setCurrentRow(1);
    }

    protected void flushCacheAndGoTo(int n) throws DataException {
        int n2 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
        int n3 = n2 + this.fieldNumRowsInCache - 1;
        int n4 = 0;
        int n5 = 0;
        if (this.fieldCurrentRow <= n) {
            n5 = 1;
            n4 = n3;
            if (!this.moreRows) {
                return;
            }
        } else {
            n5 = -1;
            n4 = n2;
            if (!this.previousRows) {
                return;
            }
        }
        try {
            int n6 = this.rt.getRowNumber();
            boolean bl = this.rt.absoluteRow(n);
            if (!bl) {
                this.rt.previousRow();
                int n7 = this.rt.getRowNumber();
                int n8 = this.getPacketsToSkip(n5, n7);
                if (n8 > 0) {
                    int n9 = this.statement.getPacketSize();
                    if (n9 < 1) {
                        n9 = 1;
                    }
                    int n10 = n8 * n9;
                    n = n4 + (n10 + 1) * n5;
                    bl = this.rt.absoluteRow(n);
                }
            }
            if (!bl) {
                this.rt.absoluteRow(n6);
            } else {
                this.fetchDirection = n5;
                this.fieldCurrentRowInCache = this.fieldCurrentRowInCache - (n - n4) + n5;
                if (n5 == 1) {
                    this.fieldCurrentRowInCache -= this.rows.size();
                }
                this.fieldNumRowsInCache = 0;
                this.fieldNumPacketsInCache = 0;
                if (n5 == 1 && n - 1 > this.fieldNumRows) {
                    this.fieldNumRows = n - 1;
                }
                this.moreRows = true;
                this.previousRows = true;
                this.rows.removeAllElements();
            }
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    protected String generateCastColumn(DatabaseTypeField databaseTypeField) throws DataException {
        StringBuffer stringBuffer = new StringBuffer(60);
        String string = databaseTypeField.getName();
        String string2 = databaseTypeField.getSQLTypeName();
        int n = databaseTypeField.getSQLType();
        int n2 = string.lastIndexOf(".");
        string = string.substring(n2 + 1);
        string = this.delimitName(string);
        stringBuffer.append("CAST (");
        stringBuffer.append(String.valueOf(string) + " AS ");
        stringBuffer.append(string2);
        if (n == 1 || n == 12 || n == -2 || n == -3) {
            stringBuffer.append("(" + databaseTypeField.getLength() + ")");
        } else if (n == 3 || n == 2) {
            stringBuffer.append("(" + databaseTypeField.getLength() + "," + databaseTypeField.getScale() + ")");
        }
        stringBuffer.append(") = ?");
        return stringBuffer.toString();
    }

    protected String generateCastParam(DatabaseTypeField databaseTypeField) throws DataException {
        StringBuffer stringBuffer = new StringBuffer(60);
        String string = databaseTypeField.getName();
        int n = string.lastIndexOf(".");
        string = string.substring(n + 1);
        string = this.delimitName(string);
        stringBuffer.append(string);
        stringBuffer.append(" = CAST (? AS ");
        stringBuffer.append(databaseTypeField.getSQLTypeName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String generateCompare(DatabaseTypeField databaseTypeField) throws DataException {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string = databaseTypeField.getName();
        int n = databaseTypeField.getSQLType();
        if (n == 2001) {
            stringBuffer.append(this.generateCastParam(databaseTypeField));
        } else if (this.statement.areDistinctTypesEnabled()) {
            stringBuffer.append(this.generateCastColumn(databaseTypeField));
        } else {
            int n2 = string.lastIndexOf(".");
            string = string.substring(n2 + 1);
            string = this.delimitName(string);
            stringBuffer.append(string);
            stringBuffer.append(" = ?");
        }
        return stringBuffer.toString();
    }

    protected DatabaseRow generateHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow2 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        while (n <= databaseCompoundType.size()) {
            String string = databaseCompoundType.fieldAt(n).getName();
            Object object = databaseRow.get(string);
            databaseRow2.putAtIndex(n, object);
            databaseRow2.setColWasChanged(n, true);
            ++n;
        }
        return databaseRow2;
    }

    protected DatabaseRow generateInsertHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow2 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        int n2 = 1;
        while (n2 <= databaseRow.size()) {
            if (databaseRow.colWasChanged(n2)) {
                databaseRow2.putAtIndex(n, databaseRow.getAtIndex(n2));
                databaseRow2.setColWasChanged(n, true);
                ++n;
            }
            ++n2;
        }
        return databaseRow2;
    }

    protected DatabaseQuerySpec generateInsertSpec(StatementResultRow statementResultRow) throws DataException {
        this.metaData.getTables();
        boolean bl = true;
        DatabaseCompoundType databaseCompoundType = null;
        DatabaseQuerySpec databaseQuerySpec = null;
        int n = this.statement.getMetaData().getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        try {
            databaseCompoundType = new DatabaseCompoundType(this.statement.getMetaData().getColumnShape());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.generateTableName(true));
        stringBuffer.append(" (");
        bl = true;
        Enumeration enumeration = this.columnNames();
        int n2 = 1;
        while (n2 <= this.getColumnCount()) {
            String string = (String)enumeration.nextElement();
            if (!statementResultRow.getCurrentColumnValues().colWasChanged(n2)) {
                databaseCompoundType.removeFieldAt(string);
            } else {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                int n3 = string.lastIndexOf(".");
                string = string.substring(n3 + 1);
                string = this.delimitName(string);
                stringBuffer.append(string);
            }
            ++n2;
        }
        stringBuffer.append(") VALUES (");
        bl = true;
        n2 = 1;
        while (n2 <= databaseCompoundType.size()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(" ?");
            ++n2;
        }
        stringBuffer.append(" )");
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected String generatePositionedDeleteSQL() throws DataException {
        this.metaData.getTables();
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.generateTableName(true));
        stringBuffer.append(" WHERE CURRENT OF ");
        try {
            stringBuffer.append(this.singleRowResult.getCursorName());
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        return new String(stringBuffer);
    }

    protected DatabaseRow generatePositionedUpdateHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow3 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        int n2 = 1;
        while (n2 <= databaseRow.size()) {
            if (databaseRow.colWasChanged(n2)) {
                databaseRow3.putAtIndex(n, databaseRow.getAtIndex(n2));
                databaseRow3.setColWasChanged(n, true);
                ++n;
            }
            ++n2;
        }
        return databaseRow3;
    }

    protected DatabaseQuerySpec generatePositionedUpdateSpec(StatementResultRow statementResultRow) throws DataException {
        this.metaData.getTables();
        boolean bl = true;
        DatabaseCompoundType databaseCompoundType = null;
        DatabaseQuerySpec databaseQuerySpec = null;
        int n = this.statement.getMetaData().getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (this.statement.getConnection().supportsMixedCaseIdentifiers || this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            // empty if block
        }
        try {
            databaseCompoundType = new DatabaseCompoundType(this.statement.getMetaData().getColumnShape());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.generateTableName(true));
        stringBuffer.append(" SET ");
        Enumeration enumeration = this.columnNames();
        int n2 = 1;
        while (n2 <= this.getColumnCount()) {
            String string = (String)enumeration.nextElement();
            if (!statementResultRow.getCurrentColumnValues().colWasChanged(n2)) {
                databaseCompoundType.removeFieldAt(string);
            } else {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                int n3 = string.lastIndexOf(".");
                string = string.substring(n3 + 1);
                stringBuffer.append(this.delimitName(string));
                stringBuffer.append(" = ?");
            }
            ++n2;
        }
        if (databaseCompoundType.size() == 0) {
            return null;
        }
        stringBuffer.append(" WHERE CURRENT OF ");
        try {
            stringBuffer.append(this.singleRowResult.getCursorName());
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseQuerySpec generateSearchedDeleteSpec(StatementResultRow statementResultRow) throws DataException {
        int n;
        Object object;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        boolean bl = true;
        DatabaseCompoundType databaseCompoundType = null;
        int n2 = this.metaData.getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (this.statement.getConnection().supportsMixedCaseIdentifiers || this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            // empty if block
        }
        databaseCompoundType = new DatabaseCompoundType();
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.generateTableName(true));
        stringBuffer.append(" WHERE ");
        bl = true;
        Enumeration enumeration = this.columnNames();
        int n3 = 0;
        while (n3 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            object = databaseRow.getType().fieldAt(n3 + 1);
            if (((DatabaseTypeField)object).isSearchable()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                string = this.delimitName(string);
                Object object2 = databaseRow.getAtIndex(n3 + 1);
                if (object2 == null) {
                    stringBuffer.append(String.valueOf(string) + " IS NULL");
                } else {
                    stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                    try {
                        databaseCompoundType.addField((DatabaseTypeField)((DatabaseTypeField)object).clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            ++n3;
        }
        if (bl) {
            enumeration = this.columnNames();
            n3 = 0;
            while (n3 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                object = databaseRow.getType().fieldAt(n3 + 1);
                int n4 = ((DatabaseTypeField)object).getSQLType();
                if (n4 != -4 && n4 != -1 && n4 != 2005 && n4 != 2004 && n4 != 70) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    n = string.lastIndexOf(".");
                    string = string.substring(n + 1);
                    string = this.delimitName(string);
                    Object object3 = databaseRow.getAtIndex(n3 + 1);
                    if (object3 == null) {
                        stringBuffer.append(String.valueOf(string) + " IS NULL");
                    } else {
                        stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                        try {
                            databaseCompoundType.addField((DatabaseTypeField)((DatabaseTypeField)object).clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                ++n3;
            }
        }
        if (bl) {
            object = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new DataException((String)object, 249);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseRow generateSearchedUpdateHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow3 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        int n2 = 1;
        while (n2 <= databaseRow.size()) {
            if (databaseRow.colWasChanged(n2)) {
                databaseRow3.putAtIndex(n, databaseRow.getAtIndex(n2));
                databaseRow3.setColWasChanged(n, true);
                ++n;
            }
            ++n2;
        }
        n2 = n;
        while (n2 <= databaseCompoundType.size()) {
            String string = databaseCompoundType.fieldAt(n2).getName();
            string = string.substring(0, string.length() - 6);
            Object object = databaseRow2.get(string);
            databaseRow3.putAtIndex(n2, object);
            databaseRow3.setColWasChanged(n2, true);
            ++n2;
        }
        return databaseRow3;
    }

    protected DatabaseQuerySpec generateSearchedUpdateSpec(StatementResultRow statementResultRow) throws DataException {
        DatabaseTypeField databaseTypeField;
        Object object;
        int n;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        this.metaData.getTables();
        DatabaseCompoundType databaseCompoundType = null;
        boolean bl = true;
        int n2 = this.statement.getMetaData().getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (this.statement.getConnection().supportsMixedCaseIdentifiers || this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            // empty if block
        }
        try {
            databaseCompoundType = new DatabaseCompoundType(this.statement.getMetaData().getColumnShape());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.generateTableName(true));
        stringBuffer.append(" SET ");
        Enumeration enumeration = this.columnNames();
        bl = true;
        int n3 = 1;
        while (n3 <= this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            if (!statementResultRow.getCurrentColumnValues().colWasChanged(n3)) {
                databaseCompoundType.removeFieldAt(string);
            } else {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                stringBuffer.append(this.delimitName(string));
                stringBuffer.append(" = ?");
            }
            ++n3;
        }
        if (databaseCompoundType.size() == 0) {
            return null;
        }
        stringBuffer.append(" WHERE ");
        bl = true;
        enumeration = this.columnNames();
        n3 = 0;
        while (n3 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            object = databaseRow.getType().fieldAt(n3 + 1);
            if (((DatabaseTypeField)object).isSearchable()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                string = this.delimitName(string);
                Object object2 = databaseRow.getAtIndex(n3 + 1);
                if (object2 == null) {
                    stringBuffer.append(String.valueOf(string) + " IS NULL");
                } else {
                    stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                    try {
                        databaseTypeField = (DatabaseTypeField)((DatabaseTypeField)object).clone();
                        databaseTypeField.setName(String.valueOf(databaseTypeField.getName()) + "_WHERE");
                        databaseCompoundType.addFieldWithProposedName(databaseTypeField);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            ++n3;
        }
        if (bl) {
            enumeration = this.columnNames();
            n3 = 0;
            while (n3 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                object = databaseRow.getType().fieldAt(n3 + 1);
                int n4 = ((DatabaseTypeField)object).getSQLType();
                if (n4 != -4 && n4 != -1 && n4 != 2005 && n4 != 2004 && n4 != 70) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    n = string.lastIndexOf(".");
                    string = string.substring(n + 1);
                    string = this.delimitName(string);
                    Object object3 = databaseRow.getAtIndex(n3 + 1);
                    if (object3 == null) {
                        stringBuffer.append(String.valueOf(string) + " IS NULL");
                    } else {
                        stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                        try {
                            databaseTypeField = (DatabaseTypeField)((DatabaseTypeField)object).clone();
                            databaseTypeField.setName(String.valueOf(databaseTypeField.getName()) + "_WHERE");
                            databaseCompoundType.addFieldWithProposedName(databaseTypeField);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                ++n3;
            }
        }
        if (bl) {
            object = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new DataException((String)object, 249);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseQuerySpec generateSelectSpec(int n, DatabaseRow databaseRow) throws DataException {
        Object object;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType();
        DatabaseCompoundType databaseCompoundType2 = new DatabaseCompoundType();
        boolean bl = true;
        int n2 = 0;
        int n3 = this.metaData.getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append("SELECT ");
        DatabaseTypeField databaseTypeField = databaseRow.getType().fieldAt(n);
        databaseCompoundType2.addField(databaseRow.getType().fieldAt(n));
        stringBuffer.append(this.delimitName(databaseTypeField.getName()));
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.generateTableName(false));
        stringBuffer.append(" WHERE ");
        bl = true;
        Enumeration enumeration = this.columnNames();
        n2 = 0;
        while (n2 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            object = databaseRow.getType().fieldAt(n2 + 1);
            if (databaseRow.getType().fieldAt(n2 + 1).isSearchable()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                string = this.delimitName(string);
                Object object2 = databaseRow.getAtIndex(n2 + 1);
                if (object2 == null) {
                    stringBuffer.append(String.valueOf(string) + " IS NULL");
                } else {
                    stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                    databaseCompoundType.addField((DatabaseTypeField)object);
                }
            }
            ++n2;
        }
        if (bl) {
            enumeration = this.columnNames();
            n2 = 0;
            while (n2 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                object = databaseRow.getType().fieldAt(n2 + 1);
                int n4 = databaseRow.getType().fieldAt(n2 + 1).getSQLType();
                if (n4 != -4 && n4 != -1 && n4 != 2005 && n4 != 2004 && n4 != 70) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    string = this.delimitName(string);
                    Object object3 = databaseRow.getAtIndex(n2 + 1);
                    if (object3 == null) {
                        stringBuffer.append(String.valueOf(string) + " IS NULL");
                    } else {
                        stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                        databaseCompoundType.addField((DatabaseTypeField)object);
                    }
                }
                ++n2;
            }
        }
        if (bl) {
            object = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new DataException((String)object, 249);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setOutputShape(databaseCompoundType2);
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseQuerySpec generateSelectSpec(DatabaseRow databaseRow, boolean bl) throws DataException {
        Object object;
        int n;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType();
        boolean bl2 = true;
        int n2 = 0;
        int n3 = this.metaData.getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n3);
        if (this.statement.getConnection().supportsMixedCaseIdentifiers || this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            // empty if block
        }
        stringBuffer.append("SELECT ");
        Enumeration enumeration = this.columnNames();
        n2 = 0;
        while (n2 < this.getColumnCount()) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            string = (String)enumeration.nextElement();
            n = string.lastIndexOf(".");
            string = string.substring(n + 1);
            string = this.delimitName(string);
            stringBuffer.append(string);
            ++n2;
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.generateTableName(bl));
        stringBuffer.append(" WHERE ");
        bl2 = true;
        enumeration = this.columnNames();
        n2 = 0;
        while (n2 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            object = databaseRow.getType().fieldAt(n2 + 1);
            if (((DatabaseTypeField)object).isSearchable()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                string = this.delimitName(string);
                Object object2 = databaseRow.getAtIndex(n2 + 1);
                ((DatabaseTypeField)object).getSQLType();
                if (object2 == null) {
                    stringBuffer.append(String.valueOf(string) + " IS NULL");
                } else {
                    stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                    databaseCompoundType.addField((DatabaseTypeField)object);
                }
            }
            ++n2;
        }
        if (bl2) {
            enumeration = this.columnNames();
            n2 = 0;
            while (n2 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                object = databaseRow.getType().fieldAt(n2 + 1);
                int n4 = databaseRow.getType().fieldAt(n2 + 1).getSQLType();
                if (n4 != -4 && n4 != -1 && n4 != 2005 && n4 != 2004 && n4 != 70) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    n = string.lastIndexOf(".");
                    string = string.substring(n + 1);
                    string = this.delimitName(string);
                    Object object3 = databaseRow.getAtIndex(n2 + 1);
                    if (object3 == null) {
                        stringBuffer.append(String.valueOf(string) + " IS NULL");
                    } else {
                        stringBuffer.append(this.generateCompare((DatabaseTypeField)object));
                        databaseCompoundType.addField((DatabaseTypeField)object);
                    }
                }
                ++n2;
            }
        }
        if (bl2) {
            object = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new DataException((String)object, 249);
        }
        if (bl) {
            stringBuffer.append(" FOR UPDATE OF ");
            enumeration = this.columnNames();
            n2 = 0;
            while (n2 < this.getColumnCount()) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                string = (String)enumeration.nextElement();
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                stringBuffer.append(this.delimitName(string));
                ++n2;
            }
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected String generateTableName(boolean bl) throws DataException {
        String string;
        String string2;
        block10: {
            string2 = "";
            Enumeration enumeration = this.statement.getMetaData().getTables();
            if (!enumeration.hasMoreElements()) {
                string = null;
                String string3 = " \t\n\r";
                String string4 = this.metaData.getSQL();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, String.valueOf(string3) + ",", true);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (!string.toUpperCase().equals("FROM")) continue;
                    string = stringTokenizer.nextToken();
                    string2 = String.valueOf(string2) + stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        if (string.equals(",")) {
                            string2 = String.valueOf(string2) + ", ";
                            string = stringTokenizer.nextToken();
                            string2 = String.valueOf(string2) + stringTokenizer.nextToken();
                            continue;
                        }
                        if (string3.indexOf(string) >= 0) {
                            continue;
                        }
                        break block10;
                    }
                    break;
                }
            } else {
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    if (n > 0) {
                        string2 = String.valueOf(string2) + ", ";
                    }
                    string = (String)enumeration.nextElement();
                    string2 = String.valueOf(string2) + this.delimitName(string);
                    ++n;
                }
            }
        }
        if (string2.equals("")) {
            string = Utilities.logMessage(IBMDBMessages.noTableDefined);
            throw new DataException(string, 250);
        }
        if (bl && string2.indexOf(",") >= 0) {
            string = Utilities.logMessage(IBMDBMessages.multipleTables);
            throw new DataException(string, 218);
        }
        return string2;
    }

    public Object getCacheValueAt(int n, int n2) throws DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted() && !this.statement.executing) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldCurrentRow <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new DataException(string, 214);
        }
        if (n <= 0) {
            Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n - 1)} : new Object[]{new Integer(n)};
            String string = Utilities.logMessage(IBMDBMessages.beforeCacheStart, objectArray);
            throw new DataException(string, 216);
        }
        if (n > this.fieldNumRowsInCache) {
            Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n - 1)} : new Object[]{new Integer(n)};
            String string = Utilities.logMessage(IBMDBMessages.indexTooLarge, objectArray);
            throw new DataException(string, 234);
        }
        return this.getValueAndValidate(n, n2);
    }

    public int getColumnCount() throws DataException {
        if (this.metaData == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        return this.metaData.getColumnCount();
    }

    public String getColumnName(int n) throws DataException {
        if (this.metaData == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        return this.metaData.getColumnName(n);
    }

    public Object getColumnValue(int n) throws DataException {
        this.getCurrentRowObject();
        return this.getValueAndValidate(this.fieldCurrentRowInCache, n);
    }

    public Object getColumnValue(String string) throws DataException {
        this.getCurrentRowObject();
        return this.getValueAndValidate(this.fieldCurrentRowInCache, this.metaData.getColumnIndex(string));
    }

    public String getColumnValueToString(int n) throws DataException {
        String string = null;
        Object object = this.getColumnValue(n);
        if (object == null) {
            string = null;
            return string;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            string = (String)object;
        } else {
            Class<?> clazz3 = class$java$lang$Integer;
            if (clazz3 == null) {
                try {
                    clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz3) {
                string = ((Integer)object).toString();
            } else {
                Class<?> clazz4 = class$java$lang$Long;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$java$lang$Long = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz4) {
                    string = ((Long)object).toString();
                } else {
                    Class<?> clazz5 = class$java$lang$Short;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz5) {
                        string = ((Short)object).toString();
                    } else {
                        Class<?> clazz6 = class$java$math$BigDecimal;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz6) {
                            string = ((BigDecimal)object).toString();
                        } else {
                            Class<?> clazz7 = class$java$lang$Float;
                            if (clazz7 == null) {
                                try {
                                    clazz7 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz7) {
                                string = ((Float)object).toString();
                            } else {
                                Class<?> clazz8 = class$java$lang$Double;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz8) {
                                    string = ((Double)object).toString();
                                } else {
                                    Class<?> clazz9 = class$java$lang$Boolean;
                                    if (clazz9 == null) {
                                        try {
                                            clazz9 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz9) {
                                        string = ((Boolean)object).toString();
                                    } else {
                                        Class<?> clazz10 = class$java$sql$Date;
                                        if (clazz10 == null) {
                                            try {
                                                clazz10 = class$java$sql$Date = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz10) {
                                            string = ((Date)object).toString();
                                        } else {
                                            Class<?> clazz11 = class$java$sql$Time;
                                            if (clazz11 == null) {
                                                try {
                                                    clazz11 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz11) {
                                                string = ((Time)object).toString();
                                            } else {
                                                Class<?> clazz12 = class$java$sql$Timestamp;
                                                if (clazz12 == null) {
                                                    try {
                                                        clazz12 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz12) {
                                                    string = ((Timestamp)object).toString();
                                                } else {
                                                    Class<?> clazz13 = class$java$net$URL;
                                                    if (clazz13 == null) {
                                                        try {
                                                            clazz13 = class$java$net$URL = Class.forName("java.net.URL");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz13) {
                                                        string = ((URL)object).toString();
                                                    } else {
                                                        Class<?> clazz14 = class$array1$$byte;
                                                        if (clazz14 == null) {
                                                            try {
                                                                clazz14 = class$array1$$byte = Class.forName("[B");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                        }
                                                        if (clazz == clazz14) {
                                                            byte[] byArray = (byte[])object;
                                                            StringBuffer stringBuffer = new StringBuffer(byArray.length);
                                                            int n2 = 0;
                                                            while (n2 < byArray.length) {
                                                                String string2;
                                                                int n3 = byArray[n2];
                                                                if (n3 < 0) {
                                                                    n3 &= 0xFF;
                                                                }
                                                                if ((string2 = Integer.toString(n3, 16)).length() == 1) {
                                                                    stringBuffer.append("0");
                                                                }
                                                                stringBuffer.append(string2);
                                                                ++n2;
                                                            }
                                                            string = new String(stringBuffer);
                                                        } else {
                                                            Class<?> clazz15 = class$java$sql$Clob;
                                                            if (clazz15 == null) {
                                                                try {
                                                                    clazz15 = class$java$sql$Clob = Class.forName("java.sql.Clob");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                            }
                                                            if (clazz15.isInstance(object)) {
                                                                InputStream inputStream;
                                                                try {
                                                                    inputStream = ((Clob)object).getAsciiStream();
                                                                }
                                                                catch (SQLException sQLException) {
                                                                    Object[] objectArray = new Object[]{this.getColumnName(n), sQLException.getMessage()};
                                                                    String string3 = Utilities.logMessage(IBMDBMessages.cannotConvertToString, objectArray);
                                                                    throw new DataException(string3, 251);
                                                                }
                                                                if (inputStream == null) {
                                                                    string = null;
                                                                } else {
                                                                    try {
                                                                        int n4 = inputStream.available();
                                                                        byte[] byArray = new byte[n4];
                                                                        inputStream.read(byArray, 0, n4);
                                                                        string = new String(byArray);
                                                                    }
                                                                    catch (IOException iOException) {
                                                                        Object[] objectArray = new Object[]{this.getColumnName(n), iOException.getMessage()};
                                                                        String string4 = Utilities.logMessage(IBMDBMessages.cannotConvertToString, objectArray);
                                                                        throw new DataException(string4, 251);
                                                                    }
                                                                }
                                                            } else {
                                                                Class<?> clazz16 = class$java$io$InputStream;
                                                                if (clazz16 == null) {
                                                                    try {
                                                                        clazz16 = class$java$io$InputStream = Class.forName("java.io.InputStream");
                                                                    }
                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                    }
                                                                }
                                                                if (clazz16.isInstance(object)) {
                                                                    try {
                                                                        ((InputStream)object).reset();
                                                                        int n5 = ((InputStream)object).available();
                                                                        byte[] byArray = new byte[n5];
                                                                        ((InputStream)object).read(byArray, 0, n5);
                                                                        string = new String(byArray);
                                                                    }
                                                                    catch (IOException iOException) {
                                                                        Object[] objectArray = new Object[]{this.getColumnName(n), iOException.getMessage()};
                                                                        String string5 = Utilities.logMessage(IBMDBMessages.cannotConvertToString, objectArray);
                                                                        throw new DataException(string5, 251);
                                                                    }
                                                                } else {
                                                                    Object[] objectArray = new Object[]{this.getColumnName(n), ""};
                                                                    String string6 = Utilities.logMessage(IBMDBMessages.cannotConvertToString, objectArray);
                                                                    throw new DataException(string6, 251);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public String getColumnValueToString(String string) throws DataException {
        if (this.statement == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string2, 229);
        }
        return this.getColumnValueToString(this.metaData.getColumnIndex(string));
    }

    public int getCurrentRow() {
        return this.fieldCurrentRow;
    }

    public int getCurrentRowInCache() {
        return this.fieldCurrentRowInCache;
    }

    protected StatementResultRow getCurrentRowObject() throws DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted() && !this.statement.executing) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldCurrentRow <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new DataException(string, 214);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(this.fieldCurrentRow - 1)} : new Object[]{new Integer(this.fieldCurrentRow)};
            String string = Utilities.logMessage(IBMDBMessages.beforeCacheStart, objectArray);
            throw new DataException(string, 216);
        }
        return (StatementResultRow)this.rows.elementAt(this.fieldCurrentRowInCache - 1);
    }

    public int getNumPacketsInCache() {
        return this.fieldNumPacketsInCache;
    }

    public int getNumRowsInCache() {
        return this.fieldNumRowsInCache;
    }

    protected int getPacketsToSkip(int n, int n2) throws DataException {
        int n3 = 0;
        int n4 = this.statement.getMaximumPacketsInCache();
        if (n4 < 1) {
            return 0;
        }
        int n5 = this.statement.getPacketSize();
        if (n5 < 1) {
            n5 = 1;
        }
        int n6 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
        int n7 = n6 + this.fieldNumRowsInCache - 1;
        int n8 = n > 0 ? n7 : n6;
        int n9 = (n2 - n8) * n;
        int n10 = n9 / n5;
        if (n9 % n5 != 0) {
            ++n10;
        }
        n3 = n10 - n4;
        return n3;
    }

    protected Object getValueAndValidate(int n, int n2) throws DataException {
        Object object;
        block17: {
            DatabaseRow databaseRow = null;
            boolean bl = false;
            StatementResultRow statementResultRow = (StatementResultRow)this.rows.elementAt(n - 1);
            object = statementResultRow.getColumnValue(n2);
            if (this.statement.isValidateLOBs()) {
                Class<?> clazz = class$java$sql$Clob;
                if (clazz == null) {
                    try {
                        clazz = class$java$sql$Clob = Class.forName("java.sql.Clob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(object)) {
                    try {
                        this.checkConnection();
                        ((Clob)object).getAsciiStream();
                    }
                    catch (SQLException sQLException) {
                        databaseRow = statementResultRow.getCurrentColumnValues();
                        bl = databaseRow.colWasChanged(n2);
                        if (bl) {
                            StatementResult.handleSQLException(sQLException);
                            break block17;
                        }
                        this.refreshColumn(n2);
                        statementResultRow = (StatementResultRow)this.rows.elementAt(n - 1);
                        object = statementResultRow.getColumnValue(n2);
                    }
                } else {
                    Class<?> clazz2 = class$java$sql$Blob;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$java$sql$Blob = Class.forName("java.sql.Blob");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.isInstance(object)) {
                        try {
                            this.checkConnection();
                            ((Blob)object).getBinaryStream();
                        }
                        catch (SQLException sQLException) {
                            databaseRow = statementResultRow.getCurrentColumnValues();
                            bl = databaseRow.colWasChanged(n2);
                            if (bl) {
                                StatementResult.handleSQLException(sQLException);
                            }
                            this.refreshColumn(n2);
                            statementResultRow = (StatementResultRow)this.rows.elementAt(n - 1);
                            object = statementResultRow.getColumnValue(n2);
                        }
                    }
                }
            }
        }
        return object;
    }

    protected synchronized void initialize() throws DataException {
        this.statement.getConnection().getConnection();
        int n = 0;
        if (this.statement.getPacketSize() == 0) {
            n = 40;
            this.rows = new Vector(n);
        } else {
            n = this.statement.getMaximumPacketsInCache() == 0 ? this.statement.getPacketSize() : this.statement.getPacketSize() * this.statement.getMaximumPacketsInCache();
            this.rows = new Vector(n, this.statement.getPacketSize());
        }
        if (!this.statement.isReadOnly()) {
            this.changes = new Vector(n / 4);
        }
        this.fieldNumRows = 0;
        this.fieldNumRowsInCache = 0;
        this.fieldNumPacketsInCache = 0;
        this.fieldCurrentRow = 0;
        this.fieldCurrentRowInCache = 0;
        this.singleRowResult = null;
        this.moreRows = true;
        this.previousRows = false;
        try {
            if (!this.rt.nextRow()) {
                this.moreRows = false;
            }
            this.fetchDirection = 1;
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    public boolean isEnd() {
        return this.fieldCurrentRow >= this.fieldNumRows && !this.moreRows;
    }

    public boolean isMaxRowsReached() throws DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (this.statement.getMaximumRows() == 0) {
            return false;
        }
        return this.fieldNumRows >= this.statement.getMaximumRows();
    }

    public boolean isRowLocked() {
        return this.singleRowResult != null && this.singleRowResult.isOpen();
    }

    public synchronized void lastRow() throws DataException {
        boolean bl = false;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new DataException(string, 214);
        }
        if (this.isEnd()) {
            return;
        }
        int n = this.fieldCurrentRow;
        int n2 = this.fieldCurrentRowInCache;
        this.updateRowBeforeLeaving();
        int n3 = 1003;
        if (this.rt != null) {
            n3 = this.rt.getType();
        }
        if (n3 != 1003 && this.moreRows) {
            int n4;
            int n5 = 0;
            int n6 = 0;
            try {
                n6 = this.rt.getRowNumber();
                this.rt.lastRow();
                n5 = this.rt.getRowNumber();
            }
            catch (SQLException sQLException) {
                StatementResult.handleSQLException(sQLException);
            }
            int n7 = this.statement.getMaximumRows();
            if (n7 > 0 && n5 > n7) {
                n5 = n7;
            }
            if ((n4 = this.getPacketsToSkip(1, n5)) > 0) {
                int n8 = this.statement.getPacketSize();
                if (n8 < 1) {
                    n8 = 1;
                }
                int n9 = this.fieldCurrentRow - this.fieldCurrentRowInCache + this.fieldNumRowsInCache;
                int n10 = n9 + n4 * n8 + 1;
                this.flushCacheAndGoTo(n10);
            } else {
                try {
                    this.rt.absoluteRow(n6);
                }
                catch (SQLException sQLException) {
                    StatementResult.handleSQLException(sQLException);
                }
            }
        }
        while (this.moreRows) {
            this.fetchNextPacket();
            bl = true;
        }
        this.fieldCurrentRow = this.fieldNumRows;
        this.fieldCurrentRowInCache = this.fieldNumRowsInCache;
        if (bl) {
            this.fireCacheRowsChanged(new DataEvent(this, 4));
        }
        this.firePropertyChange("currentRow", new Integer(n), new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(this.fieldCurrentRowInCache));
        if (this.statement != null && this.statement.isLockRows()) {
            this.lockRow();
        }
    }

    public synchronized void lockRow() throws DataException {
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        this.checkConnection();
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"lockRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string, 215);
        }
        if (this.deferUpdates) {
            return;
        }
        DatabaseConnection databaseConnection = this.statement.getConnection();
        if (databaseConnection.databaseName.equals("Microsoft SQL Server") || databaseConnection.databaseName.equals("SQL Server") || databaseConnection.databaseName.equals("Sybase SQL Server") || !databaseConnection.supportsPositionedUpdate) {
            Object[] objectArray = new Object[]{databaseConnection.databaseName};
            String string = Utilities.logMessage(IBMDBMessages.lockNotSupported, objectArray);
            throw new DataException(string, 238);
        }
        this.applyLock(statementResultRow);
    }

    public synchronized void newRow(boolean bl) throws DataException {
        int n;
        int n2;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"newRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string, 215);
        }
        if (this.isMaxRowsReached()) {
            String string = Utilities.logMessage(IBMDBMessages.maxSize);
            throw new DataException(string, 235);
        }
        this.updateRowBeforeLeaving();
        this.fireAboutToAddNewRow(new DataEvent(this));
        DatabaseCompoundType databaseCompoundType = null;
        if (this.fieldCurrentRowInCache == 0) {
            try {
                databaseCompoundType = new DatabaseCompoundType(this.metaData.getColumnShape());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            n2 = this.fieldCurrentRow + 1;
            n = this.fieldCurrentRowInCache + 1;
        } else if (bl) {
            databaseCompoundType = this.getCurrentRowObject().getCurrentColumnValues().getType();
            n2 = this.fieldCurrentRow++;
            n = this.fieldCurrentRowInCache++;
        } else {
            databaseCompoundType = this.getCurrentRowObject().getCurrentColumnValues().getType();
            n2 = this.fieldCurrentRow + 1;
            n = this.fieldCurrentRowInCache + 1;
        }
        ++this.fieldNumRows;
        ++this.fieldNumRowsInCache;
        DatabaseRow databaseRow = new DatabaseRow(databaseCompoundType);
        StatementResultRow statementResultRow = new StatementResultRow(databaseRow);
        statementResultRow.setStatus(2);
        statementResultRow.setInDatabase(false);
        this.rows.insertElementAt(statementResultRow, n - 1);
        this.fireCacheRowsChanged(new DataEvent(this, 3));
        this.setCurrentRow(n2);
        this.fireAddedNewRow(new DataEvent(this));
    }

    public synchronized void nextPacket() throws DataException {
        int n = this.fieldCurrentRow;
        int n2 = this.fieldCurrentRowInCache;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new DataException(string, 214);
        }
        if (!this.isOpen()) {
            String string = Utilities.logMessage(IBMDBMessages.notOpen);
            throw new DataException(string, 207);
        }
        this.fetchNextPacket();
        if (this.fieldCurrentRowInCache < 1) {
            this.fieldCurrentRow = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
            this.fieldCurrentRowInCache = 1;
            if (this.statement != null && this.statement.isLockRows()) {
                this.lockRow();
            }
        }
        if (this.fieldCurrentRowInCache != n2 || this.fieldCurrentRow != n) {
            this.fireCacheRowsChanged(new DataEvent(this, 4));
        }
        this.firePropertyChange("currentRow", new Integer(n), new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(this.fieldCurrentRowInCache));
    }

    public void nextRow() throws DataException {
        this.nextOrPrev = true;
        try {
            this.setCurrentRow(this.fieldCurrentRow + 1);
        }
        catch (DataException dataException) {
            this.nextOrPrev = false;
            throw dataException;
        }
        this.nextOrPrev = false;
    }

    protected synchronized void previousPacket() throws DataException {
        int n = this.fieldCurrentRow;
        int n2 = this.fieldCurrentRowInCache;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new DataException(string, 214);
        }
        if (!this.isOpen()) {
            String string = Utilities.logMessage(IBMDBMessages.notOpen);
            throw new DataException(string, 207);
        }
        this.fetchPreviousPacket();
        if (this.fieldCurrentRowInCache > this.fieldNumRowsInCache) {
            this.fieldCurrentRow -= this.fieldCurrentRowInCache - this.fieldNumRowsInCache;
            this.fieldCurrentRowInCache = this.fieldNumRowsInCache;
            if (this.statement != null && this.statement.isLockRows()) {
                this.lockRow();
            }
        }
        if (this.fieldCurrentRowInCache != n2 || this.fieldCurrentRow != n) {
            this.fireCacheRowsChanged(new DataEvent(this, 4));
        }
        this.firePropertyChange("currentRow", new Integer(n), new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(this.fieldCurrentRowInCache));
    }

    public void previousRow() throws DataException {
        this.nextOrPrev = true;
        try {
            this.setCurrentRow(this.fieldCurrentRow - 1);
        }
        catch (DataException dataException) {
            this.nextOrPrev = false;
            throw dataException;
        }
        this.nextOrPrev = false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
        this.dataChangesPending = false;
        this.moreRows = false;
        this.previousRows = false;
        this.fetchDirection = 1;
        this.leavingRow = false;
        this.nextOrPrev = false;
    }

    public void refreshColumn(int n) throws DataException {
        DatabaseRow databaseRow;
        boolean bl = false;
        DatabaseResultTable databaseResultTable = null;
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        if (!statementResultRow.isInDatabase()) {
            String string = Utilities.logMessage(IBMDBMessages.rowNotInDatabase);
            throw new DataException(string, 217);
        }
        if (statementResultRow.status == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new DataException(string, 240);
        }
        DatabaseRow databaseRow2 = null;
        databaseRow2 = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        DatabaseQuerySpec databaseQuerySpec = this.generateSelectSpec(n, databaseRow2);
        DatabaseRow databaseRow3 = this.generateHostVars(databaseQuerySpec, databaseRow2);
        try {
            try {
                databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                databaseResultTable.setTimeout(this.statement.getTimeout());
                this.currentStatement = databaseResultTable;
                databaseResultTable.execute(databaseRow3);
                bl = databaseResultTable.nextRow();
            }
            catch (SQLException sQLException) {
                if (databaseResultTable != null) {
                    try {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    catch (Throwable throwable) {
                        Object var11_22 = null;
                        databaseResultTable = null;
                        throw throwable;
                    }
                    databaseRow = null;
                    databaseResultTable = null;
                }
                StatementResult.handleSQLException(sQLException);
            }
            catch (com.ibm.db.base.DataException dataException) {
                if (databaseResultTable != null) {
                    try {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    catch (Throwable throwable) {
                        Object var11_24 = null;
                        databaseResultTable = null;
                        throw throwable;
                    }
                    Object var11_25 = null;
                    databaseResultTable = null;
                }
                Utilities.logBaseException(dataException);
                throw new DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var9_26 = null;
            this.currentStatement = null;
            throw throwable;
        }
        Object[] objectArray = null;
        this.currentStatement = null;
        if (!bl) {
            try {
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable) {
                objectArray = null;
                databaseResultTable = null;
                throw throwable;
            }
            objectArray = null;
            databaseResultTable = null;
            objectArray = new Object[]{this.getColumnName(n)};
            String string = Utilities.logMessage(IBMDBMessages.cannotRefreshData, objectArray);
            throw new DataException(string, 252);
        }
        try {
            try {
                DatabaseRow databaseRow4 = databaseResultTable.getRow();
                SQLWarning sQLWarning = databaseResultTable.getWarnings();
                databaseRow = statementResultRow.getCurrentColumnValues();
                statementResultRow.restore();
                DatabaseRow databaseRow5 = statementResultRow.getCurrentColumnValues();
                databaseRow5.putAtIndexWithCheck(n, databaseRow4.getAtIndex(1));
                while (sQLWarning != null) {
                    if (sQLWarning.getSQLState().equals("01004")) {
                        statementResultRow.setStatus(3);
                        break;
                    }
                    sQLWarning = sQLWarning.getNextWarning();
                }
                int n2 = 1;
                while (n2 <= this.getColumnCount()) {
                    if (databaseRow.colWasChanged(n2) && n2 != n) {
                        statementResultRow.setColumnValue(n2, databaseRow.getAtIndex(n2));
                    }
                    ++n2;
                }
            }
            catch (SQLException sQLException) {
                StatementResult.handleSQLException(sQLException);
            }
            catch (com.ibm.db.base.DataException dataException) {
                Utilities.logBaseException(dataException);
                throw new DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            objectArray = null;
            try {
                databaseResultTable.closeStatement();
                databaseResultTable = null;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        objectArray = null;
        try {
            databaseResultTable.closeStatement();
            databaseResultTable = null;
        }
        catch (SQLException sQLException) {}
    }

    public void refreshRow() throws DataException {
        SQLWarning sQLWarning;
        boolean bl = false;
        DatabaseResultTable databaseResultTable = null;
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        if (!statementResultRow.isInDatabase()) {
            String string = Utilities.logMessage(IBMDBMessages.rowNotInDatabase);
            throw new DataException(string, 217);
        }
        if (statementResultRow.status == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new DataException(string, 240);
        }
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        DatabaseQuerySpec databaseQuerySpec = this.generateSelectSpec(databaseRow, false);
        DatabaseRow databaseRow2 = this.generateHostVars(databaseQuerySpec, databaseRow);
        databaseQuerySpec.setOutputShape(this.metaData.getDbQuerySpec().getOutputShape());
        try {
            try {
                databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec, 1003, this.statement.isReadOnly());
                databaseResultTable.setTimeout(this.statement.getTimeout());
                this.currentStatement = databaseResultTable;
                databaseResultTable.execute(databaseRow2);
                bl = databaseResultTable.nextRow();
            }
            catch (SQLException sQLException) {
                if (databaseResultTable != null) {
                    try {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    catch (Throwable throwable) {
                        Object var10_20 = null;
                        databaseResultTable = null;
                        throw throwable;
                    }
                    sQLWarning = null;
                    databaseResultTable = null;
                }
                StatementResult.handleSQLException(sQLException);
            }
            catch (com.ibm.db.base.DataException dataException) {
                if (databaseResultTable != null) {
                    try {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    catch (Throwable throwable) {
                        Object var10_22 = null;
                        databaseResultTable = null;
                        throw throwable;
                    }
                    Object var10_23 = null;
                    databaseResultTable = null;
                }
                Utilities.logBaseException(dataException);
                throw new DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var8_25 = null;
            this.currentStatement = null;
            throw throwable;
        }
        String string = null;
        this.currentStatement = null;
        if (bl) {
            try {
                try {
                    DatabaseRow databaseRow3 = databaseResultTable.getRow();
                    StatementResultRow statementResultRow2 = new StatementResultRow(databaseRow3);
                    sQLWarning = databaseResultTable.getWarnings();
                    while (sQLWarning != null) {
                        if (sQLWarning.getSQLState().equals("01004")) {
                            statementResultRow2.setStatus(3);
                            break;
                        }
                        sQLWarning = sQLWarning.getNextWarning();
                    }
                    this.rows.setElementAt(statementResultRow2, this.fieldCurrentRowInCache - 1);
                }
                catch (SQLException sQLException) {
                    StatementResult.handleSQLException(sQLException);
                }
                catch (com.ibm.db.base.DataException dataException) {
                    Utilities.logBaseException(dataException);
                    throw new DataException(dataException.getMessage(), dataException.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                string = null;
                try {
                    databaseResultTable.closeStatement();
                    databaseResultTable = null;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            string = null;
            try {
                databaseResultTable.closeStatement();
                databaseResultTable = null;
            }
            catch (SQLException sQLException) {}
        } else {
            try {
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                databaseResultTable = null;
                throw throwable;
            }
            Object var9_17 = null;
            databaseResultTable = null;
            if (this.leavingRow) {
                string = Utilities.logMessage(IBMDBMessages.rowChanged);
                throw new DataException(string, 237);
            }
            string = Utilities.logMessage(IBMDBMessages.rowNotFound);
            throw new DataException(string, 205);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeStatementResultValueChangeListener(StatementResultValueChangeListener statementResultValueChangeListener) {
        this.aStatementResultValueChangeListener = StatementResultValueChangeEventMulticaster.remove(this.aStatementResultValueChangeListener, statementResultValueChangeListener);
    }

    protected synchronized void restoreChanges() {
        StatementResultRow statementResultRow = null;
        try {
            while (true) {
                statementResultRow = (StatementResultRow)this.changes.lastElement();
                switch (statementResultRow.getAction()) {
                    case 1: 
                    case 3: {
                        this.restoreUpdate(statementResultRow);
                        break;
                    }
                    case 2: {
                        this.restoreDelete(statementResultRow);
                        break;
                    }
                }
                this.changes.removeElementAt(0);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    protected void restoreDelete(StatementResultRow statementResultRow) {
        int n = this.fieldCurrentRow - this.fieldCurrentRowInCache;
        int n2 = statementResultRow.getNumberWhenChanged() - n;
        if (n2 > 0 && n2 <= this.fieldNumRowsInCache) {
            statementResultRow.setAction(0);
            this.rows.insertElementAt(statementResultRow, n2 - 1);
            ++this.fieldNumRowsInCache;
        }
        ++this.fieldNumRows;
    }

    public void restoreRow() throws DataException {
        String string = null;
        Object object = null;
        Object object2 = null;
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"restoreRow"};
            String string2 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string2, 215);
        }
        if (statementResultRow.getStatus() == 1) {
            if (this.statement != null && this.statement.isReadOnly()) {
                Object[] objectArray = new Object[]{"restoreRow"};
                String string3 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
                throw new DataException(string3, 215);
            }
            DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
            int n = 1;
            while (n <= this.getColumnCount()) {
                if (databaseRow.colWasChanged(n)) {
                    string = this.getColumnName(n);
                    object = statementResultRow.getColumnValue(n);
                    object2 = statementResultRow.getPreviousColumnValue(n);
                    this.fireAboutToSetColumnValue(new PropertyChangeEvent(this, string, object, object2));
                }
                ++n;
            }
            statementResultRow.restore();
            n = 1;
            while (n <= this.getColumnCount()) {
                if (databaseRow.colWasChanged(n)) {
                    string = this.getColumnName(n);
                    object = databaseRow.getAtIndex(n);
                    object2 = statementResultRow.getColumnValue(n);
                    this.fireColumnValueSet(new PropertyChangeEvent(this, string, object, object2));
                }
                ++n;
            }
        }
    }

    protected void restoreUpdate(StatementResultRow statementResultRow) {
        int n = this.fieldCurrentRow - this.fieldCurrentRowInCache;
        int n2 = statementResultRow.getNumberWhenChanged() - n;
        if (n2 > 0 && n2 <= this.fieldNumRowsInCache) {
            statementResultRow.setAction(0);
            this.rows.removeElementAt(n2 - 1);
            this.rows.insertElementAt(statementResultRow, n2 - 1);
        }
    }

    public synchronized void setColumnValue(int n, Object object) throws DataException {
        String string = this.getColumnName(n);
        Object object2 = this.getColumnValue(n);
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"setColumnValue"};
            String string2 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string2, 215);
        }
        this.fireAboutToSetColumnValue(new PropertyChangeEvent(this, string, object2, object));
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        try {
            statementResultRow.setColumnValue(n, object);
        }
        catch (com.ibm.db.base.DataException dataException) {
            String string3 = Utilities.logBaseException(dataException, this.statement.isForVAJavaSelect());
            throw new DataException(string3, dataException.getErrorCode());
        }
        this.fireColumnValueSet(new PropertyChangeEvent(this, string, object2, object));
    }

    public void setColumnValue(String string, Object object) throws DataException {
        if (this.statement == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string2, 229);
        }
        int n = this.metaData.getColumnIndex(string);
        this.setColumnValue(n, object);
    }

    public void setColumnValueFromString(int n, String string) throws DataException {
        Class clazz;
        block98: {
            block97: {
                if (this.statement == null) {
                    String string2 = Utilities.logMessage(IBMDBMessages.noStatement);
                    throw new DataException(string2, 229);
                }
                if (this.statement.isReadOnly()) {
                    Object[] objectArray = new Object[]{"setColumnValue"};
                    String string3 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
                    throw new DataException(string3, 215);
                }
                clazz = this.metaData.getColumnClass(n);
                if (string == null) break block97;
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2 || string.length() != 0) break block98;
            }
            this.setColumnValue(n, null);
            return;
        }
        Class<?> clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            this.setColumnValue(n, (Object)string);
        } else {
            Class<?> clazz4 = class$java$lang$Integer;
            if (clazz4 == null) {
                try {
                    clazz4 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz4) {
                this.setColumnValue(n, (Object)new Integer(string));
            } else {
                Class<?> clazz5 = class$java$lang$Long;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$java$lang$Long = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz5) {
                    this.setColumnValue(n, (Object)new Long(string));
                } else {
                    Class<?> clazz6 = class$java$lang$Short;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz6) {
                        this.setColumnValue(n, (Object)new Short(string));
                    } else {
                        Class<?> clazz7 = class$java$math$BigDecimal;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz7) {
                            this.setColumnValue(n, (Object)new BigDecimal(string));
                        } else {
                            Class<?> clazz8 = class$java$lang$Float;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz8) {
                                this.setColumnValue(n, (Object)new Float(string));
                            } else {
                                Class<?> clazz9 = class$java$lang$Double;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz9) {
                                    this.setColumnValue(n, (Object)new Double(string));
                                } else {
                                    Class<?> clazz10 = class$java$lang$Boolean;
                                    if (clazz10 == null) {
                                        try {
                                            clazz10 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz10) {
                                        this.setColumnValue(n, (Object)Boolean.valueOf(string));
                                    } else {
                                        Class<?> clazz11 = class$java$sql$Date;
                                        if (clazz11 == null) {
                                            try {
                                                clazz11 = class$java$sql$Date = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz11) {
                                            this.setColumnValue(n, (Object)Date.valueOf(string));
                                        } else {
                                            Class<?> clazz12 = class$java$sql$Time;
                                            if (clazz12 == null) {
                                                try {
                                                    clazz12 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz12) {
                                                this.setColumnValue(n, (Object)Time.valueOf(string));
                                            } else {
                                                Class<?> clazz13 = class$java$sql$Timestamp;
                                                if (clazz13 == null) {
                                                    try {
                                                        clazz13 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz13) {
                                                    this.setColumnValue(n, (Object)Timestamp.valueOf(string));
                                                } else {
                                                    Class<?> clazz14 = class$java$net$URL;
                                                    if (clazz14 == null) {
                                                        try {
                                                            clazz14 = class$java$net$URL = Class.forName("java.net.URL");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz14) {
                                                        try {
                                                            this.setColumnValue(n, (Object)new URL(string));
                                                        }
                                                        catch (MalformedURLException malformedURLException) {
                                                            Object[] objectArray = new Object[]{this.getColumnName(n)};
                                                            String string4 = Utilities.logMessage(IBMDBMessages.cannotConvert, objectArray);
                                                            throw new DataException(string4, 222);
                                                        }
                                                    }
                                                    Class<?> clazz15 = class$array1$$byte;
                                                    if (clazz15 == null) {
                                                        try {
                                                            clazz15 = class$array1$$byte = Class.forName("[B");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz15) {
                                                        if (string.length() % 2 != 0) {
                                                            Object[] objectArray = new Object[]{this.getColumnName(n)};
                                                            String string5 = Utilities.logMessage(IBMDBMessages.cannotConvert, objectArray);
                                                            throw new DataException(string5, 222);
                                                        }
                                                        byte[] byArray = new byte[string.length() / 2];
                                                        int n2 = 0;
                                                        while (2 * n2 < string.length()) {
                                                            int n3 = n2 * 2;
                                                            int n4 = Integer.parseInt(string.substring(n3, n3 + 2), 16);
                                                            byArray[n2] = (byte)n4;
                                                            ++n2;
                                                        }
                                                        this.setColumnValue(n, (Object)byArray);
                                                    } else {
                                                        Class<?> clazz16 = class$java$sql$Clob;
                                                        if (clazz16 == null) {
                                                            try {
                                                                clazz16 = class$java$sql$Clob = Class.forName("java.sql.Clob");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                        }
                                                        if (clazz == clazz16) {
                                                            this.setColumnValue(n, (Object)new StringBufferInputStream(string));
                                                        } else {
                                                            Object[] objectArray = new Object[]{this.getColumnName(n)};
                                                            String string6 = Utilities.logMessage(IBMDBMessages.cannotConvert, objectArray);
                                                            throw new DataException(string6, 222);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void setColumnValueFromString(String string, String string2) throws DataException {
        if (this.statement == null) {
            String string3 = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string3, 229);
        }
        int n = this.metaData.getColumnIndex(string);
        this.setColumnValueFromString(n, string2);
    }

    public synchronized void setCurrentRow(int n) throws DataException {
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted() && !this.statement.executing) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.statement.getConnection() == null || !this.statement.getConnection().isConnected()) {
            this.statement.disconnect();
        }
        int n4 = n;
        Integer n5 = new Integer(this.fieldCurrentRow);
        Integer n6 = new Integer(this.fieldCurrentRowInCache);
        if (this.fieldCurrentRow == 0 && this.statement.executing) {
            n5 = null;
            n6 = null;
        }
        int n7 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
        int n8 = n7 + this.fieldNumRowsInCache - 1;
        if (n != this.fieldCurrentRow) {
            this.updateRowBeforeLeaving();
        }
        int n9 = 1003;
        if (this.rt != null) {
            n9 = this.rt.getType();
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = this.statement.getPacketSize();
        if (n12 < 1) {
            n12 = 1;
        }
        if ((n3 = this.statement.getMaximumPacketsInCache()) == 0) {
            n3 = Integer.MAX_VALUE;
        }
        if (n < n7) {
            if (n9 == 1003) {
                bl2 = true;
                n = n7;
            } else {
                if (n < 1) {
                    bl4 = true;
                    n = 1;
                }
                if ((n11 = this.getPacketsToSkip(-1, n)) > 0) {
                    n10 = n7 - n11 * n12 - 1;
                    this.flushCacheAndGoTo(n10);
                }
            }
            while (this.previousRows && n < n7) {
                this.fetchPreviousPacket();
                bl = true;
                n7 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
                n8 = n7 + this.fieldNumRowsInCache - 1;
            }
        } else if (n > n8) {
            if (n9 != 1003) {
                n2 = n;
                int n13 = this.statement.getMaximumRows();
                if (n13 > 0 && n > n13) {
                    n2 = n13;
                }
                if ((n11 = this.getPacketsToSkip(1, n2)) > 0) {
                    n10 = n8 + n11 * n12 + 1;
                    this.flushCacheAndGoTo(n10);
                }
            }
            n2 = this.statement.isFillCacheOnExecute() ? 1 : 0;
            while (this.moreRows && (n > n8 || n2 != 0 && this.fieldNumPacketsInCache < n3)) {
                this.fetchNextPacket();
                bl = true;
                n7 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
                n8 = n7 + this.fieldNumRowsInCache - 1;
            }
        }
        if (n > n8) {
            bl3 = true;
            this.fieldCurrentRow = this.fieldNumRows;
            this.fieldCurrentRowInCache = this.fieldNumRowsInCache;
        } else {
            n2 = this.fieldCurrentRow - n;
            this.fieldCurrentRow = n;
            this.fieldCurrentRowInCache -= n2;
        }
        if (this.statement != null && this.statement.isLockRows()) {
            this.lockRow();
        }
        if (bl || this.fieldCurrentRow == 0 && this.statement.executing) {
            this.fireCacheRowsChanged(new DataEvent(this, 4));
        }
        this.firePropertyChange("currentRow", n5, new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", n6, new Integer(this.fieldCurrentRowInCache));
        if (bl2 || n == 0) {
            if (this.fieldNumRows == 0) {
                String string = Utilities.logMessage(IBMDBMessages.noResults);
                throw new DataException(string, 214);
            }
            if (!this.nextOrPrev || this.fieldCurrentRow != 1) {
                Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n4 - 1)} : new Object[]{new Integer(n4)};
                String string = Utilities.logMessage(IBMDBMessages.beforeCacheStart, objectArray);
                throw new DataException(string, 216);
            }
        }
        if (bl3 || bl4) {
            if (this.fieldNumRows == 0) {
                if (!this.statement.executing && !this.statement.firstFirstRow) {
                    String string = Utilities.logMessage(IBMDBMessages.noResults);
                    throw new DataException(string, 214);
                }
            } else if (!this.nextOrPrev) {
                Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n4 - 1)} : new Object[]{new Integer(n4)};
                String string = Utilities.logMessage(IBMDBMessages.indexTooLarge, objectArray);
                throw new DataException(string, 234);
            }
        }
    }

    protected void setCurrentRowInCache(int n) {
        int n2 = this.fieldCurrentRowInCache;
        this.fieldCurrentRowInCache = n;
        this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(this.fieldCurrentRowInCache));
    }

    public void setStatement(SelectStatement selectStatement) {
        this.statement = selectStatement;
        if (selectStatement != null) {
            this.metaData = selectStatement.getMetaData();
        }
    }

    public void unlockRow() throws DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new DataException(string, 214);
        }
        if (!this.isRowLocked()) {
            return;
        }
        this.checkConnection();
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"unlockRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new DataException(string, 215);
        }
        try {
            try {
                this.singleRowResult.closeStatement();
            }
            catch (SQLException sQLException) {
                if (!this.leavingRow) {
                    StatementResult.handleSQLException(sQLException);
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.singleRowResult = null;
            throw throwable;
        }
        Object var2_7 = null;
        this.singleRowResult = null;
    }

    public synchronized void updateRow() throws DataException {
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        if (statementResultRow.getStatus() == 2 && !this.leavingRow) {
            String string = Utilities.logMessage(IBMDBMessages.noValuesSet);
            throw new DataException(string, 244);
        }
        if (statementResultRow.getStatus() == 1) {
            this.checkConnection();
            if (this.statement != null && this.statement.isReadOnly()) {
                Object[] objectArray = new Object[]{"updateRow"};
                String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
                throw new DataException(string, 215);
            }
            StatementResultRow statementResultRow2 = new StatementResultRow(statementResultRow);
            statementResultRow2.setNumberWhenChanged(this.fieldCurrentRow);
            this.fireAboutToUpdateRow(new DataEvent(this));
            if (statementResultRow.isInDatabase()) {
                statementResultRow2.setAction(1);
            } else {
                statementResultRow2.setAction(3);
            }
            this.changes.addElement(statementResultRow2);
            statementResultRow.reset();
            statementResultRow.setInDatabase(true);
            if (!this.deferUpdates) {
                this.apply();
            }
            this.fireUpdatedRow(new DataEvent(this));
        } else if (!(this.statement.isReadOnly() || !this.leavingRow && this.statement.isLockRows())) {
            this.unlockRow();
        }
    }

    protected void updateRowBeforeLeaving() throws DataException {
        if (this.fieldCurrentRowInCache > 0) {
            this.leavingRow = true;
            try {
                this.updateRow();
            }
            catch (DataException dataException) {
                this.leavingRow = false;
                throw dataException;
            }
            this.leavingRow = false;
        }
    }
}

