/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.IBMDBMessages;
import com.ibm.db.base.DataException;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.UtilitiesBase;
import java.io.PrintStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;

class Utilities {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    protected static String getMessage(String string) {
        String string2 = IBMDBMessages.getText(string);
        return string2;
    }

    protected static String getMessage(String string, Object[] objectArray) {
        String string2 = IBMDBMessages.getText(string);
        String string3 = MessageFormat.format(string2, objectArray);
        return string3;
    }

    protected static String logBaseException(DataException dataException) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        String string = dataException.getMessage();
        printStream.println(string);
        return string;
    }

    protected static String logBaseException(DataException dataException, boolean bl) {
        String string;
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        Object[] objectArray = dataException.getMessageArgs();
        Integer n = null;
        if (!bl) {
            string = dataException.getMessage();
        } else if (dataException.getErrorCode() == 103) {
            n = new Integer((Integer)objectArray[0] - 1);
            objectArray[0] = n;
            string = UtilitiesBase.getMessage(IBMDBBaseMessages.inconsistentColumnType, objectArray);
        } else {
            string = dataException.getMessage();
        }
        printStream.println(string);
        return string;
    }

    protected static String logBaseException(Exception exception) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        String string = exception.getMessage();
        printStream.println(string);
        return string;
    }

    protected static String logMessage(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        String string2 = Utilities.getMessage(string);
        printStream.println(string2);
        return string2;
    }

    protected static String logMessage(String string, Object[] objectArray) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        String string2 = Utilities.getMessage(string, objectArray);
        printStream.println(string2);
        return string2;
    }

    protected static String logSQLException(SQLException sQLException) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            printStream = System.out;
        }
        String string = Utilities.getMessage(IBMDBMessages.sqlException);
        printStream.println(string);
        printStream.println("SQL State: " + sQLException.getSQLState());
        printStream.println(sQLException.getMessage());
        return string;
    }

    Utilities() {
    }
}

