/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseLogonSpec;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.JDBCConnectionManager;
import com.ibm.db.base.UtilitiesBase;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseConnectionSpec
implements Cloneable,
Serializable {
    private String driverName;
    private String dataSourceName;
    private String alias;
    private DatabaseLogonSpec logonSpec;
    private boolean promptUID = false;
    private Properties props = null;
    private String jndiDataSource;
    private String initialContext;
    private String providerURL;
    public static final int POOL_TYPE_NONE = 0;
    public static final int POOL_TYPE_WEBSPHERE = 1;
    private int connectionPoolType = 0;
    static final long serialVersionUID = -3635437464895834970L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseConnectionSpec(String string, String string2) {
        this.setDriverName(string);
        this.setDataSourceName(string2);
    }

    public DatabaseConnectionSpec(String string, String string2, String string3) {
        this.setDriverName(string2);
        this.setDataSourceName(string3);
        this.setAlias(string);
    }

    public synchronized Object clone() {
        try {
            DatabaseConnectionSpec databaseConnectionSpec = (DatabaseConnectionSpec)super.clone();
            return databaseConnectionSpec;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public DatabaseConnection connect() throws SQLException, ClassNotFoundException, DataException {
        JDBCConnectionManager jDBCConnectionManager = this.getJndiDataSource() != null ? JDBCConnectionManager.getJDBCConnectionManager(null) : JDBCConnectionManager.getJDBCConnectionManager(this.getDriverName());
        DatabaseConnection databaseConnection = jDBCConnectionManager.connectUsingSpec(this);
        return databaseConnection;
    }

    public boolean disconnect() throws SQLException, DataException, ClassNotFoundException {
        JDBCConnectionManager jDBCConnectionManager = this.getJndiDataSource() != null ? JDBCConnectionManager.getJDBCConnectionManager(null) : JDBCConnectionManager.getJDBCConnectionManager(this.getDriverName());
        return jDBCConnectionManager.disconnectUsingSpec(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public int getConnectionPoolType() {
        return this.connectionPoolType;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getId() {
        if (this.logonSpec != null) {
            return this.logonSpec.getId();
        }
        return null;
    }

    public String getInitialContextFactory() {
        return this.initialContext;
    }

    public String getJndiDataSource() {
        return this.jndiDataSource;
    }

    public DatabaseLogonSpec getLogonSpec() {
        return this.logonSpec;
    }

    public String getPassword() {
        if (this.logonSpec != null) {
            return this.logonSpec.getPassword();
        }
        return null;
    }

    public boolean getPromptUID() {
        return this.promptUID;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setConnectionPoolType(int n) throws DataException {
        if (n != 0 && n != 1) {
            Object[] objectArray = new Object[]{new Integer(n).toString()};
            String string = UtilitiesBase.getMessage(IBMDBBaseMessages.invalidConnPoolType, objectArray);
            DataException dataException = new DataException(string, 113);
            dataException.setMessageArgs(objectArray);
            throw dataException;
        }
        this.connectionPoolType = n;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public void setId(String string) {
        if (this.logonSpec != null) {
            this.logonSpec.setId(string);
        } else {
            this.logonSpec = new DatabaseLogonSpec(string, " ");
        }
    }

    public void setInitialContextFactory(String string) {
        this.initialContext = string;
    }

    public void setJndiDataSource(String string) {
        this.jndiDataSource = string;
    }

    public void setLogonSpec(DatabaseLogonSpec databaseLogonSpec) {
        this.logonSpec = databaseLogonSpec;
    }

    public void setPassword(String string) {
        if (this.logonSpec != null) {
            this.logonSpec.setPassword(string);
        } else {
            this.logonSpec = new DatabaseLogonSpec(" ", string);
        }
    }

    public void setPromptUID(boolean bl) {
        this.promptUID = bl;
    }

    public void setProps(Properties properties) {
        this.props = properties;
    }

    public void setProviderURL(String string) {
        this.providerURL = string;
    }
}

