/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseResultTableParent;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseStatement;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.UtilitiesBase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Vector;

public class DatabaseResultTable
extends DatabaseResultTableParent {
    private PreparedStatement aStmt;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 2000";
    protected Vector qSpecVector = new Vector();
    protected Enumeration qSpecEnum = this.qSpecVector.elements();
    protected int resultCount = 0;
    protected int updateCount = -1;
    protected boolean afterLastResult = false;
    protected boolean readOnly = false;

    public DatabaseResultTable(DatabaseConnection databaseConnection, DatabaseQuerySpec databaseQuerySpec, int n, boolean bl) throws SQLException, DataException {
        this.readOnly = bl;
        this.setConnection(databaseConnection);
        this.setQuerySpec(databaseQuerySpec);
        this.prepare(n);
    }

    public void addQuerySpec(DatabaseQuerySpec databaseQuerySpec) {
        this.qSpecVector.addElement(databaseQuerySpec);
    }

    public synchronized void cancel() throws SQLException {
        this.aStmt.cancel();
    }

    public synchronized void closeStatement() throws SQLException {
        try {
            if (this.aStmt != null) {
                this.aStmt.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.aStmt = null;
            this.setIsOpen(false);
            throw throwable;
        }
        Object var1_3 = null;
        this.aStmt = null;
        this.setIsOpen(false);
    }

    public void execute() throws SQLException, DataException {
        String string = this.conn.getConnectionMetaData().getDatabaseProductName();
        if (this.dbSearchTypeInfo == null && !string.startsWith("DSN")) {
            this.dbSearchTypeInfo = this.conn.getSearchTypeInfo();
        }
        boolean bl = this.aStmt.execute();
        this.updateCount = this.aStmt.getUpdateCount();
        if (bl) {
            this.fetchResultSet();
        } else {
            this.isOpen = false;
            this.afterLastResult = true;
        }
    }

    public void execute(DatabaseRow databaseRow) throws SQLException, DataException {
        String string = this.conn.getConnectionMetaData().getDatabaseProductName();
        if (this.dbSearchTypeInfo == null && !string.startsWith("DSN")) {
            this.dbSearchTypeInfo = this.conn.getSearchTypeInfo();
        }
        this.setInputValues(databaseRow);
        boolean bl = this.aStmt.execute();
        this.updateCount = this.aStmt.getUpdateCount();
        if (bl) {
            this.fetchResultSet();
        } else {
            this.isOpen = false;
            this.afterLastResult = true;
        }
    }

    public void executeUpdate() throws SQLException, DataException {
        this.aStmt.execute();
        this.updateCount = this.aStmt.getUpdateCount();
        this.isOpen = false;
    }

    public void executeUpdate(DatabaseRow databaseRow) throws SQLException, DataException {
        this.setInputValues(databaseRow);
        this.aStmt.execute();
        this.updateCount = this.aStmt.getUpdateCount();
        this.isOpen = false;
    }

    private void fetchResultSet() throws SQLException, DataException {
        block12: {
            if (this.qSpecEnum.hasMoreElements()) {
                this.qSpec = (DatabaseQuerySpec)this.qSpecEnum.nextElement();
                if (this.qSpec != null) {
                    this.setRowStruct(this.qSpec.getOutputShape());
                }
            }
            this.setResultSet(this.aStmt.getResultSet());
            if (this.resultSet == null) {
                this.isOpen = false;
                this.afterLastResult = true;
            } else {
                this.isOpen = true;
                ++this.resultCount;
                if (this.resultSetType != 1003) {
                    this.resultSetType = this.getResultSet().getType();
                    if (this.resultSetType != 1003) {
                        try {
                            this.getResultSet().beforeFirst();
                        }
                        catch (SQLException sQLException) {
                            this.resultSetType = 1003;
                        }
                    }
                }
                try {
                    if (this.getRowStruct() == null) {
                        this.describe();
                    } else {
                        this.fillInColumnShape();
                    }
                }
                catch (SQLException sQLException) {
                    if (!sQLException.getSQLState().equals("07005")) break block12;
                    this.isOpen = false;
                    --this.resultCount;
                    this.afterLastResult = true;
                }
            }
        }
    }

    public boolean getAfterLastResult() {
        return this.afterLastResult;
    }

    public String getCursorName() throws SQLException {
        return this.getResultSet().getCursorName();
    }

    public Object getParameter(int n, DatabaseTypeField databaseTypeField) throws SQLException {
        Object object = null;
        if (databaseTypeField.getMode() == 4 || databaseTypeField.getMode() == 2) {
            object = databaseTypeField.getObject((CallableStatement)this.aStmt, n);
            boolean bl = ((CallableStatement)this.aStmt).wasNull();
            if (bl) {
                object = null;
            }
        }
        return object;
    }

    private PreparedStatement getStatement() {
        return this.aStmt;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    protected boolean hasResultSet() {
        return this.getResultSet() != null;
    }

    public boolean isReadOnlyResultSet() {
        return this.readOnly;
    }

    public void nextResult() throws SQLException, DataException {
        boolean bl = false;
        bl = this.aStmt.getMoreResults();
        this.updateCount = this.aStmt.getUpdateCount();
        if (this.updateCount != -1) {
            this.isOpen = false;
            ++this.resultCount;
        } else if (bl) {
            this.fetchResultSet();
        } else {
            this.isOpen = false;
            this.afterLastResult = true;
        }
    }

    private void prepare(int n) throws SQLException, DataException {
        String string;
        boolean bl = false;
        Connection connection = this.conn.getJdbcConnection();
        DatabaseMetaData databaseMetaData = this.conn.getConnectionMetaData();
        boolean bl2 = false;
        if (n == 1004) {
            try {
                bl2 = databaseMetaData.supportsResultSetType(1004);
            }
            catch (Throwable throwable) {
                UtilitiesBase.logMessage(IBMDBBaseMessages.jdbc1);
            }
        }
        if (bl = DatabaseStatement.isCallStatement(string = this.qSpec.getStatement())) {
            if (bl2) {
                this.setStatement(connection.prepareCall(string, n, 1007));
            } else {
                this.setStatement(connection.prepareCall(string));
            }
            this.registerOutputParameters();
        } else if (bl2) {
            this.setStatement(connection.prepareStatement(string, n, 1007));
        } else {
            this.setStatement(connection.prepareStatement(string));
        }
        this.resultSetType = 1003;
        if (bl2) {
            this.resultSetType = this.getStatement().getResultSetType();
        }
        this.afterLastResult = false;
        this.resultCount = 0;
        this.isOpen = false;
    }

    public void refresh() throws SQLException, DataException {
        this.qSpec = (DatabaseQuerySpec)this.qSpecVector.elementAt(0);
        this.qSpecEnum = this.qSpecVector.elements();
        if (this.getResultSet() != null) {
            this.getResultSet().close();
            this.setResultSet(null);
        }
        this.afterLastResult = false;
        this.resultCount = 0;
        this.isOpen = false;
        this.execute();
    }

    public void refresh(DatabaseRow databaseRow) throws SQLException, DataException {
        this.qSpec = (DatabaseQuerySpec)this.qSpecVector.elementAt(0);
        this.qSpecEnum = this.qSpecVector.elements();
        if (this.getResultSet() != null) {
            this.getResultSet().close();
            this.setResultSet(null);
        }
        this.afterLastResult = false;
        this.resultCount = 0;
        this.isOpen = false;
        this.execute(databaseRow);
    }

    private void registerOutputParameters() throws SQLException {
        DatabaseCompoundType databaseCompoundType = this.qSpec.getHostVarShape();
        DatabaseTypeField databaseTypeField = null;
        if (databaseCompoundType == null || databaseCompoundType.size() == 0) {
            return;
        }
        int n = 1;
        while (n <= databaseCompoundType.size()) {
            databaseTypeField = databaseCompoundType.fieldAt(n);
            if (databaseTypeField.getMode() == 4 || databaseTypeField.getMode() == 2) {
                int n2 = databaseTypeField.getSQLType();
                if (n2 == 2 || n2 == 3) {
                    ((CallableStatement)this.aStmt).registerOutParameter(n, n2, databaseTypeField.getScale());
                } else {
                    ((CallableStatement)this.aStmt).registerOutParameter(n, n2);
                }
            }
            ++n;
        }
    }

    private void setInputValues(DatabaseRow databaseRow) throws SQLException {
        Enumeration enumeration = databaseRow.getColumnNames();
        DatabaseCompoundType databaseCompoundType = this.qSpec.getHostVarShape();
        DatabaseTypeField databaseTypeField = null;
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            int n2 = databaseRow.getColumnIndex((String)e);
            Object object = databaseRow.getAtIndex(n2);
            if (databaseCompoundType == null) {
                this.aStmt.setObject(n, object);
            } else {
                databaseTypeField = databaseCompoundType.fieldAt(n);
                if ((databaseTypeField.getMode() == 1 || databaseTypeField.getMode() == 2) && databaseRow.colWasChanged(n2)) {
                    databaseTypeField.setObject(object, this.aStmt, n);
                }
            }
            ++n;
        }
    }

    protected void setQuerySpec(DatabaseQuerySpec databaseQuerySpec) {
        this.qSpec = databaseQuerySpec;
        this.qSpecVector = new Vector();
        this.qSpecVector.addElement(this.qSpec);
        this.qSpecEnum = this.qSpecVector.elements();
        if (this.qSpec != null) {
            this.setRowStruct(this.qSpec.getOutputShape());
        }
    }

    private void setStatement(PreparedStatement preparedStatement) {
        this.aStmt = preparedStatement;
    }

    public void setTimeout(int n) throws SQLException {
        block2: {
            try {
                this.aStmt.setQueryTimeout(n);
            }
            catch (SQLException sQLException) {
                if (n == 0) break block2;
                throw sQLException;
            }
        }
    }
}

