/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseStatement;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.JDBCConnectionManager;
import com.ibm.db.base.UtilitiesBase;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class DatabaseResultTableParent
extends DatabaseStatement {
    protected DatabaseCompoundType rowStruct;
    protected ResultSet resultSet;
    protected int resultSetType;
    protected transient Hashtable dbSearchTypeInfo;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2000";
    static Class class$com$ibm$db$base$DatabaseObjectField;

    public DatabaseResultTableParent() {
    }

    public DatabaseResultTableParent(DatabaseConnection databaseConnection, DatabaseQuerySpec databaseQuerySpec) {
        this.setConnection(databaseConnection);
        this.setQuerySpec(databaseQuerySpec);
    }

    public boolean absoluteRow(int n) throws SQLException {
        return this.getResultSet() != null && this.getResultSet().absolute(n);
    }

    public abstract void addQuerySpec(DatabaseQuerySpec var1);

    public abstract void cancel() throws SQLException;

    private void checkSearchLevel(String string, DatabaseTypeField databaseTypeField) throws SQLException {
        String string2 = this.conn.getConnectionMetaData().getDatabaseProductName();
        if (string2.startsWith("DSN")) {
            if (databaseTypeField.getSQLType() == -4 || databaseTypeField.getSQLType() == -1 || databaseTypeField.getSQLType() == 2004 || databaseTypeField.getSQLType() == 2005 || databaseTypeField.getSQLType() == 70) {
                databaseTypeField.setSearchable(false);
            } else {
                databaseTypeField.setSearchable(true);
            }
        } else {
            Integer n = (Integer)this.dbSearchTypeInfo.get(string);
            if (n == null) {
                if (databaseTypeField.getSQLType() == -4 || databaseTypeField.getSQLType() == -1 || databaseTypeField.getSQLType() == 2004 || databaseTypeField.getSQLType() == 2005 || databaseTypeField.getSQLType() == 2001 || databaseTypeField.getSQLType() == 70) {
                    databaseTypeField.setSearchable(false);
                } else {
                    databaseTypeField.setSearchable(true);
                }
                Object[] objectArray = new Object[]{string, new Boolean(databaseTypeField.isSearchable()).toString()};
                UtilitiesBase.logMessage(IBMDBBaseMessages.noSearchValue, objectArray);
            } else if (n <= 1) {
                databaseTypeField.setSearchable(false);
            } else {
                databaseTypeField.setSearchable(true);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.clearWarnings();
        }
    }

    public synchronized void close() throws SQLException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.setIsOpen(false);
            this.resultSet = null;
            throw throwable;
        }
        Object var1_3 = null;
        this.setIsOpen(false);
        this.resultSet = null;
    }

    public abstract void closeStatement() throws SQLException;

    protected void describe() throws SQLException, DataException {
        DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType();
        ResultSetMetaData resultSetMetaData = this.getResultSet().getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            this.describeCol(n2, databaseCompoundType, resultSetMetaData);
            ++n2;
        }
        this.setRowStruct(databaseCompoundType);
    }

    protected void describeCol(int n, DatabaseCompoundType databaseCompoundType, ResultSetMetaData resultSetMetaData) throws SQLException, DataException {
        Hashtable hashtable;
        Class clazz;
        DatabaseTypeField databaseTypeField = null;
        int n2 = resultSetMetaData.getColumnType(n);
        String string = resultSetMetaData.getColumnTypeName(n);
        String string2 = resultSetMetaData.getColumnName(n);
        if (string2 == null) {
            string2 = resultSetMetaData.getColumnLabel(n);
        }
        if ((clazz = (Class)(hashtable = JDBCConnectionManager.getSQLTypeTable()).get(new Integer(n2))) == null) {
            Class<?> clazz2 = class$com$ibm$db$base$DatabaseObjectField;
            if (clazz2 == null) {
                try {
                    clazz2 = class$com$ibm$db$base$DatabaseObjectField = Class.forName("com.ibm.db.base.DatabaseObjectField");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz = clazz2;
        }
        try {
            databaseTypeField = (DatabaseTypeField)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        databaseTypeField.setName(string2);
        databaseTypeField.setScale(resultSetMetaData.getScale(n));
        databaseTypeField.setLength(resultSetMetaData.getColumnDisplaySize(n));
        databaseTypeField.setSQLType(n2);
        databaseTypeField.setSQLTypeName(string);
        if (!this.isReadOnlyResultSet()) {
            this.checkSearchLevel(string, databaseTypeField);
        }
        databaseTypeField.setMode(2);
        databaseCompoundType.addFieldWithProposedName(databaseTypeField);
    }

    public abstract void execute() throws SQLException, DataException;

    public abstract void execute(DatabaseRow var1) throws SQLException, DataException;

    protected void fillInColumnShape() throws SQLException, DataException {
        DatabaseCompoundType databaseCompoundType = this.getRowStruct();
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        DatabaseTypeField databaseTypeField = null;
        String string = null;
        int n = databaseCompoundType.size();
        if (n != resultSetMetaData.getColumnCount()) {
            Object[] objectArray = new Object[]{new Integer(databaseCompoundType.size()), new Integer(resultSetMetaData.getColumnCount())};
            String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.inconsistentColumnCount, objectArray);
            DataException dataException = new DataException(string2, 102);
            dataException.setMessageArgs(objectArray);
            throw dataException;
        }
        int n2 = 1;
        while (n2 <= n) {
            databaseTypeField = databaseCompoundType.fieldAt(n2);
            int n3 = resultSetMetaData.getColumnType(n2);
            int n4 = databaseTypeField.getSQLType();
            if (n4 != n3) {
                if (n3 == 2001) {
                    n4 = 2001;
                    databaseTypeField.setSQLType(2001);
                } else if (!(n4 == 9 && n3 == 91 || n4 == 10 && n3 == 92 || n4 == 11 && n3 == 93 || n4 == 3 && n3 == 2 || n4 == 1 && n3 == 12 || n4 == 12 && n3 == -1 || n4 == -1 && n3 == 12 || n4 == -1 && n3 == 2005 || n4 == -4 && n3 == 2004 || n4 == -400 && n3 == 70)) {
                    Object[] objectArray = new Object[]{new Integer(n2), new Integer(n4), new Integer(n3)};
                    String string3 = UtilitiesBase.getMessage(IBMDBBaseMessages.inconsistentColumnType, objectArray);
                    DataException dataException = new DataException(string3, 103);
                    dataException.setMessageArgs(objectArray);
                    throw dataException;
                }
            }
            string = resultSetMetaData.getColumnTypeName(n2);
            databaseTypeField.setSQLTypeName(string);
            if (!this.isReadOnlyResultSet()) {
                this.checkSearchLevel(string, databaseTypeField);
                if (databaseTypeField.getScale() == 0) {
                    databaseTypeField.setScale(resultSetMetaData.getScale(n2));
                }
                if (databaseTypeField.getLength() == 0) {
                    databaseTypeField.setLength(resultSetMetaData.getColumnDisplaySize(n2));
                }
            }
            ++n2;
        }
    }

    public abstract String getCursorName() throws SQLException;

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSet == null) {
            return null;
        }
        return this.resultSet.getMetaData();
    }

    protected ResultSet getResultSet() {
        return this.resultSet;
    }

    public DatabaseRow getRow() throws SQLException, DataException {
        DatabaseRow databaseRow = this.newEmptyRow();
        DatabaseCompoundType databaseCompoundType = this.getRowStruct();
        int n = 1;
        Enumeration enumeration = databaseCompoundType.getColumnNames();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            Object object = databaseCompoundType.fieldAt(n).getObject(this.getResultSet(), n);
            boolean bl = this.getResultSet().wasNull();
            databaseRow.setColIsNull(n, bl);
            if (!bl) {
                databaseRow.putAtIndex(n, object);
            }
            ++n;
        }
        return databaseRow;
    }

    public int getRowNumber() throws SQLException {
        return this.getResultSet().getRow();
    }

    public DatabaseCompoundType getRowStruct() {
        return this.rowStruct;
    }

    public int getType() {
        return this.resultSetType;
    }

    public abstract SQLWarning getWarnings() throws SQLException;

    public abstract boolean isReadOnlyResultSet();

    public boolean lastRow() throws SQLException {
        return this.getResultSet() != null && this.getResultSet().last();
    }

    protected DatabaseRow newEmptyRow() {
        return new DatabaseRow(this.getRowStruct());
    }

    public boolean nextRow() throws SQLException {
        return this.getResultSet() != null && this.getResultSet().next();
    }

    public boolean previousRow() throws SQLException {
        return this.getResultSet() != null && this.getResultSet().previous();
    }

    public abstract void refresh() throws SQLException, DataException;

    public abstract void refresh(DatabaseRow var1) throws SQLException, DataException;

    public boolean relativeRow(int n) throws SQLException {
        return this.getResultSet() != null && this.getResultSet().relative(n);
    }

    protected void setQuerySpec(DatabaseQuerySpec databaseQuerySpec) {
        this.qSpec = databaseQuerySpec;
        if (this.qSpec != null) {
            this.setRowStruct(this.qSpec.getOutputShape());
        }
    }

    protected void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    protected void setRowStruct(DatabaseCompoundType databaseCompoundType) {
        this.rowStruct = databaseCompoundType;
    }

    public abstract void setTimeout(int var1) throws SQLException;
}

