/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.UtilitiesBase;
import java.io.Serializable;
import java.util.Enumeration;

public class DatabaseRow
implements Serializable {
    private DatabaseCompoundType type;
    private Object[] values;
    private boolean[] nullIndicators;
    private boolean[] changedIndicators;
    static final long serialVersionUID = -8042148413714571291L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 2000";
    static Class class$array1$$byte;
    static Class class$java$sql$Blob;
    static Class class$java$io$InputStream;
    static Class class$java$sql$Clob;

    public DatabaseRow(DatabaseCompoundType databaseCompoundType) {
        this.type = databaseCompoundType;
        int n = this.type.size();
        this.values = new Object[n];
        this.nullIndicators = new boolean[n];
        this.changedIndicators = new boolean[n];
    }

    public DatabaseRow(DatabaseRow databaseRow) {
        if (databaseRow == null) {
            return;
        }
        this.type = databaseRow.type;
        int n = this.type.size();
        this.values = new Object[n];
        this.nullIndicators = new boolean[n];
        this.changedIndicators = new boolean[n];
        int n2 = 1;
        while (n2 <= this.type.size()) {
            Object object = databaseRow.getAtIndex(n2);
            if (object != null) {
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = class$array1$$byte;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("[B");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    int n3 = ((byte[])object).length;
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray[n4] = ((byte[])object)[n4];
                        ++n4;
                    }
                    object = byArray;
                }
            }
            this.putAtIndex(n2, object);
            this.setColIsNull(n2, databaseRow.colIsNull(n2));
            this.setColWasChanged(n2, databaseRow.colWasChanged(n2));
            ++n2;
        }
    }

    protected boolean colIsNull(int n) {
        return this.getNullIndicators()[n - 1];
    }

    public String columnName(int n) {
        return this.getType().fieldAt(n).getName();
    }

    public boolean colWasChanged(int n) {
        return this.changedIndicators[n - 1];
    }

    public synchronized Object get(String string) {
        int n = this.getType().indexOfColumnName(string);
        return this.getAtIndex(n);
    }

    public Object getAtIndex(int n) {
        return this.getValues()[n - 1];
    }

    public int getColumnIndex(String string) {
        int n = this.getType().indexOfColumnName(string);
        return n;
    }

    public Enumeration getColumnNames() {
        return this.getType().getColumnNames();
    }

    protected boolean[] getNullIndicators() {
        return this.nullIndicators;
    }

    public DatabaseCompoundType getType() {
        return this.type;
    }

    protected Object[] getValues() {
        return this.values;
    }

    public synchronized DatabaseRow put(String string, Object object) throws DataException {
        int n = this.getType().indexOfColumnName(string);
        this.putAtIndexWithCheck(n, object);
        return this;
    }

    public void putAtIndex(int n, Object object) {
        this.getValues()[n - 1] = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void putAtIndexWithCheck(int n, Object object) throws DataException {
        DatabaseTypeField databaseTypeField;
        block16: {
            block15: {
                databaseTypeField = this.type.fieldAt(n);
                if (databaseTypeField == null) {
                    throw new IndexOutOfBoundsException();
                }
                if (object == null) {
                    this.getValues()[n - 1] = object;
                    return;
                }
                Class clazz = databaseTypeField.getFieldClass();
                if (clazz == null || clazz.isInstance(object)) break block15;
                Class<?> clazz2 = class$java$io$InputStream;
                if (clazz2 == null) {
                    Class<?> clazz3;
                    try {
                        clazz3 = Class.forName("java.io.InputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz2 = class$java$io$InputStream = clazz3;
                }
                if (!clazz2.isInstance(object)) break block16;
                Class<?> clazz4 = class$java$sql$Clob;
                if (clazz4 == null) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("java.sql.Clob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz4 = class$java$sql$Clob = clazz5;
                }
                if (clazz == clazz4) break block15;
                Class<?> clazz6 = class$java$sql$Blob;
                if (clazz6 == null) {
                    Class<?> clazz7;
                    try {
                        clazz7 = Class.forName("java.sql.Blob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz6 = class$java$sql$Blob = clazz7;
                }
                if (clazz != clazz6) break block16;
            }
            this.getValues()[n - 1] = object;
            return;
        }
        Class<?> clazz = object.getClass();
        Object[] objectArray = new Object[]{databaseTypeField.getName(), clazz.getName()};
        String string = UtilitiesBase.getMessage(IBMDBBaseMessages.wrongObjectType, objectArray);
        DataException dataException = new DataException(string, 104);
        dataException.setMessageArgs(objectArray);
        throw dataException;
    }

    public void setColIsNull(int n, boolean bl) {
        this.nullIndicators[n - 1] = bl;
    }

    public void setColWasChanged(int n, boolean bl) {
        this.changedIndicators[n - 1] = bl;
    }

    public int size() {
        return this.getType().size();
    }

    public synchronized String toString() {
        int n = this.getType().size();
        String string = new String();
        int n2 = 1;
        while (n2 <= n) {
            string = String.valueOf(string) + "[" + this.getAtIndex(n2) + "]";
            ++n2;
        }
        return string;
    }
}

