/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.UtilitiesBase;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.StringTokenizer;

public abstract class DatabaseStatement {
    protected boolean isOpen = false;
    protected DatabaseQuerySpec qSpec;
    protected DatabaseConnection conn;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseStatement() {
    }

    public DatabaseStatement(DatabaseConnection databaseConnection, DatabaseQuerySpec databaseQuerySpec) {
        this.setConnection(databaseConnection);
        this.setQuerySpec(databaseQuerySpec);
    }

    public abstract void cancel() throws SQLException;

    public abstract void clearWarnings() throws SQLException;

    public abstract void closeStatement() throws SQLException;

    public abstract void execute() throws SQLException, DataException;

    public abstract void execute(DatabaseRow var1) throws SQLException, DataException;

    protected DatabaseConnection getConnection() {
        return this.conn;
    }

    protected DatabaseQuerySpec getQuerySpec() {
        return this.qSpec;
    }

    public abstract SQLWarning getWarnings() throws SQLException;

    public static boolean isCallStatement(String string) throws DataException {
        if (string == null || string.length() == 0) {
            String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.noSQL);
            throw new DataException(string2, 106);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{} \t\n\r");
        String string3 = stringTokenizer.nextToken().toUpperCase();
        if (string3.equals("CALL")) {
            return true;
        }
        return (string3.startsWith(":") || string3.equals("?")) && (string3 = stringTokenizer.nextToken()).equals("=") && (string3 = stringTokenizer.nextToken().toUpperCase()).equals("CALL");
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public static boolean isSelectStatement(String string) throws DataException {
        if (string == null || string.length() == 0) {
            String string2 = UtilitiesBase.getMessage(IBMDBBaseMessages.noSQL);
            throw new DataException(string2, 106);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toUpperCase();
            if (string3.equals("SELECT") || string3.equals("WITH") || string3.equals("VALUES")) {
                return true;
            }
            if (string3.equals("(")) continue;
            return false;
        }
        return false;
    }

    protected void setConnection(DatabaseConnection databaseConnection) {
        this.conn = databaseConnection;
    }

    protected void setIsOpen(boolean bl) {
        this.isOpen = bl;
    }

    protected void setQuerySpec(DatabaseQuerySpec databaseQuerySpec) {
        this.qSpec = databaseQuerySpec;
    }

    public abstract void setTimeout(int var1) throws SQLException;
}

