/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics.wsHandlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsHandlerBase;
import com.ibm.wsspi.webservices.rpc.handler.MessageContext;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class ReqMetricsClientHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register((String)(class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsClientHandler == null ? (class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsClientHandler = ReqMetricsClientHandler.class$("com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler")) : class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsClientHandler).getName(), (String)"pmi.rm", (String)"com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    public static final String PORT_NAME = "wsdlPort";
    public static final String OP_NAME = "opName";
    public static final String TRANSPORT_NAME = "transportName";
    public static final String TARGET_ENDPOINRT = "targetEndpoint";
    public static final String PARAM_NAMES = "paramNames";
    public static final String SERVICE_REF_NAME = "serviceReferenceName";
    public static final String RESPONSE_MSG = "responseMessage";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 0;
    public static final int TRANSPORT_ID = 0;
    public static final int TARGET_ENDPOINT_ID = 0;
    public static final int PARAMS_ID = 0;
    public static final int SERVICE_REF_ID = 0;
    public static final String RM_CLNT_START = "REQMETRICS_WS_CLIENT_START";
    static /* synthetic */ Class class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsClientHandler;

    public ReqMetricsClientHandler() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ReqMetricsClientHandler is initialized");
        }
    }

    public boolean handleRequest(javax.xml.rpc.handler.MessageContext messageContext) {
        if (this.impl == null) {
            this.impl = PmiReqMetricsImpl.getInstance();
            if (this.impl == null) {
                Tr.error((TraceComponent)tc, (String)"PMRM0022E");
                return true;
            }
        }
        if (!this.impl.isEnabled() || !this.impl.isTMTPEnabled()) {
            return true;
        }
        Tr.entry((TraceComponent)tc, (String)"handleRequest");
        boolean bl = tc.isDebugEnabled();
        try {
            Object object;
            Object object2;
            PmiRmArmTx pmiRmArmTx = PmiRmArmStack.peekTransaction();
            if (pmiRmArmTx == null) {
                Tr.error((TraceComponent)tc, (String)"PMRM0030E");
                Tr.exit((TraceComponent)tc, (String)"handleRequest");
                return true;
            }
            boolean bl2 = this.isTraceEnabled(pmiRmArmTx.getCorrelatorBytes());
            if (!bl2) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest: isTraceEnabled returns false. Do not create sub-transaction");
                }
            } else {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest: isTraceEnabled returns true. Create sub-transaction");
                }
                object2 = this.getTranName(messageContext);
                this.impl.updateBegin(3, "Web Services Requestor", (String)object2);
                object = this.impl.getThreadContext();
                int n = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)object);
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)("calling MessageContext.setProperty for startHandle=" + n));
                }
                messageContext.setProperty(RM_CLNT_START, (Object)new Integer(n));
            }
            pmiRmArmTx = PmiRmArmStack.peekTransaction();
            object2 = null;
            object = null;
            if (pmiRmArmTx == null) {
                Tr.warning((TraceComponent)tc, (String)"PMRM0210W", (Object)"handleRequest");
                return true;
            }
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"handleRequest: find a correlator on stack");
            }
            if (pmiRmArmTx instanceof PmiRmCallContext) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest: get PmiRmCallContext");
                }
                object2 = (PmiRmCallContext)pmiRmArmTx;
                object = ((PmiRmCallContext)object2).getCorrelator();
            } else if (bl) {
                Tr.debug((TraceComponent)tc, (String)"handleRequest: get armTx");
            }
            byte[] byArray = pmiRmArmTx.getCorrelatorBytes();
            this.impl.getArmWrapper();
            String string = PmiRmArmWrapper.toHexString(byArray);
            String string2 = PmiRmCorrelator.getStringFromPmiRmCorrelator((PmiRmCorrelator)object);
            if (string == null && string2 == null) {
                Tr.warning((TraceComponent)tc, (String)"both ARM and request metrics correlators are null");
                Tr.exit((TraceComponent)tc, (String)"handleRequest");
                return true;
            }
            this.addCorrelatorsToSoapHeader(messageContext, string, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.handleRequest", (String)FFDC_ID_1);
            Tr.warning((TraceComponent)tc, (String)"PMRM0108E", (Object)exception.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"handleRequest");
        return true;
    }

    private void addCorrelatorsToSoapHeader(javax.xml.rpc.handler.MessageContext messageContext, String string, String string2) {
        try {
            SOAPMessageContext sOAPMessageContext;
            SOAPMessage sOAPMessage;
            SOAPPart sOAPPart;
            SOAPEnvelope sOAPEnvelope;
            SOAPHeader sOAPHeader;
            boolean bl = tc.isDebugEnabled();
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"addCorrelatorsToSoapHeader");
            }
            if ((sOAPHeader = (sOAPEnvelope = (sOAPPart = (sOAPMessage = (sOAPMessageContext = (SOAPMessageContext)messageContext).getMessage()).getSOAPPart()).getEnvelope()).getHeader()) == null) {
                sOAPHeader = sOAPEnvelope.addHeader();
            }
            Name name = sOAPEnvelope.createName("correlator", "reqmetrics", "http://websphere.ibm.com");
            SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(name);
            sOAPHeaderElement.addTextNode(string);
            sOAPHeaderElement.setActor("reqmetricsURI");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addCorrelatorsToSoapHeader: add arm cor value=" + sOAPHeaderElement.getValue()));
            }
            if (string2 != null) {
                Name name2 = sOAPEnvelope.createName("rm_correlator", "", "");
                sOAPHeaderElement.addAttribute(name2, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addCorrelatorsToSoapHeader: add rm cor attribute=" + sOAPHeaderElement.getAttributeValue(name2)));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCorrelatorsToSoapHeader");
        }
    }

    public boolean handleResponse(javax.xml.rpc.handler.MessageContext messageContext) {
        if (this.impl == null || !this.impl.isEnabled() || !this.impl.isTMTPEnabled()) {
            return true;
        }
        Tr.entry((TraceComponent)tc, (String)"handleResponse");
        this.tranEnd(messageContext, 1);
        Tr.exit((TraceComponent)tc, (String)"handleResponse");
        return true;
    }

    public boolean handleFault(javax.xml.rpc.handler.MessageContext messageContext) {
        if (this.impl == null || !this.impl.isEnabled() || !this.impl.isTMTPEnabled()) {
            return true;
        }
        Tr.entry((TraceComponent)tc, (String)"handleFault");
        this.tranEnd(messageContext, 2);
        Tr.exit((TraceComponent)tc, (String)"handleFault");
        return true;
    }

    private void tranEnd(javax.xml.rpc.handler.MessageContext messageContext, int n) {
        Tr.entry((TraceComponent)tc, (String)"tranEnd");
        try {
            PmiRmCallContext pmiRmCallContext;
            int n2;
            PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
            PmiRmArmTx pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction(pmiRmThreadCtx);
            if (pmiRmArmTx == null) {
                Tr.error((TraceComponent)tc, (String)"PMRM0030E");
                Tr.exit((TraceComponent)tc, (String)"tranEnd");
                return;
            }
            Integer n3 = (Integer)messageContext.getProperty(RM_CLNT_START);
            if (n3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tranEnd: no start handle is found, so do not call stop on this transaction");
                }
                Tr.exit((TraceComponent)tc, (String)"tranEnd");
                return;
            }
            int n4 = n3;
            if (n4 != (n2 = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx))) {
                Tr.warning((TraceComponent)tc, (String)"PMRM0213W", (Object)"tranEnd");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"tranEnd, ready to call updateEnd on this transaction");
            }
            if ((pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tranEnd: calling setContext");
                }
                pmiRmCallContext.setContextInfo(this.getContextInfo(pmiRmCallContext.getCorrelatorBytes(), messageContext));
            }
            this.impl.updateEnd(pmiRmThreadCtx, 3, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.tranEnd", (String)FFDC_ID_2);
            Tr.warning((TraceComponent)tc, (String)"PMRM0108E", (Object)exception.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"tranEnd");
    }

    public void handleClosure(javax.xml.rpc.handler.MessageContext messageContext) {
    }

    protected HashMap getMetricsData(javax.xml.rpc.handler.MessageContext messageContext, int n, boolean bl) {
        StringBuffer stringBuffer;
        com.ibm.ws.webservices.engine.SOAPPart sOAPPart;
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMetricsData: level=" + n));
        }
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap.put("", hashMap2);
        if (messageContext == null) {
            return hashMap;
        }
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        if (n >= 2) {
            qName = rPCContext.getWSDLPort();
            sOAPPart = rPCContext.getWSDLParameters();
            stringBuffer = new StringBuffer();
            if (sOAPPart != null && ((QName[])sOAPPart).length > 0) {
                for (int i = 0; i < ((QName[])sOAPPart).length; ++i) {
                    stringBuffer.append(sOAPPart[i].getLocalPart());
                    if (i >= ((com.ibm.ws.webservices.engine.SOAPPart)sOAPPart).length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            hashMap2.put("WS_PORT_NM", qName.getLocalPart());
            hashMap2.put("WS_OP_NM", rPCContext.getWSDLOperation());
            hashMap2.put("WS_TRAN_NM", rPCContext.getTransportName());
            hashMap2.put("WS_PRM_Q_NM_LST", stringBuffer.toString());
        }
        if (n == 3) {
            hashMap2.put("WS_TGT_E_ADR", rPCContext.getTargetEndpointAddress());
            hashMap2.put("WS_SVC_REF_NM", rPCContext.getServiceRefName());
            if (bl) {
                try {
                    qName = ((com.ibm.ws.webservices.engine.MessageContext)messageContext).getMessage();
                    sOAPPart = (com.ibm.ws.webservices.engine.SOAPPart)qName.getSOAPPart();
                    stringBuffer = sOAPPart.getEnvelope();
                    SOAPBody sOAPBody = stringBuffer.getBody();
                    hashMap2.put("WS_RESP_MSG", (String)sOAPBody);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.getMetricsData", (String)FFDC_ID_4);
                    Tr.warning((TraceComponent)tc, (String)"PMRM0108E", (Object)exception.toString());
                }
            }
        }
        return hashMap;
    }

    protected String getTranName(javax.xml.rpc.handler.MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTranName");
        }
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        QName qName = rPCContext.getWSDLPort();
        QName[] qNameArray = rPCContext.getWSDLParameters();
        StringBuffer stringBuffer = new StringBuffer();
        if (qNameArray != null && qNameArray.length > 0) {
            for (int i = 0; i < qNameArray.length; ++i) {
                stringBuffer.append(qNameArray[i].getLocalPart());
                if (i >= qNameArray.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("wsrequestor:");
        stringBuffer2.append(qName.getLocalPart());
        String string = rPCContext.getWSDLOperation();
        if (string == null) {
            stringBuffer2.append(".");
        } else {
            stringBuffer2.append(".").append(string);
        }
        stringBuffer2.append("?transport=").append(rPCContext.getTransportName());
        stringBuffer2.append("&parameters=").append(stringBuffer.toString());
        String string2 = stringBuffer2.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTranName returns " + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTranName");
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

