/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.reqmetrics.wsHandlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmConstants;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmFilterConfig;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsHandlerBase;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.wsspi.webservices.rpc.handler.MessageContext;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class ReqMetricsServerHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register((String)(class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsServerHandler == null ? (class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsServerHandler = ReqMetricsServerHandler.class$("com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler")) : class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsServerHandler).getName(), (String)"pmi.rm", (String)"com.ibm.ws.pmi.reqmetrics.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int NAMESPACE_ID = 3;
    public static final int INPUT_MESSAGE_ID = 4;
    public static final String RM_SRV_START = "REQMETRICS_WS_SERVER_START";
    static /* synthetic */ Class class$com$ibm$ws$pmi$reqmetrics$wsHandlers$ReqMetricsServerHandler;

    public ReqMetricsServerHandler() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ReqMetricsServerHandler is initialized");
        }
    }

    public boolean handleRequest(javax.xml.rpc.handler.MessageContext messageContext) {
        if (this.impl == null) {
            Tr.error((TraceComponent)tc, (String)"PMRM0022E");
            return true;
        }
        if (!this.impl.isEnabled() || !this.impl.isTMTPEnabled()) {
            return true;
        }
        boolean bl = tc.isDebugEnabled();
        Tr.entry((TraceComponent)tc, (String)"handleRequest");
        try {
            boolean bl2;
            if (!this.impl.isEnabled()) {
                return true;
            }
            PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
            ReqMetricsServerHandler reqMetricsServerHandler = this;
            PmiRmConfigData pmiRmConfigData = reqMetricsServerHandler.impl.getConfig();
            pmiRmThreadCtx.setConfig(pmiRmConfigData);
            byte[] byArray = null;
            PmiRmCorrelator pmiRmCorrelator = null;
            PmiRmCallContext pmiRmCallContext = null;
            boolean bl3 = false;
            boolean bl4 = true;
            PmiRmArmTx pmiRmArmTx = PmiRmArmStack.peekTransaction();
            if (pmiRmArmTx != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest: peekTransaction returns a PmiRmArmTx");
                }
                bl3 = true;
                byArray = pmiRmArmTx.getCorrelatorBytes();
                if (!pmiRmArmTx.ispoppable()) {
                    pmiRmCallContext = (PmiRmCallContext)pmiRmArmTx;
                    pmiRmCorrelator = pmiRmCallContext.getCorrelator();
                }
            } else {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest: do not have correlator on the stack, check incoming correlator");
                }
                pmiRmThreadCtx.reset();
                String[] stringArray = this.getCorrelatorsFromContext(messageContext);
                this.impl.getArmWrapper();
                byArray = PmiRmArmWrapper.fromHexString(stringArray[0]);
                pmiRmCorrelator = PmiRmCorrelator.getPmiRmCorrelatorFromString(stringArray[1]);
                if (pmiRmCorrelator != null && byArray != null) {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"handleRequest: find both arm and rm correlatorin SOAP header");
                    }
                    pmiRmCorrelator.setArmCorrelator(byArray);
                } else if (byArray != null) {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"handleRequest: no rm correlator is found in SOAP header");
                    }
                    pmiRmCorrelator = new PmiRmCorrelator(-1, "na", "na", -1L, -1L, -1L);
                    pmiRmCorrelator.setArmCorrelator(byArray);
                } else if (pmiRmCorrelator != null) {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"handleRequest: no arm correlator is found in SOAP header");
                    }
                } else {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"handleRequest: no correlator is found in SOAP header");
                    }
                    bl4 = false;
                }
                pmiRmThreadCtx.setTrace(true);
                if (pmiRmCorrelator != null) {
                    pmiRmThreadCtx.setInboundComponent(5);
                    pmiRmCallContext = PmiRmArmWrapper.pushParentContext(pmiRmThreadCtx, pmiRmCorrelator, "Web Services Provider", "UNKNOWN");
                }
            }
            if (!(bl2 = this.isTraceEnabled(byArray))) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"handleRequest: isTraceEnabled returns false. Do not create sub-transaction");
                }
            } else {
                int n;
                String[] stringArray = this.getContextValues(messageContext);
                String string = this.getTranName(stringArray);
                if (!bl3 && !bl4) {
                    n = 1;
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"handleRequest: no parent correlator on stack and no incoming correlator");
                    }
                    pmiRmThreadCtx.setTrace(n != 0);
                }
                this.impl.reqStart(pmiRmThreadCtx, "Web Services Provider", string, PmiRmConstants.webservices_ctxnames, stringArray);
                n = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx);
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)("calling MessageContext.setProperty for startHandler=" + n));
                }
                messageContext.setProperty(RM_SRV_START, (Object)new Integer(n));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.handleRequest", (String)FFDC_ID_1);
            Tr.warning((TraceComponent)tc, (String)"PMRM0108E", (Object)exception.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"handleRequest");
        return true;
    }

    public boolean handleResponse(javax.xml.rpc.handler.MessageContext messageContext) {
        if (this.impl == null) {
            Tr.error((TraceComponent)tc, (String)"PMRM0022E");
            return true;
        }
        if (!this.impl.isEnabled() || !this.impl.isTMTPEnabled()) {
            return true;
        }
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.entry((TraceComponent)tc, (String)"handleResponse");
        }
        this.tranEnd(messageContext, 1);
        if (bl) {
            Tr.exit((TraceComponent)tc, (String)"handleResponse");
        }
        return true;
    }

    public boolean handleFault(javax.xml.rpc.handler.MessageContext messageContext) {
        if (this.impl == null) {
            Tr.error((TraceComponent)tc, (String)"PMRM0022E");
            return true;
        }
        if (!this.impl.isEnabled() || !this.impl.isTMTPEnabled()) {
            return true;
        }
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.entry((TraceComponent)tc, (String)"handleFault");
        }
        this.tranEnd(messageContext, 2);
        if (bl) {
            Tr.exit((TraceComponent)tc, (String)"handleFault");
        }
        return true;
    }

    public void handleClosure(javax.xml.rpc.handler.MessageContext messageContext) {
    }

    private void tranEnd(javax.xml.rpc.handler.MessageContext messageContext, int n) {
        Tr.entry((TraceComponent)tc, (String)"tranEnd");
        try {
            PmiRmCallContext pmiRmCallContext;
            int n2;
            PmiRmThreadCtx pmiRmThreadCtx = this.impl.getThreadContext();
            PmiRmArmTx pmiRmArmTx = PmiRmArmWrapper.peekArmTransaction(pmiRmThreadCtx);
            if (pmiRmArmTx == null) {
                Tr.error((TraceComponent)tc, (String)"PMRM0030E");
                Tr.exit((TraceComponent)tc, (String)"tranEnd");
                return;
            }
            Integer n3 = (Integer)messageContext.getProperty(RM_SRV_START);
            if (n3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tranEnd: no start handle is found, so do not call stop on this transaction");
                }
                Tr.exit((TraceComponent)tc, (String)"tranEnd");
                if (pmiRmThreadCtx.isInboundComponent(5)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"tranEnd: is inbound web services, call popContext for possible incoming parent correlator");
                    }
                    PmiRmArmWrapper.popContext(pmiRmThreadCtx);
                }
                return;
            }
            int n4 = n3;
            if (n4 != (n2 = PmiRmArmWrapper.getStartHandle(pmiRmThreadCtx))) {
                Tr.warning((TraceComponent)tc, (String)"PMRM0213W", (Object)"tranEnd");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"tranEnd, ready to call stop on this transaction");
            }
            if ((pmiRmCallContext = PmiRmArmWrapper.peekContext(pmiRmThreadCtx)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tranEnd: calling setContext");
                }
                pmiRmCallContext.setContextInfo(this.getContextInfo(pmiRmCallContext.getCorrelatorBytes(), messageContext));
            }
            this.impl.reqStop(pmiRmThreadCtx, 3, n);
            if (pmiRmThreadCtx.isInboundComponent(5)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tranEnd: is inbound web services, call popContext for possible incoming parent correlator");
                }
                PmiRmArmWrapper.popContext(pmiRmThreadCtx);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.handleResponse", (String)FFDC_ID_2);
            Tr.warning((TraceComponent)tc, (String)"PMRM0108E", (Object)exception.toString());
        }
        Tr.exit((TraceComponent)tc, (String)"tranEnd");
    }

    private String getTranName(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("wsprovider:");
        stringBuffer.append(stringArray[0]);
        if (stringArray[1] == null) {
            stringBuffer.append(".");
        } else {
            stringBuffer.append(".").append(stringArray[1]);
        }
        stringBuffer.append("?transport=").append(stringArray[2]);
        if (stringArray[3] == null) {
            stringBuffer.append("&namespace=");
        } else {
            stringBuffer.append("&namespace=").append(stringArray[3]);
        }
        stringBuffer.append("&input=").append(stringArray[4]);
        String string = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTranName returns " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTranName");
        }
        return string;
    }

    private String[] getContextValues(javax.xml.rpc.handler.MessageContext messageContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getContextValues");
        }
        String[] stringArray = new String[PmiRmConstants.webservices_ctxnames.length];
        if (messageContext == null) {
            return stringArray;
        }
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        QName qName = rPCContext.getWSDLPort();
        QName qName2 = rPCContext.getWSDLInputMessageName();
        if (qName == null) {
            stringArray[0] = "";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ReqMetricsServerHandler.getContextValues: portQName is null");
            }
        } else {
            stringArray[0] = qName.getLocalPart();
        }
        stringArray[1] = rPCContext.getWSDLOperation();
        stringArray[2] = rPCContext.getTransportName();
        stringArray[3] = rPCContext.getWSDLTargetNamespace();
        if (qName2 == null) {
            stringArray[4] = "";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ReqMetricsServerHandler.getContextValues: inputMsg is null");
            }
        } else {
            stringArray[4] = qName2.getLocalPart();
        }
        return stringArray;
    }

    protected HashMap getMetricsData(javax.xml.rpc.handler.MessageContext messageContext, int n, boolean bl) {
        QName qName;
        QName qName2;
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMetricsData: level=" + n));
        }
        HashMap hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap.put("", hashMap2);
        if (messageContext == null) {
            return hashMap;
        }
        MessageContext messageContext2 = (MessageContext)messageContext;
        RPCContext rPCContext = messageContext2.getRPCContext();
        if (n >= 2) {
            qName2 = rPCContext.getWSDLPort();
            qName = rPCContext.getWSDLInputMessageName();
            hashMap2.put("WS_PORT_NM", qName2.getLocalPart());
            hashMap2.put("WS_OP_NM", rPCContext.getWSDLOperation());
            hashMap2.put("WS_TRAN_NM", rPCContext.getTransportName());
            hashMap2.put("WS_TGT_NS", rPCContext.getWSDLTargetNamespace());
            if (qName != null) {
                hashMap2.put("WS_IN_MSG_NM", qName.getLocalPart());
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getMetricsData: inputMsg QName is null");
            }
        }
        if (n == 3) {
            hashMap2.put("WS_WSDL_LOC", rPCContext.getWSDLLocation());
            if (bl) {
                try {
                    qName2 = ((com.ibm.ws.webservices.engine.MessageContext)messageContext).getMessage();
                    qName = (com.ibm.ws.webservices.engine.SOAPPart)qName2.getSOAPPart();
                    SOAPEnvelope sOAPEnvelope = qName.getEnvelope();
                    SOAPBody sOAPBody = sOAPEnvelope.getBody();
                    hashMap2.put("WS_SOAP_BD", (String)sOAPBody);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.getMetricsData", (String)FFDC_ID_4);
                    Tr.warning((TraceComponent)tc, (String)"PMRM0108E", (Object)exception.toString());
                }
            }
        }
        return hashMap;
    }

    private String[] getCorrelatorsFromContext(javax.xml.rpc.handler.MessageContext messageContext) {
        try {
            boolean bl = tc.isDebugEnabled();
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            String string = null;
            String string2 = null;
            if (sOAPHeader != null) {
                Name name = sOAPEnvelope.createName("rm_correlator", "", "");
                Iterator iterator = sOAPHeader.examineHeaderElements("reqmetricsURI");
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement;
                    com.ibm.ws.webservices.engine.xmlsoap.Name name2;
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)"ReqMetricsServerHandler.getCorrelatorsFromContext: find a header element");
                    }
                    if ((name2 = (com.ibm.ws.webservices.engine.xmlsoap.Name)(sOAPHeaderElement = (SOAPHeaderElement)iterator.next()).getElementName()).getLocalName().indexOf("correlator") != -1) {
                        string = sOAPHeaderElement.getValue();
                        string2 = sOAPHeaderElement.getAttributeValue(name);
                        bl2 = true;
                    }
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)("getCorrelatorsFromContext armCorStr=" + string + ", rmCorStr=" + string2));
                    }
                    if (!bl2) continue;
                }
            }
            return new String[]{string, string2};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new String[]{null, null};
        }
    }

    private boolean isFilterPassed(com.ibm.ws.webservices.engine.MessageContext messageContext, PmiRmConfigData pmiRmConfigData) {
        PmiRmFilterConfig pmiRmFilterConfig = pmiRmConfigData.getIpFilterConfig();
        boolean bl = pmiRmFilterConfig.isEnabled();
        boolean bl2 = false;
        boolean bl3 = tc.isDebugEnabled();
        bl2 = true;
        PmiRmFilterConfig pmiRmFilterConfig2 = pmiRmConfigData.getUriFilterConfig();
        boolean bl4 = pmiRmFilterConfig2.isEnabled();
        boolean bl5 = false;
        if (bl3) {
            Tr.debug((TraceComponent)tc, (String)("checkingUriFilter = " + bl4));
        }
        if (bl4) {
            PortDesc portDesc = messageContext.getPortDesc();
            String string = portDesc.getName();
            for (int i = 0; !(i >= pmiRmFilterConfig2.numFilters() || pmiRmFilterConfig2.isFilterEnabled(i) && (bl5 = this.isStrMatched(pmiRmFilterConfig2.getFilter(i), string))); ++i) {
            }
        }
        boolean bl6 = false;
        if (!bl && !bl4) {
            bl6 = true;
        }
        if (bl && bl4) {
            bl6 = bl5 && bl2;
        } else if (bl) {
            bl6 = bl2;
        } else if (bl4) {
            bl6 = bl5;
        }
        if (bl3) {
            Tr.debug((TraceComponent)tc, (String)("fFilterPass = " + bl6 + ", ipFilterMatch=" + bl2 + ", uriFilterMatch=" + bl5));
        }
        return bl6;
    }

    private boolean isStrMatched(String string, String string2) {
        boolean bl = false;
        String string3 = string2;
        int n = string.indexOf("*");
        if (n == 0) {
            return true;
        }
        if (n > -1) {
            if (string2.length() > n) {
                string3 = string2.substring(0, n);
            }
            string = string.substring(0, n);
        }
        if (string3.equals(string)) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

