/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.info;

import db2j.l.cz;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ProductVersionHolder {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private static final int BAD_NUMBER = -1;
    private static final String BETA = "beta";
    public static final int LT = -1;
    public static final int EQ = 0;
    public static final int GT = 1;
    private String productVendorName;
    private String productGenus;
    private String productSpecies;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int maintVersion = -1;
    private int buildNumber = -1;
    private Boolean isBeta;

    static ProductVersionHolder getProductVersionHolder(String string, String string2, int n2, int n3, int n4, int n5, Boolean bl2) {
        ProductVersionHolder productVersionHolder = new ProductVersionHolder(string, string2, n2, n3, n4, n5, bl2);
        if (productVersionHolder.isValid()) {
            return productVersionHolder;
        }
        return null;
    }

    public static ProductVersionHolder getProductVersionHolderFromMyEnv(String string) {
        Properties properties;
        ProductVersionHolder productVersionHolder = null;
        if (cz.JDK_ID != 1) {
            try {
                productVersionHolder = (ProductVersionHolder)Class.forName("com.ibm.db2j.info.ProductVersionHolderJava2").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (productVersionHolder == null) {
            productVersionHolder = new ProductVersionHolder();
        }
        if ((properties = productVersionHolder.loadProperties(string)) == null) {
            return null;
        }
        return ProductVersionHolder.getProductVersionHolder(properties);
    }

    public static ProductVersionHolder getProductVersionHolder(Properties properties) {
        String string = properties.getProperty("db2j.product.vendor");
        String string2 = properties.getProperty("db2j.product.internal.name");
        int n2 = ProductVersionHolder.parseInt(properties.getProperty("db2j.version.major"));
        int n3 = ProductVersionHolder.parseInt(properties.getProperty("db2j.version.minor"));
        int n4 = ProductVersionHolder.parseInt(properties.getProperty("db2j.version.maint"));
        int n5 = ProductVersionHolder.parseInt(properties.getProperty("db2j.build.number"));
        Boolean bl2 = Boolean.valueOf(properties.getProperty("db2j.version.beta"));
        return ProductVersionHolder.getProductVersionHolder(string, string2, n2, n3, n4, n5, bl2);
    }

    public static ProductVersionHolder getProductVersionHolder(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.lastIndexOf(45);
        if (n3 == -1) {
            return null;
        }
        int n4 = string.lastIndexOf(45, n3 - 1);
        if (n4 == -1) {
            return null;
        }
        int n5 = string.indexOf(45);
        if (n5 == n4) {
            return null;
        }
        String string2 = string.substring(0, n5);
        String string3 = string.substring(n5 + 1, n4).trim();
        String string4 = string.substring(n3 + 1).trim();
        if (string4.length() < 3 || string4.charAt(0) != '(' || string4.charAt(string4.length() - 1) != ')') {
            return null;
        }
        string4 = string4.substring(1, string4.length() - 1);
        int n6 = ProductVersionHolder.parseInt(string4);
        String string5 = string.substring(n4 + 1, n3).trim();
        int n7 = string5.indexOf(46);
        if (n7 < 1) {
            return null;
        }
        int n8 = string5.lastIndexOf(46);
        if (n8 <= n7 || n8 >= string5.length() - 1) {
            return null;
        }
        int n9 = ProductVersionHolder.parseInt(string5.substring(0, n7));
        int n10 = ProductVersionHolder.parseInt(string5.substring(n7 + 1, n8));
        Boolean bl2 = null;
        int n11 = string5.lastIndexOf(BETA);
        if (string5.endsWith(BETA)) {
            bl2 = new Boolean(true);
            String string6 = string5.substring(n8 + 1, string5.length() - BETA.length()).trim();
            n2 = ProductVersionHolder.parseInt(string6);
        } else {
            bl2 = new Boolean(false);
            n2 = ProductVersionHolder.parseInt(string5.substring(n8 + 1));
        }
        return ProductVersionHolder.getProductVersionHolder(string2, string3, n9, n10, n2, n6, bl2);
    }

    public String getProductVendorName() {
        return this.productVendorName;
    }

    public String getProductName() {
        return ProductVersionHolder.getProductName(this.productGenus, this.productSpecies);
    }

    public static String getProductName(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string3 = null;
        if (string2 != null && string2.trim().length() != 0) {
            string3 = string2.trim();
        }
        if (string3 == null) {
            return string.trim();
        }
        return string.trim() + ":" + string3;
    }

    public String getProductGenus() {
        return this.productGenus;
    }

    private static String getProductGenus(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        String string2 = n2 == -1 ? string.trim() : string.substring(0, n2).trim();
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public String getProductSpecies() {
        return this.productSpecies;
    }

    private static String getProductSpecies(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n2 + 1).trim();
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMaintVersion() {
        return this.maintVersion;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    private boolean isValid() {
        return this.productVendorName != null && this.productVendorName.length() > 0 && this.productGenus != null && this.productGenus.length() > 0 && this.majorVersion >= 0 && this.minorVersion >= 0 && this.maintVersion >= 0 && this.buildNumber > 0 && this.isBeta != null;
    }

    private static int parseInt(String string) {
        int n2 = -1;
        try {
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 < 0) {
            n2 = -1;
        }
        return n2;
    }

    public int featureCompare(ProductVersionHolder productVersionHolder) {
        if (this.getMajorVersion() < productVersionHolder.getMajorVersion()) {
            return -1;
        }
        if (this.getMajorVersion() > productVersionHolder.getMajorVersion()) {
            return 1;
        }
        if (this.getMinorVersion() < productVersionHolder.getMinorVersion()) {
            return -1;
        }
        if (this.getMinorVersion() > productVersionHolder.getMinorVersion()) {
            return 1;
        }
        if (this.isBeta() && !productVersionHolder.isBeta()) {
            return -1;
        }
        if (!this.isBeta() && productVersionHolder.isBeta()) {
            return 1;
        }
        return 0;
    }

    public int compare(ProductVersionHolder productVersionHolder) {
        if (this.getMajorVersion() < productVersionHolder.getMajorVersion()) {
            return -1;
        }
        if (this.getMajorVersion() > productVersionHolder.getMajorVersion()) {
            return 1;
        }
        if (this.getMinorVersion() < productVersionHolder.getMinorVersion()) {
            return -1;
        }
        if (this.getMinorVersion() > productVersionHolder.getMinorVersion()) {
            return 1;
        }
        if (this.getMaintVersion() < productVersionHolder.getMaintVersion()) {
            return -1;
        }
        if (this.getMaintVersion() > productVersionHolder.getMaintVersion()) {
            return 1;
        }
        if (this.isBeta() && !productVersionHolder.isBeta()) {
            return -1;
        }
        if (!this.isBeta() && productVersionHolder.isBeta()) {
            return 1;
        }
        return 0;
    }

    public String createProductVersionString() {
        if (this.isValid()) {
            return this.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProductVendorName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getProductName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getVersionBuildString());
        return stringBuffer.toString();
    }

    public String getVersionBuildString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.majorVersion + "." + this.minorVersion + "." + this.maintVersion);
        if (this.isBeta()) {
            stringBuffer.append(" beta");
        }
        stringBuffer.append(" - ");
        stringBuffer.append("(" + this.buildNumber + ")");
        return stringBuffer.toString();
    }

    protected Properties loadProperties(String string) {
        String string2 = string + ".properties";
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected ProductVersionHolder() {
    }

    private ProductVersionHolder(String string, String string2, int n2, int n3, int n4, int n5, Boolean bl2) {
        if (string != null) {
            this.productVendorName = string.trim();
        }
        this.productGenus = ProductVersionHolder.getProductGenus(string2);
        this.productSpecies = ProductVersionHolder.getProductSpecies(string2);
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.maintVersion = n4;
        this.buildNumber = n5;
        this.isBeta = bl2;
    }
}

