/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.jdbc;

import com.ibm.db2j.jdbc.DB2jAbstractDataSource;
import com.ibm.db2j.util.DriverUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;

public class DB2jDataSource
extends DB2jAbstractDataSource
implements DataSource {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001,2003. All Rights Reserved.";
    private static final long serialVersionUID = -4945135214995641181L;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    protected transient Driver driver;
    private transient String jdbcurl;

    public boolean equals(Object object) {
        if (object instanceof DB2jDataSource) {
            DB2jDataSource dB2jDataSource = (DB2jDataSource)object;
            boolean bl2 = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(dB2jDataSource.databaseName)) {
                    bl2 = false;
                }
            } else if (dB2jDataSource.databaseName != null) {
                bl2 = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(dB2jDataSource.dataSourceName)) {
                    bl2 = false;
                }
            } else if (dB2jDataSource.dataSourceName != null) {
                bl2 = false;
            }
            if (this.description != null) {
                if (!this.description.equals(dB2jDataSource.description)) {
                    bl2 = false;
                }
            } else if (dB2jDataSource.description != null) {
                bl2 = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(dB2jDataSource.createDatabase)) {
                    bl2 = false;
                }
            } else if (dB2jDataSource.createDatabase != null) {
                bl2 = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(dB2jDataSource.shutdownDatabase)) {
                    bl2 = false;
                }
            } else if (dB2jDataSource.shutdownDatabase != null) {
                bl2 = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(dB2jDataSource.connectionAttributes)) {
                    bl2 = false;
                }
            } else if (dB2jDataSource.connectionAttributes != null) {
                bl2 = false;
            }
            if (this.loginTimeout != dB2jDataSource.loginTimeout) {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    public final void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.equalsIgnoreCase("create") ? string : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown") ? string : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        if (string != null) {
            ((Hashtable)properties).put("user", string);
        }
        if (string2 != null) {
            ((Hashtable)properties).put("password", string2);
        }
        return this.getConnectionViaDriver(properties);
    }

    Connection getConnectionViaDriver(Properties properties) throws SQLException {
        this.populateInfo(properties);
        return this.findDriver().connect(this.jdbcurl, properties);
    }

    public void populateInfo(Properties properties) {
        if (this.createDatabase != null) {
            ((Hashtable)properties).put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            ((Hashtable)properties).put("shutdown", "true");
        }
    }

    public void setDatabaseProperties(Properties properties) {
        this.createDatabase = properties.getProperty("create");
        this.shutdownDatabase = properties.getProperty("shutdown");
    }

    Driver findDriver() throws SQLException {
        String string = this.jdbcurl;
        if (this.driver == null || !this.driver.acceptsURL(string)) {
            DB2jDataSource dB2jDataSource = this;
            synchronized (dB2jDataSource) {
                if (this.driver == null || !this.driver.acceptsURL(string)) {
                    try {
                        DriverUtil.loadDriverIfKnown(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.driver = DriverManager.getDriver(string);
                }
            }
        }
        return this.driver;
    }

    void update() {
        String string = "jdbc:db2j:" + this.getDatabaseName();
        if (this.connectionAttributes != null) {
            string = string + ";" + this.connectionAttributes;
        }
        this.jdbcurl = string;
    }
}

