/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.jdbc;

import db2j.bh.b;
import db2j.ca.m;
import db2j.p.j;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

class DB2jPooledConnection
implements PooledConnection,
m {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private Vector eventListener;
    protected b realConnection;
    protected int defaultIsolationLevel;
    private boolean defaultReadOnly;
    protected db2j.ca.b currentConnectionHandle;
    protected final DataSource dataSource;
    private final String username;
    private final String password;
    private boolean isActive;

    String getUsername() {
        if (this.username == null || this.username.equals("")) {
            return "APP";
        }
        return this.username;
    }

    String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.checkActive();
        this.closeCurrentConnectionHandle();
        if (this.realConnection == null) {
            this.openRealConnection();
        } else {
            this.resetRealConnection();
        }
        Connection connection = this.getNewCurrentConnectionHandle();
        return connection;
    }

    protected final void openRealConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection(this.username, this.password);
        this.realConnection = (b)connection;
        this.defaultIsolationLevel = connection.getTransactionIsolation();
        this.defaultReadOnly = connection.isReadOnly();
        if (this.currentConnectionHandle != null) {
            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
        }
    }

    protected final Connection getNewCurrentConnectionHandle() {
        db2j.ca.b b2 = this.currentConnectionHandle = this.realConnection.getLocalDriver().newBrokeredConnection(this);
        this.realConnection.setApplicationConnection(b2);
        return b2;
    }

    protected void closeCurrentConnectionHandle() throws SQLException {
        if (this.currentConnectionHandle != null) {
            Vector vector = this.eventListener;
            this.eventListener = null;
            try {
                this.currentConnectionHandle.close();
            }
            finally {
                Object var3_2 = null;
                this.eventListener = vector;
            }
            this.currentConnectionHandle = null;
        }
    }

    protected void resetRealConnection() throws SQLException {
        this.realConnection.rollback();
        this.realConnection.clearWarnings();
        if (this.realConnection.getTransactionIsolation() != this.defaultIsolationLevel) {
            Connection connection = this.realConnection.getApplicationConnection();
            this.realConnection.setApplicationConnection(this.realConnection);
            this.realConnection.setTransactionIsolation(this.defaultIsolationLevel);
            this.realConnection.setApplicationConnection(connection);
        }
        if (!this.realConnection.getAutoCommit()) {
            this.realConnection.setAutoCommit(true);
        }
        if (this.realConnection.isReadOnly() != this.defaultReadOnly) {
            this.realConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.realConnection.getHoldability() != 2) {
            this.realConnection.setHoldability(2);
        }
    }

    public synchronized void close() throws SQLException {
        block3: {
            if (!this.isActive) {
                return;
            }
            this.closeCurrentConnectionHandle();
            try {
                if (this.realConnection == null || this.realConnection.isClosed()) break block3;
                this.realConnection.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.realConnection = null;
                this.isActive = false;
                this.eventListener = null;
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.realConnection = null;
        this.isActive = false;
        this.eventListener = null;
    }

    public final synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.isActive) {
            return;
        }
        if (connectionEventListener == null) {
            return;
        }
        if (this.eventListener == null) {
            this.eventListener = new Vector();
        }
        this.eventListener.addElement(connectionEventListener);
    }

    public final synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            return;
        }
        if (this.eventListener != null) {
            this.eventListener.removeElement(connectionEventListener);
        }
    }

    public synchronized Connection getRealConnection() throws SQLException {
        this.checkActive();
        return this.realConnection;
    }

    public synchronized void notifyError(SQLException sQLException) {
        if (sQLException.getErrorCode() < 40000) {
            return;
        }
        if (this.eventListener != null && this.eventListener.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            Enumeration enumeration = this.eventListener.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    public synchronized void notifyClose() {
        if (this.eventListener != null && this.eventListener.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            Enumeration enumeration = this.eventListener.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionClosed(connectionEvent);
            }
        }
    }

    protected final void checkActive() throws SQLException {
        if (!this.isActive) {
            throw j.noCurrentConnection();
        }
    }

    public void notifyException(SQLException sQLException) {
        this.notifyError(sQLException);
    }

    public void checkAutoCommit(boolean bl2) throws SQLException {
    }

    public void checkSavepoint() throws SQLException {
    }

    public void checkRollback() throws SQLException {
    }

    public void checkCommit() throws SQLException {
    }

    public boolean closingConnection() throws SQLException {
        this.notifyClose();
        this.currentConnectionHandle = null;
        return false;
    }

    public Statement wrapStatement(Statement statement) throws SQLException {
        return statement;
    }

    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        return preparedStatement;
    }

    public CallableStatement wrapStatement(CallableStatement callableStatement, String string) throws SQLException {
        return callableStatement;
    }

    DB2jPooledConnection(DataSource dataSource, String string, String string2) throws SQLException {
        this.dataSource = dataSource;
        this.username = string;
        this.password = string2;
        this.isActive = true;
        this.openRealConnection();
    }
}

