/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.jdbc;

import com.ibm.db2j.jdbc.DB2jDataSource;
import com.ibm.db2j.jdbc.DB2jPooledConnection;
import com.ibm.db2j.jdbc.XAStatementControl;
import com.ibm.db2j.jdbc.XATransactionState;
import db2j.cr.b;
import db2j.cr.e;
import db2j.fn.a;
import db2j.l.cz;
import db2j.p.h;
import db2j.p.k;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

final class DB2jXAConnection
extends DB2jPooledConnection
implements XAConnection,
XAResource {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001,2002. All Rights Reserved.";
    final a ra;
    db2j.az.a currentXid;

    public final synchronized XAResource getXAResource() throws SQLException {
        this.checkActive();
        return this;
    }

    public final synchronized void start(Xid xid, int n2) throws XAException {
        this.checkXAActive();
        if (this.currentXid != null) {
            throw new XAException(-6);
        }
        db2j.az.a a2 = new db2j.az.a(xid);
        XATransactionState xATransactionState = this.getTransactionState(a2);
        switch (n2) {
            case 0: {
                if (xATransactionState != null) {
                    throw new XAException(-8);
                }
                try {
                    if (this.realConnection == null) {
                        this.openRealConnection();
                        if (this.currentConnectionHandle != null) {
                            this.currentConnectionHandle.setState(true);
                            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
                        }
                    } else {
                        if (!this.realConnection.transactionIsIdle()) {
                            throw new XAException(-9);
                        }
                        if (this.currentConnectionHandle != null) {
                            this.currentConnectionHandle.setState(true);
                        } else {
                            this.resetRealConnection();
                        }
                    }
                    this.realConnection.setAutoCommit(false);
                    this.realConnection.getLanguageConnection().getTransactionExecute().createXATransactionFromLocalTransaction(a2.getFormatId(), a2.getGlobalTransactionId(), a2.getBranchQualifier());
                }
                catch (db2j.em.b b2) {
                    throw DB2jXAConnection.wrapInXAException(b2);
                }
                catch (SQLException sQLException) {
                    throw DB2jXAConnection.wrapInXAException(sQLException);
                }
                if (this.ra.addConnection(a2, new XATransactionState(this.realConnection.getContextManager(), this.realConnection, this, a2))) break;
                throw new XAException(-8);
            }
            case 0x200000: 
            case 0x8000000: {
                if (xATransactionState == null) {
                    throw new XAException(-4);
                }
                xATransactionState.start(this, n2);
                if (xATransactionState.conn == this.realConnection) break;
                if (this.realConnection != null) {
                    if (!this.realConnection.transactionIsIdle()) {
                        throw new XAException(-9);
                    }
                    DB2jXAConnection.closeUnusedConnection(this.realConnection);
                }
                this.realConnection = xATransactionState.conn;
                if (this.currentConnectionHandle == null) break;
                try {
                    this.currentConnectionHandle.setState(false);
                    this.realConnection.setApplicationConnection(this.currentConnectionHandle);
                    break;
                }
                catch (SQLException sQLException) {
                    throw DB2jXAConnection.wrapInXAException(sQLException);
                }
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.currentXid = a2;
    }

    public final synchronized void end(Xid xid, int n2) throws XAException {
        XATransactionState xATransactionState;
        this.checkXAActive();
        db2j.az.a a2 = new db2j.az.a(xid);
        boolean bl2 = false;
        if (this.currentXid != null) {
            if (!this.currentXid.equals(a2)) {
                throw new XAException(-6);
            }
            bl2 = true;
        }
        if ((xATransactionState = this.getTransactionState(a2)) == null) {
            throw new XAException(-4);
        }
        boolean bl3 = xATransactionState.end(this, n2, bl2);
        if (bl2) {
            this.currentXid = null;
            this.realConnection = null;
        }
        if (bl3) {
            throw new XAException(xATransactionState.rollbackOnlyCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized int prepare(Xid xid) throws XAException {
        this.checkXAActive();
        db2j.az.a a2 = new db2j.az.a(xid);
        XATransactionState xATransactionState = this.getTransactionState(a2);
        if (xATransactionState == null) {
            db2j.az.b b2 = this.ra.getXAResourceManager();
            b b3 = b2.find(xid);
            if (b3 != null) throw new XAException(-6);
            throw new XAException(-4);
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            this.checkUserCredentials(xATransactionState.creatingResource);
            switch (xATransactionState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(xATransactionState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (xATransactionState.isPrepared) {
                throw new XAException(-6);
            }
            db2j.bh.b b4 = xATransactionState.conn;
            try {
                int n2 = b4.xa_prepare();
                if (n2 == 2) {
                    xATransactionState.isPrepared = true;
                    return 0;
                }
                this.returnConnectionToResource(xATransactionState, a2);
                return 3;
            }
            catch (SQLException sQLException) {
                throw DB2jXAConnection.wrapInXAException(sQLException);
            }
        }
    }

    public final synchronized void commit(Xid xid, boolean bl2) throws XAException {
        this.checkXAActive();
        db2j.az.a a2 = new db2j.az.a(xid);
        XATransactionState xATransactionState = this.getTransactionState(a2);
        if (xATransactionState == null) {
            db2j.az.b b2 = this.ra.getXAResourceManager();
            b b3 = b2.find(xid);
            if (b3 == null) {
                throw new XAException(-4);
            }
            e e2 = e.getFactory();
            b b4 = e2.getCurrentContextManager();
            e2.setCurrentContextManager(b3);
            try {
                try {
                    b2.commit(b3, a2, bl2);
                    b3.cleanupOnError(db2j.em.b.closeException());
                    Object var10_12 = null;
                    e2.setCurrentContextManager(b4);
                    return;
                }
                catch (db2j.em.b b5) {
                    b3.cleanupOnError(b5);
                    throw DB2jXAConnection.wrapInXAException(b5);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                e2.setCurrentContextManager(b4);
                throw throwable;
            }
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            this.checkUserCredentials(xATransactionState.creatingResource);
            switch (xATransactionState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(xATransactionState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (xATransactionState.isPrepared == bl2) {
                throw new XAException(-6);
            }
            db2j.bh.b b6 = xATransactionState.conn;
            try {
                try {
                    b6.xa_commit(bl2);
                }
                catch (SQLException sQLException) {
                    throw DB2jXAConnection.wrapInXAException(sQLException);
                }
                Object var9_17 = null;
                this.returnConnectionToResource(xATransactionState, a2);
            }
            catch (Throwable throwable) {
                Object var9_18 = null;
                this.returnConnectionToResource(xATransactionState, a2);
                throw throwable;
            }
        }
    }

    public final synchronized void rollback(Xid xid) throws XAException {
        this.checkXAActive();
        db2j.az.a a2 = new db2j.az.a(xid);
        XATransactionState xATransactionState = this.getTransactionState(a2);
        if (xATransactionState == null) {
            db2j.az.b b2 = this.ra.getXAResourceManager();
            b b3 = b2.find(xid);
            if (b3 == null) {
                throw new XAException(-4);
            }
            e e2 = e.getFactory();
            b b4 = e2.getCurrentContextManager();
            e2.setCurrentContextManager(b3);
            try {
                try {
                    b2.rollback(b3, a2);
                    b3.cleanupOnError(db2j.em.b.closeException());
                    Object var9_12 = null;
                    e2.setCurrentContextManager(b4);
                    return;
                }
                catch (db2j.em.b b5) {
                    b3.cleanupOnError(b5);
                    throw DB2jXAConnection.wrapInXAException(b5);
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                e2.setCurrentContextManager(b4);
                throw throwable;
            }
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            switch (xATransactionState.associationState) {
                case -1: 
                case 0: {
                    break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            this.checkUserCredentials(xATransactionState.creatingResource);
            try {
                try {
                    xATransactionState.conn.xa_rollback();
                }
                catch (SQLException sQLException) {
                    throw DB2jXAConnection.wrapInXAException(sQLException);
                }
                Object var7_10 = null;
                this.returnConnectionToResource(xATransactionState, a2);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.returnConnectionToResource(xATransactionState, a2);
                throw throwable;
            }
        }
    }

    public final synchronized Xid[] recover(int n2) throws XAException {
        this.checkXAActive();
        try {
            return this.ra.getXAResourceManager().recover(n2);
        }
        catch (db2j.em.b b2) {
            throw DB2jXAConnection.wrapInXAException(b2);
        }
    }

    public final synchronized void forget(Xid xid) throws XAException {
        this.checkXAActive();
        db2j.az.a a2 = new db2j.az.a(xid);
        XATransactionState xATransactionState = this.getTransactionState(a2);
        if (xATransactionState == null) {
            db2j.az.b b2 = this.ra.getXAResourceManager();
            b b3 = b2.find(xid);
            if (b3 == null) {
                throw new XAException(-4);
            }
            e e2 = e.getFactory();
            b b4 = e2.getCurrentContextManager();
            e2.setCurrentContextManager(b3);
            try {
                try {
                    b2.forget(b3, a2);
                    b3.cleanupOnError(db2j.em.b.closeException());
                    Object var9_8 = null;
                    e2.setCurrentContextManager(b4);
                    return;
                }
                catch (db2j.em.b b5) {
                    b3.cleanupOnError(b5);
                    throw DB2jXAConnection.wrapInXAException(b5);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                e2.setCurrentContextManager(b4);
                throw throwable;
            }
        }
        throw new XAException(xATransactionState.isPrepared ? -4 : -6);
    }

    public final synchronized boolean isSameRM(XAResource xAResource) throws XAException {
        this.checkXAActive();
        if (xAResource instanceof DB2jXAConnection) {
            return this.ra == ((DB2jXAConnection)xAResource).ra;
        }
        return false;
    }

    public int getTransactionTimeout() {
        return 0;
    }

    public boolean setTransactionTimeout(int n2) {
        return false;
    }

    public void checkAutoCommit(boolean bl2) throws SQLException {
        if (bl2 && this.currentXid != null) {
            throw k.generateCsSQLException("XJ056.S");
        }
        super.checkAutoCommit(bl2);
    }

    public void checkSavepoint() throws SQLException {
        if (this.currentXid != null) {
            throw k.generateCsSQLException("XJ058.S");
        }
        super.checkSavepoint();
    }

    public void checkRollback() throws SQLException {
        if (this.currentXid != null) {
            throw k.generateCsSQLException("XJ058.S");
        }
        super.checkRollback();
    }

    public void checkCommit() throws SQLException {
        if (this.currentXid != null) {
            throw k.generateCsSQLException("XJ057.S");
        }
        super.checkCommit();
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        if (this.currentXid == null) {
            connection = super.getConnection();
        } else {
            if (this.currentConnectionHandle != null) {
                throw k.generateCsSQLException("XJ059.S");
            }
            connection = this.getNewCurrentConnectionHandle();
        }
        this.currentConnectionHandle.syncState();
        return connection;
    }

    public Statement wrapStatement(Statement statement) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, statement);
        return xAStatementControl.applicationStatement;
    }

    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, preparedStatement, string, object);
        return (PreparedStatement)((Object)xAStatementControl.applicationStatement);
    }

    public CallableStatement wrapStatement(CallableStatement callableStatement, String string) throws SQLException {
        return callableStatement;
    }

    public Connection getRealConnection() throws SQLException {
        Connection connection = super.getRealConnection();
        if (connection != null) {
            return connection;
        }
        this.openRealConnection();
        this.currentConnectionHandle.setState(true);
        return this.realConnection;
    }

    private XATransactionState getTransactionState(db2j.az.a a2) {
        return (XATransactionState)this.ra.findConnection(a2);
    }

    private static XAException wrapInXAException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        String string2 = sQLException.getMessage();
        XAException xAException = string == null ? (string2 != null ? new XAException(string2) : new XAException(-3)) : (string.equals(db2j.em.b.getSQLStateFromIdentifier("XSAX1.S")) ? new XAException(-8) : (string.equals(db2j.em.b.getSQLStateFromIdentifier("XSAX0.S")) ? new XAException(105) : (string.equals("40001.T#T") ? new XAException(102) : (string.equals("40XL1.T#T") ? new XAException(106) : (string2 != null ? new XAException(string2) : new XAException(-3))))));
        if (cz.JDK_ID >= 4) {
            xAException.initCause(sQLException);
        }
        return xAException;
    }

    private static XAException wrapInXAException(db2j.em.b b2) {
        return DB2jXAConnection.wrapInXAException(h.wrapInSQLException(null, b2));
    }

    void removeXATransaction(db2j.az.a a2) {
        XATransactionState xATransactionState = (XATransactionState)this.ra.removeConnection(a2);
        if (xATransactionState != null) {
            xATransactionState.popMe();
        }
    }

    private void returnConnectionToResource(XATransactionState xATransactionState, db2j.az.a a2) {
        this.removeXATransaction(a2);
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            xATransactionState.associationState = 3;
            xATransactionState.notifyAll();
            db2j.bh.b b2 = xATransactionState.conn;
            if (xATransactionState.creatingResource.realConnection == b2 || xATransactionState.creatingResource.realConnection == null) {
                xATransactionState.creatingResource.realConnection = b2;
                db2j.ca.b b3 = xATransactionState.creatingResource.currentConnectionHandle;
                b2.setApplicationConnection(b3);
                if (b3 != null) {
                    try {
                        b3.setState(true);
                    }
                    catch (SQLException sQLException) {
                        DB2jXAConnection.closeUnusedConnection(xATransactionState.conn);
                        xATransactionState.creatingResource.realConnection = null;
                    }
                }
                Object var4_7 = null;
                return;
            }
        }
        DB2jXAConnection.closeUnusedConnection(xATransactionState.conn);
    }

    private void checkXAActive() throws XAException {
        try {
            this.checkActive();
        }
        catch (SQLException sQLException) {
            throw DB2jXAConnection.wrapInXAException(sQLException);
        }
    }

    private void checkUserCredentials(DB2jXAConnection dB2jXAConnection) throws XAException {
        if (dB2jXAConnection == this) {
            return;
        }
        if (dB2jXAConnection.getPassword().equals(this.getPassword()) && dB2jXAConnection.getUsername().equals(this.getUsername())) {
            return;
        }
        throw new XAException(103);
    }

    private static void closeUnusedConnection(db2j.bh.b b2) {
        if (b2 != null) {
            try {
                b2.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    DB2jXAConnection(DB2jDataSource dB2jDataSource, a a2, String string, String string2) throws SQLException {
        super(dB2jDataSource, string, string2);
        this.ra = a2;
    }
}

