/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.jdbc;

import com.ibm.db2j.info.ProductGenusNames;
import com.ibm.db2j.info.ProductVersionHolder;
import db2j.ca.j;
import db2j.cr.b;
import db2j.cr.e;
import db2j.ej.c;
import db2j.l.ag;
import db2j.m.i;
import db2j.p.a;
import db2j.p.d;
import db2j.p.g;
import db2j.p.k;
import db2j.p.m;
import db2j.p.n;
import db2j.p.q;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class EmbeddedDriver
implements Driver,
db2j.ej.b {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};
    private boolean active;
    private Class antiGCDriverManager;
    private e contextServiceFactory;
    private db2j.bp.a authenticationService;
    private static /* synthetic */ Class class$Ljava$sql$DriverManager;

    public void boot(boolean bl2, Properties properties) throws db2j.em.b {
        this.contextServiceFactory = e.getFactory();
        this.active = true;
        try {
            DriverManager.registerDriver(this);
            this.antiGCDriverManager = class$Ljava$sql$DriverManager != null ? class$Ljava$sql$DriverManager : (class$Ljava$sql$DriverManager = EmbeddedDriver.class$("java.sql.DriverManager"));
        }
        catch (SQLException sQLException) {
            throw db2j.em.b.newException("XBM0N.D", sQLException);
        }
    }

    public void stop() {
        this.active = false;
        this.contextServiceFactory = null;
        try {
            DriverManager.deregisterDriver(this);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean acceptsURL(String string) {
        return this.active && (string.startsWith("jdbc:db2j:") || string.equals("jdbc:default:connection"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection connect(String string, Properties properties) throws SQLException {
        d d2;
        ag ag2;
        block18: {
            Connection connection;
            block17: {
                Connection connection2;
                block16: {
                    Connection connection3;
                    block15: {
                        d d3 = null;
                        if (!this.acceptsURL(string)) {
                            return null;
                        }
                        ag2 = this.getAttributes(string, properties);
                        properties = null;
                        try {
                            boolean bl2 = Boolean.valueOf(ag2.getProperty("shutdown"));
                            boolean bl3 = string.equals("jdbc:default:connection");
                            if (bl3) {
                                j j2 = this.getConnectionContext();
                                if (j2 != null) {
                                    d3 = (d)j2.getLocalConnection();
                                    if (d3 != null) {
                                        if (bl2) {
                                            try {
                                                EmbeddedDriver.shutdownDatabase(d3);
                                            }
                                            catch (db2j.em.b b2) {
                                                throw d3.handleException(b2);
                                            }
                                        }
                                        if (d3.isClosed()) {
                                            throw k.noCurrentConnection();
                                        }
                                    }
                                    Connection connection4 = j2.getProxyConnection();
                                    Object var6_15 = null;
                                    ag2.clearDefaults();
                                    return connection4;
                                }
                                db2j.er.e e2 = this.getCurrentLanguageContext();
                                if (e2 != null) {
                                    db2j.er.b b3 = e2.getLanguageConnectionFactory();
                                    String string2 = "jdbc:db2j:" + c.getMonitor().getServiceName(b3);
                                    d3 = this.getNewLocalConnection(string2, e2);
                                    connection3 = this.getNewProxyConnection(d3);
                                    break block15;
                                }
                                connection2 = null;
                                break block16;
                            }
                            if (bl2 && EmbeddedDriver.getDatabaseName(string, ag2).length() == 0) {
                                if (this.getAuthenticationService() == null) {
                                    throw k.generateCsSQLException("08004", db2j.dd.c.getTextMessage("A001"));
                                }
                                if (!this.getAuthenticationService().authenticate(null, ag2)) {
                                    throw k.generateCsSQLException("08004", db2j.dd.c.getTextMessage("A020"));
                                }
                                c.getMonitor().shutdown();
                                throw k.generateCsSQLException("XJ015.M");
                            }
                            d3 = this.getNewLocalConnection(string, ag2);
                            if (d3.isClosed()) {
                                connection = null;
                                break block17;
                            }
                            d2 = d3;
                            break block18;
                        }
                        catch (Throwable throwable) {
                            Object var6_20 = null;
                            ag2.clearDefaults();
                            throw throwable;
                        }
                    }
                    Object var6_16 = null;
                    ag2.clearDefaults();
                    return connection3;
                }
                Object var6_17 = null;
                ag2.clearDefaults();
                return connection2;
            }
            Object var6_18 = null;
            ag2.clearDefaults();
            return connection;
        }
        Object var6_19 = null;
        ag2.clearDefaults();
        return d2;
    }

    private db2j.er.e getCurrentLanguageContext() {
        b b2 = this.getCurrentContextManager();
        if (b2 == null) {
            return null;
        }
        return (db2j.er.e)b2.getContext("LanguageConnectionContext");
    }

    public int getMajorVersion() {
        ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(ProductGenusNames.DBMS);
        return productVersionHolder.getMajorVersion();
    }

    public int getMinorVersion() {
        ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(ProductGenusNames.DBMS);
        return productVersionHolder.getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected ag getAttributes(String string, Properties properties) throws SQLException {
        ag ag2 = new ag(properties);
        properties = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(61);
            if (n2 == -1) {
                throw k.generateCsSQLException("XJ028.C", string);
            }
            ((Hashtable)ag2).put(string2.substring(0, n2).trim(), string2.substring(n2 + 1).trim());
        }
        EmbeddedDriver.checkBoolean(ag2, "dataEncryption");
        EmbeddedDriver.checkBoolean(ag2, "create");
        EmbeddedDriver.checkBoolean(ag2, "createSource");
        EmbeddedDriver.checkBoolean(ag2, "convertToSource");
        EmbeddedDriver.checkBoolean(ag2, "shutdown");
        EmbeddedDriver.checkBoolean(ag2, "upgrade");
        EmbeddedDriver.checkBoolean(ag2, "unicode");
        return ag2;
    }

    private static void checkBoolean(Properties properties, String string) throws SQLException {
        String[] stringArray = new String[]{"true", "false"};
        EmbeddedDriver.checkEnumeration(properties, string, stringArray);
    }

    private static void checkEnumeration(Properties properties, String string, String[] stringArray) throws SQLException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equalsIgnoreCase(stringArray[n2])) {
                return;
            }
            ++n2;
        }
        String string3 = "{";
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (n3 > 0) {
                string3 = string3 + "|";
            }
            string3 = string3 + stringArray[n3];
            ++n3;
        }
        throw k.generateCsSQLException("XJ05B.C", string, string2, string3 + "}");
    }

    public static String getDatabaseName(String string, Properties properties) {
        if (string.equals("jdbc:default:connection")) {
            return "";
        }
        int n2 = string.indexOf(59);
        String string2 = n2 == -1 ? string.substring("jdbc:db2j:".length()) : string.substring("jdbc:db2j:".length(), n2);
        if (string2.length() == 0 && properties != null) {
            string2 = properties.getProperty("databaseName", string2);
        }
        string2 = string2.trim();
        return string2;
    }

    public final e getContextServiceFactory() {
        return this.contextServiceFactory;
    }

    public db2j.bp.a getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = (db2j.bp.a)c.findService("db2j.bp.a", "authentication");
        }
        return this.authenticationService;
    }

    protected d getNewLocalConnection(String string, Properties properties) throws SQLException {
        return new d(this, string, properties, null);
    }

    private j getConnectionContext() {
        b b2 = this.getCurrentContextManager();
        j j2 = null;
        if (b2 != null) {
            j2 = (j)((Object)b2.getContext("JDBC_ConnectionContext"));
        }
        return j2;
    }

    d getCurrentConnection() {
        j j2 = this.getConnectionContext();
        if (j2 != null) {
            return (d)j2.getLocalConnection();
        }
        return null;
    }

    private b getCurrentContextManager() {
        return this.getContextServiceFactory().getCurrentContextManager();
    }

    public boolean isActive() {
        return this.active;
    }

    public static void shutdownDatabase(d d2) throws db2j.em.b {
        db2j.em.b b2 = db2j.em.b.newException("08006.D", d2.getDBName());
        b2.setReport(1);
        throw b2;
    }

    public Connection getNewProxyConnection(d d2) {
        return new a(d2);
    }

    public d getNewLocalConnection(String string, db2j.er.e e2) throws SQLException {
        return new d(this, string, e2);
    }

    public db2j.ca.b newBrokeredConnection(db2j.ca.m m2) {
        return new db2j.ca.b(m2);
    }

    public Statement newLocalStatement(d d2, boolean bl2, int n2, int n3, int n4) {
        return new n(d2, bl2, n2, n3, n4);
    }

    public PreparedStatement newLocalPreparedStatement(d d2, String string, boolean bl2, int n2, int n3, int n4, int n5, int[] nArray, String[] stringArray) throws SQLException {
        return new q(d2, string, bl2, n2, n3, n4, n5, nArray, stringArray);
    }

    public CallableStatement newLocalCallableStatement(d d2, String string, int n2, int n3, int n4) throws SQLException {
        return new m(d2, string, n2, n3, n4);
    }

    public g newLocalDatabaseMetaData(d d2, String string) throws db2j.em.b, SQLException {
        return new g(d2, string);
    }

    public db2j.p.c newLocalResultSet(d d2, i i2, boolean bl2, n n2, boolean bl3) {
        return new db2j.p.c(d2, i2, bl2, n2, bl3, false);
    }

    public SQLException batchUpdateException(SQLException sQLException, int[] nArray) {
        return sQLException;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (properties != null && Boolean.valueOf(properties.getProperty("shutdown")).booleanValue()) {
            return new DriverPropertyInfo[0];
        }
        if (this.getCurrentConnection() != null) {
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{EmbeddedDriver.getShutdownOption()};
            return driverPropertyInfoArray;
        }
        String string2 = EmbeddedDriver.getDatabaseName(string, properties);
        ag ag2 = this.getAttributes(string, properties);
        properties = null;
        boolean bl2 = Boolean.valueOf(ag2.getProperty("dataEncryption"));
        String string3 = ag2.getProperty("bootPassword");
        if (string2.length() == 0 || (bl2 = string3 == null)) {
            String[][] stringArray = new String[][]{{"databaseName", "J004"}, {"createTargetFrom", "J015"}, {"encryptionProvider", "J016"}, {"encryptionAlgorithm", "J017"}, {"encryptionKeyLength", "J018"}, {"encryptionKey", "J019"}, {"locale", "J021"}, {"user", "J022"}, {"logDevice", "J025"}, {"stagePageSize", "J027"}};
            String[][] stringArray2 = new String[][]{{"shutdown", "J005"}, {"create", "J007"}, {"dataEncryption", "J010"}, {"createSource", "J011"}, {"convertToSource", "J012"}, {"upgrade", "J013"}, {"unicode", "J014"}};
            String[][] stringArray3 = new String[][]{{"bootPassword", "J020"}, {"password", "J023"}};
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length + stringArray2.length + stringArray3.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < stringArray.length) {
                driverPropertyInfoArray[n2] = new DriverPropertyInfo(stringArray[n3][0], ag2.getProperty(stringArray[n3][0]));
                driverPropertyInfoArray[n2].description = db2j.dd.c.getTextMessage(stringArray[n3][1]);
                ++n3;
                ++n2;
            }
            driverPropertyInfoArray[0].choices = c.getMonitor().getServiceList("com.ibm.db2j.database.Database");
            driverPropertyInfoArray[0].value = string2;
            n3 = 0;
            while (n3 < stringArray3.length) {
                driverPropertyInfoArray[n2] = new DriverPropertyInfo(stringArray3[n3][0], ag2.getProperty(stringArray3[n3][0]) == null ? "" : "****");
                driverPropertyInfoArray[n2].description = db2j.dd.c.getTextMessage(stringArray3[n3][1]);
                ++n3;
                ++n2;
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                driverPropertyInfoArray[n2] = new DriverPropertyInfo(stringArray2[n3][0], Boolean.valueOf(ag2 == null ? "" : ag2.getProperty(stringArray2[n3][0])).toString());
                driverPropertyInfoArray[n2].description = db2j.dd.c.getTextMessage(stringArray2[n3][1]);
                driverPropertyInfoArray[n2].choices = BOOLEAN_CHOICES;
                ++n3;
                ++n2;
            }
            return driverPropertyInfoArray;
        }
        return new DriverPropertyInfo[0];
    }

    private static DriverPropertyInfo getShutdownOption() {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("shutdown", "false");
        driverPropertyInfo.description = db2j.dd.c.getTextMessage("J005");
        driverPropertyInfo.choices = BOOLEAN_CHOICES;
        return driverPropertyInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

