/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools;

import com.ibm.db2j.jdbc.DB2jDriver;
import com.ibm.db2j.tools.ImportExportImpl.ControlFileReader;
import com.ibm.db2j.tools.ImportExportImpl.ControlFileReaderAbstract;
import com.ibm.db2j.tools.ImportExportImpl.ImportAbstract;
import com.ibm.db2j.tools.ImportExportImpl.ImportReadData;
import com.ibm.db2j.tools.ImportExportSQLException;
import db2j.l.bb;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

public class FileImport
extends ImportAbstract {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    public static final String INSERT_MODE_PROPERTY = "insertMode";
    private String inputFileName;
    private String controlFileName;

    public static void Import(Connection connection, String string, String string2) throws Exception {
        FileImport.Import(connection, string, string2, null, null);
    }

    public static void Import(Connection connection, String string, String string2, Properties properties) throws Exception {
        FileImport.Import(connection, string, string2, null, properties);
    }

    public static void Import(Connection connection, String string, String string2, String string3) throws Exception {
        FileImport.Import(connection, string, string2, string3, null);
    }

    public static void Import(Connection connection, String string, String string2, String string3, Properties properties) throws Exception {
        if (connection == null) {
            throw ImportExportSQLException.connectionNull();
        }
        if (string == null) {
            throw ImportExportSQLException.entityNameMissing();
        }
        if (string2 == null) {
            throw ImportExportSQLException.dataFileNull();
        }
        FileImport.makeInsertStatement(connection, string, string2, string3, properties);
    }

    public static void main(String[] stringArray) throws Exception {
        FileImport.ImportInit();
        if (!FileImport.validateArgumentCount(stringArray)) {
            return;
        }
        String string = stringArray.length == 3 ? null : stringArray[3];
        String string2 = stringArray[0];
        if (!FileImport.validateUrl(string2)) {
            return;
        }
        new DB2jDriver();
        Connection connection = DriverManager.getConnection(string2, "", "");
        Properties properties = new Properties();
        String string3 = System.getProperty(INSERT_MODE_PROPERTY, "bulkInsert");
        ((Hashtable)properties).put(INSERT_MODE_PROPERTY, string3);
        FileImport.makeInsertStatement(connection, stringArray[1], stringArray[2], string, properties);
        connection.close();
    }

    private static void makeInsertStatement(Connection connection, String string, String string2, String string3, Properties properties) throws Exception {
        String string4 = "bulkInsert";
        if (properties != null) {
            string4 = properties.getProperty(INSERT_MODE_PROPERTY, "bulkInsert");
        }
        String string5 = "INSERT INTO " + string + " PROPERTIES insertMode=" + string4 + " SELECT * FROM NEW com.ibm.db2j.tools.FileImport('" + string2;
        string5 = string3 == null ? string5 + "' ) AS a" : string5 + "','" + string3 + "' ) AS a";
        Statement statement = connection.createStatement();
        statement.executeUpdate(string5);
    }

    private static boolean validateArgumentCount(String[] stringArray) {
        if (stringArray.length < 3 || stringArray.length > 4) {
            bb.out.println(bb.getTextMessage("IE_usage_import"));
            return false;
        }
        return true;
    }

    private static boolean validateUrl(String string) {
        if (!string.startsWith("jdbc:db2j:")) {
            bb.out.println(bb.getTextMessage("IE_incorrect_connection_url_to_the_database", string));
            return false;
        }
        return true;
    }

    protected ControlFileReaderAbstract getControlFileReader() throws Exception {
        return new ControlFileReader(this.controlFileName, this.appUI);
    }

    protected boolean defaultControlFileReader() throws Exception {
        return this.controlFileName == null;
    }

    protected ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader);
    }

    protected static void ImportInit() {
        bb.init();
    }

    protected void ImportInitInstance() {
        this.appUI = new bb();
        this.appUI.initInstance();
    }

    public FileImport(String string) throws Exception {
        this(string, null);
    }

    public FileImport(String string, String string2) throws Exception {
        this.ImportInitInstance();
        if (string == null) {
            throw ImportExportSQLException.dataFileNull(this.appUI);
        }
        this.inputFileName = string;
        this.controlFileName = string2;
        try {
            this.doAllTheWork();
        }
        catch (Exception exception) {
            String string3 = this.errMessageStream != null && !this.errMessageStream.isSystemOut() ? this.appUI.getMessageInstance("IE_details_in_the_message_file") : "";
            this.appUI.getStreamWriter().println(this.appUI.getTextMessageInstance("IE_error_while_importing", string3));
            throw exception;
        }
    }
}

