/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ImportExportImpl;

import com.ibm.db2j.tools.ImportExportImpl.ControlFileReaderAbstract;
import com.ibm.db2j.tools.ImportExportSQLException;
import db2j.l.bb;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ControlFileReader
extends ControlFileReaderAbstract {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    static final String ESCAPE = "Escape";
    static final String DEFAULT_ESCAPE = "\\";
    static final String QUOTE = "Quote";
    static final String DEFAULT_QUOTE = "'";
    static final String COMMIT_COUNT = "CommitCount";
    static final String DEFAULT_COMMIT_COUNT = "0";
    static final String START_ROW = "StartRow";
    static final String DEFAULT_START_ROW = "1";
    static final String STOP_ROW = "StopRow";
    static final String DEFAULT_STOP_ROW = "0";
    protected String controlFileName;

    public Properties getCurrentProperties() throws Exception {
        if (this.currentProperties == null) {
            this.loadDefaultValues();
            if (this.controlFileName != null) {
                try {
                    URL uRL = new URL(this.controlFileName);
                    if (uRL.getProtocol().equals("file")) {
                        this.controlFileName = uRL.getFile();
                        throw new MalformedURLException();
                    }
                    InputStream inputStream = uRL.openStream();
                    this.currentProperties.load(inputStream);
                    inputStream.close();
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(this.controlFileName);
                    if (file.exists()) {
                        try {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            this.currentProperties.load(fileInputStream);
                            fileInputStream.close();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw ImportExportSQLException.controlFileNotFound(this.controlFileName, this.appUI);
                        }
                    }
                    throw ImportExportSQLException.controlFileNotFound(this.controlFileName, this.appUI);
                }
            }
        }
        return this.currentProperties;
    }

    public ControlFileReader(String string) throws Exception {
        this.controlFileName = string;
        this.appUI = bb.getAppUIInstance();
        this.getCurrentProperties();
        this.getMessageFileStream();
        if (this.getFieldSeparator().indexOf(this.getRecordSeparator()) != -1) {
            throw ImportExportSQLException.fieldAndRecordSeparatorsSubset(this.appUI);
        }
    }

    public ControlFileReader(String string, bb bb2) throws Exception {
        this.appUI = bb2;
        this.controlFileName = string;
        this.getCurrentProperties();
        this.getMessageFileStream();
        if (this.getFieldSeparator().indexOf(this.getRecordSeparator()) != -1) {
            throw ImportExportSQLException.fieldAndRecordSeparatorsSubset(bb2);
        }
    }
}

