/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ImportExportImpl;

import com.ibm.db2j.tools.ImportExportSQLException;
import db2j.l.bb;
import db2j.l.cd;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class ControlFileReaderAbstract {
    public static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    static final String FIELD_SEPARATOR = "FieldSeparator";
    static final String DEFAULT_FIELD_SEPARATOR = ",";
    static final String RECORD_SEPARATOR = "RecordSeparator";
    static final String DEFAULT_RECORD_SEPARATOR = System.getProperty("line.separator");
    static final String COLUMN_DEFINITION = "ColumnDefinition";
    static final String DEFAULT_COLUMN_DEFINITION = "FALSE";
    static final String NULL_STRING = "Null";
    static final String DEFAULT_NULL_STRING = "NULL";
    static final String FORMAT = "Format";
    static final String DEFAULT_FORMAT = "ASCII_DELIMITED";
    static final String DB2_DELIMITED_FORMAT = "DB2_DELIMITED";
    static final String ASCII_FIXED_FORMAT = "ASCII_FIXED";
    static final String FIELD_START_DELIMITER = "FieldStartDelimiter";
    static final String DEFAULT_FIELD_START_DELIMITER = "\"";
    static final String FIELD_END_DELIMITER = "FieldEndDelimiter";
    static final String DEFAULT_FIELD_END_DELIMITER = "\"";
    static final String COLUMN_WIDTHS = "ColumnWidths";
    static final String MESSAGE_FILE = "MessageFile";
    static final String DEFAULT_VERSION = "1";
    static final String VERSION = "Version";
    static final String NEWLINE = "\n";
    static final String COMMA = ",";
    static final String SPACE = " ";
    static final String TAB = "\t";
    static final String CR = "\r";
    static final String LF = "\n";
    static final String CRLF = "\r\n";
    static final String LFCR = "\n\r";
    static final String FF = "\f";
    static final String EMPTY_LINE = "\n\n";
    static final String SEMICOLON = ";";
    static final String DATA_CODESET = "DataCodeset";
    static final String DATA_LOCALE = "DataLocale";
    static final String DEFAULT_DATA_LOCALE = "None";
    static final String HAS_DELIMETER_AT_END = "HasDelimeterAtEnd";
    static final String INTERNAL_NONE = "None";
    static final String INTERNAL_TRUE = "True";
    static final String INTERNAL_FALSE = "False";
    static final String INTERNAL_TAB = "Tab";
    static final String INTERNAL_SPACE = "Space";
    static final String INTERNAL_CR = "CR";
    static final String INTERNAL_LF = "LF";
    static final String INTERNAL_CRLF = "CR-LF";
    static final String INTERNAL_LFCR = "LF-CR";
    static final String INTERNAL_COMMA = "Comma";
    static final String INTERNAL_SEMICOLON = "Semicolon";
    static final String INTERNAL_NEWLINE = "New Line";
    static final String INTERNAL_FF = "FF";
    static final String INTERNAL_EMPTY_LINE = "Empty line";
    protected Properties currentProperties = null;
    protected cd errMessageStream = null;
    protected bb appUI = null;

    public abstract Properties getCurrentProperties() throws Exception;

    public String getPropertyValue(String string) throws Exception {
        return this.getCurrentProperties().getProperty(string);
    }

    protected void loadDefaultValues() {
        this.currentProperties = new Properties();
        ((Hashtable)this.currentProperties).put(FIELD_SEPARATOR, ",");
        ((Hashtable)this.currentProperties).put(RECORD_SEPARATOR, DEFAULT_RECORD_SEPARATOR);
        ((Hashtable)this.currentProperties).put(COLUMN_DEFINITION, DEFAULT_COLUMN_DEFINITION);
        ((Hashtable)this.currentProperties).put(NULL_STRING, DEFAULT_NULL_STRING);
        ((Hashtable)this.currentProperties).put(FORMAT, DEFAULT_FORMAT);
        ((Hashtable)this.currentProperties).put(FIELD_START_DELIMITER, "\"");
        ((Hashtable)this.currentProperties).put(FIELD_END_DELIMITER, "\"");
        ((Hashtable)this.currentProperties).put(VERSION, DEFAULT_VERSION);
        String string = new InputStreamReader(System.in).getEncoding();
        ((Hashtable)this.currentProperties).put(DATA_CODESET, string);
        ((Hashtable)this.currentProperties).put(DATA_LOCALE, "None");
        ((Hashtable)this.currentProperties).put(HAS_DELIMETER_AT_END, INTERNAL_FALSE);
    }

    public String getCurrentVersion() throws Exception {
        return DEFAULT_VERSION;
    }

    public String getVersion() throws Exception {
        String string = this.getCurrentProperties().getProperty(VERSION);
        if (string == null) {
            throw ImportExportSQLException.versionInformationMissing(this.appUI);
        }
        return string;
    }

    public String getFormat() throws Exception {
        return this.getCurrentProperties().getProperty(FORMAT);
    }

    public int[] getColumnWidths() throws Exception {
        if (this.getFormat().equals(ASCII_FIXED_FORMAT)) {
            int[] nArray;
            String string = this.getCurrentProperties().getProperty(COLUMN_WIDTHS);
            int[] nArray2 = new int[10];
            int n2 = 0;
            if (string == null) {
                throw ImportExportSQLException.columnWidthsMissing(this.appUI);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                if (n2 == nArray2.length) {
                    nArray = new int[nArray2.length * 2];
                    System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                    nArray2 = nArray;
                }
                nArray2[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            nArray = new int[n2];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
            nArray2 = nArray;
            return nArray2;
        }
        return null;
    }

    public String getFieldSeparator() throws Exception {
        String string = this.getCurrentProperties().getProperty(FIELD_SEPARATOR);
        string = this.mapFromUserFriendlyFieldDelimiters(string);
        return string;
    }

    public String getFieldStartDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_START_DELIMITER);
    }

    public String getFieldEndDelimiter() throws Exception {
        return this.getCurrentProperties().getProperty(FIELD_END_DELIMITER);
    }

    public String getRecordSeparator() throws Exception {
        String string = this.getCurrentProperties().getProperty(RECORD_SEPARATOR);
        string = this.mapFromUserFriendlyRecordDelimiters(string);
        return string;
    }

    public boolean getHasDelimiterAtEnd() throws Exception {
        String string = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        string = this.mapFromUserMessagesToInternalFormat(string);
        return string.equals(INTERNAL_TRUE);
    }

    public String getHasDelimeterAtEndString() throws Exception {
        String string = this.getCurrentProperties().getProperty(HAS_DELIMETER_AT_END);
        string = this.mapFromUserMessagesToInternalFormat(string);
        return string;
    }

    public String getNullString() throws Exception {
        return this.getCurrentProperties().getProperty(NULL_STRING);
    }

    public cd getMessageFileStream() throws Exception {
        if (this.errMessageStream == null) {
            String string = this.getCurrentProperties().getProperty(MESSAGE_FILE);
            this.errMessageStream = string == null ? this.appUI.getStreamWriter() : new cd(new FileOutputStream(string, true));
        }
        return this.errMessageStream;
    }

    public String getColumnDefinition() throws Exception {
        return this.getCurrentProperties().getProperty(COLUMN_DEFINITION);
    }

    private String mapFromUserFriendlyFieldDelimiters(String string) {
        if (string.toUpperCase().equals(INTERNAL_TAB.toUpperCase())) {
            return TAB;
        }
        if (string.toUpperCase().equals(INTERNAL_SPACE.toUpperCase())) {
            return SPACE;
        }
        if (string.toUpperCase().equals(INTERNAL_CR.toUpperCase())) {
            return CR;
        }
        if (string.toUpperCase().equals(INTERNAL_LF.toUpperCase())) {
            return "\n";
        }
        if (string.toUpperCase().equals(INTERNAL_CRLF.toUpperCase())) {
            return CRLF;
        }
        if (string.toUpperCase().equals(INTERNAL_LFCR.toUpperCase())) {
            return LFCR;
        }
        if (string.toUpperCase().equals(INTERNAL_COMMA.toUpperCase())) {
            return ",";
        }
        if (string.toUpperCase().equals(INTERNAL_SEMICOLON.toUpperCase())) {
            return SEMICOLON;
        }
        string = this.commonToFieldAndRecordDelimiters(string, "\\n", '\n');
        string = this.commonToFieldAndRecordDelimiters(string, "\\t", '\t');
        string = this.commonToFieldAndRecordDelimiters(string, "\\r", '\r');
        string = this.commonToFieldAndRecordDelimiters(string, "\\f", '\f');
        return string;
    }

    private String commonToFieldAndRecordDelimiters(String string, String string2, char c2) {
        while (string.indexOf(string2) != -1) {
            int n2 = string.indexOf(string2);
            String string3 = string.substring(0, n2);
            String string4 = string.substring(n2 + 2);
            string = string3 + c2 + string4;
        }
        return string;
    }

    private String mapFromUserFriendlyRecordDelimiters(String string) {
        if (string.equals("\n")) {
            string = INTERNAL_NEWLINE;
        }
        if (string.toUpperCase().equals(INTERNAL_NEWLINE.toUpperCase())) {
            return "\n";
        }
        if (string.toUpperCase().equals(INTERNAL_CR.toUpperCase())) {
            return CR;
        }
        if (string.toUpperCase().equals(INTERNAL_LF.toUpperCase())) {
            return "\n";
        }
        if (string.toUpperCase().equals(INTERNAL_CRLF.toUpperCase())) {
            return CRLF;
        }
        if (string.toUpperCase().equals(INTERNAL_LFCR.toUpperCase())) {
            return LFCR;
        }
        if (string.toUpperCase().equals(INTERNAL_FF.toUpperCase())) {
            return FF;
        }
        if (string.toUpperCase().equals(INTERNAL_EMPTY_LINE.toUpperCase())) {
            return EMPTY_LINE;
        }
        string = this.commonToFieldAndRecordDelimiters(string, "\\n", '\n');
        string = this.commonToFieldAndRecordDelimiters(string, "\\t", '\t');
        string = this.commonToFieldAndRecordDelimiters(string, "\\r", '\r');
        string = this.commonToFieldAndRecordDelimiters(string, "\\f", '\f');
        return string;
    }

    public String getDataCodeset() throws Exception {
        return this.getCurrentProperties().getProperty(DATA_CODESET);
    }

    public String getDataLocale() throws Exception {
        return this.getCurrentProperties().getProperty(DATA_LOCALE);
    }

    public String mapFromUserMessagesToInternalFormat(String string) {
        if (string.equals(this.appUI.getTextMessageInstance("CV_None"))) {
            return "None";
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Tab"))) {
            return INTERNAL_TAB;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Spac"))) {
            return INTERNAL_SPACE;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Cr"))) {
            return INTERNAL_CR;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Lf"))) {
            return INTERNAL_LF;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_CrLf"))) {
            return INTERNAL_CRLF;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_LfCr"))) {
            return INTERNAL_LFCR;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Comm"))) {
            return INTERNAL_COMMA;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Semi"))) {
            return INTERNAL_SEMICOLON;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_NewLine"))) {
            return INTERNAL_NEWLINE;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Ff"))) {
            return INTERNAL_FF;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_EmptLine"))) {
            return INTERNAL_EMPTY_LINE;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_True"))) {
            return INTERNAL_TRUE;
        }
        if (string.equals(this.appUI.getTextMessageInstance("CV_Fals"))) {
            return INTERNAL_FALSE;
        }
        return string;
    }

    public String mapToUserMessagesFromInternalFormat(String string) {
        if (string.equals("None")) {
            return this.appUI.getTextMessageInstance("CV_None");
        }
        if (string.equals(INTERNAL_TAB)) {
            return this.appUI.getTextMessageInstance("CV_Tab");
        }
        if (string.equals(INTERNAL_SPACE)) {
            return this.appUI.getTextMessageInstance("CV_Spac");
        }
        if (string.equals(INTERNAL_CR)) {
            return this.appUI.getTextMessageInstance("CV_Cr");
        }
        if (string.equals(INTERNAL_LF)) {
            return this.appUI.getTextMessageInstance("CV_Lf");
        }
        if (string.equals(INTERNAL_CRLF)) {
            return this.appUI.getTextMessageInstance("CV_CrLf");
        }
        if (string.equals(INTERNAL_LFCR)) {
            return this.appUI.getTextMessageInstance("CV_LfCr");
        }
        if (string.equals(INTERNAL_COMMA)) {
            return this.appUI.getTextMessageInstance("CV_Comm");
        }
        if (string.equals(INTERNAL_SEMICOLON)) {
            return this.appUI.getTextMessageInstance("CV_Semi");
        }
        if (string.equals(INTERNAL_NEWLINE)) {
            return this.appUI.getTextMessageInstance("CV_NewLine");
        }
        if (string.equals(INTERNAL_FF)) {
            return this.appUI.getTextMessageInstance("CV_Ff");
        }
        if (string.equals(INTERNAL_EMPTY_LINE)) {
            return this.appUI.getTextMessageInstance("CV_EmptLine");
        }
        if (string.equals(INTERNAL_TRUE)) {
            return this.appUI.getTextMessageInstance("CV_True");
        }
        if (string.equals(INTERNAL_FALSE)) {
            return this.appUI.getTextMessageInstance("CV_Fals");
        }
        return string;
    }

    public bb getAppUIObject() {
        return this.appUI;
    }
}

