/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ImportExportImpl;

import com.ibm.db2j.tools.ImportExportImpl.ControlFileReaderAbstract;
import com.ibm.db2j.tools.ImportExportImpl.ExportWriteDataAbstract;
import com.ibm.db2j.tools.ImportExportSQLException;
import db2j.l.bb;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;

public class ExportWriteData
extends ExportWriteDataAbstract {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private String outputFileName;
    private FileOutputStream anOutputStream;
    private BufferedOutputStream aBufferedOutputStream;
    private DataOutputStream adStream;
    private OutputStreamWriter aStream;
    private bb appUI = null;

    private void openFile() throws Exception {
        try {
            URL uRL = new URL(this.outputFileName);
            this.outputFileName = uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.anOutputStream = new FileOutputStream(this.outputFileName);
        this.aBufferedOutputStream = new BufferedOutputStream(this.anOutputStream);
        this.adStream = new DataOutputStream(this.aBufferedOutputStream);
        this.aStream = new OutputStreamWriter((OutputStream)this.adStream, this.dataCodeset);
    }

    public void writeColumnDefinitionOptionally(String[] stringArray, String[] stringArray2) throws Exception {
        boolean bl2 = this.controlFileReader.getDataLocale().equals("None");
        if (this.columnDefinition.toUpperCase().equals("True".toUpperCase())) {
            String string = new String();
            int n2 = 0;
            while (n2 < stringArray.length) {
                string = n2 > 0 ? this.fieldSeparator : "";
                string = string + this.fieldStartDelimiter + stringArray[n2] + this.fieldStopDelimiter;
                if (!bl2) {
                    string = string + this.fieldSeparator + this.fieldStartDelimiter + stringArray2[n2] + this.fieldStopDelimiter;
                }
                this.aStream.write(string, 0, string.length());
                ++n2;
            }
            this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
        }
    }

    private void writeNextColumn(String string, boolean bl2) throws Exception {
        if (string != null) {
            if (this.format.equals("ASCII_DELIMITED") || !bl2) {
                this.aStream.write(this.fieldStartDelimiter, 0, this.fieldStartDelimiter.length());
            }
            this.aStream.write(string, 0, string.length());
            if (this.format.equals("ASCII_DELIMITED") || !bl2) {
                this.aStream.write(this.fieldStopDelimiter, 0, this.fieldStopDelimiter.length());
            }
        }
    }

    public void writeData(String[] stringArray, boolean[] blArray) throws Exception {
        if (this.format.equals("ASCII_DELIMITED") || this.format.equals("DB2_DELIMITED")) {
            this.writeNextColumn(stringArray[0], blArray[0]);
            int n2 = 1;
            while (n2 < stringArray.length) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
                this.writeNextColumn(stringArray[n2], blArray[n2]);
                ++n2;
            }
            if (this.hasDelimiterAtEnd) {
                this.aStream.write(this.fieldSeparator, 0, this.fieldSeparator.length());
            }
        } else if (this.format.equals("ASCII_FIXED")) {
            int n3 = 0;
            while (n3 < this.columnLengths.length) {
                String string = this.nullString;
                if (n3 < stringArray.length && stringArray[n3] != null) {
                    string = stringArray[n3];
                    string = this.columnLengths[n3] < stringArray[n3].length() ? stringArray[n3].substring(0, this.columnLengths[n3]) : stringArray[n3];
                }
                if (string.equals(this.nullString) && this.nullString.length() > this.columnLengths[n3]) {
                    throw ImportExportSQLException.nullStringGreaterThanColumnWidth(n3 + 1, this.appUI);
                }
                StringBuffer stringBuffer = new StringBuffer(string);
                if (string.length() < this.columnLengths[n3]) {
                    stringBuffer.ensureCapacity(this.columnLengths[n3]);
                }
                int n4 = stringBuffer.length();
                while (n4 < this.columnLengths[n3]) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                this.aStream.write(stringBuffer.toString(), 0, stringBuffer.toString().length());
                ++n3;
            }
        }
        this.aStream.write(this.recordSeparator, 0, this.recordSeparator.length());
    }

    public void noMoreRows() throws Exception {
        this.aStream.flush();
        this.adStream.flush();
        this.aBufferedOutputStream.flush();
        this.anOutputStream.close();
    }

    public ExportWriteData(String string, ControlFileReaderAbstract controlFileReaderAbstract) throws Exception {
        this.outputFileName = string;
        this.controlFileReader = controlFileReaderAbstract;
        this.appUI = controlFileReaderAbstract.getAppUIObject();
        this.loadPropertiesInfo();
        this.openFile();
    }
}

