/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ImportExportImpl;

import com.ibm.db2j.tools.ImportExportImpl.ControlFileReaderAbstract;
import com.ibm.db2j.tools.ImportExportImpl.ImportReadData;
import com.ibm.db2j.tools.ImportExportImpl.ImportResultSetMetaData;
import com.ibm.db2j.tools.ImportExportSQLException;
import com.ibm.db2j.vti.VTITemplate;
import db2j.l.bb;
import db2j.l.cd;
import db2j.l.cm;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public abstract class ImportAbstract
extends VTITemplate {
    public static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    protected ControlFileReaderAbstract controlFileReader;
    protected ImportReadData importReadData;
    protected cd errMessageStream;
    protected cm appData;
    protected bb appUI;
    protected String[] columnNames;
    protected int numberOfColumns;
    protected int[] columnWidths;
    protected String[] nextRow;
    protected ResultSetMetaData importResultSetMetaData;
    int wasNullFlag = -1;

    protected abstract ControlFileReaderAbstract getControlFileReader() throws Exception;

    protected abstract boolean defaultControlFileReader() throws Exception;

    protected abstract ImportReadData getImportReadData() throws Exception;

    protected void doAllTheWork() throws Exception {
        String string;
        String string2;
        this.controlFileReader = this.getControlFileReader();
        if (!this.defaultControlFileReader() && !(string2 = this.controlFileReader.getCurrentVersion()).equals(string = this.controlFileReader.getVersion())) {
            throw ImportExportSQLException.versionMisMatch(string, this.appUI);
        }
        this.errMessageStream = this.controlFileReader.getMessageFileStream();
        this.importReadData = this.getImportReadData();
        this.numberOfColumns = this.importReadData.getNumberOfColumns();
        this.columnWidths = this.controlFileReader.getColumnWidths();
        this.columnNames = new String[this.numberOfColumns];
        this.loadColumnNames();
        this.nextRow = new String[this.numberOfColumns];
        this.importResultSetMetaData = new ImportResultSetMetaData(this.numberOfColumns, this.columnNames, this.columnWidths);
    }

    protected void loadColumnNames() {
        int n2 = 1;
        while (n2 <= this.numberOfColumns) {
            this.columnNames[n2 - 1] = "COLUMN" + n2;
            ++n2;
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.importResultSetMetaData;
    }

    public int getRow() throws SQLException {
        return this.importReadData.getCurrentRowNumber();
    }

    public boolean next() throws SQLException {
        try {
            return this.importReadData.readNextRow(this.nextRow);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    public void close() throws SQLException {
        try {
            this.importReadData.closeStream();
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    public boolean wasNull() throws SQLException {
        if (this.wasNullFlag == -1) {
            throw ImportExportSQLException.wasNullError(this.appUI);
        }
        return this.wasNullFlag == 1;
    }

    public String getString(int n2) throws SQLException {
        if (n2 <= this.numberOfColumns) {
            String string = this.nextRow[n2 - 1];
            this.wasNullFlag = string == null ? 1 : 0;
            return string;
        }
        this.wasNullFlag = -1;
        throw ImportExportSQLException.invalidColumnNumber(this.numberOfColumns, this.appUI);
    }

    public String getString(String string) throws SQLException {
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            if (this.columnNames[n2].equals(string)) {
                this.wasNullFlag = this.nextRow[n2] == null ? 1 : 0;
                return this.nextRow[n2];
            }
            ++n2;
        }
        this.wasNullFlag = -1;
        throw ImportExportSQLException.invalidColumnName(string, this.appUI);
    }

    public int findColumn(String string) throws SQLException {
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            if (this.columnNames[n2].equals(string)) {
                return n2 + 1;
            }
            ++n2;
        }
        throw ImportExportSQLException.invalidColumnName(string, this.appUI);
    }
}

