/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ImportExportImpl;

import com.ibm.db2j.tools.ImportExportImpl.ControlFileReaderAbstract;
import com.ibm.db2j.tools.ImportExportImpl.ImportReadDataAbstract;
import com.ibm.db2j.tools.ImportExportSQLException;
import db2j.l.bb;
import db2j.l.cm;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class ImportReadData
extends ImportReadDataAbstract {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private static final int START_SIZE = 10240;
    static final int DEFAULT_FORMAT_CODE = 0;
    static final int ASCII_FIXED_FORMAT_CODE = 1;
    public static final int NoConversion = 0;
    public static final int NeedDateConversion = 1;
    public static final int NeedTimeConversion = 2;
    public static final int NeedTimeStampConversion = 3;
    public static final int NeedValueConversion = 4;
    private String inputFileName;
    private int[] columnWidths;
    private int rowWidth;
    private char[] tempString;
    private int numberOfCharsReadSoFar;
    private cm appData;
    private bb appUI;
    private InputStreamReader inputFileStreamReader;
    private InputStream inputStream;
    private BufferedReader bufferedReader;
    private char[] currentToken = new char[10240];
    private int currentTokenMaxSize = 10240;
    boolean foundStartDelimiter;
    int totalCharsSoFar;
    int positionOfNonWhiteSpaceCharInFront;
    int positionOfNonWhiteSpaceCharInBack;
    int lineNumber;
    int fieldStartDelimiterIndex;
    int fieldStopDelimiterIndex;
    int stopDelimiterPosition;
    boolean foundStartAndStopDelimiters;
    boolean streamOpenForReading;
    private int formatCode = 0;
    private boolean hasColumnDefinition;
    private char recordSeparatorChar0;
    private char fieldSeparatorChar0;
    private boolean recordSepStartNotWhite = true;
    private boolean fieldSepStartNotWhite = true;
    private boolean haveSep = true;

    protected void loadPropertiesInfo() throws Exception {
        super.loadPropertiesInfo();
        if (this.format.equals("ASCII_FIXED")) {
            this.formatCode = 1;
            this.columnWidths = this.controlFileReader.getColumnWidths();
            this.numberOfColumns = this.columnWidths.length;
            this.rowWidth = 0;
            int n2 = this.numberOfColumns - 1;
            while (n2 >= 0) {
                this.rowWidth += this.columnWidths[n2];
                --n2;
            }
            this.rowWidth += this.recordSeparator.length;
            this.tempString = new char[this.rowWidth];
        }
        if (this.recordSeparatorLength > 0) {
            this.recordSeparatorChar0 = this.recordSeparator[0];
            boolean bl2 = this.recordSepStartNotWhite = !Character.isWhitespace(this.recordSeparatorChar0);
        }
        if (this.fieldSeparatorLength > 0) {
            this.fieldSeparatorChar0 = this.fieldSeparator[0];
            this.fieldSepStartNotWhite = !Character.isWhitespace(this.fieldSeparatorChar0);
        }
    }

    protected void ignoreFirstRow() throws Exception {
        this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength);
    }

    protected void loadColumnTypes() throws Exception {
        this.bufferedReader.mark(31744);
        this.findNumberOfColumnsInARow();
        this.bufferedReader.reset();
        String[] stringArray = new String[this.numberOfColumns];
        this.readNextDelimitedRow(stringArray);
        this.columnTypes = new String[this.numberOfColumns / 2];
        this.columnConversions = new int[this.numberOfColumns / 2];
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            this.columnTypes[n2 / 2] = stringArray[n2 + 1];
            String string = this.columnTypes[n2 / 2];
            this.columnConversions[n2 / 2] = string.equals("DATE") ? 1 : (string.equals("TIME") ? 2 : (string.equals("TIMESTAMP") ? 3 : (string.equals("DECIMAL") || string.equals("DOUBLE PRECISION") || string.equals("BIGINT") || string.equals("REAL") || string.equals("NUMERIC") || string.equals("INT") || string.equals("SMALLINT") || string.equals("SMALLINT") || string.equals("TINYINT") ? 4 : 0)));
            n2 += 2;
        }
        this.bufferedReader.reset();
        this.numberOfColumns = 0;
    }

    private void openFile() throws Exception {
        try {
            try {
                URL uRL = new URL(this.inputFileName);
                if (uRL.getProtocol().equals("file")) {
                    this.inputFileName = uRL.getFile();
                    throw new MalformedURLException();
                }
                this.inputStream = uRL.openStream();
                this.inputFileStreamReader = null;
                this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, this.dataCodeset));
            }
            catch (MalformedURLException malformedURLException) {
                this.inputFileStreamReader = new InputStreamReader((InputStream)new FileInputStream(this.inputFileName), this.dataCodeset);
                this.inputStream = null;
                this.bufferedReader = new BufferedReader(this.inputFileStreamReader, 32768);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ImportExportSQLException.dataFileNotFound(this.inputFileName, this.appUI);
        }
        this.streamOpenForReading = true;
    }

    private void loadMetaData() throws Exception {
        this.openFile();
        if (this.columnDefinition.toUpperCase().equals("True".toUpperCase())) {
            this.hasColumnDefinition = true;
            if (!this.controlFileReader.getDataLocale().equals("None")) {
                this.loadColumnTypes();
            }
            this.ignoreFirstRow();
        }
        if (this.formatCode == 0) {
            this.findNumberOfColumnsInARow();
        }
        this.closeStream();
    }

    public void closeStream() throws Exception {
        if (this.streamOpenForReading) {
            this.bufferedReader.close();
            if (this.inputStream == null) {
                this.inputFileStreamReader.close();
            } else {
                this.inputStream.close();
            }
            this.streamOpenForReading = false;
        }
    }

    public int findNumberOfColumnsInARow() throws Exception {
        this.numberOfColumns = 1;
        while (!this.readTokensUntilEndOfRecord()) {
            ++this.numberOfColumns;
        }
        if (this.hasDelimiterAtEnd) {
            --this.numberOfColumns;
        }
        if (this.numberOfCharsReadSoFar == 0) {
            this.numberOfColumns = 0;
        }
        return this.numberOfColumns;
    }

    private void checkForWhiteSpaceInFront() {
        char c2;
        if (!(this.positionOfNonWhiteSpaceCharInFront + 1 != this.totalCharsSoFar || this.foundStartDelimiter || this.foundStartAndStopDelimiters || !Character.isWhitespace(c2 = this.currentToken[this.positionOfNonWhiteSpaceCharInFront]) || !this.recordSepStartNotWhite && c2 == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && c2 == this.fieldSeparatorChar0)) {
            ++this.positionOfNonWhiteSpaceCharInFront;
        }
    }

    private void checkForWhiteSpaceInBack() {
        boolean bl2 = true;
        this.positionOfNonWhiteSpaceCharInBack = 0;
        int n2 = this.totalCharsSoFar;
        while (n2 > this.stopDelimiterPosition && bl2) {
            char c2 = this.currentToken[n2];
            if (Character.isWhitespace(c2)) {
                if ((this.recordSepStartNotWhite || c2 != this.recordSeparatorChar0) && (this.fieldSepStartNotWhite || c2 != this.fieldSeparatorChar0)) {
                    ++this.positionOfNonWhiteSpaceCharInBack;
                }
            } else {
                bl2 = false;
            }
            --n2;
        }
    }

    public boolean readTokensUntilEndOfRecord() throws Exception {
        int n2;
        int n3 = 0;
        int n4 = 0;
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.foundStartDelimiter = false;
        this.foundStartAndStopDelimiters = false;
        this.numberOfCharsReadSoFar = 0;
        do {
            if ((n2 = this.bufferedReader.read()) == -1) {
                return true;
            }
            ++this.numberOfCharsReadSoFar;
            this.currentToken[this.totalCharsSoFar++] = (char)n2;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] cArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, cArray, 0, this.totalCharsSoFar);
                this.currentToken = cArray;
            }
            if ((n3 = this.lookForPassedSeparator(this.fieldSeparator, n3, this.fieldSeparatorLength, n2)) != -1) continue;
            return false;
        } while (this.foundStartDelimiter || (n4 = this.lookForPassedSeparator(this.recordSeparator, n4, this.recordSeparatorLength, n2)) != -1);
        return true;
    }

    private int lookForPassedSeparator(char[] cArray, int n2, int n3, int n4) {
        if (!this.foundStartDelimiter) {
            if (this.fieldStartDelimiterLength != 0 && !this.foundStartAndStopDelimiters && this.totalCharsSoFar != this.positionOfNonWhiteSpaceCharInFront && this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront <= this.fieldStartDelimiterLength) {
                if (n4 == this.fieldStartDelimiter[this.fieldStartDelimiterIndex]) {
                    ++this.fieldStartDelimiterIndex;
                    if (this.fieldStartDelimiterIndex == this.fieldStartDelimiterLength) {
                        this.foundStartDelimiter = true;
                        this.totalCharsSoFar = 0;
                        this.positionOfNonWhiteSpaceCharInFront = 0;
                        return 0;
                    }
                } else if (this.fieldStartDelimiterIndex > 0) {
                    this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStartDelimiterIndex, this.fieldStartDelimiter, this.fieldStartDelimiterLength);
                }
            }
            if (n4 == cArray[n2]) {
                if (++n2 == n3) {
                    this.totalCharsSoFar -= n3;
                    return -1;
                }
                return n2;
            }
            if (n2 > 0) {
                return this.reCheckRestOfTheCharacters(this.totalCharsSoFar - n2, cArray, n3);
            }
        } else {
            if (n4 == this.fieldStopDelimiter[this.fieldStopDelimiterIndex]) {
                ++this.fieldStopDelimiterIndex;
                if (this.fieldStopDelimiterIndex == this.fieldStopDelimiterLength) {
                    this.foundStartDelimiter = false;
                    this.totalCharsSoFar -= this.fieldStopDelimiterLength;
                    this.stopDelimiterPosition = this.totalCharsSoFar;
                    this.foundStartAndStopDelimiters = true;
                    return 0;
                }
                return 0;
            }
            if (this.fieldStopDelimiterIndex > 0) {
                this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStopDelimiterIndex, this.fieldStopDelimiter, this.fieldStopDelimiterLength);
                return 0;
            }
        }
        return 0;
    }

    private int reCheckRestOfTheCharacters(int n2, char[] cArray, int n3) {
        int n4 = 0;
        int n5 = n2;
        while (n5 < this.totalCharsSoFar) {
            n4 = this.currentToken[n5] == cArray[n4] ? ++n4 : 0;
            ++n5;
        }
        return n4;
    }

    public int getCurrentRowNumber() {
        return this.lineNumber;
    }

    public boolean readNextRow(String[] stringArray) throws Exception {
        boolean bl2;
        if (!this.streamOpenForReading) {
            this.openFile();
            if (this.hasColumnDefinition) {
                this.ignoreFirstRow();
            }
        }
        if (!(bl2 = this.formatCode == 0 ? this.readNextDelimitedRow(stringArray) : this.readNextFixedRow(stringArray)) || this.controlFileReader.getDataLocale().equals("None")) {
            return bl2;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.columnConversions[n2] != 0 && stringArray[n2] != null) {
                switch (this.columnConversions[n2]) {
                    case 1: {
                        stringArray[n2] = this.appData.getStringFromDate(stringArray[n2]);
                        break;
                    }
                    case 2: {
                        stringArray[n2] = this.appData.getStringFromTime(stringArray[n2]);
                        break;
                    }
                    case 3: {
                        stringArray[n2] = this.appData.getStringFromTimestamp(stringArray[n2]);
                        break;
                    }
                    case 4: {
                        stringArray[n2] = this.appData.getStringFromValue(stringArray[n2]);
                        break;
                    }
                }
            }
            ++n2;
        }
        return bl2;
    }

    private boolean readNextFixedRow(String[] stringArray) throws Exception {
        int n2 = 0;
        int n3 = 0;
        while ((n2 += this.bufferedReader.read(this.tempString, n2, this.rowWidth - n2)) < this.rowWidth) {
            if (n2 == n3 - 1) {
                if (n2 == -1) {
                    return false;
                }
                if (n3 != this.rowWidth - this.recordSeparator.length) {
                    throw ImportExportSQLException.unexpectedEndOfFile(this.lineNumber + 1, this.appUI);
                }
                this.haveSep = false;
                break;
            }
            n3 = n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numberOfColumns) {
            int n6 = this.columnWidths[n5];
            if (n6 == 0) {
                stringArray[n5] = null;
            } else {
                String string = new String(this.tempString, n4, n6);
                stringArray[n5] = string.trim().equals(this.nullString) ? null : string;
                n4 += n6;
            }
            ++n5;
        }
        if (this.haveSep) {
            n5 = this.recordSeparatorLength - 1;
            while (n5 >= 0) {
                if (this.tempString[n4 + n5] != this.recordSeparator[n5]) {
                    throw ImportExportSQLException.recordSeparatorMissing(this.lineNumber + 1, this.appUI);
                }
                --n5;
            }
        } else {
            this.haveSep = true;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean readNextDelimitedRow(String[] stringArray) throws Exception {
        int n2 = this.numberOfColumns - 1;
        if (n2 < 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!this.readNextToken(this.fieldSeparator, 0, this.fieldSeparatorLength)) {
                if (n3 == 0) {
                    return false;
                }
                throw ImportExportSQLException.unexpectedEndOfFile(this.lineNumber + 1, this.appUI);
            }
            if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
                int n4 = this.stopDelimiterPosition + 1;
                while (n4 < this.totalCharsSoFar) {
                    if (!Character.isWhitespace(this.currentToken[n4])) {
                        throw ImportExportSQLException.dataAfterStopDelimiter(this.lineNumber + 1, n3 + 1, this.appUI);
                    }
                    ++n4;
                }
                this.totalCharsSoFar = this.stopDelimiterPosition;
            }
            stringArray[n3] = this.totalCharsSoFar != -1 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
            ++n3;
        }
        if (!this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength)) {
            if (n2 == 0) {
                return false;
            }
            throw ImportExportSQLException.unexpectedEndOfFile(this.lineNumber + 1, this.appUI);
        }
        if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
            n3 = this.stopDelimiterPosition + 1;
            while (n3 < this.totalCharsSoFar) {
                if (!Character.isWhitespace(this.currentToken[n3])) {
                    throw ImportExportSQLException.dataAfterStopDelimiter(this.lineNumber + 1, this.numberOfColumns, this.appUI);
                }
                ++n3;
            }
            this.totalCharsSoFar = this.stopDelimiterPosition;
        }
        if (this.hasDelimiterAtEnd && this.fieldStopDelimiterLength <= 0) {
            --this.totalCharsSoFar;
        }
        if (this.totalCharsSoFar != -1) {
            if (!this.hasDelimiterAtEnd) {
                stringArray[n2] = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
            } else if (this.totalCharsSoFar == this.fieldSeparatorLength && this.isFieldSep(this.currentToken)) {
                String string = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
                stringArray[n2] = this.currentToken[this.totalCharsSoFar + 1] == this.fieldStopDelimiter[0] ? string : null;
            } else {
                stringArray[n2] = this.totalCharsSoFar > 0 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
            }
        } else {
            stringArray[n2] = null;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean isFieldSep(char[] cArray) {
        int n2 = 0;
        while (n2 < cArray.length && n2 < this.fieldSeparatorLength) {
            if (cArray[n2] != this.fieldSeparator[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean readNextToken(char[] cArray, int n2, int n3) throws Exception {
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.stopDelimiterPosition = 0;
        this.foundStartAndStopDelimiters = false;
        this.foundStartDelimiter = false;
        int n4;
        while ((n4 = this.bufferedReader.read()) != -1) {
            int n5;
            this.currentToken[this.totalCharsSoFar++] = (char)n4;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] cArray2 = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, cArray2, 0, this.totalCharsSoFar);
                this.currentToken = cArray2;
            }
            if ((n5 = this.lookForPassedSeparator(cArray, n2, n3, n4)) == -1) {
                if (!this.foundStartAndStopDelimiters) {
                    if (this.totalCharsSoFar == 0) {
                        this.totalCharsSoFar = -1;
                    } else {
                        this.checkForWhiteSpaceInBack();
                        this.totalCharsSoFar = this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront - this.positionOfNonWhiteSpaceCharInBack;
                    }
                }
                return true;
            }
            n2 = n5;
        }
        return false;
    }

    public ImportReadData(String string, ControlFileReaderAbstract controlFileReaderAbstract) throws Exception {
        this.inputFileName = string;
        this.controlFileReader = controlFileReaderAbstract;
        this.appUI = controlFileReaderAbstract.getAppUIObject();
        this.appData = new cm(this.controlFileReader.getDataLocale());
        this.loadPropertiesInfo();
        this.loadMetaData();
    }
}

