/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.SysInfo;

import db2j.dd.a;
import java.io.InputStream;
import java.io.PrintWriter;

public class ClasspathTester {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    public static final String ARG1 = "embedded";
    public static final String ARG4 = "RmiServer";
    public static final String ARG5 = "RmiClient";
    public static final String ARG6 = "utils";
    public static final String ARG7 = "cview";
    public static final String ARG8 = "sampleApp";
    public static final String ARG9 = "sync";
    public static final String ARG10 = "iif2ksync";
    public static final String MAINUSAGESTRING = "java com.ibm.db2j.tools.sysinfo -cp";
    public static final String USAGESTRINGPARTA = "java com.ibm.db2j.tools.sysinfo -cp [ [ embedded | RmiServer | RmiClient ][ utils] [ cview ] [ sampleApp ] [ sync ] [ iif2ksync ] [ ";
    public static final String USAGESTRINGPARTB = ".class ] ]";

    public static void useMe(String[] stringArray, PrintWriter printWriter) {
        int n2;
        PrintWriter printWriter2 = printWriter;
        if (printWriter2 == null) {
            printWriter2 = new PrintWriter(System.out);
        }
        if ((n2 = stringArray.length) == 1) {
            try {
                ClasspathTester.tryAllClasspaths(printWriter2);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                ClasspathTester.trySomeClasspaths(stringArray, printWriter2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void tryAllClasspaths(PrintWriter printWriter) throws Throwable {
        printWriter.println(a.getTextMessage("SIF08.B"));
        printWriter.println(a.getTextMessage("SIF08.C", "java com.ibm.db2j.tools.sysinfo -cp args"));
        StringBuffer stringBuffer = new StringBuffer(a.getTextMessage("SIF08.D") + ClasspathTester.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(ClasspathTester.crLf() + a.getTextMessage("SIF08.E") + ClasspathTester.crLf());
        ClasspathTester.tryCoreClasspath(stringBuffer, stringBuffer2);
        ClasspathTester.tryClientClasspath(stringBuffer, stringBuffer2);
        ClasspathTester.tryUtilsClasspath(stringBuffer, stringBuffer2);
        ClasspathTester.tryCviewClasspath(stringBuffer, stringBuffer2);
        ClasspathTester.trySampleAppClasspath(stringBuffer, stringBuffer2);
        ClasspathTester.trySyncSourceClasspath(stringBuffer, stringBuffer2);
        printWriter.println(stringBuffer.toString());
        if (!stringBuffer2.toString().equals(ClasspathTester.crLf() + a.getTextMessage("SIF08.E") + ClasspathTester.crLf())) {
            printWriter.println(stringBuffer2.toString());
        } else {
            printWriter.println(a.getTextMessage("SIF08.F"));
        }
        printWriter.flush();
    }

    public static void trySomeClasspaths(String[] stringArray, PrintWriter printWriter) throws Throwable {
        String string;
        StringBuffer stringBuffer = new StringBuffer(a.getTextMessage("SIF08.D") + ClasspathTester.crLf());
        StringBuffer stringBuffer2 = new StringBuffer(ClasspathTester.crLf() + a.getTextMessage("SIF08.E") + ClasspathTester.crLf());
        String string2 = ClasspathTester.lookForMainArg(stringArray, printWriter);
        printWriter.flush();
        if (string2.equals("")) {
            return;
        }
        printWriter.println(a.getTextMessage("SIF08.G", string2));
        if (string2.equals(ARG1)) {
            ClasspathTester.tryCoreClasspath(stringBuffer, stringBuffer2);
        }
        if (string2.equals(ARG4)) {
            ClasspathTester.tryCoreClasspath(stringBuffer, stringBuffer2);
        }
        if (string2.equals(ARG5)) {
            ClasspathTester.tryClientClasspath(stringBuffer, stringBuffer2);
        }
        if (ClasspathTester.argumentsContain(stringArray, ARG6)) {
            ClasspathTester.tryUtilsClasspath(stringBuffer, stringBuffer2);
        }
        if (ClasspathTester.argumentsContain(stringArray, ARG7)) {
            ClasspathTester.tryCviewClasspath(stringBuffer, stringBuffer2);
        }
        if (ClasspathTester.argumentsContain(stringArray, ARG8)) {
            ClasspathTester.trySampleAppClasspath(stringBuffer, stringBuffer2);
        }
        if (ClasspathTester.argumentsContain(stringArray, ARG9)) {
            ClasspathTester.trySyncSourceClasspath(stringBuffer, stringBuffer2);
        }
        if (ClasspathTester.argumentsContain(stringArray, ARG10)) {
            ClasspathTester.tryIif2kSyncClasspath(stringBuffer, stringBuffer2);
        }
        if (!(string = ClasspathTester.argumentMatches(stringArray, ".class")).equals("")) {
            ClasspathTester.tryMyClasspath(ClasspathTester.argumentMatches(stringArray, ".class"), a.getTextMessage("SIF08.H", string), stringBuffer, stringBuffer2);
        }
        printWriter.println(stringBuffer.toString());
        if (!stringBuffer2.toString().equals(ClasspathTester.crLf() + a.getTextMessage("SIF08.E") + ClasspathTester.crLf())) {
            printWriter.println(stringBuffer2.toString());
        } else {
            printWriter.println(a.getTextMessage("SIF08.I", string2));
        }
        printWriter.flush();
    }

    private static void tryCoreClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryMyClasspath("com.ibm.db2j.core.JDBCBoot", a.getTextMessage("SIF08.J", "db2j.jar"), stringBuffer, stringBuffer2);
        ClasspathTester.tryAsResource("com/ibm/db2j/info/license.properties", a.getTextMessage("SIF08.K"), stringBuffer, stringBuffer2);
    }

    private static void tryClientClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryAsResource("com/ibm/db2j/info/client.properties", a.getTextMessage("SIF08.L", "cloudclient.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryUtilsClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryMyClasspath("com.ibm.db2j.tools.ij", a.getTextMessage("SIF08.Q", "cloudutil.jar"), stringBuffer, stringBuffer2);
    }

    public static void tryCviewClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryMyClasspath("com.ibm.db2j.tools.cview", a.getTextMessage("SIF08.V", "cloudview.jar"), stringBuffer, stringBuffer2);
        ClasspathTester.tryMyClasspath("javax.swing.AbstractAction", a.getTextMessage("SIF08.R", "swingall.jar"), stringBuffer, stringBuffer2);
        ClasspathTester.tryMyClasspath("javax.help.HelpBroker", a.getTextMessage("SIF08.W", "jh.jar"), stringBuffer, stringBuffer2);
    }

    private static void trySampleAppClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryMyClasspath("JBMSTours.serializabletypes.City", a.getTextMessage("SIF08.S", "/tours"), stringBuffer, stringBuffer2);
    }

    private static void trySyncSourceClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryMyClasspath("com.ibm.db2j.synchronization.RowListVTI", a.getTextMessage("SIF08.T", "cloudsync.jar", "db2j.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryIif2kSyncClasspath(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        ClasspathTester.tryMyClasspath("com.ibm.db2j.lsa.LucidAdapter", a.getTextMessage("SIF08.X", "cloudpub.jar"), stringBuffer, stringBuffer2);
        ClasspathTester.tryMyClasspath("com.informix.jdbc.IfxDriver", a.getTextMessage("SIF08.Y", "ifxjdbc.jar"), stringBuffer, stringBuffer2);
    }

    private static void tryMyClasspath(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        try {
            Class.forName(string);
            stringBuffer.append(ClasspathTester.found(string, string2));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(ClasspathTester.notFound(string, string2));
        }
    }

    private static void tryAsResource(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Throwable {
        try {
            string = "/" + string;
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            inputStream.close();
            stringBuffer.append(ClasspathTester.found(string, string2));
        }
        catch (Throwable throwable) {
            stringBuffer2.append(ClasspathTester.notFound(string, string2));
        }
    }

    private static String found(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(ClasspathTester.crLf());
        stringBuffer.append("   " + string2);
        stringBuffer.append(ClasspathTester.crLf());
        stringBuffer.append(ClasspathTester.crLf());
        return stringBuffer.toString();
    }

    private static String notFound(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(ClasspathTester.crLf());
        stringBuffer.append("   " + string2);
        stringBuffer.append(ClasspathTester.crLf());
        stringBuffer.append("    " + a.getTextMessage("SIF08.U", string));
        stringBuffer.append(ClasspathTester.crLf());
        stringBuffer.append(ClasspathTester.crLf());
        return stringBuffer.toString();
    }

    private static String crLf() {
        return System.getProperty("line.separator");
    }

    private static String lookForMainArg(String[] stringArray, PrintWriter printWriter) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[5];
        stringArray2[0] = ARG1;
        stringArray2[1] = ARG4;
        stringArray2[2] = ARG5;
        int n3 = 0;
        String string = "";
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < 3) {
                if (stringArray[n4].equalsIgnoreCase(stringArray2[n5])) {
                    ++n3;
                    string = stringArray2[n5];
                }
                ++n5;
            }
            ++n4;
        }
        if (n3 > 1 || n3 < 1) {
            printWriter.println(a.getTextMessage("SIF08.A", USAGESTRINGPARTA, USAGESTRINGPARTB));
            return "";
        }
        return string;
    }

    private static boolean argumentsContain(String[] stringArray, String string) {
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3].equalsIgnoreCase(string)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static String argumentMatches(String[] stringArray, String string) {
        String string2 = "";
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3].endsWith(string)) {
                string2 = stringArray[n3].substring(0, stringArray[n3].length() - 6);
            }
            ++n3;
        }
        return string2;
    }
}

