/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.SysInfo;

import com.ibm.db2j.info.LocaleNames;
import com.ibm.db2j.info.ProductGenusNames;
import com.ibm.db2j.info.ProductVersionHolder;
import com.ibm.db2j.tools.SysInfo.ClasspathTester;
import com.ibm.db2j.tools.ZipInfo.ZipInfoProperties;
import db2j.ai.a;
import db2j.em.b;
import db2j.l.bb;
import db2j.l.bx;
import db2j.l.cd;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Properties;

public class Main {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private static final boolean NAG = false;
    public static boolean setPause = false;
    public static boolean setLicense = false;
    public static boolean cptester = false;
    public static final String sep = "------------------------------------------------------";
    public static final String javaSep = db2j.dd.a.getTextMessage("SIF01.L");
    public static final String jbmsSep = db2j.dd.a.getTextMessage("SIF01.M");
    public static final String licSep = db2j.dd.a.getTextMessage("SIF01.N");
    public static final String locSep = db2j.dd.a.getTextMessage("SIF01.P");
    public static final String curLoc = db2j.dd.a.getTextMessage("SIF01.T");
    protected static final String infoFile = "com/ibm/db2j/info/sysinfo.properties";
    protected static final String failureTag = db2j.dd.a.getTextMessage("SIF01.J");
    protected static ZipInfoProperties[] properties;
    protected static com.ibm.db2j.tools.ZipInfo.Main zipInfo;

    protected static void loadProperties() {
        if (zipInfo == null) {
            zipInfo = new com.ibm.db2j.tools.ZipInfo.Main();
        }
        properties = zipInfo.getAllInfo();
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        bb.init();
        try {
            object2 = new bx(System.in);
            object = new cd(System.out);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Unable to open AppStreamReader/Writer");
        }
        object2 = null;
        object = null;
        Locale locale = null;
        object2 = System.getProperty("user.language");
        object = System.getProperty("user.region");
        locale = new Locale((String)object2, (String)object);
        Locale.setDefault(locale);
        Main.parseArgs(stringArray);
        if (cptester) {
            Main.getClasspathInfo(stringArray, null);
        } else {
            Main.getMainInfo(null, setLicense, setPause);
        }
    }

    public static void getMainInfo(cd cd2, boolean bl2, boolean bl3) {
        if (cd2 == null) {
            try {
                cd2 = new cd(System.out);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        cd2.println(javaSep);
        Main.reportJavaInfo(cd2);
        cd2.println(jbmsSep);
        Main.reportCloudscape(cd2);
        try {
            Main.reportLicenseInfo(cd2);
        }
        catch (Exception exception) {
            cd2.println(db2j.dd.a.getTextMessage("SIF01.A"));
            cd2.println(db2j.dd.a.getTextMessage("SIF01.B"));
        }
        if (bl2) {
            cd2.println(licSep);
            Main.printLicenseFile(cd2);
        }
        cd2.println(sep);
        try {
            Main.reportLocales(cd2);
        }
        catch (Exception exception) {
            cd2.println(db2j.dd.a.getTextMessage("SIF01.Q"));
            cd2.println(db2j.dd.a.getTextMessage("SIF01.B"));
        }
        if (bl3) {
            Main.pause();
        }
    }

    public static void parseArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-pause")) {
                setPause = true;
            }
            if (stringArray[n2].equals("-l")) {
                setLicense = true;
            }
            if (stringArray[n2].equals("-cp")) {
                cptester = true;
            }
            ++n2;
        }
    }

    public static int getMajorVersion() {
        ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(ProductGenusNames.DBMS);
        return productVersionHolder.getMajorVersion();
    }

    public static int getMinorVersion() {
        ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(ProductGenusNames.DBMS);
        return productVersionHolder.getMinorVersion();
    }

    public static int getMaintenanceVersion() {
        ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(ProductGenusNames.DBMS);
        return productVersionHolder.getMaintVersion();
    }

    public static int getMaintVersion() {
        return Main.getMaintenanceVersion();
    }

    public static void pause() {
        try {
            System.out.print(db2j.dd.a.getTextMessage("SIF01.C"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getBuildNumber() {
        com.ibm.db2j.tools.ZipInfo.Main main = new com.ibm.db2j.tools.ZipInfo.Main();
        ZipInfoProperties[] zipInfoPropertiesArray = main.getAllInfo();
        if (zipInfoPropertiesArray != null) {
            return zipInfoPropertiesArray[0].getBuildNumber();
        }
        return -1;
    }

    public static void reportCloudscape(cd cd2) {
        cd cd3 = cd2;
        if (cd2 == null) {
            try {
                cd2 = new cd(System.out);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        com.ibm.db2j.tools.ZipInfo.Main main = new com.ibm.db2j.tools.ZipInfo.Main();
        ZipInfoProperties[] zipInfoPropertiesArray = main.getAllInfo();
        String string = "";
        if (zipInfoPropertiesArray != null) {
            int n2 = 0;
            while (n2 < zipInfoPropertiesArray.length) {
                String string2 = "";
                String string3 = zipInfoPropertiesArray[n2].getBeta();
                if (string3 != null && Boolean.valueOf(string3).booleanValue()) {
                    string2 = " <BETA> ";
                }
                String string4 = "[" + zipInfoPropertiesArray[n2].getLocation() + "] " + zipInfoPropertiesArray[n2].getVersionBuildInfo() + string;
                cd3.println(string4);
                ++n2;
            }
        } else {
            cd3.println(db2j.dd.a.getTextMessage("SIF01.D"));
        }
    }

    public static void reportLicenseInfo(cd cd2) throws b {
        cd cd3 = cd2;
        if (cd2 == null) {
            try {
                cd2 = new cd(System.out);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            a.verifyLicense();
            Properties properties = a.loadProperties();
            String string = properties.getProperty("db2j.license.type");
            if (string.equals("EVAL")) {
                String string2 = properties.getProperty("db2j.local.license.expiration.date");
                cd3.println(db2j.dd.a.getTextMessage("SIF01.E", string2));
            } else if (string.equals("DEV")) {
                cd3.println(db2j.dd.a.getTextMessage("SIF01.F"));
            }
        }
        catch (b b2) {
            String string = b2.toString();
            int n2 = string.indexOf(";");
            int n3 = string.indexOf(";", ++n2);
            cd3.println("[" + string.substring(n2, n3) + " ]");
            throw b2;
        }
        catch (NullPointerException nullPointerException) {
            cd3.println(db2j.dd.a.getTextMessage("SIF01.A"));
            cd3.println(db2j.dd.a.getTextMessage("SIF01.B"));
        }
    }

    public static void printLicenseFile(cd cd2) {
        cd cd3 = cd2;
        if (cd2 == null) {
            try {
                cd2 = new cd(System.out);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            String[] stringArray = a.toStringArray();
            int n2 = 0;
            while (n2 < stringArray.length) {
                cd3.println(stringArray[n2]);
                ++n2;
            }
        }
        catch (b b2) {
            cd3.println(db2j.dd.a.getTextMessage("SIF01.G", b2));
        }
    }

    public static void reportJavaInfo(cd cd2) {
        cd cd3 = cd2;
        if (cd2 == null) {
            try {
                cd3 = new cd(System.out);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        cd3.println(db2j.dd.a.getTextMessage("SIF02.A", Main.getJavaProperty("java.version")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.B", Main.getJavaProperty("java.vendor")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.C", Main.getJavaProperty("java.home")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.D", Main.getJavaProperty("java.class.path")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.E", Main.getJavaProperty("os.name")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.F", Main.getJavaProperty("os.arch")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.G", Main.getJavaProperty("os.version")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.H", Main.getJavaProperty("user.name")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.I", Main.getJavaProperty("user.home")));
        cd3.println(db2j.dd.a.getTextMessage("SIF02.J", Main.getJavaProperty("user.dir")));
    }

    protected static String getJavaProperty(String string) {
        String string2 = db2j.dd.a.getTextMessage("SIF01.H");
        try {
            String string3 = System.getProperty(string, string2);
            return string3;
        }
        catch (SecurityException securityException) {
            return db2j.dd.a.getTextMessage("SIF01.I", securityException);
        }
    }

    public static String getProductVersion() {
        return Main.getMajorVersion() + "." + Main.getMinorVersion() + "." + Main.getMaintenanceVersion();
    }

    public static void getClasspathInfo(String[] stringArray, cd cd2) {
        ClasspathTester.useMe(stringArray, cd2);
    }

    public static void reportLocales(cd cd2) {
        boolean bl2 = true;
        cd cd3 = cd2;
        if (cd2 == null) {
            try {
                cd2 = new cd(System.out);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        cd3.println(locSep);
        String[] stringArray = LocaleNames.knownLocales;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = "/com/ibm/db2j/info/locale" + stringArray[n3] + ".properties";
            Object object = new Object();
            try {
                InputStream inputStream = object.getClass().getResourceAsStream(string);
                if (inputStream != null) {
                    Properties properties = new Properties();
                    try {
                        properties.load(inputStream);
                        if (bl2) {
                            Locale locale = null;
                            locale = Locale.getDefault();
                            cd3.println(db2j.dd.a.getTextMessage("SIF01.T") + "  [" + locale.getDisplayLanguage() + "/" + locale.getDisplayCountry() + " [" + locale + "]]");
                            bl2 = false;
                        }
                        cd3.println(db2j.dd.a.getTextMessage("SIF01.R", properties.getProperty("db2j.locale.external.name")));
                        cd3.println(db2j.dd.a.getTextMessage("SIF01.S", properties.getProperty("db2j.locale.version.major"), properties.getProperty("db2j.locale.version.minor"), properties.getProperty("db2j.locale.version.maint"), properties.getProperty("db2j.locale.build.number")));
                    }
                    catch (IOException iOException) {
                        cd3.println("Could not get locale properties from : " + inputStream);
                    }
                }
            }
            catch (Throwable throwable) {
                cd3.println("Could not load resource: " + string);
                cd3.println("Exception: " + throwable);
            }
            ++n3;
        }
        cd3.println(sep);
    }
}

