/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ZipInfo;

import com.ibm.db2j.info.ProductGenusNames;
import com.ibm.db2j.tools.ZipInfo.ZipInfoProperties;
import db2j.dd.a;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Main {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    static String[] infoNames = new String[]{"com/ibm/db2j/info/" + ProductGenusNames.DBMS + ".properties", "com/ibm/db2j/info/" + ProductGenusNames.TOOLS + ".properties", "com/ibm/db2j/info/" + ProductGenusNames.CLIENT + ".properties", "com/ibm/db2j/info/" + ProductGenusNames.PUB + ".properties", "com/ibm/db2j/drda/info/" + ProductGenusNames.NET + ".properties"};
    static boolean debug = false;

    static void debugMessage(String string) {
        if (debug) {
            System.out.println("DEBUG: " + string);
        }
    }

    public static void setDebug(boolean bl2) {
        debug = bl2;
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        ZipInfoProperties[] zipInfoPropertiesArray = main.getAllInfo();
        if (zipInfoPropertiesArray == null) {
            System.out.println(a.getTextMessage("SIF03.A"));
        } else {
            System.out.println(a.getTextMessage("SIF03.B"));
            System.out.println(" " + zipInfoPropertiesArray.length);
            int n2 = 0;
            while (n2 < zipInfoPropertiesArray.length) {
                System.out.println("[" + n2 + "]");
                zipInfoPropertiesArray[n2].list(System.out);
                ++n2;
            }
        }
    }

    public ZipInfoProperties getInfo(String string) {
        ZipInfoProperties[] zipInfoPropertiesArray = this.getAllInfo();
        if (zipInfoPropertiesArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < zipInfoPropertiesArray.length) {
            ZipInfoProperties zipInfoProperties = zipInfoPropertiesArray[n2];
            if (zipInfoProperties.whichZipFile().equals(string)) {
                return zipInfoProperties;
            }
            ++n2;
        }
        return null;
    }

    public ZipInfoProperties[] getAllInfo() {
        try {
            String string = System.getProperty("java.class.path");
            String[] stringArray = this.parseClasspath(string);
            Vector<ZipInfoProperties> vector = new Vector<ZipInfoProperties>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                ZipInfoProperties zipInfoProperties = this.checkForInfo(stringArray[n2]);
                if (zipInfoProperties != null) {
                    vector.addElement(zipInfoProperties);
                }
                ++n2;
            }
            if (vector.size() > 0) {
                Main.debugMessage("vector size was: " + vector.size());
                Object[] objectArray = new ZipInfoProperties[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            Main.debugMessage("Calling upon last resort");
            return this.loadZipFromResource();
        }
        catch (SecurityException securityException) {
            ZipInfoProperties[] zipInfoPropertiesArray = new ZipInfoProperties[]{new ZipInfoProperties()};
            zipInfoPropertiesArray[0].setLocation(a.getTextMessage("SIF03.C"));
            return zipInfoPropertiesArray;
        }
    }

    protected ZipInfoProperties[] loadZipFromResource() {
        Vector vector = new Vector();
        InputStream[] inputStreamArray = new InputStream[infoNames.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < infoNames.length) {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + infoNames[n3]);
            Main.debugMessage("is: " + inputStream);
            inputStreamArray[n3] = inputStream;
            if (inputStream != null) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        ZipInfoProperties[] zipInfoPropertiesArray = new ZipInfoProperties[n2];
        int n4 = 0;
        while (n4 < inputStreamArray.length) {
            if (inputStreamArray[n4] != null) {
                zipInfoPropertiesArray[--n2] = new ZipInfoProperties();
                try {
                    zipInfoPropertiesArray[n2].load(inputStreamArray[n4]);
                }
                catch (IOException iOException) {
                    zipInfoPropertiesArray[n2].setLocation(a.getTextMessage("SIF03.D", iOException));
                }
            }
            ++n4;
        }
        return zipInfoPropertiesArray;
    }

    String[] parseClasspath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    ZipInfoProperties checkForInfo(String string) {
        File file = new File(string);
        if (!file.exists()) {
            Main.debugMessage("classpath entry: " + string + " does not exist");
            return null;
        }
        if (file.isDirectory()) {
            ZipInfoProperties zipInfoProperties = this.checkDirectory(string);
            return zipInfoProperties;
        }
        if (file.isFile()) {
            ZipInfoProperties zipInfoProperties = this.checkFile(string);
            return zipInfoProperties;
        }
        Main.debugMessage("ERROR Unknown type of classpath entry " + string);
        Main.debugMessage("      Created a File object: " + file);
        return null;
    }

    ZipInfoProperties checkDirectory(String string) {
        Object object;
        boolean bl2 = false;
        File file = null;
        Main.debugMessage("checking <dir> " + string);
        int n2 = 0;
        while (n2 < infoNames.length) {
            object = infoNames[n2].replace('/', File.separatorChar);
            file = new File(string, (String)object);
            if (file.exists()) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl2 || file == null) {
            Main.debugMessage("returning null for:" + string);
            return null;
        }
        ZipInfoProperties zipInfoProperties = new ZipInfoProperties();
        try {
            object = new BufferedInputStream(new FileInputStream(file));
            zipInfoProperties.load((InputStream)object);
            zipInfoProperties.setLocation(new File(string).getCanonicalPath().replace('/', File.separatorChar) + " *expanded* ");
            Main.debugMessage("returning zipinfoproperty");
            Main.debugMessage("where build # is: " + zipInfoProperties.getBuildNumber());
            return zipInfoProperties;
        }
        catch (IOException iOException) {
            Main.debugMessage("IOException in checkDirectory");
            return null;
        }
    }

    public ZipInfoProperties checkFile(String string) {
        Main.debugMessage("checking " + string);
        if (string.indexOf("db2jcc") >= 0) {
            Class<?> clazz = null;
            Method method = null;
            Object var4_7 = null;
            Integer n2 = null;
            Integer n3 = null;
            Integer n4 = null;
            try {
                clazz = Class.forName("com.ibm.db2.jcc.DB2Driver");
                method = clazz.getMethod("getJCCBuildNumber", null);
                var4_7 = clazz.newInstance();
                n2 = (Integer)method.invoke(var4_7, null);
                method = clazz.getMethod("getMajorVersion", null);
                n3 = (Integer)method.invoke(var4_7, null);
                method = clazz.getMethod("getMinorVersion", null);
                n4 = (Integer)method.invoke(var4_7, null);
                ZipInfoProperties zipInfoProperties = new ZipInfoProperties();
                zipInfoProperties.setLocation(new File(string).getCanonicalPath().replace('/', File.separatorChar));
                ((Hashtable)zipInfoProperties).put("db2j.product.vendor", "IBM Corp.");
                ((Hashtable)zipInfoProperties).put("db2j.product.internal.name", "DRDA:jcc");
                ((Hashtable)zipInfoProperties).put("db2j.version.major", n3.toString());
                ((Hashtable)zipInfoProperties).put("db2j.version.minor", n4.toString());
                ((Hashtable)zipInfoProperties).put("db2j.version.maint", "0");
                ((Hashtable)zipInfoProperties).put("db2j.build.number", n2.toString());
                ((Hashtable)zipInfoProperties).put("db2j.version.beta", "false");
                zipInfoProperties.setBuild(n2.toString());
                zipInfoProperties.setMajor(n3.toString());
                zipInfoProperties.setMinor(n4.toString());
                zipInfoProperties.setMaint("0");
                zipInfoProperties.setBeta(false);
                zipInfoProperties.setVendor("IBM Corp.");
                zipInfoProperties.setZipNameString("db2jcc");
                zipInfoProperties.setInternalProductName("net:jcc");
                zipInfoProperties.setExternalProductName("DB2 Java Common Client");
                return zipInfoProperties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = null;
            int n5 = 0;
            while (n5 < infoNames.length) {
                zipEntry = zipFile.getEntry(infoNames[n5]);
                if (zipEntry != null) break;
                ++n5;
            }
            if (zipEntry == null) {
                Main.debugMessage(string + "had no entry in it");
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            if (bufferedInputStream == null) {
                Main.debugMessage("input stream could not be loaded. returning null for " + string);
                return null;
            }
            ZipInfoProperties zipInfoProperties = new ZipInfoProperties();
            zipInfoProperties.load(bufferedInputStream);
            zipInfoProperties.setLocation(new File(string).getCanonicalPath().replace('/', File.separatorChar));
            Main.debugMessage("returning zippropertyinfo for " + string);
            Main.debugMessage("with a build #: " + zipInfoProperties.getBuildNumber());
            return zipInfoProperties;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

