/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.tools.ZipInfo;

import com.ibm.db2j.info.ProductVersionHolder;
import com.ibm.db2j.info.PropertyNames;
import db2j.dd.a;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;

public class ZipInfoProperties
extends Properties {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    public static final int INVALID_VERSION = -1;
    protected String major = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String minor = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String maint = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String build = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String vendor = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String internalProduct = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String externalProduct = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected String zipNameString = PropertyNames.PRODUCT_INFO_UNAVAILABLE;
    protected boolean isBeta = false;
    protected String location = PropertyNames.PRODUCT_INFO_UNAVAILABLE;

    public String getVersionBuildInfo() {
        ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolder(this);
        if (productVersionHolder == null) {
            return a.getTextMessage("SIF04.C");
        }
        return productVersionHolder.getVersionBuildString();
    }

    public String getVersionNumberString() {
        int n2 = this.getMajorVersionNumber();
        int n3 = this.getMinorVersionNumber();
        int n4 = this.getMaintenanceVersionNumber();
        if (n2 == -1 || n3 == -1 || n4 == -1) {
            return PropertyNames.PRODUCT_INFO_UNAVAILABLE;
        }
        return this.getMajorVersionNumber() + "." + this.getMinorVersionNumber() + "." + this.getMaintenanceVersionNumber();
    }

    public String getBeta() {
        return this.getProperty("db2j.version.beta");
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public String getInternalName() {
        return this.getProperty("db2j.product.internal.name", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
    }

    public String getExternalName() {
        return this.getProperty("db2j.product.external.name", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
    }

    public String whichZipFile() {
        return this.getProperty("db2j.this.file.name", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
    }

    public String getLocation() {
        return this.location;
    }

    public int getMaintenanceVersionNumber() {
        String string = this.getProperty("db2j.version.maint", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getMinorVersionNumber() {
        String string = this.getProperty("db2j.version.minor", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getMajorVersionNumber() {
        String string = this.getProperty("db2j.version.major", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int getBuildNumber() {
        String string = this.getProperty("db2j.build.number", PropertyNames.PRODUCT_INFO_UNAVAILABLE);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setBeta(boolean bl2) {
        this.isBeta = bl2;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setMajor(String string) {
        this.major = string;
    }

    public void setMinor(String string) {
        this.minor = string;
    }

    public void setMaint(String string) {
        this.maint = string;
    }

    public void setBuild(String string) {
        this.build = string;
    }

    public void setExternalProductName(String string) {
        this.externalProduct = string;
    }

    public void setInternalProductName(String string) {
        this.internalProduct = string;
    }

    public void setZipNameString(String string) {
        this.zipNameString = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void save(OutputStream outputStream, String string) {
        ((Hashtable)this).put("db2j.product.internal.name", this.internalProduct);
        ((Hashtable)this).put("db2j.product.external.name", this.externalProduct);
        ((Hashtable)this).put("db2j.this.file.name", this.zipNameString);
        ((Hashtable)this).put("db2j.version.major", this.major);
        ((Hashtable)this).put("db2j.version.minor", this.minor);
        ((Hashtable)this).put("db2j.version.maint", this.maint);
        ((Hashtable)this).put("db2j.build.number", this.build);
        ((Hashtable)this).put("db2j.product.vendor", this.vendor);
        ((Hashtable)this).put("db2j.version.beta", "" + this.isBeta);
        super.save(outputStream, string);
    }
}

