/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.ui.utils.vti;

import com.ibm.db2j.ui.utils.vti.JarMetaData;
import com.ibm.db2j.vti.VTICosting;
import com.ibm.db2j.vti.VTIEnvironment;
import com.ibm.db2j.vti.VTITemplate;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarVTI
extends VTITemplate
implements VTICosting {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private ResultSetMetaData metaData;
    private String jarName;
    private ZipFile zip;
    private Enumeration rows;
    private boolean open;
    private ZipEntry entry;
    public double myEstimatedRowCount = 5000.0;
    public double myEstimatedCost = 439.0;
    public Integer rowcount = null;

    private static ResultSetMetaData getResultSetMetaData(String string) {
        return new JarMetaData();
    }

    public boolean next() throws SQLException {
        if (!this.rows.hasMoreElements()) {
            this.entry = null;
            return false;
        }
        this.entry = (ZipEntry)this.rows.nextElement();
        return true;
    }

    public String getString(int n2) throws SQLException {
        this.checkOnRow();
        switch (n2) {
            case 1: {
                return this.entry.getName();
            }
        }
        return super.getString(n2);
    }

    public boolean getBoolean(int n2) throws SQLException {
        this.checkOnRow();
        switch (n2) {
            case 2: {
                return this.entry.isDirectory();
            }
        }
        return super.getBoolean(n2);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkOnRow();
        switch (n2) {
            case 3: {
                return new Timestamp(this.entry.getTime());
            }
        }
        return super.getTimestamp(n2);
    }

    public long getLong(int n2) throws SQLException {
        this.checkOnRow();
        switch (n2) {
            case 3: {
                return this.entry.getTime();
            }
            case 4: {
                return this.entry.getSize();
            }
            case 5: {
                return this.entry.getCompressedSize();
            }
        }
        return super.getLong(n2);
    }

    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkOnRow();
        switch (n2) {
            case 6: {
                try {
                    return this.zip.getInputStream(this.entry);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            }
        }
        return super.getBinaryStream(n2);
    }

    public Object getObject(int n2) throws SQLException {
        switch (n2) {
            case 1: {
                return this.entry.getName();
            }
            case 2: {
                return this.entry.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return new Long(this.entry.getTime());
            }
            case 4: {
                return new Long(this.entry.getSize());
            }
            case 5: {
                return new Long(this.entry.getCompressedSize());
            }
            case 6: {
                return this.entry.getExtra();
            }
        }
        return super.getObject(n2);
    }

    public void close() {
        this.open = false;
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zip = null;
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    private void checkOnRow() throws SQLException {
        if (!this.open) {
            throw new SQLException("jar vti closed");
        }
        if (this.entry == null) {
            throw new SQLException("jar vti not on row");
        }
    }

    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) throws SQLException {
        if (this.rowcount != null) {
            return this.rowcount.doubleValue();
        }
        if (!this.open) {
            return this.myEstimatedRowCount;
        }
        int n2 = 0;
        while (this.rows.hasMoreElements()) {
            ++n2;
            this.rows.nextElement();
        }
        this.rows = this.zip.entries();
        this.open = true;
        return n2;
    }

    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) throws SQLException {
        if (!this.open) {
            return this.myEstimatedCost;
        }
        return 0.0879 * this.getEstimatedRowCount(vTIEnvironment);
    }

    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) throws SQLException {
        return true;
    }

    public int findColumn(String string) throws SQLException {
        int n2 = 0;
        while (n2 < JarMetaData.columnNames.length) {
            if (JarMetaData.columnNames[n2].equals(string)) {
                return n2;
            }
            ++n2;
        }
        throw new SQLException(string);
    }

    public JarVTI(String string) throws SQLException {
        this.metaData = JarVTI.getResultSetMetaData(string);
        if (this.metaData == null) {
            return;
        }
        this.jarName = string;
        if (string == null) {
            return;
        }
        try {
            this.zip = new ZipFile(string);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        this.rows = this.zip.entries();
        this.open = true;
    }
}

