/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.util;

public class BitUtil {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] set(byte[] byArray, int n2) {
        int n3;
        if (n2 >= 0 && (n3 = n2 >> 3) < byArray.length) {
            int n4 = 7 - n2 % 8;
            int n5 = n3;
            byArray[n5] = (byte)(byArray[n5] | 1 << n4);
            return byArray;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static byte[] clear(byte[] byArray, int n2) {
        int n3;
        if (n2 >= 0 && (n3 = n2 >> 3) < byArray.length) {
            int n4 = 7 - n2 % 8;
            int n5 = n3;
            byArray[n5] = (byte)(byArray[n5] & ~(1 << n4));
            return byArray;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static boolean get(byte[] byArray, int n2) {
        int n3;
        if (n2 >= 0 && (n3 = n2 >> 3) < byArray.length) {
            int n4 = 7 - n2 % 8;
            return (byArray[n3] & 1 << n4) != 0;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static boolean equals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (n3 != n5) {
            return false;
        }
        int n6 = 0;
        while (n6 < n3) {
            if (byArray[n6 + n2] != byArray2[n6 + n4]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            int n6 = (byArray[n5] & 0xF0) >>> 4;
            int n7 = byArray[n5] & 0xF;
            stringBuffer.append(hex_table[n6]);
            stringBuffer.append(hex_table[n7]);
            ++n5;
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string, int n2, int n3) {
        if (n3 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n3 / 2];
        int n4 = 0;
        int n5 = n2 + n3;
        int n6 = n2;
        while (n6 < n5) {
            int n7 = Character.digit(string.charAt(n6), 16);
            int n8 = Character.digit(string.charAt(n6 + 1), 16);
            if (n7 == -1 || n8 == -1) {
                return null;
            }
            byArray[n4++] = (byte)(n7 << 4 & 0xF0 | n8 & 0xF);
            n6 += 2;
        }
        return byArray;
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        int n2 = 0;
        while (n2 < byArray.length) {
            char c2;
            String string = Integer.toHexString(n2);
            int n3 = string.length();
            while (n3 < 8) {
                stringBuffer.append("0");
                ++n3;
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            n3 = 0;
            while (n3 < 16 && n2 + n3 < byArray.length) {
                byte by2 = byArray[n2 + n3];
                if (n3 % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c2 = (char)((by2 & 0xF0) >>> 4);
                byte by3 = (byte)(by2 & 0xF);
                stringBuffer.append(hex_table[c2]);
                stringBuffer.append(hex_table[by3]);
                ++n3;
            }
            stringBuffer.append("  ");
            n3 = 0;
            while (n3 < 16 && n2 + n3 < byArray.length) {
                c2 = (char)byArray[n2 + n3];
                if (Character.isLetterOrDigit(c2)) {
                    stringBuffer.append(String.valueOf(c2));
                } else {
                    stringBuffer.append(".");
                }
                ++n3;
            }
            stringBuffer.append("\n");
            n2 += 16;
        }
        return stringBuffer.toString();
    }
}

