/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2j.util;

import db2j.dd.c;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DriverUtil {
    private static final String copyrightNotice = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private static final String[][] protocolDrivers = new String[][]{{"jdbc:db2j:net:", "com.ibm.db2.jcc.DB2Driver"}, {"jdbc:db2j:", "com.ibm.db2j.jdbc.DB2jDriver"}, {"jdbc:informix-sqli:", "com.informix.jdbc.IfxDriver"}, {"jdbc:oracle:thin:", "oracle.jdbc.driver.OracleDriver"}};
    public static final String CORE_NAG_MESSAGE = c.getTextMessage("I026");

    public static void loadDriverIfKnown(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        int n2 = 0;
        while (n2 < protocolDrivers.length) {
            if (string.startsWith(protocolDrivers[n2][0])) {
                DriverUtil.loadDriver(protocolDrivers[n2][1]);
                break;
            }
            ++n2;
        }
    }

    public static void loadDriver(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(string).newInstance();
    }

    public static void embeddedShutdown() {
        Driver driver = null;
        try {
            driver = DriverManager.getDriver("jdbc:db2j:");
        }
        catch (Exception exception) {
            driver = null;
        }
        if (driver != null) {
            try {
                DriverManager.getConnection("jdbc:db2j:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private DriverUtil() {
    }
}

