/*
 * Decompiled with CFR 0.152.
 */
package db2j.h;

import db2j.ao.a;
import db2j.dh.g;
import db2j.dh.m;
import db2j.dh.o;
import db2j.em.b;
import db2j.l.s;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class i
extends db2j.ao.i {
    public static final String b = "(c) Copyright IBM Corp. 2001. All Rights Reserved.";
    private long c;
    private boolean d;

    public int getInt() throws b {
        if (this.c > Integer.MAX_VALUE || this.c < Integer.MIN_VALUE) {
            throw db2j.em.b.newException("22003", this, (Object)"INTEGER");
        }
        return (int)this.c;
    }

    public byte getByte() throws b {
        if (this.c > 127L || this.c < -128L) {
            throw db2j.em.b.newException("22003", this, (Object)"TINYINT");
        }
        return (byte)this.c;
    }

    public short getShort() throws b {
        if (this.c > 32767L || this.c < -32768L) {
            throw db2j.em.b.newException("22003", this, (Object)"SMALLINT");
        }
        return (short)this.c;
    }

    public long getLong() {
        return this.c;
    }

    public float getFloat() {
        return this.c;
    }

    public double getDouble() {
        return this.c;
    }

    public BigDecimal getBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.c);
    }

    public boolean getBoolean() {
        return this.c != 0L;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.c);
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.c);
    }

    public int getLength() {
        return 8;
    }

    public String getTypeName() {
        return "BIGINT";
    }

    public int getTypeFormatId() {
        return 84;
    }

    public boolean isNull() {
        return this.d;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.c);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.c = objectInput.readLong();
        this.d = false;
    }

    public void readExternalFromArray(s s2) throws IOException {
        this.c = s2.readLong();
        this.d = false;
    }

    public void restoreToNull() {
        this.c = 0L;
        this.d = true;
    }

    protected int typeCompare(m m2) throws b {
        long l2;
        long l3 = this.getLong();
        if (l3 == (l2 = m2.getLong())) {
            return 0;
        }
        if (l3 > l2) {
            return 1;
        }
        return -1;
    }

    public m getClone() {
        return new i(this.c, this.d);
    }

    public m getNewNull() {
        return new i();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) throws SQLException {
        this.c = resultSet.getLong(n2);
        this.d = this.c == 0L ? bl2 && resultSet.wasNull() : false;
    }

    public final void setInto(PreparedStatement preparedStatement, int n2) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n2, -5);
            return;
        }
        preparedStatement.setLong(n2, this.c);
    }

    public final void setInto(ResultSet resultSet, int n2) throws SQLException {
        resultSet.updateLong(n2, this.c);
    }

    public void setValue(String string) throws b {
        if (string == null) {
            this.c = 0L;
            this.d = true;
        } else {
            try {
                this.c = Long.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw db2j.em.b.newException("22018", "BIGINT", (Object)string);
            }
            this.d = false;
        }
    }

    public void setValue(long l2) {
        this.c = l2;
        this.d = false;
    }

    public void setValue(int n2) {
        this.c = n2;
        this.d = false;
    }

    public void setValue(short s2) {
        this.c = s2;
        this.d = false;
    }

    public void setValue(byte by2) {
        this.c = by2;
        this.d = false;
    }

    public void setValue(float f2) throws b {
        this.check(f2);
        if (f2 > 9.223372E18f || f2 < -9.223372E18f) {
            throw db2j.em.b.newException("22003", String.valueOf(f2), (Object)"BIGINT");
        }
        float f3 = (float)Math.floor(f2);
        this.c = (long)f3;
        this.d = false;
    }

    public void setValue(double d2) throws b {
        this.check(d2);
        if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
            throw db2j.em.b.newException("22003", String.valueOf(d2), (Object)"BIGINT");
        }
        double d3 = Math.floor(d2);
        this.c = (long)d3;
        this.d = false;
    }

    public void setValue(boolean bl2) {
        this.c = bl2 ? 1 : 0;
        this.d = false;
    }

    public void setValue(Object object) throws b {
        if (object == null) {
            this.setToNull();
        } else if (object instanceof Number) {
            this.setValue(((Number)object).longValue());
        } else {
            throw new ClassCastException(object.getClass().getName());
        }
    }

    public void setValue(m m2) throws b {
        if (m2.isNull()) {
            this.setToNull();
        } else {
            this.setValue(m2.getLong());
        }
    }

    public int typePrecedence() {
        return 60;
    }

    public o equals(m m2, m m3) throws b {
        return a.truthValue(m2, m3, m2.getLong() == m3.getLong());
    }

    public o notEquals(m m2, m m3) throws b {
        return a.truthValue(m2, m3, m2.getLong() != m3.getLong());
    }

    public o lessThan(m m2, m m3) throws b {
        return a.truthValue(m2, m3, m2.getLong() < m3.getLong());
    }

    public o greaterThan(m m2, m m3) throws b {
        return a.truthValue(m2, m3, m2.getLong() > m3.getLong());
    }

    public o lessOrEquals(m m2, m m3) throws b {
        return a.truthValue(m2, m3, m2.getLong() <= m3.getLong());
    }

    public o greaterOrEquals(m m2, m m3) throws b {
        return a.truthValue(m2, m3, m2.getLong() >= m3.getLong());
    }

    public g plus(g g2, g g3, g g4) throws b {
        if (g4 == null) {
            g4 = new i();
        }
        if (g2.isNull() || g3.isNull()) {
            g4.setToNull();
            return g4;
        }
        long l2 = g2.getLong();
        long l3 = g3.getLong();
        long l4 = l2 + l3;
        if (l2 < 0L == l3 < 0L && l2 < 0L != l4 < 0L) {
            throw db2j.em.b.newException("22003", String.valueOf(g2.getDouble() + g3.getDouble()), (Object)"BIGINT");
        }
        g4.setValue(l4);
        return g4;
    }

    public g minus(g g2, g g3, g g4) throws b {
        if (g4 == null) {
            g4 = new i();
        }
        if (g2.isNull() || g3.isNull()) {
            g4.setToNull();
            return g4;
        }
        long l2 = g2.getLong() - g3.getLong();
        if (g2.getLong() < 0L != g3.getLong() < 0L && g2.getLong() < 0L != l2 < 0L) {
            throw db2j.em.b.newException("22003", String.valueOf(g3.getDouble() - g2.getDouble()), (Object)"BIGINT");
        }
        g4.setValue(l2);
        return g4;
    }

    public g times(g g2, g g3, g g4) throws b {
        if (g4 == null) {
            g4 = new i();
        }
        if (g2.isNull() || g3.isNull()) {
            g4.setToNull();
            return g4;
        }
        long l2 = g2.getLong() * g3.getLong();
        if (g3.getLong() != 0L && g2.getLong() != l2 / g3.getLong()) {
            throw db2j.em.b.newException("22003", String.valueOf(g3.getDouble() * g2.getDouble()), (Object)"BIGINT");
        }
        g4.setValue(l2);
        return g4;
    }

    public g divide(g g2, g g3, g g4) throws b {
        if (g4 == null) {
            g4 = new i();
        }
        if (g2.isNull() || g3.isNull()) {
            g4.setToNull();
            return g4;
        }
        long l2 = g3.getLong();
        if (l2 == 0L) {
            throw db2j.em.b.newException("22012");
        }
        g4.setValue(g2.getLong() / l2);
        return g4;
    }

    public g mod(g g2, g g3, g g4) throws b {
        if (g4 == null) {
            g4 = new i();
        }
        if (g2.isNull() || g3.isNull()) {
            g4.setToNull();
            return g4;
        }
        long l2 = g3.getLong();
        if (l2 == 0L) {
            throw db2j.em.b.newException("22012");
        }
        g4.setValue(g2.getLong() % l2);
        return g4;
    }

    public g minus(g g2) throws b {
        if (g2 == null) {
            g2 = new i();
        }
        if (this.isNull()) {
            g2.setToNull();
            return g2;
        }
        long l2 = this.getLong();
        if (l2 == Long.MIN_VALUE) {
            throw db2j.em.b.newException("22003", String.valueOf(9.223372036854776E18), (Object)"BIGINT");
        }
        g2.setValue(-l2);
        return g2;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.c < 0L;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Long.toString(this.c);
    }

    public int hashCode() {
        return (int)(this.c ^ this.c >> 32);
    }

    public i() {
        this.d = true;
    }

    public i(long l2) {
        this.c = l2;
    }

    private i(long l2, boolean bl2) {
        this.c = l2;
        this.d = bl2;
    }

    public i(Long l2) {
        this.d = l2 == null;
        if (!this.d) {
            this.c = l2;
        }
    }
}

