/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperator;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.WEBDBKeyDatabase;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import java.util.Random;
import java.util.Vector;

public class CryptographicToken {
    private static boolean isInitialized = false;
    private static String moduleName = null;
    private static Vector tokenLabelList = null;
    private static boolean isAnyPasswordRequired = false;
    private String label = null;
    private boolean isPasswordRequired = false;
    private String password = null;
    private boolean isOpen = false;
    private Vector personalKeyLabelList = null;
    private Vector requestKeyLabelList = null;
    private Vector signerKeyLabelList = null;

    public static native int c_GetCryptoTokenLabelList(String var0);

    public static native boolean c_IsPasswordRequired(String var0, String var1);

    public native int c_BuildKeyLabelList(String var1, String var2, String var3);

    public native int c_ChangeKeyDbPwd(String var1, String var2, String var3, String var4);

    public native int c_ReceivePersonalCertificate(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public native boolean c_IsPersonalCertificateRenewal(String var1, String var2, String var3, int var4, byte[] var5);

    public native int c_RenewPersonalCertificate(String var1, String var2, String var3, int var4, byte[] var5);

    public native int c_DeleteKeyItemByLabel(String var1, String var2, String var3, String var4, boolean var5);

    public native KeyItem c_GetKeyItemByLabel(String var1, String var2, String var3, String var4, boolean var5);

    public native int c_ImportCertificate(String var1, String var2, String var3, String var4, String var5, String var6, int var7, byte[] var8, int var9, byte[] var10);

    public native int c_ImportPersonalCertificateRequest(String var1, String var2, String var3, String var4, int var5, byte[] var6, int var7, byte[] var8);

    public native int c_RecreatePersonalCertificateRequest(String var1, String var2, String var3, String var4, int var5, String var6);

    public native int c_CreateSelfSignedCertificate(String var1, String var2, String var3, int var4, String var5, int var6, DNItem var7, int var8, int var9);

    public native int c_ExtractCertificate(String var1, String var2, String var3, String var4, String var5, boolean var6);

    public native int c_CreatePersonalCertificateRequest(String var1, String var2, String var3, String var4, int var5, DNItem var6, int var7, String var8);

    public native int c_ExtractPersonalCertificateRequest(String var1, String var2, String var3, String var4, String var5);

    public native int c_AddSignerCertificate(String var1, String var2, String var3, String var4, String var5, boolean var6);

    public static void init() throws KMException {
        isInitialized = false;
        moduleName = null;
        tokenLabelList = null;
        isAnyPasswordRequired = false;
        if (!isInitialized) {
            moduleName = KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_MODULE");
            if (moduleName != null && moduleName.length() == 0) {
                moduleName = null;
            }
            if (moduleName != null && KMSystem.isJNIEnabled()) {
                tokenLabelList = new Vector();
                int n = CryptographicToken.c_GetCryptoTokenLabelList(moduleName);
                if (n == 0) {
                    int n2 = 0;
                    while (n2 < tokenLabelList.size()) {
                        if (CryptographicToken.c_IsPasswordRequired(moduleName, (String)tokenLabelList.elementAt(n2))) {
                            isAnyPasswordRequired = true;
                            break;
                        }
                        ++n2;
                    }
                    isInitialized = true;
                } else {
                    String string = CMSKeyDatabaseException.getErrKey(n);
                    KMException kMException = new KMException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_INITIALIZATION_FAILED"), string);
                    if (string.equals("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_LIBRARY_NOT_LOADED")) {
                        String string2 = KMSystem.getNLSErrString(string);
                        Object[] objectArray = new Object[]{moduleName};
                        String string3 = MessageFormat.format(string2, objectArray);
                        kMException.setNLSErrString(string3);
                    }
                    throw kMException;
                }
            }
        }
    }

    public static void refresh() throws KMException {
        tokenLabelList = new Vector();
        int n = CryptographicToken.c_GetCryptoTokenLabelList(moduleName);
        if (n != 0) {
            String string = CMSKeyDatabaseException.getErrKey(n);
            KMException kMException = new KMException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_INITIALIZATION_FAILED"), string);
            throw kMException;
        }
    }

    public static void init(String string) throws KMException {
        isInitialized = false;
        moduleName = null;
        tokenLabelList = null;
        isAnyPasswordRequired = false;
        if (!isInitialized && (moduleName = string) != null && KMSystem.isJNIEnabled()) {
            KMUtil.debugMsg("CryptographicToken::init(String) 00010, moduleName=" + string);
            tokenLabelList = new Vector();
            int n = CryptographicToken.c_GetCryptoTokenLabelList(moduleName);
            if (n == 0) {
                int n2 = 0;
                while (n2 < tokenLabelList.size()) {
                    if (CryptographicToken.c_IsPasswordRequired(moduleName, (String)tokenLabelList.elementAt(n2))) {
                        isAnyPasswordRequired = true;
                        break;
                    }
                    ++n2;
                }
                isInitialized = true;
            } else {
                String string2 = CMSKeyDatabaseException.getErrKey(n);
                KMException kMException = new KMException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_INITIALIZATION_FAILED"), string2);
                if (string2.equals("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_LIBRARY_NOT_LOADED")) {
                    String string3 = KMSystem.getNLSErrString(string2);
                    Object[] objectArray = new Object[]{moduleName};
                    String string4 = MessageFormat.format(string3, objectArray);
                    kMException.setNLSErrString(string4);
                }
                throw kMException;
            }
        }
    }

    public static String getCryptographicModuleName() {
        KMUtil.debugMsg("CryptographicToken::gegetCryptographicModuleName(), moduleName=" + moduleName);
        return moduleName;
    }

    public static void addTokenLabel(String string) {
        if (string != null) {
            if (tokenLabelList == null) {
                tokenLabelList = new Vector();
            }
            tokenLabelList.addElement(string);
        }
    }

    public static boolean exists() throws KMException {
        if (!isInitialized) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        return tokenLabelList != null && tokenLabelList.size() > 0;
    }

    public static boolean tokenLabelExists(String string) throws KMException {
        if (!isInitialized) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        boolean bl = false;
        if (CryptographicToken.exists()) {
            int n = 0;
            while (n < tokenLabelList.size()) {
                if (string.equals(tokenLabelList.elementAt(n))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public static Vector getTokenLabelList() throws KMException {
        if (!isInitialized) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        return tokenLabelList;
    }

    public static boolean isAnyPasswordRequired() throws KMException {
        if (!isInitialized) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        return isAnyPasswordRequired;
    }

    public CryptographicToken(String string) throws KMException {
        if (!isInitialized) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        this.label = string;
        if (!CryptographicToken.tokenLabelExists(string)) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_LABEL_NOT_EXIST";
            throw this.buildNewKMException(string3, string3);
        }
        this.isPasswordRequired = CryptographicToken.c_IsPasswordRequired(moduleName, this.label);
        this.password = null;
        this.isOpen = false;
        this.personalKeyLabelList = null;
        this.requestKeyLabelList = null;
        this.signerKeyLabelList = null;
    }

    public boolean isPasswordRequired() {
        return this.isPasswordRequired;
    }

    public boolean isOpen() {
        KMUtil.debugMsg("CryptographicToken::isOpen(), isOpen=" + this.isOpen);
        return this.isOpen;
    }

    public void open() throws KMException {
        this.open(null);
    }

    public void open(String string) throws KMException {
        if (this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_ALREADY_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        if (this.isPasswordRequired() && string == null) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_PASSWORD_REQUIRED";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        if (!this.isPasswordRequired() && string != null) {
            String string4 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_PASSWORD_NOT_REQUIRED";
            throw new KMException(KMSystem.getNLSErrString(string4), string4);
        }
        this.password = string;
        try {
            this.buildKeyLabelList();
        }
        catch (KMException kMException) {
            this.password = null;
            throw this.buildNewKMException("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_OPEN_FAILED", kMException.getErrCodeName());
        }
        this.isOpen = true;
    }

    private void buildKeyLabelList() throws KMException {
        this.personalKeyLabelList = new Vector();
        this.requestKeyLabelList = new Vector();
        this.signerKeyLabelList = new Vector();
        int n = this.c_BuildKeyLabelList(moduleName, this.label, this.password);
        if (n != 0) {
            String string = CMSKeyDatabaseException.getErrKey(n);
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
    }

    public void close() throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        this.password = null;
        this.personalKeyLabelList = null;
        this.requestKeyLabelList = null;
        this.signerKeyLabelList = null;
        this.isOpen = false;
    }

    public void changePassword(String string) throws KMException {
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        if (!this.isPasswordRequired()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_PASSWORD_NOT_REQUIRED";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        int n = this.c_ChangeKeyDbPwd(moduleName, this.label, this.password, string);
        if (n != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_PWDCHG", CMSKeyDatabaseException.getErrKey(n));
        }
        this.password = string;
    }

    public String getLabel() {
        return this.label;
    }

    public Vector getPersonalKeyLabelList() throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        return this.personalKeyLabelList;
    }

    public Vector getRequestKeyLabelList() throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        return this.requestKeyLabelList;
    }

    public Vector getSignerKeyLabelList() throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        return this.signerKeyLabelList;
    }

    public void receivePersonalCertificate(String string, boolean bl) throws KMException {
        this.receivePersonalCertificate((KeyDatabase)null, string, bl);
    }

    public void receivePersonalCertificate(KeyDatabase keyDatabase, String string, boolean bl) throws KMException {
        int n;
        KMUtil.debugMsg("CryptographicToken::receivePersonalCertificate(3 args) 0000");
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            KMUtil.debugMsg("CryptographicToken::receivePersonalCertificate(3 args) 9999-1");
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        if (keyDatabase != null && keyDatabase.getType() != 1) {
            String string3 = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            KMUtil.debugMsg("CryptographicToken::receivePersonalCertificate(3 args) 9999-2");
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        String string4 = null;
        String string5 = null;
        if (keyDatabase != null) {
            string4 = keyDatabase.getKeyDbFileName();
            string5 = keyDatabase.getKeyDbPwd();
        }
        if ((n = this.c_ReceivePersonalCertificate(moduleName, this.label, this.password, string4, string5, string, bl)) != 0) {
            if (n == 146) {
                KMUtil.debugMsg("CryptographicToken::receivePersonalCertificate(3 args) 9999-3");
                throw this.buildNewKMException("GSKKM_ERR_ADD_ROOTCA_FIRST_RECEIVE", CMSKeyDatabaseException.getErrKey(n));
            }
            KMUtil.debugMsg("CryptographicToken::receivePersonalCertificate(3 args) 9999-4");
            throw this.buildNewKMException("GSKKM_ERR_CMN_CERT_RECV", CMSKeyDatabaseException.getErrKey(n));
        }
        try {
            this.buildKeyLabelList();
        }
        catch (KMException kMException) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_CERT_RECV", kMException.getErrCodeName());
        }
        KMUtil.debugMsg("CryptographicToken::receivePersonalCertificate(3 args) 9999");
    }

    public void receivePersonalCertificate(KeyStoreManager keyStoreManager, String string, boolean bl) throws KMException {
        int n;
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        if (keyStoreManager != null && keyStoreManager.getType() != 1) {
            String string3 = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        String string4 = null;
        String string5 = null;
        if (keyStoreManager != null) {
            string4 = keyStoreManager.getKeyDbFileName();
            string5 = keyStoreManager.getKeyDbPwd();
        }
        if ((n = this.c_ReceivePersonalCertificate(moduleName, this.label, this.password, string4, string5, string, bl)) != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_CERT_RECV", CMSKeyDatabaseException.getErrKey(n));
        }
        try {
            this.buildKeyLabelList();
        }
        catch (KMException kMException) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_CERT_RECV", kMException.getErrCodeName());
        }
    }

    public boolean isPersonalCertificateRenewal(String string, boolean bl) throws KMException {
        KMUtil.debugMsg("CryptographicToken::isPersonalCertificateRenewal() 0000, inputCertFileName=" + string + ", isBase64Armored=" + bl);
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            KMUtil.debugMsg("CryptographicToken::isPersonalCertificateRenewal() 9999-1");
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        byte[] byArray = this.getCertBERData(string, bl);
        boolean bl2 = this.c_IsPersonalCertificateRenewal(moduleName, this.label, this.password, byArray.length, byArray);
        KMUtil.debugMsg("CryptographicToken::isPersonalCertificateRenewal() 9999, retval=" + bl2);
        return bl2;
    }

    private byte[] getCertBERData(String string, boolean bl) throws KMException {
        byte[] byArray = null;
        try {
            byArray = bl ? this.cryptoBase64DearmorFileToBuf(string) : this.cryptoFileToBuf(string);
        }
        catch (SSLightKeyDatabaseException sSLightKeyDatabaseException) {
            String string2 = "GSKKM_ERR_BASE64_INVALID_DATA";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        if (byArray == null || byArray.length <= 0) {
            String string3 = "GSKKM_ERR_CMN_INVALID_INPUT";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        return byArray;
    }

    public void renewPersonalCertificate(String string, boolean bl) throws KMException {
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        byte[] byArray = this.getCertBERData(string, bl);
        int n = this.c_RenewPersonalCertificate(moduleName, this.label, this.password, byArray.length, byArray);
        if (n != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_RENEW_CERT", CMSKeyDatabaseException.getErrKey(n));
        }
    }

    public void deleteKeyItemByLabel(String string) throws KMException {
        int n;
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        KeyItem keyItem = this.getKeyItemByLabel(string);
        boolean bl = false;
        if (this.requestKeyLabelList != null && this.requestKeyLabelList.contains(string)) {
            bl = true;
        }
        if ((n = this.c_DeleteKeyItemByLabel(moduleName, this.label, this.password, string, bl)) != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_KEY_DELETE", CMSKeyDatabaseException.getErrKey(n));
        }
        Vector vector = null;
        vector = keyItem.hasCertificate() ? (keyItem.hasPrivateKey() ? this.personalKeyLabelList : this.signerKeyLabelList) : this.requestKeyLabelList;
        this.deleteKeyLabel(vector, string);
    }

    public KeyItem getKeyItemByLabel(String string) throws KMException {
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        boolean bl = this.containsKeyLabel(this.requestKeyLabelList, string);
        KeyItem keyItem = null;
        keyItem = this.c_GetKeyItemByLabel(moduleName, this.label, this.password, string, bl);
        if (keyItem == null) {
            String string3 = "GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL";
            throw this.buildNewKMException(string3, string3);
        }
        return keyItem;
    }

    public void importKeyItems(KeyDatabase keyDatabase, String[] stringArray) throws KMException {
        this.importKeyItems(null, keyDatabase, stringArray);
    }

    public void importKeyItems(KeyStoreManager keyStoreManager, String[] stringArray) throws KMException {
        this.importKeyItems(null, keyStoreManager, stringArray);
    }

    public void importKeyItems(KeyDatabase keyDatabase, KeyDatabase keyDatabase2, String[] stringArray) throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyDatabase != null && keyDatabase.getType() != 1) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyDatabase2 == null || keyDatabase2.getType() == 0) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = null;
        String string2 = null;
        if (keyDatabase != null) {
            string = keyDatabase.getKeyDbFileName();
            string2 = keyDatabase.getKeyDbPwd();
        }
        String string3 = keyDatabase2.getKeyDbFileName();
        String string4 = keyDatabase2.getKeyDbPwd();
        int n = 0;
        while (n < stringArray.length) {
            KeyItem keyItem = ((KeyDatabaseOperator)((Object)keyDatabase2)).getKeyItemByLabel(stringArray[n]);
            if (keyItem.hasPrivateKey()) {
                PrivateKeyInfoItem privateKeyInfoItem = null;
                switch (keyDatabase2.getType()) {
                    case 1: {
                        privateKeyInfoItem = ((CMSKeyDatabase)keyDatabase2).decryptPrivateKey(keyItem.getEncryptedPrivateKeyInfoItem());
                        break;
                    }
                    case 2: {
                        privateKeyInfoItem = ((WEBDBKeyDatabase)keyDatabase2).decryptPrivateKey(keyItem.getEncryptedPrivateKeyInfoItem());
                        break;
                    }
                    default: {
                        String string5 = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
                        throw new KMException(KMSystem.getNLSErrString(string5), string5);
                    }
                }
                keyItem.setEncryptedPrivateKeyInfoItem(this.encryptPrivateKey(privateKeyInfoItem));
            }
            if (keyItem.hasCertificate()) {
                this.importCertificate(string, string2, keyItem);
            } else {
                this.importPersonalCertificateRequest(keyItem);
            }
            ++n;
        }
    }

    public void importKeyItems(KeyStoreManager keyStoreManager, KeyStoreManager keyStoreManager2, String[] stringArray) throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyStoreManager != null && keyStoreManager.getType() != 1) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyStoreManager2 == null || keyStoreManager2.getType() == 0) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = null;
        String string2 = null;
        if (keyStoreManager != null) {
            string = keyStoreManager.getKeyDbFileName();
            string2 = keyStoreManager.getKeyDbPwd();
        }
        String string3 = keyStoreManager2.getKeyDbFileName();
        String string4 = keyStoreManager2.getKeyDbPwd();
        int n = 0;
        while (n < stringArray.length) {
            KeyItem keyItem;
            block14: {
                keyItem = keyStoreManager2.getKeyItemByLabel(stringArray[n]);
                if (keyItem.hasPrivateKey()) {
                    try {
                        Key key = keyStoreManager2.getKeyStoreInstance().getKey(stringArray[n], keyStoreManager2.getKeyDbPwd().toCharArray());
                        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(key.getEncoded());
                        PrivateKeyInfoItem privateKeyInfoItem = new PrivateKeyInfoItem(privateKeyInfo.getEncoded());
                        keyItem.setEncryptedPrivateKeyInfoItem(this.encryptPrivateKey(privateKeyInfoItem));
                    }
                    catch (IOException iOException) {
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_KEYDB_NAME"));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
                    }
                    catch (KeyStoreException keyStoreException) {
                        if (keyStoreException.getMessage().equals("User canceled")) break block14;
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
                    }
                }
            }
            if (keyItem.hasCertificate()) {
                this.importCertificate(string, string2, keyItem);
            } else {
                this.importPersonalCertificateRequest(keyItem);
            }
            ++n;
        }
    }

    private void importCertificate(String string, String string2, KeyItem keyItem) throws KMException {
        int n;
        if (!this.isOpen()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        if (keyItem == null || !keyItem.hasCertificate()) {
            String string4 = "GSKKM_ERR_CMN_KEYDB_KEY_INSERT";
            throw new KMException(KMSystem.getNLSErrString(string4), string4);
        }
        String string5 = keyItem.getKeyLabel();
        CertificateItem certificateItem = (CertificateItem)keyItem.getCertificateChain().elementAt(0);
        int n2 = certificateItem.getLength();
        byte[] byArray = certificateItem.getEncoded();
        int n3 = 0;
        byte[] byArray2 = null;
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
        if (encryptedPrivateKeyInfoItem != null) {
            byArray2 = encryptedPrivateKeyInfoItem.getEncoded();
            n3 = encryptedPrivateKeyInfoItem.getLength();
        }
        if ((n = this.c_ImportCertificate(moduleName, this.label, this.password, string, string2, string5, n2, byArray, n3, byArray2)) != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_KEY_INSERT", CMSKeyDatabaseException.getErrKey(n));
        }
        if (n3 > 0) {
            this.addPersonalKeyLabel(string5);
        } else {
            this.addSignerKeyLabel(string5);
        }
    }

    private void importPersonalCertificateRequest(KeyItem keyItem) throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyItem == null) {
            return;
        }
        if (keyItem == null || keyItem.hasCertificate()) {
            String string = "GSKKM_ERR_CMN_KEYDB_KEY_INSERT";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        String string = keyItem.getKeyLabel();
        CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
        if (certificateRequestItem != null) {
            int n;
            int n2 = certificateRequestItem.getLength();
            byte[] byArray = certificateRequestItem.getEncoded();
            int n3 = 0;
            byte[] byArray2 = null;
            EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = keyItem.getEncryptedPrivateKeyInfoItem();
            if (encryptedPrivateKeyInfoItem != null) {
                byArray2 = encryptedPrivateKeyInfoItem.getEncoded();
                n3 = encryptedPrivateKeyInfoItem.getLength();
            }
            if ((n = this.c_ImportPersonalCertificateRequest(moduleName, this.label, this.password, string, n2, byArray, n3, byArray2)) != 0) {
                throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_KEY_INSERT", CMSKeyDatabaseException.getErrKey(n));
            }
            this.addRequestKeyLabel(string);
        }
    }

    public void importCertificate(KeyItem keyItem) throws KMException {
        this.importCertificate((KeyDatabase)null, keyItem);
    }

    public void importCertificate(KeyDatabase keyDatabase, KeyItem keyItem) throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyDatabase != null && keyDatabase.getType() != 1) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyItem == null || !keyItem.hasCertificate()) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        String string = null;
        String string2 = null;
        if (keyDatabase != null) {
            string = keyDatabase.getKeyDbFileName();
            string2 = keyDatabase.getKeyDbPwd();
        }
        this.importCertificate(string, string2, keyItem);
    }

    public void importCertificate(KeyStoreManager keyStoreManager, KeyItem keyItem) throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyStoreManager != null && keyStoreManager.getType() != 1) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        if (keyItem == null || !keyItem.hasCertificate()) {
            String string = "GSKKM_ERR_CMN_KEYDB_INVALID_TYPE";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        String string = null;
        String string2 = null;
        if (keyStoreManager != null) {
            string = keyStoreManager.getKeyDbFileName();
            string2 = keyStoreManager.getKeyDbPwd();
        }
        this.importCertificate(string, string2, keyItem);
    }

    public String resolveLabelConflict(KeyItem keyItem) throws KMException {
        String string;
        Object object;
        Object object2;
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        Vector<Object> vector = new Vector<Object>();
        if (this.personalKeyLabelList != null && this.personalKeyLabelList.size() > 0) {
            object2 = this.personalKeyLabelList.elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (object == null || ((String)object).length() <= 0) continue;
                vector.addElement(object);
            }
        }
        if (this.signerKeyLabelList != null && this.signerKeyLabelList.size() > 0) {
            object2 = this.signerKeyLabelList.elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (object == null || ((String)object).length() <= 0) continue;
                vector.addElement(object);
            }
        }
        if ((string = keyItem.getKeyLabel()) == null) {
            if (keyItem.hasCertificate() && (object = ((CertificateItem)(object2 = (CertificateItem)keyItem.getCertificateChain().elementAt(0))).getSubject()) != null) {
                string = ((DNItem)object).getCommonName();
            }
            if (string == null || string.length() == 0) {
                string = "Dummy Key Label_" + Integer.toString(Math.abs(new Random().nextInt()));
            }
        }
        if (vector != null && vector.contains(string)) {
            object2 = null;
            try {
                object2 = this.getKeyItemByLabel(string);
            }
            catch (KMException kMException) {
                object2 = null;
            }
            if (object2 != null && !keyItem.equalsCert((KeyItem)object2)) {
                int n = 0;
                while (vector.contains(string) && n < 1000) {
                    string = string + "_" + Integer.toString(new Random().nextInt());
                    ++n;
                }
            } else {
                string = null;
            }
        }
        return string;
    }

    public EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem privateKeyInfoItem) throws KMException {
        if (!this.isOpen()) {
            String string = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string), string);
        }
        EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
        try {
            String string = moduleName;
            encryptedPrivateKeyInfoItem = CMSKeyDatabase.encryptPrivateKey(privateKeyInfoItem, string);
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            throw new KMException(cMSKeyDatabaseException.getNLSErrString(), cMSKeyDatabaseException.getErrCodeName());
        }
        return encryptedPrivateKeyInfoItem;
    }

    public void recreatePersonalCertificateRequest(String string, int n, String string2) throws KMException {
        if (!this.isOpen()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        int n2 = this.c_RecreatePersonalCertificateRequest(moduleName, this.label, this.password, string, n, string2);
        if (n2 != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_RECREATE_CERTREQ", CMSKeyDatabaseException.getErrKey(n2));
        }
        this.addRequestKeyLabel(string);
    }

    public void createSelfSignedCertificate(int n, String string, int n2, DNItem dNItem, int n3, int n4) throws KMException {
        if (!this.isOpen()) {
            String string2 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string2), string2);
        }
        int n5 = this.c_CreateSelfSignedCertificate(moduleName, this.label, this.password, n - 1, string, n2, dNItem, n3, n4);
        if (n5 != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT", CMSKeyDatabaseException.getErrKey(n5));
        }
        this.addPersonalKeyLabel(string);
    }

    public void extractCertificate(String string, String string2, boolean bl) throws KMException {
        if (!this.isOpen()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        int n = this.c_ExtractCertificate(moduleName, this.label, this.password, string, string2, bl);
        if (n != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYREC_EXTRACT_CERT", CMSKeyDatabaseException.getErrKey(n));
        }
    }

    public void createPersonalCertificateRequest(String string, int n, DNItem dNItem, int n2, String string2) throws KMException {
        if (!this.isOpen()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        int n3 = this.c_CreatePersonalCertificateRequest(moduleName, this.label, this.password, string, n, dNItem, n2, string2);
        if (n3 != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_KEYDB_NEW_CERTREQ", CMSKeyDatabaseException.getErrKey(n3));
        }
        this.addRequestKeyLabel(string);
    }

    public void extractPersonalCertificateRequest(String string, int n, String string2) throws KMException {
        if (!this.isOpen()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        int n2 = this.c_ExtractPersonalCertificateRequest(moduleName, this.label, this.password, string, string2);
        if (n2 != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_RECREATE_CERTREQ", CMSKeyDatabaseException.getErrKey(n2));
        }
    }

    public void addSignerCertificate(String string, String string2, boolean bl) throws KMException {
        if (!this.isOpen()) {
            String string3 = "GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_OPEN";
            throw new KMException(KMSystem.getNLSErrString(string3), string3);
        }
        int n = this.c_AddSignerCertificate(moduleName, this.label, this.password, string, string2, bl);
        if (n != 0) {
            throw this.buildNewKMException("GSKKM_ERR_CMN_CERT_STORE", CMSKeyDatabaseException.getErrKey(n));
        }
        this.addSignerKeyLabel(string);
    }

    private boolean containsKeyLabel(Vector vector, String string) {
        if (vector != null && string != null) {
            int n = 0;
            while (n < vector.size()) {
                if (string.equals(vector.elementAt(n))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void deleteKeyLabel(Vector vector, String string) {
        if (vector != null && string != null) {
            int n = 0;
            while (n < vector.size()) {
                if (string.equals(vector.elementAt(n))) {
                    vector.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
    }

    public void addPersonalKeyLabel(String string) {
        if (string != null) {
            if (this.personalKeyLabelList == null) {
                this.personalKeyLabelList = new Vector();
            }
            this.personalKeyLabelList.addElement(string);
        }
    }

    public void addRequestKeyLabel(String string) {
        if (string != null) {
            if (this.requestKeyLabelList == null) {
                this.requestKeyLabelList = new Vector();
            }
            this.requestKeyLabelList.addElement(string);
        }
    }

    public void addSignerKeyLabel(String string) {
        if (string != null) {
            if (this.signerKeyLabelList == null) {
                this.signerKeyLabelList = new Vector();
            }
            this.signerKeyLabelList.addElement(string);
        }
    }

    private KMException buildNewKMException(String string, String string2) {
        String string3;
        Object[] objectArray;
        String string4;
        KMUtil.debugMsg("CryptographicToken::buildNewKMException() 0000, msgName=" + string + ", errCodeName=" + string2);
        KMException kMException = new KMException(KMSystem.getNLSErrString(string), string2);
        kMException.setNLSErrString(KMSystem.getNLSErrString(string));
        if (string2.equals("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_LABEL_NOT_EXIST")) {
            string4 = KMSystem.getNLSErrString(string2);
            objectArray = new Object[]{this.label};
            string3 = MessageFormat.format(string4, objectArray);
            kMException.setNLSErrString(string3);
        }
        if (string2.equals("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_LIBRARY_NOT_LOADED")) {
            string4 = KMSystem.getNLSErrString(string2);
            objectArray = new Object[]{moduleName};
            string3 = MessageFormat.format(string4, objectArray);
            kMException.setNLSErrString(string3);
        }
        KMUtil.debugMsg("CryptographicToken::buildNewKMException() 9999");
        return kMException;
    }

    private byte[] cryptoBase64DearmorFileToBuf(String string) throws KMException {
        byte[] byArray;
        byte[] byArray2 = this.cryptoFileToBuf(string);
        if (byArray2 == null) {
            return null;
        }
        int[] nArray = new int[2];
        this.cryptoFindCertificateBeginEnd(byArray2, nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        if (n == -1 || n2 == -1) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        int n3 = n2 - n;
        byte[] byArray3 = new byte[n3];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3 + n) {
            int n6 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(byArray2[n4]);
            if (n6 != -1) {
                byArray3[n5] = (byte)n6;
                ++n5;
            }
            ++n4;
        }
        int n7 = n5;
        int n8 = n7 % 4;
        int n9 = (n7 - n8) * 3 / 4;
        if (n8 == 1) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_INVALID_DATA"));
        }
        if (n8 == 2) {
            byArray = new byte[++n9];
            byArray[n9 - 1] = (byte)(byArray3[n5 - 2] << 2 | byArray3[n5 - 1] >>> 4);
        } else if (n8 == 3) {
            byArray = new byte[n9 += 2];
            byArray[n9 - 2] = (byte)(byArray3[n5 - 3] << 2 | byArray3[n5 - 2] >>> 4);
            byArray[n9 - 1] = (byte)(byArray3[n5 - 2] << 4 | byArray3[n5 - 1] >>> 2);
        } else {
            byArray = new byte[n9];
        }
        int n10 = 0;
        n5 = 0;
        n10 = 0;
        while (n5 + 3 < n7) {
            byArray[n10] = (byte)(byArray3[n5] << 2 | byArray3[n5 + 1] >>> 4);
            byArray[n10 + 1] = (byte)(byArray3[n5 + 1] << 4 | byArray3[n5 + 2] >>> 2);
            byArray[n10 + 2] = (byte)(byArray3[n5 + 2] << 6 | byArray3[n5 + 3]);
            n5 += 4;
            n10 += 3;
        }
        return byArray;
    }

    private byte[] cryptoFileToBuf(String string) throws KMException {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
        int n2 = (int)file.length();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[n2];
        try {
            fileInputStream = new FileInputStream(file);
            n = 0;
            int n3 = 0;
            while (n < byArray.length && (n3 = fileInputStream.read(byArray, n, byArray.length - n)) != -1) {
                n += n3;
            }
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            fileInputStream = null;
            n = 0;
        }
        if (n != byArray.length) {
            return null;
        }
        return byArray;
    }

    private void cryptoFindCertificateBeginEnd(byte[] byArray, int[] nArray) {
        int n;
        byte by;
        nArray[0] = -1;
        nArray[1] = -1;
        int n2 = 0;
        int n3 = 0;
        String[][] stringArrayArray = new String[][]{{"-----BEGIN PRIVACY-ENHANCED MESSAGE-----", "-----END PRIVACY-ENHANCED MESSAGE-----"}, {"-----BEGIN PKCS #7 SIGNED DATA-----", "-----END PKCS #7 SIGNED DATA-----"}, {"-----BEGIN X509 CERTIFICATE-----", "-----END X509 CERTIFICATE-----"}, {"-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"}, {"-----BEGIN", "-----END"}};
        n2 = 0;
        while (n2 < byArray.length && nArray[0] == -1) {
            n3 = 0;
            while (n3 < stringArrayArray.length && nArray[0] == -1) {
                by = (byte)stringArrayArray[n3][0].charAt(0);
                if (byArray[n2] == by) {
                    n = 0;
                    while (n + n2 < byArray.length && n < stringArrayArray[n3][0].length() && Character.toUpperCase((char)byArray[n2 + n]) == stringArrayArray[n3][0].charAt(n)) {
                        ++n;
                    }
                    if (n == stringArrayArray[n3][0].length()) {
                        nArray[0] = n2 + stringArrayArray[n3][0].length();
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (nArray[0] != -1) {
            by = (byte)stringArrayArray[--n3][1].charAt(0);
            n2 = nArray[0];
            while (n2 < byArray.length && nArray[1] == -1) {
                if (byArray[n2] == by) {
                    n = 0;
                    while (n + n2 < byArray.length && n < stringArrayArray[n3][1].length() && Character.toUpperCase((char)byArray[n2 + n]) == stringArrayArray[n3][1].charAt(n)) {
                        ++n;
                    }
                    if (n == stringArrayArray[n3][1].length()) {
                        nArray[1] = n2;
                    }
                }
                ++n2;
            }
        }
    }
}

