/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.BERDecoder;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.pki.SubjectPublicKeyInfo;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.ce.AltNames;
import com.ibm.cfwk.pki.ce.AuthorityKeyIdentifier;
import com.ibm.cfwk.pki.ce.BasicConstraints;
import com.ibm.cfwk.pki.ce.CRLDistributionPoints;
import com.ibm.cfwk.pki.ce.ExtKeyUsage;
import com.ibm.cfwk.pki.ce.KeyUsage;
import com.ibm.cfwk.pki.ce.NameConstraints;
import com.ibm.cfwk.pki.ce.PolicyConstraints;
import com.ibm.cfwk.pki.ce.PolicyMappings;
import com.ibm.cfwk.pki.ce.PrivateKeyUsagePeriod;
import com.ibm.cfwk.pki.ce.SubjectDirectoryAttributes;
import com.ibm.cfwk.pki.ce.SubjectKeyIdentifier;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.cli.CLICertificateInfo;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLICryptoDatabaseManager;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreManager;
import com.ibm.gsk.ikeyman.ikeycmd;
import com.ibm.util.x500name.RDNAttribute;
import com.ibm.util.x500name.X500Name;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class CLICryptoCertificateManager
implements CLIConstants {
    public static void create(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::create, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        String string3 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        String string4 = cLICertificateInfo.dn.getCommonName();
        String string5 = cLICertificateInfo.dn.getOrgUnit();
        String string6 = cLICertificateInfo.dn.getOrg();
        String string7 = cLICertificateInfo.dn.getLocality();
        String string8 = cLICertificateInfo.dn.getState();
        String string9 = cLICertificateInfo.dn.getZipCode();
        String string10 = cLICertificateInfo.dn.getCountry();
        String string11 = cLICertificateInfo.dn.getEmail();
        Vector vector = cLICertificateInfo.dn.getOptions();
        DNItem dNItem = new DNItem(string4, string5, string6, string7, string8, string9, string10, string11);
        int n3 = cLICertificateInfo.getVersion();
        String string12 = cLICertificateInfo.getLabel();
        int n4 = cLICertificateInfo.getKeySize();
        long l2 = cLICertificateInfo.getExpire();
        int n5 = KMSystem.getDefaultSignatureAlg();
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            ikeycmd.debugMsg("CLICryptoCertificateManager::open Token OK signalg=" + n5 + " SSKeyLabel=" + string12 + " cn=" + string4 + " org=" + string6 + " c=" + string10);
            if (keyStoreManager.isOpen()) {
                ikeycmd.debugMsg("CLICryptoCertManager:: - isOpen");
                keyStoreManager.createSelfSignedCertificate(n3, string12, n4, dNItem, (int)l2, n5);
            }
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::create, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void receive(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::receive, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        String string3 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            String string4 = cLICertificateInfo.getFileName();
            boolean bl = cLICertificateInfo.getFormat();
            String string5 = cLICertificateInfo.getSecondDBName();
            String string6 = cLICertificateInfo.getSecondDBPswd();
            if (string5 != null && string6 != null) {
                KeyStoreManager keyStoreManager2 = CLIKeyStoreManager.makeKeyDatabase(1, string5, string6, l);
                keyStoreManager.receivePersonalCertificate(keyStoreManager2, string4, bl);
            } else {
                keyStoreManager.receivePersonalCertificate(string4, bl, true);
            }
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::receive, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void add(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::add, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        String string3 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            String string4 = cLICertificateInfo.getLabel();
            String string5 = cLICertificateInfo.getFileName();
            boolean bl = cLICertificateInfo.getFormat();
            keyStoreManager.addSignerCertificate(string4, string5, bl);
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::add, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void list(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::list, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        Vector vector = null;
        String string = null;
        KeyItem keyItem = null;
        String string2 = cLICertificateInfo.cliDb.getName();
        String string3 = cLICertificateInfo.cliDb.getPassword();
        String string4 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string2);
        ikeycmd.debugMsg("TokenPassword: " + string3);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string4);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string4, n2, n, string2);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string3);
            String string5 = cLICertificateInfo.getList();
            if (string5.equalsIgnoreCase("all")) {
                String string6;
                int n3;
                vector = new Vector();
                Vector vector2 = keyStoreManager.getSignerKeyLabelList();
                Vector vector3 = keyStoreManager.getPersonalKeyLabelList();
                ikeycmd.debugMsg("slotID345:  ");
                if (vector2 != null) {
                    n3 = 0;
                    while (n3 < vector2.size()) {
                        string6 = (String)vector2.elementAt(n3);
                        vector.addElement(string6);
                        ++n3;
                    }
                }
                if (vector3 != null) {
                    n3 = 0;
                    while (n3 < vector3.size()) {
                        string6 = (String)vector3.elementAt(n3);
                        vector.addElement(string6);
                        ++n3;
                    }
                }
            } else if (string5.equalsIgnoreCase("CA")) {
                vector = keyStoreManager.getSignerKeyLabelList();
            } else {
                if (string5.equalsIgnoreCase("site")) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_CMS_NO_GOOD"));
                }
                if (string5.equalsIgnoreCase("personal")) {
                    vector = keyStoreManager.getPersonalKeyLabelList();
                }
            }
            if (vector == null || vector.size() == 0) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
            }
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_LIST_MSG") + " " + string2);
            int n4 = 0;
            while (n4 < vector.size()) {
                string = (String)vector.elementAt(n4);
                keyItem = keyStoreManager.getKeyItemByLabel(string);
                System.out.println("   " + string);
                ++n4;
            }
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::list, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void moreDetails(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        KeyStoreManager keyStoreManager = null;
        ikeycmd.debugMsg("CLICryptoCertificateManager::moreDetails, 0000");
        String string = "  ";
        String string2 = "    ";
        String string3 = "      ";
        String string4 = "        ";
        cLICertificateInfo.init();
        String string5 = cLICertificateInfo.cliDb.getName();
        String string6 = cLICertificateInfo.cliDb.getPassword();
        String string7 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string5);
        ikeycmd.debugMsg("TokenPassword: " + string6);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string7);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string7, n2, n, string5);
            keyStoreManager.open(string6);
            String string8 = cLICertificateInfo.getLabel();
            KeyItem keyItem = null;
            try {
                keyItem = keyStoreManager.getKeyItemByLabel(string8);
                if (null == keyItem) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
                }
            }
            catch (Exception exception) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            if (keyItem != null && keyItem.hasCertificate()) {
                System.out.println("\n\n");
                if (keyItem.getKeyLabel().compareTo(string8) == 0) {
                    System.out.println(ikeycmd.getNLSResString("GUI_LABEL_KEY_LABEL_COLON") + " " + keyItem.getKeyLabel());
                }
                System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_TBS_CERT"));
                Vector vector = keyItem.getCertificateChain();
                if (vector != null && vector.size() > 0) {
                    String string9;
                    Object object;
                    Object object2;
                    String string10;
                    String string11;
                    Object object3;
                    RDNAttribute[][] rDNAttributeArray;
                    String string12;
                    String string13;
                    Object object4;
                    CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                    X509Cert x509Cert = null;
                    try {
                        x509Cert = new X509Cert(certificateItem.getEncoded(), 0, certificateItem.getLength());
                    }
                    catch (ASN1Exception aSN1Exception) {
                        // empty catch block
                    }
                    System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " X509 V" + certificateItem.getVersion());
                    System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SERIAL") + " " + certificateItem.getSerialNumber());
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ISSUER"));
                    X500Name x500Name = x509Cert.issuer();
                    RDNAttribute[][] rDNAttributeArray2 = x500Name.attributes();
                    if (rDNAttributeArray2 != null) {
                        int n3 = 0;
                        while (n3 < rDNAttributeArray2.length) {
                            int n4 = 0;
                            while (n4 < rDNAttributeArray2[n3].length) {
                                object4 = rDNAttributeArray2[n3][n4].keyToASN1OID();
                                string13 = object4.toString();
                                string12 = rDNAttributeArray2[n3][n4].valueToString();
                                rDNAttributeArray = CLICryptoCertificateManager.getAttributeName(object4);
                                System.out.println(string3 + (String)rDNAttributeArray);
                                System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + string13);
                                System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + string12);
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_VALIDITY"));
                    Date date = certificateItem.getValidNotBefore();
                    String string14 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date);
                    object4 = certificateItem.getValidNotAfter();
                    string13 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format((Date)object4);
                    if (date != null && object4 != null) {
                        System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_NOT_BEFORE") + ": " + string14);
                        System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_NOT_AFTER") + ": " + string13);
                    }
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT"));
                    string12 = x509Cert.subject();
                    rDNAttributeArray = string12.attributes();
                    if (rDNAttributeArray != null) {
                        int n5 = 0;
                        while (n5 < rDNAttributeArray.length) {
                            int n6 = 0;
                            while (n6 < rDNAttributeArray[n5].length) {
                                object3 = rDNAttributeArray[n5][n6].keyToASN1OID();
                                string11 = object3.toString();
                                string10 = rDNAttributeArray[n5][n6].valueToString();
                                String string15 = CLICryptoCertificateManager.getAttributeName((ASN1OID)object3);
                                System.out.println(string3 + string15);
                                System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + string11);
                                System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + string10);
                                ++n6;
                            }
                            ++n5;
                        }
                    }
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"));
                    AlgId algId = x509Cert.subjectKeyAlgId();
                    byte[] byArray = null;
                    object3 = x509Cert.subjectPublicKeyInfo();
                    if (object3 != null && ((byte[])object3).length > 0) {
                        string11 = new BERDecoder(object3);
                        string10 = new SubjectPublicKeyInfo();
                        try {
                            string10.decode((ASN1Decoder)string11, algId);
                            byArray = string10.computePublicKeyAsByteArray();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (algId != null) {
                        string11 = algId.asn1oid();
                        if (string11 != null && (string10 = string11.toString()) != null && string10.length() > 0) {
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string10);
                        }
                        switch (algId.parameterStatus()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                                break;
                            }
                            case 2: {
                                string10 = algId.toString();
                                System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string10);
                                break;
                            }
                        }
                    }
                    if (byArray != null && byArray.length > 0) {
                        string11 = CLICryptoCertificateManager.getHexDumpForMoreDetails(byArray);
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY") + ":\n" + string3 + string11);
                    }
                    string11 = null;
                    try {
                        string11 = x509Cert.extensions(false);
                    }
                    catch (ASN1Exception aSN1Exception) {
                        // empty catch block
                    }
                    int n7 = string11.numberOfExtensions();
                    if (string11 != null && n7 > 0) {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_EXTENSIONS"));
                        int n8 = 0;
                        while (n8 < n7) {
                            object2 = string11.extension(n8);
                            object = "";
                            string9 = "";
                            ASN1OID aSN1OID = null;
                            String string16 = "";
                            String string17 = "";
                            int n9 = 0;
                            boolean bl = false;
                            String string18 = ikeycmd.getNLSResString("GUI_LABEL_EXTNID");
                            String string19 = ikeycmd.getNLSResString("GUI_LABEL_CRITICAL");
                            String string20 = ikeycmd.getNLSResString("GUI_LABEL_EXTNVALUE");
                            aSN1OID = object2.asn1oid();
                            object = aSN1OID.toString();
                            string9 = object;
                            if (string9.equals("2.5.29.9")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_DIRECTORY_ATTRIBUTES");
                                n9 = 9;
                            } else if (string9.equals("2.5.29.14")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_KEY_IDENTIFIER");
                                n9 = 14;
                            } else if (string9.equals("2.5.29.15")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_KEY_USAGE");
                                n9 = 15;
                            } else if (string9.equals("2.5.29.16")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_PRIVATE_KEY_USAGE_PERIOD");
                                n9 = 16;
                            } else if (string9.equals("2.5.29.17")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_ALTERNATIVE_NAME");
                                n9 = 17;
                            } else if (string9.equals("2.5.29.18")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_ISSUER_ALTERNATIVE_NAMES");
                                n9 = 18;
                            } else if (string9.equals("2.5.29.19")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_BASIC_CONSTRAINTS");
                                n9 = 19;
                            } else if (string9.equals("2.5.29.30")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_NAME_CONSTRAINTS");
                                n9 = 30;
                            } else if (string9.equals("2.5.29.31")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_CRL_DISTRIBUTION_POINTS");
                                n9 = 31;
                            } else if (string9.equals("2.5.29.32")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_CERTIFICATE_POLICIES");
                                n9 = 32;
                            } else if (string9.equals("2.5.29.33")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_POLICY_MAPPINGS");
                                n9 = 33;
                            } else if (string9.equals("2.5.29.35")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_AUTH_KEY_ID");
                                n9 = 35;
                            } else if (string9.equals("2.5.29.36")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_POLICY_CONSTRAINTS");
                                n9 = 36;
                            } else if (string9.equals("2.5.29.37")) {
                                string9 = ikeycmd.getNLSResString("GUI_LABEL_EXT_KEY_USAGE_FIELD");
                                n9 = 37;
                            }
                            System.out.println(string3 + string9);
                            System.out.println(string4 + string18 + ": " + (String)object);
                            string16 = object2.isCritical() ? ikeycmd.getNLSResString("GUI_LABEL_TRUE") : ikeycmd.getNLSResString("GUI_LABEL_FALSE");
                            System.out.println(string4 + string19 + ": " + string16);
                            try {
                                string17 = object2.toBERDump();
                            }
                            catch (ASN1Exception aSN1Exception) {
                                bl = true;
                            }
                            if (!bl && object2.isValid()) {
                                switch (n9) {
                                    case 9: {
                                        string17 = ((SubjectDirectoryAttributes)object2).valueToString();
                                        break;
                                    }
                                    case 14: {
                                        string17 = ((SubjectKeyIdentifier)object2).valueToString();
                                        break;
                                    }
                                    case 15: {
                                        string17 = ((KeyUsage)object2).valueToString();
                                        break;
                                    }
                                    case 16: {
                                        string17 = ((PrivateKeyUsagePeriod)object2).valueToString();
                                        break;
                                    }
                                    case 17: {
                                        string17 = ((AltNames)object2).valueToString();
                                        break;
                                    }
                                    case 18: {
                                        string17 = ((AltNames)object2).valueToString();
                                        break;
                                    }
                                    case 19: {
                                        string17 = ((BasicConstraints)object2).valueToString();
                                        break;
                                    }
                                    case 30: {
                                        string17 = ((NameConstraints)object2).valueToString();
                                        break;
                                    }
                                    case 31: {
                                        string17 = ((CRLDistributionPoints)object2).valueToString();
                                        break;
                                    }
                                    case 32: {
                                        break;
                                    }
                                    case 33: {
                                        string17 = ((PolicyMappings)object2).valueToString();
                                        break;
                                    }
                                    case 35: {
                                        string17 = ((AuthorityKeyIdentifier)object2).valueToString();
                                        break;
                                    }
                                    case 36: {
                                        string17 = ((PolicyConstraints)object2).valueToString();
                                        break;
                                    }
                                    case 37: {
                                        string17 = ((ExtKeyUsage)object2).valueToString();
                                        break;
                                    }
                                }
                            } else {
                                string17 = ikeycmd.getNLSResString("GUI_LABEL_INFO_NOT_VALID_ERROR");
                            }
                            System.out.println(string4 + string20 + ": " + string17);
                            ++n8;
                        }
                    }
                    AlgId algId2 = x509Cert.signatureKeyAlgId();
                    object2 = certificateItem.getSignature();
                    System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_SIG_ALG"));
                    if (algId2 != null) {
                        object = algId2.asn1oid();
                        if (object != null && (string9 = object.toString()) != null && string9.length() > 0) {
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string9);
                        }
                        switch (algId2.parameterStatus()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                                break;
                            }
                            case 2: {
                                string9 = algId2.toString();
                                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string9);
                                break;
                            }
                        }
                    }
                    if (object2 != null) {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SIG_VALUE") + ":\n" + string3 + CLICryptoCertificateManager.getHexDumpForMoreDetails(object2));
                    }
                    System.out.println("\n");
                }
            } else {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::moreDetails, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    private static String getAttributeName(ASN1OID aSN1OID) {
        String string = null;
        if (aSN1OID != null) {
            string = aSN1OID.equals((Object)X500Name.COMMON_NAME) ? ikeycmd.getNLSResString("GUI_LABEL_COMMON_NAME") : (aSN1OID.equals((Object)X500Name.SERIAL_NUMBER) ? ikeycmd.getNLSResString("GUI_LABEL_SERIALNO") : (aSN1OID.equals((Object)X500Name.COUNTRY) ? ikeycmd.getNLSResString("GUI_LABEL_COUNTRY") : (aSN1OID.equals((Object)X500Name.LOCATION) ? ikeycmd.getNLSResString("GUI_LABEL_LOCALITY") : (aSN1OID.equals((Object)X500Name.STATE) ? ikeycmd.getNLSResString("GUI_LABEL_STATE") : (aSN1OID.equals((Object)X500Name.STREET) ? ikeycmd.getNLSResString("GUI_LABEL_STREET") : (aSN1OID.equals((Object)X500Name.ORGANIZATION) ? ikeycmd.getNLSResString("GUI_LABEL_ORG") : (aSN1OID.equals((Object)X500Name.ORGANIZATIONAL_UNIT) ? ikeycmd.getNLSResString("GUI_LABEL_ORG_UNIT") : (aSN1OID.equals((Object)X500Name.TITLE) ? ikeycmd.getNLSResString("GUI_LABEL_TITLE2") : (aSN1OID.equals((Object)X500Name.ZIP) ? ikeycmd.getNLSResString("GUI_LABEL_ZIPCODE") : (aSN1OID.equals((Object)X500Name.EMAIL) ? ikeycmd.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : aSN1OID.toString()))))))))));
        }
        return string;
    }

    private static String getHexDumpForMoreDetails(byte[] byArray) {
        String string = new String("");
        String string2 = "      ";
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n" + string2;
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    public static void details(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::details, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        String string3 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            String string4 = cLICertificateInfo.getLabel();
            KeyItem keyItem = null;
            try {
                keyItem = keyStoreManager.getKeyItemByLabel(string4);
                if (null == keyItem) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
                }
            }
            catch (Exception exception) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            if (keyItem != null && keyItem.hasCertificate()) {
                Vector vector;
                System.out.println("\n\n");
                if (keyItem.getKeyLabel().compareTo(string4) == 0) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_LABEL") + " " + keyItem.getKeyLabel());
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_KEYSIZE") + " " + keyItem.getKeySize());
                }
                if ((vector = keyItem.getCertificateChain()) != null && vector.size() > 0) {
                    String string5;
                    String string6;
                    DNItem dNItem;
                    CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " X509 V" + certificateItem.getVersion());
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SERIAL") + " " + certificateItem.getSerialNumber());
                    DNItem dNItem2 = certificateItem.getIssuer();
                    if (dNItem2 != null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_ISSUER") + " " + dNItem2.toStringWithoutTag());
                    }
                    if ((dNItem = certificateItem.getSubject()) != null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SUBJECT") + " " + dNItem.toStringWithoutTag());
                    }
                    Date date = certificateItem.getValidNotBefore();
                    String string7 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date);
                    Date date2 = certificateItem.getValidNotAfter();
                    String string8 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date2);
                    if (date != null && date2 != null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VALID") + " " + string7 + " " + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_TO") + " " + string8);
                    }
                    if ((string6 = certificateItem.getFingerPrint()) != null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_FINGER") + " " + string6);
                    }
                    if ((string5 = certificateItem.getSigAlgorithmIdOID()) != null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SIG") + " " + string5);
                    }
                    if (keyItem.isTrusted()) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_ENABLED"));
                    } else {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_DISABLED"));
                    }
                    System.out.println("\n");
                }
            } else {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::details, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void delete(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::delete, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        String string3 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            String string4 = cLICertificateInfo.getLabel();
            if (string4 == null || string4.equals("")) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
            }
            ikeycmd.debugMsg("Deleteing Label: " + string4 + "\n");
            try {
                KeyItem keyItem = null;
                keyItem = keyStoreManager.getKeyItemByLabel(string4);
                if (null == keyItem) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
                }
            }
            catch (Exception exception) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
            }
            keyStoreManager.deleteKeyItemByLabel(string4);
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::delete, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void modify(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
    }

    public static void importCert(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException, Exception {
        ikeycmd.debugMsg("CLICryptoCertificateManager::importCert, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("src fileName: " + string);
        ikeycmd.debugMsg("src filePwd: " + string2);
        ikeycmd.debugMsg("src fileType: " + n);
        ikeycmd.debugMsg("--------------------------------------");
        String string3 = cLICertificateInfo.getTokenDriverName();
        String string4 = cLICertificateInfo.getPasswordForToken();
        String string5 = cLICertificateInfo.cliDb.getTokenLabel();
        int n2 = cLICertificateInfo.getTokenType();
        int n3 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string3);
        ikeycmd.debugMsg("TokenPassword: " + string4);
        ikeycmd.debugMsg("keyDbType:  " + n2);
        ikeycmd.debugMsg("TokenLabel: " + string5);
        ikeycmd.debugMsg("SlotID:  " + n3);
        ikeycmd.debugMsg("\n");
        if (n3 != -1 && cLICertificateInfo.getSecondDBName() != null) {
            ikeycmd.displayHelp("-secondaryDB", "JSSE", -47);
        }
        try {
            KeyStoreManager keyStoreManager2 = null;
            keyStoreManager2 = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
            keyStoreManager2.open();
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string5, n3, n2, string3);
            keyStoreManager.open(string4);
            if (keyStoreManager == null) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
                System.exit(1);
            } else if (keyStoreManager2 == null) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
                System.exit(1);
            } else {
                String string6 = cLICertificateInfo.getSecondDBName();
                String string7 = cLICertificateInfo.getSecondDBPswd();
                if (string6 != null && string7 == null) {
                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_NULL"));
                }
                KeyStoreManager keyStoreManager3 = null;
                if (string6 != null && string7 != null) {
                    ikeycmd.debugMsg("secondKeyDbName: " + string6);
                    ikeycmd.debugMsg("secondKeyDbPswd: " + string7);
                    ikeycmd.debugMsg("\n");
                    keyStoreManager3 = CLIKeyStoreManager.makeKeyDatabase(1, string6, string7, l);
                }
                String[] stringArray = null;
                if (string.endsWith("p12") || string.endsWith("P12")) {
                    String[] stringArray2 = new String[keyStoreManager2.getKeyLabelList().size()];
                    int n4 = 0;
                    Enumeration enumeration = keyStoreManager2.getKeyLabelList().elements();
                    while (enumeration.hasMoreElements()) {
                        stringArray2[n4] = enumeration.nextElement().toString();
                        ++n4;
                    }
                    stringArray = stringArray2;
                } else {
                    String[] stringArray3 = new String[]{cLICertificateInfo.getLabel().toString()};
                    stringArray = stringArray3;
                }
                if (n2 == 10) {
                    if (keyStoreManager3 != null && keyStoreManager3.getType() == 1) {
                        keyStoreManager.importKeyItems(keyStoreManager3, keyStoreManager2, stringArray);
                    } else {
                        keyStoreManager.importKeyItems(keyStoreManager2, stringArray);
                    }
                } else {
                    keyStoreManager.importKeyFromKeyStore(keyStoreManager2, stringArray, stringArray);
                }
                keyStoreManager.close();
                keyStoreManager2.close();
            }
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::importCert, 9700, CMSKeyDatabaseException");
                ikeycmd.debugMsg(cMSKeyDatabaseException.getMessage());
            }
            throw cMSKeyDatabaseException;
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::importCert, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
        catch (Exception exception) {
            if (ikeycmd.DEBUG) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO") + exception);
                exception.printStackTrace();
            }
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_IMPORT_KEY"));
        }
    }

    public static void export(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, Exception {
    }

    public static void extract(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException {
        ikeycmd.debugMsg("CLICryptoCertificateManager::extract, 0000");
        KeyStoreManager keyStoreManager = null;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        String string3 = cLICertificateInfo.cliDb.getTokenLabel();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        int n2 = cLICertificateInfo.cliDb.getSlotID();
        ikeycmd.debugMsg("TokenModuleName: " + string);
        ikeycmd.debugMsg("TokenPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("TokenLabel: " + string3);
        ikeycmd.debugMsg("SlotID:  " + n2);
        ikeycmd.debugMsg("Label:  " + cLICertificateInfo.getLabel());
        ikeycmd.debugMsg("File:  " + cLICertificateInfo.getExtractTarget());
        ikeycmd.debugMsg("\n");
        try {
            keyStoreManager = CLICryptoDatabaseManager.makeCryptoDatabase(string3, n2, n, string);
            if (keyStoreManager == null) {
                throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
            }
            keyStoreManager.open(string2);
            String string4 = cLICertificateInfo.getLabel();
            String string5 = cLICertificateInfo.getExtractTarget();
            boolean bl = cLICertificateInfo.getFormat();
            keyStoreManager.extractCryptokiCertificate(string4, string5, bl);
            keyStoreManager.close();
        }
        catch (KMException kMException) {
            if (ikeycmd.DEBUG) {
                ikeycmd.debugMsg("CLICryptoCertificateManager::extract, 9900, KMException");
                ikeycmd.debugMsg(kMException.getMessage());
            }
            throw kMException;
        }
    }

    public static void sign(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
    }

    public static void setDefault(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
    }

    public static void getDefault(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
    }
}

