/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDefaults;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreManager;
import com.ibm.gsk.ikeyman.ikeycmd;
import java.io.File;
import java.util.Calendar;
import java.util.StringTokenizer;

public class CLIDatabaseInfo
implements CLIConstants {
    public int action;
    public String message;
    public int rc;
    private String name;
    private String password;
    private String tokenLabel;
    private String newPassword;
    private String extension;
    private String newExtension;
    private String passwordFileLocation;
    private long expire;
    private boolean stashed;
    private String file;
    private int dbType;
    private int newDbType;
    private boolean stashOnCreate;
    private boolean useDefaultDbType;
    private CLIDefaults defaults;
    private int slotID;
    private boolean expiryShow;
    private int expiryTime;

    public CLIDatabaseInfo() {
        this.action = -3;
        this.message = null;
        this.name = null;
        this.password = null;
        this.tokenLabel = null;
        this.newPassword = null;
        this.extension = new String("kdb");
        this.newExtension = new String("kdb");
        this.passwordFileLocation = null;
        this.stashed = false;
        this.expire = 60L;
        this.dbType = 1;
        this.newDbType = 1;
        this.useDefaultDbType = true;
        this.stashOnCreate = false;
        this.slotID = -1;
        this.expiryShow = false;
        this.expiryTime = -1;
        this.defaults = new CLIDefaults();
    }

    public CLIDatabaseInfo(int n) {
        this.defaults = new CLIDefaults();
        this.action = n;
        this.message = null;
        this.dbType = 1;
        this.newDbType = 1;
        this.useDefaultDbType = true;
        if (this.defaults.defaultDbType != null) {
            this.newDbType = this.dbType = Integer.valueOf(this.defaults.defaultDbType).intValue();
        }
        if (this.dbType == 1) {
            if (this.defaults.CMSname != null) {
                this.name = this.defaults.CMSname;
            }
            if (this.defaults.defaultCMSPw != null) {
                this.password = this.defaults.defaultCMSPw;
            }
            this.extension = new String("kdb");
            if (this.defaults.CMSext != null) {
                this.extension = this.defaults.CMSext;
            }
        } else if (this.dbType == 2) {
            if (this.defaults.WEBDBname != null) {
                this.name = this.defaults.WEBDBname;
            }
            if (this.defaults.defaultWEBDBPw != null) {
                this.password = this.defaults.defaultWEBDBPw;
            }
            this.extension = new String("kyr");
            if (this.defaults.WEBDBext != null) {
                this.extension = this.defaults.WEBDBext;
            }
        } else if (this.dbType == 3) {
            if (this.defaults.SSLname != null) {
                this.name = this.defaults.SSLname;
            }
            if (this.defaults.defaultSSLPw != null) {
                this.password = this.defaults.defaultSSLPw;
            }
            this.extension = new String("class");
            if (this.defaults.SSLext != null) {
                this.extension = this.defaults.WEBDBext;
            }
        } else if (this.dbType == 8) {
            if (this.defaults.PKCS12FileName != null) {
                this.name = this.defaults.PKCS12FileName;
            }
            if (this.defaults.defaultPKCS12Pw != null) {
                this.password = this.defaults.defaultPKCS12Pw;
            }
            this.extension = new String("p12");
            if (this.defaults.PKCS12ext != null) {
                this.extension = this.defaults.PKCS12ext;
            }
        } else if (this.dbType == 7) {
            if (this.defaults.JCEKSname != null) {
                this.name = this.defaults.JCEKSname;
            }
            this.extension = new String("jck");
            if (this.defaults.JCEKSext != null) {
                this.extension = this.defaults.JCEKSext;
            }
        } else if (this.dbType == 6) {
            if (this.defaults.JKSname != null) {
                this.name = this.defaults.JKSname;
            }
            this.extension = new String("jks");
            if (this.defaults.SSLext != null) {
                this.extension = this.defaults.JKSext;
            }
        }
        if (this.newDbType == 1) {
            if (this.defaults.defaultCMSPw != null) {
                this.newPassword = this.defaults.defaultCMSPw;
            }
            this.newExtension = new String("kdb");
            if (this.defaults.CMSext != null) {
                this.newExtension = this.defaults.CMSext;
            }
        } else if (this.newDbType == 2) {
            if (this.defaults.defaultWEBDBPw != null) {
                this.newPassword = this.defaults.defaultWEBDBPw;
            }
            this.newExtension = new String("kyr");
            if (this.defaults.WEBDBext != null) {
                this.newExtension = this.defaults.WEBDBext;
            }
        } else if (this.newDbType == 3) {
            if (this.defaults.defaultSSLPw != null) {
                this.newPassword = this.defaults.defaultSSLPw;
            }
            this.newExtension = new String("class");
            if (this.defaults.SSLext != null) {
                this.newExtension = this.defaults.WEBDBext;
            }
        } else if (this.newDbType == 6) {
            this.newExtension = new String("jks");
            if (this.defaults.JKSext != null) {
                this.newExtension = this.defaults.JKSext;
            }
        } else if (this.newDbType == 7) {
            this.newExtension = new String("jck");
            if (this.defaults.JCEKSext != null) {
                this.newExtension = this.defaults.JCEKSext;
            }
        }
        this.stashOnCreate = false;
        if (this.defaults.stashingState != null && this.defaults.stashingState.equalsIgnoreCase("true")) {
            this.stashOnCreate = true;
        }
        this.stashed = false;
        this.expire = 60L;
        if (this.defaults.defaultExpire != null) {
            this.expire = Long.valueOf(this.defaults.defaultExpire);
        }
    }

    public void init() {
        ikeycmd.debugMsg("CLIDatabaseInfo");
        ikeycmd.debugMsg("init-dbType: " + this.dbType);
        ikeycmd.debugMsg("init-name: " + this.name);
        ikeycmd.debugMsg("init-extension: " + this.extension);
        ikeycmd.debugMsg("\n");
        if (this.name != null) {
            if (this.name.indexOf(".") == -1) {
                if (this.dbType == 1) {
                    if (!this.extension.equalsIgnoreCase("kdb") && this.defaults.CMSext == null) {
                        this.extension = "kdb";
                    } else if (this.defaults.CMSext != null && !this.extension.equalsIgnoreCase(this.defaults.CMSext)) {
                        this.extension = this.defaults.CMSext;
                    }
                }
                if (this.dbType == 3) {
                    if (!this.extension.equalsIgnoreCase("class") && this.defaults.SSLext == null) {
                        this.extension = "class";
                    } else if (this.defaults.SSLext != null && !this.extension.equalsIgnoreCase(this.defaults.SSLext)) {
                        this.extension = this.defaults.SSLext;
                    }
                }
                if (this.dbType == 2) {
                    if (!this.extension.equalsIgnoreCase("kyr") && this.defaults.WEBDBext == null) {
                        this.extension = "kyr";
                    } else if (this.defaults.CMSext != null && !this.extension.equalsIgnoreCase(this.defaults.WEBDBext)) {
                        this.extension = this.defaults.WEBDBext;
                    }
                }
                if (this.dbType == 8) {
                    if (!this.extension.equalsIgnoreCase("p12") && this.defaults.PKCS12ext == null) {
                        this.extension = "p12";
                    } else if (this.defaults.PKCS12ext != null && !this.extension.equalsIgnoreCase(this.defaults.PKCS12ext)) {
                        this.extension = this.defaults.PKCS12ext;
                    }
                }
                if (this.dbType == 6) {
                    if (!this.extension.equalsIgnoreCase("jks") && this.defaults.JKSext == null) {
                        this.extension = "jks";
                    } else if (this.defaults.JKSext != null && !this.extension.equalsIgnoreCase(this.defaults.JKSext)) {
                        this.extension = this.defaults.JKSext;
                    }
                }
                if (this.dbType == 7) {
                    if (!this.extension.equalsIgnoreCase("jck") && this.defaults.JCEKSext == null) {
                        this.extension = "jck";
                    } else if (this.defaults.JCEKSext != null && !this.extension.equalsIgnoreCase(this.defaults.JCEKSext)) {
                        this.extension = this.defaults.JCEKSext;
                    }
                }
                if (this.dbType == 5) {
                    this.extension = "";
                }
                if (this.name.equalsIgnoreCase("MSCertificateStore")) {
                    this.useDefaultDbType = false;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.name, ".");
                String string = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                if (string.equalsIgnoreCase("kdb")) {
                    if (this.dbType != 1 && !this.useDefaultDbType) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WARN_TYPE_CONFLICT"));
                    }
                    this.dbType = 1;
                    this.useDefaultDbType = false;
                } else if (string.equalsIgnoreCase("class")) {
                    if (this.dbType != 3 && !this.useDefaultDbType) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WARN_TYPE_CONFLICT"));
                    }
                    this.dbType = 3;
                    this.useDefaultDbType = false;
                } else if (string.equalsIgnoreCase("p12")) {
                    if (this.dbType != 8 && !this.useDefaultDbType) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WARN_TYPE_CONFLICT"));
                    }
                    this.dbType = 8;
                    this.useDefaultDbType = false;
                } else if (string.equalsIgnoreCase("jks")) {
                    if (this.dbType != 6 && !this.useDefaultDbType) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WARN_TYPE_CONFLICT"));
                    }
                    this.dbType = 6;
                    this.useDefaultDbType = false;
                } else if (string.equalsIgnoreCase("jck")) {
                    if (this.dbType != 7 && !this.useDefaultDbType) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WARN_TYPE_CONFLICT"));
                    }
                    this.dbType = 7;
                    this.useDefaultDbType = false;
                }
            }
        } else if (this.dbType == 5) {
            ikeycmd.debugMsg(":::  " + this.defaults.CryptographicModuleName);
            if (this.defaults.CryptographicModuleName != null) {
                this.name = this.defaults.CryptographicModuleName;
            } else {
                ikeycmd.displayHelp(null, -44);
            }
        } else {
            ikeycmd.displayHelp(null, -18);
        }
        if (this.useDefaultDbType) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WARN_TYPE"));
        }
        if (System.getProperty("os.name").startsWith("Windows") && this.name.indexOf(58) != 1 || !System.getProperty("os.name").startsWith("Windows") && this.name.indexOf(47) != 0) {
            if (this.dbType == 1) {
                if (!this.name.equalsIgnoreCase("MSCertificateStore")) {
                    if (this.defaults.CMSFileLocation != null) {
                        this.name = this.defaults.CMSFileLocation + File.separator + this.name;
                    } else if (this.defaults.FileLocation != null) {
                        this.name = this.defaults.FileLocation + File.separator + this.name;
                    }
                }
            } else if (this.dbType == 2) {
                if (this.action == 7) {
                    if (this.defaults.WEBDBFileLocation != null) {
                        this.name = this.defaults.CMSFileLocation + File.separator + this.name;
                    } else if (this.defaults.FileLocation != null) {
                        this.name = this.defaults.FileLocation + File.separator + this.name;
                    }
                } else {
                    ikeycmd.displayHelp("" + this.dbType, -23);
                }
            } else if (this.dbType == 3) {
                if (this.defaults.SSLFileLocation != null) {
                    this.name = this.defaults.SSLFileLocation + File.separator + this.name;
                } else if (this.defaults.FileLocation != null) {
                    this.name = this.defaults.FileLocation + File.separator + this.name;
                }
            } else if (this.dbType == 6) {
                if (this.defaults.SSLFileLocation != null) {
                    this.name = this.defaults.SSLFileLocation + File.separator + this.name;
                } else if (this.defaults.FileLocation != null) {
                    this.name = this.defaults.FileLocation + File.separator + this.name;
                }
            } else if (this.dbType == 7) {
                if (this.defaults.SSLFileLocation != null) {
                    this.name = this.defaults.SSLFileLocation + File.separator + this.name;
                } else if (this.defaults.FileLocation != null) {
                    this.name = this.defaults.FileLocation + File.separator + this.name;
                }
            } else if (this.dbType == 8) {
                if (this.defaults.PKCS12FileLocation != null) {
                    this.name = this.defaults.PKCS12FileLocation + File.separator + this.name;
                } else if (this.defaults.FileLocation != null) {
                    this.name = this.defaults.FileLocation + File.separator + this.name;
                }
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTokenLabel(String string) {
        this.tokenLabel = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setPasswordFileLocation(String string) {
        this.passwordFileLocation = string;
    }

    public void setExpire(long l) {
        this.expire = l;
    }

    public void setFileName(String string) {
        this.file = string;
    }

    public String getFileName() {
        return this.file;
    }

    public void stashPw() {
        this.stashed = true;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public void setNewExtension(String string) {
        this.newExtension = string;
    }

    public String getNewExtension() {
        return this.newExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getTokenLabel() {
        return this.tokenLabel;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getPasswordFileLocation() {
        return this.passwordFileLocation;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setDbType(int n) {
        this.useDefaultDbType = false;
        this.dbType = n;
    }

    public void setDbType(String string) {
        this.useDefaultDbType = false;
        if (string.equalsIgnoreCase("JKS") || string.equalsIgnoreCase("jks")) {
            this.setDbType(6);
        } else if (string.equalsIgnoreCase("JCEKS") || string.equalsIgnoreCase("jck")) {
            this.setDbType(7);
        } else if (string.equalsIgnoreCase("PKCS12") || string.equalsIgnoreCase("p12")) {
            this.setDbType(8);
        } else {
            this.setDbType(0);
        }
    }

    public int getDbType() {
        if (this.dbType == 0) {
            this.dbType = CLIKeyStoreManager.getKeyDatabaseTypeByName(this.name);
            ikeycmd.debugMsg("CLIDatabaseInfo.getDbType()::" + this.dbType + "\n");
        }
        return this.dbType;
    }

    public void setNewDbType(int n) {
        this.newDbType = n;
    }

    public int getNewDbType() {
        return this.newDbType;
    }

    public void setStash(boolean bl) {
        this.stashOnCreate = bl;
    }

    public boolean getStash() {
        return this.stashOnCreate;
    }

    public void setSlotID(int n) {
        this.slotID = n;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public void setExpiryShow(boolean bl) {
        this.expiryShow = bl;
    }

    public boolean getExpiryShow() {
        return this.expiryShow;
    }

    public void setExpiryTime(int n) {
        this.expiryTime = n;
    }

    public int getExpiryTime() {
        return this.expiryTime;
    }

    public Calendar getCalculatedExpiry() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, this.expiryTime);
        return calendar;
    }
}

