/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.cli.CLICertificateInfo;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreManager;
import com.ibm.gsk.ikeyman.ikeycmd;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IssuerAlternativeNameExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.PolicyConstraintsExtension;
import com.ibm.security.x509.PolicyMappingsExtension;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class CLIKeyStoreCertificateManager
implements CLIConstants {
    public static void create(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.create.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.create.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.create.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.dn.getCommonName();
        String string4 = cLICertificateInfo.dn.getOrgUnit();
        String string5 = cLICertificateInfo.dn.getOrg();
        String string6 = cLICertificateInfo.dn.getLocality();
        String string7 = cLICertificateInfo.dn.getState();
        String string8 = cLICertificateInfo.dn.getZipCode();
        String string9 = cLICertificateInfo.dn.getCountry();
        String string10 = cLICertificateInfo.dn.getEmail();
        Vector vector = cLICertificateInfo.dn.getOptions();
        DNItem dNItem = new DNItem(string3, string4, string5, string6, string7, string8, string9, null, null);
        int n2 = cLICertificateInfo.getVersion();
        String string11 = cLICertificateInfo.getLabel();
        boolean bl = cLICertificateInfo.getDefault();
        int n3 = cLICertificateInfo.getKeySize();
        long l2 = cLICertificateInfo.getExpire();
        String string12 = cLICertificateInfo.getFileName();
        boolean bl2 = cLICertificateInfo.getFormat();
        keyStoreManager.open();
        ikeycmd.debugMsg("calling createNewSelfSignedCertificate with parms: \n \nversion: " + n2 + " \nlabel: " + string11 + " \nset as default: " + bl + " \nkeySize: " + n3 + " \nexpire: " + l2 + " \ncertFileName: " + string12 + " \nis base 64 armored: " + bl2);
        ikeycmd.debugMsg("\n");
        try {
            Vector vector2 = keyStoreManager.getMyCertLabelList();
            if (vector2 != null) {
                if (keyStoreManager.getType() == 2) {
                    Enumeration enumeration = vector2.elements();
                    Vector<String> vector3 = new Vector<String>();
                    while (enumeration.hasMoreElements()) {
                        String string13 = enumeration.nextElement().toString();
                        vector3.add(CLIKeyStoreManager.getMSTrimString(string13, keyStoreManager.getType(), 1));
                    }
                    if (vector3 != null && vector3.contains(string11)) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                        System.exit(1);
                    }
                } else if (vector2.contains(string11)) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                    System.exit(1);
                }
            }
            if (keyStoreManager.getReqKeyLabelList() != null && keyStoreManager.getReqKeyLabelList().size() > 0 && keyStoreManager.getReqKeyLabelList().contains(string11)) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                System.exit(1);
            }
            if (keyStoreManager.getCaCertLabelList() != null && keyStoreManager.getCaCertLabelList().size() > 0 && keyStoreManager.getCaCertLabelList().contains(string11)) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                System.exit(1);
            }
            keyStoreManager.createNewSelfSignedCertificate(n2, string11, bl, n3, dNItem, (int)l2, CLIKeyStoreCertificateManager.signatureAlg(), string12, bl2, new Vector());
            keyStoreManager.close();
            ikeycmd.debugMsg("returned from create self sign ok\n");
        }
        catch (KMException kMException) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_NEW_SSCERT"));
            System.exit(1);
        }
    }

    public static void receive(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.receive.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.receive.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.receive.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getFileName();
        boolean bl = cLICertificateInfo.getFormat();
        boolean bl2 = cLICertificateInfo.getDefault();
        keyStoreManager.open();
        ikeycmd.debugMsg("Calling receive with params: ");
        ikeycmd.debugMsg("filename: " + string3);
        ikeycmd.debugMsg("format: " + bl);
        ikeycmd.debugMsg("default: " + bl2);
        ikeycmd.debugMsg("\n");
        keyStoreManager.receiveCertificate(string3, bl, bl2);
        ikeycmd.debugMsg("returned from receive a cert ok\n");
        keyStoreManager.close();
    }

    public static void add(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.add.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.add.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.add.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        String string4 = cLICertificateInfo.getFileName();
        boolean bl = cLICertificateInfo.getFormat();
        keyStoreManager.open();
        ikeycmd.debugMsg("Calling addCACertificate(" + string3 + ", " + string4 + "' " + bl + ")\n");
        keyStoreManager.addCACertificate(string3, string4, bl);
        ikeycmd.debugMsg("returned from receive a CA cert ok\n");
        keyStoreManager.close();
    }

    public static void list(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        Object object;
        Object object2;
        Vector vector;
        cLICertificateInfo.init();
        Vector vector2 = null;
        String string = null;
        KeyItem keyItem = null;
        String string2 = "      ";
        String string3 = cLICertificateInfo.cliDb.getName();
        String string4 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        boolean bl = cLICertificateInfo.cliDb.getExpiryShow();
        int n2 = cLICertificateInfo.cliDb.getExpiryTime();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.list.KeyDbFileName: " + string3);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.list.keyDbPassword: " + string4);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.list.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string3, string4, l);
        keyStoreManager.open();
        String string5 = cLICertificateInfo.getList();
        if (string5.equalsIgnoreCase("all")) {
            int n3;
            vector2 = new Vector();
            Vector vector3 = keyStoreManager.getCaCertLabelList();
            vector = keyStoreManager.getSiteCertLabelList();
            object2 = keyStoreManager.getMyCertLabelList();
            if (vector3 != null) {
                n3 = 0;
                while (n3 < vector3.size()) {
                    object = (String)vector3.elementAt(n3);
                    vector2.addElement(object);
                    ++n3;
                }
            }
            if (vector != null) {
                n3 = 0;
                while (n3 < vector.size()) {
                    object = (String)vector.elementAt(n3);
                    vector2.addElement(object);
                    ++n3;
                }
            }
            if (object2 != null) {
                n3 = 0;
                while (n3 < ((Vector)object2).size()) {
                    object = (String)((Vector)object2).elementAt(n3);
                    vector2.addElement(object);
                    ++n3;
                }
            }
        } else if (string5.equalsIgnoreCase("CA")) {
            vector2 = keyStoreManager.getCaCertLabelList();
        } else if (string5.equalsIgnoreCase("site")) {
            if (n == 1) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_CMS_NO_GOOD"));
            }
            vector2 = keyStoreManager.getSiteCertLabelList();
        } else if (string5.equalsIgnoreCase("personal")) {
            vector2 = keyStoreManager.getMyCertLabelList();
        }
        if (vector2 == null || vector2.size() == 0) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
        }
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_LIST_MSG") + " " + string3);
        int n4 = 0;
        while (n4 < vector2.size()) {
            string = (String)vector2.elementAt(n4);
            keyItem = keyStoreManager.getKeyItemByLabel(string);
            if (bl) {
                if (keyItem != null && keyItem.hasCertificate() && (vector = keyItem.getCertificateChain()) != null && vector.size() > 0) {
                    object2 = (CertificateItem)vector.elementAt(0);
                    Date date = ((CertificateItem)object2).getValidNotBefore();
                    object = ((CertificateItem)object2).getValidNotAfter();
                    if (date != null && object != null) {
                        Calendar calendar = cLICertificateInfo.cliDb.getCalculatedExpiry();
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.setTime((Date)object);
                        if (n2 < 0 || calendar2.before(calendar)) {
                            System.out.println("   " + CLIKeyStoreManager.getMSTrimString(string, keyStoreManager.getType(), 3));
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_VALIDITY"));
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_NOT_BEFORE") + ": " + date.toString());
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_NOT_AFTER") + ": " + ((Date)object).toString());
                        }
                    }
                }
            } else {
                System.out.println("   " + CLIKeyStoreManager.getMSTrimString(string, keyStoreManager.getType(), 3));
            }
            ++n4;
        }
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from list cert ok\n");
    }

    public static String getGNValue(GeneralName generalName) throws Exception {
        switch (generalName.getType()) {
            case 4: {
                return "X500Name: " + generalName.toString();
            }
            case 2: {
                return generalName.toString();
            }
            case 5: {
                return generalName.toString();
            }
            case 7: {
                return generalName.toString();
            }
            case 8: {
                return generalName.toString();
            }
            case 1: {
                return generalName.toString();
            }
            case 6: {
                return generalName.toString();
            }
            case 3: {
                return generalName.toString();
            }
        }
        return " OtherName: " + generalName.toString();
    }

    public static void moreDetails(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        KeyStoreManager keyStoreManager;
        block93: {
            block92: {
                ObjectIdentifier objectIdentifier;
                Object object;
                Object object2;
                X509CertImpl x509CertImpl;
                String string;
                String string2;
                String string3;
                block94: {
                    Object object3;
                    Object[] objectArray;
                    Object object4;
                    String string4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    string3 = "  ";
                    string2 = "    ";
                    string = "      ";
                    String string5 = "        ";
                    cLICertificateInfo.init();
                    String string6 = cLICertificateInfo.cliDb.getName();
                    String string7 = cLICertificateInfo.cliDb.getPassword();
                    int n = cLICertificateInfo.cliDb.getDbType();
                    long l = cLICertificateInfo.cliDb.getExpire();
                    ikeycmd.debugMsg("CLIKeyStoreCertificateManager.moredetails.CLIKeyStoreCertificateManager: moreDetails()");
                    ikeycmd.debugMsg("CLIKeyStoreCertificateManager.moredetails.KeyDbFileName: " + string6);
                    ikeycmd.debugMsg("CLIKeyStoreCertificateManager.moredetails.keyDbPassword: " + string7);
                    ikeycmd.debugMsg("CLIKeyStoreCertificateManager.moredetails.keyDbType:  " + n);
                    ikeycmd.debugMsg("\n");
                    keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string6, string7, l);
                    String string8 = cLICertificateInfo.getLabel();
                    KeyItem keyItem = null;
                    keyStoreManager.open();
                    if (keyStoreManager.getType() == 2) {
                        object8 = null;
                        object8 = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getMyCertLabelList(), string8);
                        if (object8 == null || ((String)object8).equals("")) {
                            object8 = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getCaCertLabelList(), string8);
                        }
                        string8 = object8;
                    }
                    if ((keyItem = keyStoreManager.getKeyItemByLabel(string8)) == null || !keyItem.hasCertificate()) break block92;
                    System.out.println("\n\n");
                    if (keyItem.getKeyLabel().compareTo(string8) == 0) {
                        System.out.println(ikeycmd.getNLSResString("GUI_LABEL_KEY_LABEL_COLON") + " " + CLIKeyStoreManager.getMSTrimString(keyItem.getKeyLabel(), keyStoreManager.getType(), 3));
                    }
                    System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_TBS_CERT"));
                    object8 = keyItem.getCertificateChain();
                    if (object8 == null || ((Vector)object8).size() <= 0) break block93;
                    CertificateItem certificateItem = (CertificateItem)((Vector)object8).elementAt(0);
                    x509CertImpl = null;
                    try {
                        x509CertImpl = new X509CertImpl(certificateItem.getEncoded());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " X509 V" + x509CertImpl.getVersion());
                    byte[] byArray = x509CertImpl.getSerialNumber().toByteArray();
                    String string9 = null;
                    if (byArray != null && byArray.length > 0) {
                        string9 = CLIKeyStoreCertificateManager.getHexDumpForMoreDetails(byArray);
                    }
                    System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SERIAL") + " " + string9);
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ISSUER"));
                    Principal principal = x509CertImpl.getIssuerDN();
                    X500Name x500Name = new X500Name(principal.getName());
                    int n2 = x500Name.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        object7 = new RDN[n2];
                        object7[n3] = x500Name.getRDN(n3);
                        int n4 = object7[n3].size();
                        int n5 = 0;
                        while (n5 < n4) {
                            String string10;
                            String string11;
                            object6 = new AVA[n4];
                            object6[n5] = object7[n3].getAVA(n5);
                            object5 = object6[n5].getOID();
                            string4 = CLIKeyStoreCertificateManager.getAttributeName((ObjectIdentifier)object5);
                            System.out.println(string + string4);
                            if (object5 != null) {
                                string11 = object5.toString();
                                string10 = object6[n5].getValue();
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + string11);
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + string10);
                            } else {
                                string11 = object6[n5].toString();
                                string10 = object6[n5].getValue();
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + string11);
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + string10);
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_VALIDITY"));
                    object7 = x509CertImpl.getNotBefore();
                    String string12 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format((Date)object7);
                    Date date = x509CertImpl.getNotAfter();
                    object6 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date);
                    if (object7 != null && date != null) {
                        System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_NOT_BEFORE") + ": " + string12);
                        System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_NOT_AFTER") + ": " + (String)object6);
                    }
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT"));
                    object5 = x509CertImpl.getSubjectDN();
                    string4 = new X500Name(object5.getName());
                    int n6 = string4.size();
                    int n7 = 0;
                    while (n7 < n6) {
                        object4 = new RDN[n6];
                        object4[n7] = string4.getRDN(n7);
                        int n8 = object4[n7].size();
                        int n9 = 0;
                        while (n9 < n8) {
                            objectArray = new AVA[n8];
                            objectArray[n9] = object4[n7].getAVA(n9);
                            object3 = objectArray[n9].getOID();
                            object2 = CLIKeyStoreCertificateManager.getAttributeName(object3);
                            System.out.println(string + (String)object2);
                            if (null != object3) {
                                object = object3.toString();
                                objectIdentifier = objectArray[n9].getValue();
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object);
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + (String)objectIdentifier);
                            } else {
                                object = objectArray[n9].toString();
                                objectIdentifier = objectArray[n9].getValue();
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object);
                                System.out.println(string5 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + (String)objectIdentifier);
                            }
                            ++n9;
                        }
                        ++n7;
                    }
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"));
                    object4 = null;
                    object4 = x509CertImpl.getPublicKey();
                    DerValue derValue = new DerValue(object4.getEncoded());
                    AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValue.getData().getDerValue());
                    objectArray = null;
                    objectArray = object4.getEncoded();
                    if (algorithmId != null) {
                        object3 = algorithmId.getOID();
                        if (object3 != null && (object2 = object3.toString()) != null && ((String)object2).length() > 0) {
                            System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + (String)object2);
                        }
                        object2 = null;
                        if (null == algorithmId.getAlgParameters()) {
                            System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                        } else {
                            try {
                                object2 = CLIKeyStoreCertificateManager.getHexDumpWithASCII(algorithmId.getParameters());
                                if (object2 != null && ((String)object2).length() > 0) {
                                    System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + (String)object2);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (objectArray != null && objectArray.length > 0) {
                        object3 = CLIKeyStoreCertificateManager.getHexDumpForMoreDetails((byte[])objectArray);
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY") + ":\n" + string + (String)object3);
                    }
                    object3 = null;
                    try {
                        object2 = new DerValue(x509CertImpl.getEncoded());
                        object = object2.getData().getDerValue();
                        objectIdentifier = new X509CertInfo((DerValue)object);
                        object3 = (CertificateExtensions)objectIdentifier.get("extensions");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object3 == null) break block94;
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_EXTENSIONS"));
                    object2 = object3.getAllExtensions();
                    object = object2.iterator();
                    objectIdentifier = new Extension[object2.size()];
                    int n10 = 0;
                    while (object.hasNext()) {
                        objectIdentifier[n10] = (Extension)object.next();
                        ++n10;
                    }
                    int n11 = 0;
                    while (n11 < object2.size()) {
                        String string13;
                        int n12;
                        String string14;
                        block91: {
                            block95: {
                                ObjectIdentifier objectIdentifier2 = objectIdentifier[n11];
                                String string15 = "";
                                String string16 = "";
                                ObjectIdentifier objectIdentifier3 = null;
                                String string17 = "";
                                string14 = "";
                                n12 = 0;
                                boolean bl = false;
                                String string18 = ikeycmd.getNLSResString("GUI_LABEL_EXTNID");
                                String string19 = ikeycmd.getNLSResString("GUI_LABEL_CRITICAL");
                                string13 = ikeycmd.getNLSResString("GUI_LABEL_EXTNVALUE");
                                objectIdentifier3 = objectIdentifier2.getExtensionId();
                                string15 = objectIdentifier3.toString();
                                string16 = string15;
                                if (string16.equals("2.5.29.9")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_DIRECTORY_ATTRIBUTES");
                                    n12 = 9;
                                } else if (string16.equals("2.5.29.14")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_KEY_IDENTIFIER");
                                    n12 = 14;
                                } else if (string16.equals("2.5.29.15")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_KEY_USAGE");
                                    n12 = 15;
                                } else if (string16.equals("2.5.29.16")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_PRIVATE_KEY_USAGE_PERIOD");
                                    n12 = 16;
                                } else if (string16.equals("2.5.29.17")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_ALTERNATIVE_NAME");
                                    n12 = 17;
                                } else if (string16.equals("2.5.29.18")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_ISSUER_ALTERNATIVE_NAMES");
                                    n12 = 18;
                                } else if (string16.equals("2.5.29.19")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_BASIC_CONSTRAINTS");
                                    n12 = 19;
                                } else if (string16.equals("2.5.29.30")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_NAME_CONSTRAINTS");
                                    n12 = 30;
                                } else if (string16.equals("2.5.29.31")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_CRL_DISTRIBUTION_POINTS");
                                    n12 = 31;
                                } else if (string16.equals("2.5.29.32")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_CERTIFICATE_POLICIES");
                                    n12 = 32;
                                } else if (string16.equals("2.5.29.33")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_POLICY_MAPPINGS");
                                    n12 = 33;
                                } else if (string16.equals("2.5.29.35")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_AUTH_KEY_ID");
                                    n12 = 35;
                                } else if (string16.equals("2.5.29.36")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_POLICY_CONSTRAINTS");
                                    n12 = 36;
                                } else if (string16.equals("2.5.29.37")) {
                                    string16 = ikeycmd.getNLSResString("GUI_LABEL_EXT_KEY_USAGE_FIELD");
                                    n12 = 37;
                                }
                                System.out.println(string + string16);
                                System.out.println(string5 + string18 + ": " + string15);
                                string17 = objectIdentifier2.isCritical() ? ikeycmd.getNLSResString("GUI_LABEL_TRUE") : ikeycmd.getNLSResString("GUI_LABEL_FALSE");
                                System.out.println(string5 + string19 + ": " + string17);
                                if (bl) break block95;
                                Vector vector = null;
                                switch (n12) {
                                    case 9: {
                                        break;
                                    }
                                    case 14: {
                                        try {
                                            vector = (GeneralNames)((SubjectKeyIdentifierExtension)objectIdentifier2).get("key_id");
                                        }
                                        catch (IOException iOException) {
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (vector != null) {
                                            string14 = vector.toString();
                                            break;
                                        }
                                        break block91;
                                    }
                                    case 15: {
                                        string14 = ((KeyUsageExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 16: {
                                        string14 = ((PrivateKeyUsageExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 17: {
                                        try {
                                            Object object9;
                                            vector = (GeneralNames)((SubjectAlternativeNameExtension)objectIdentifier2).get("subject_name");
                                            String string20 = string13;
                                            if (vector.size() > 1) {
                                                object9 = new char[string13.length() + 2];
                                                Arrays.fill(object9, ' ');
                                                string20 = new String((char[])object9);
                                            }
                                            n11 = 0;
                                            while (n11 < vector.size()) {
                                                object9 = (GeneralName)vector.elementAt(n11);
                                                if (n11 != 0) {
                                                    System.out.println(string5 + string20 + CLIKeyStoreCertificateManager.getGNValue((GeneralName)object9));
                                                } else {
                                                    System.out.println(string5 + string13 + ": " + CLIKeyStoreCertificateManager.getGNValue((GeneralName)object9));
                                                }
                                                ++n11;
                                            }
                                            break block91;
                                        }
                                        catch (Exception exception) {}
                                        break block91;
                                    }
                                    case 18: {
                                        try {
                                            vector = (GeneralNames)((IssuerAlternativeNameExtension)objectIdentifier2).get("issuer_name");
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        string14 = vector.toString();
                                        break;
                                    }
                                    case 19: {
                                        string14 = ((BasicConstraintsExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 30: {
                                        string14 = ((NameConstraintsExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 31: {
                                        string14 = ((CRLDistributionPointsExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 32: {
                                        break;
                                    }
                                    case 33: {
                                        string14 = ((PolicyMappingsExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 35: {
                                        string14 = ((AuthorityKeyIdentifierExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 36: {
                                        string14 = ((PolicyConstraintsExtension)objectIdentifier2).toString();
                                        break;
                                    }
                                    case 37: {
                                        break;
                                    }
                                }
                                break block91;
                            }
                            string14 = ikeycmd.getNLSResString("GUI_LABEL_INFO_NOT_VALID_ERROR");
                        }
                        if (n12 != 17) {
                            System.out.println(string5 + string13 + ": " + string14);
                        }
                        ++n11;
                    }
                }
                object2 = AlgorithmId.get((String)x509CertImpl.getSigAlgName());
                object = x509CertImpl.getSignature();
                System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_SIG_ALG"));
                if (object2 != null) {
                    String string21;
                    objectIdentifier = object2.getOID();
                    if (objectIdentifier != null && (string21 = objectIdentifier.toString()) != null && string21.length() > 0) {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string21);
                    }
                    String string22 = null;
                    if (null == object2.getAlgParameters()) {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                    } else {
                        try {
                            string22 = CLIKeyStoreCertificateManager.getHexDumpWithASCII(object2.getParameters());
                            if (string22 != null && string22.length() > 0) {
                                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string22);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (object != null) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SIG_VALUE") + ":\n" + string + CLIKeyStoreCertificateManager.getHexDumpForMoreDetails((byte[])object));
                }
                System.out.println("\n");
                break block93;
            }
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL"));
            System.exit(1);
        }
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from show more details cert ok\n");
    }

    private static String getAttributeName(ObjectIdentifier objectIdentifier) {
        String string = null;
        if (objectIdentifier != null) {
            string = objectIdentifier.equals(X500Name.commonName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_COMMON_NAME") : (objectIdentifier.equals(X500Name.serialNumber_oid) ? ikeycmd.getNLSResString("GUI_LABEL_SERIALNO") : (objectIdentifier.equals(X500Name.countryName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_COUNTRY") : (objectIdentifier.equals(X500Name.localityName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_LOCALITY") : (objectIdentifier.equals(X500Name.stateName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_STATE") : (objectIdentifier.equals(X500Name.streetAddress_oid) ? ikeycmd.getNLSResString("GUI_LABEL_STREET") : (objectIdentifier.equals(X500Name.orgName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_ORG") : (objectIdentifier.equals(X500Name.orgUnitName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_ORG_UNIT") : (objectIdentifier.equals(X500Name.title_oid) ? ikeycmd.getNLSResString("GUI_LABEL_TITLE2") : (objectIdentifier.equals(X500Name.postalCode_oid) ? ikeycmd.getNLSResString("GUI_LABEL_ZIPCODE") : (objectIdentifier.equals(X500Name.emailAddress_oid) ? ikeycmd.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : objectIdentifier.toString()))))))))));
        }
        return string;
    }

    private static String getHexDumpWithASCII(byte[] byArray) {
        String string = new String("");
        if (byArray != null && byArray.length > 0) {
            String string2 = new String("");
            String string3 = new String("");
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                int n3 = 0;
                n3 = n + 16 <= byArray.length ? 16 : byArray.length % 16;
                byte[] byArray2 = new byte[n3];
                string3 = "";
                n2 = 0;
                while (n2 < byArray2.length) {
                    byArray2[n2] = byArray[n + n2];
                    string3 = byArray2[n2] < 0 || Character.getType((char)byArray2[n2]) == 15 ? string3 + "." : string3 + (char)byArray2[n2];
                    ++n2;
                }
                string2 = CLIKeyStoreCertificateManager.getHexDumpForMoreDetails(byArray2);
                string = string + string2;
                if (byArray2.length % 16 != 0) {
                    n2 = 0;
                    while (n2 < 16 - byArray2.length % 16) {
                        string = string + "   ";
                        ++n2;
                    }
                }
                string = string + "    " + string3;
                if (n + n3 < byArray.length) {
                    string = string + "\n";
                }
                n += n3;
            }
        }
        return string;
    }

    private static String getHexDumpForMoreDetails(byte[] byArray) {
        String string = new String("");
        String string2 = "      ";
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n" + string2;
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    public static void details(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        Object object;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.details.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.details.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.details.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        KeyItem keyItem = null;
        keyStoreManager.open();
        if (keyStoreManager.getType() == 2) {
            object = null;
            object = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getMyCertLabelList(), string3);
            if (object == null || ((String)object).equals("")) {
                object = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getCaCertLabelList(), string3);
            }
            string3 = object;
        }
        if ((keyItem = keyStoreManager.getKeyItemByLabel(string3)) != null && keyItem.hasCertificate()) {
            System.out.println("\n\n");
            if (keyItem.getKeyLabel().compareTo(string3) == 0) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_LABEL") + " " + CLIKeyStoreManager.getMSTrimString(keyItem.getKeyLabel(), keyStoreManager.getType(), 3));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_KEYSIZE") + " " + keyItem.getKeySize());
            }
            if ((object = keyItem.getCertificateChain()) != null && ((Vector)object).size() > 0) {
                String string4;
                String string5;
                Object object2;
                Object object3;
                DNItem dNItem;
                CertificateItem certificateItem = (CertificateItem)((Vector)object).elementAt(0);
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " X509 V" + certificateItem.getVersion());
                try {
                    dNItem = new X509CertImpl(certificateItem.getEncoded());
                    object3 = dNItem.getSerialNumber().toByteArray();
                    if (object3 != null && ((byte[])object3).length > 0) {
                        object2 = CLIKeyStoreCertificateManager.getHexDumpForMoreDetails((byte[])object3);
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SERIAL") + " " + (String)object2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dNItem = certificateItem.getIssuer();
                if (dNItem != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_ISSUER") + " " + dNItem.toStringWithoutTag());
                }
                if ((object3 = (Object)certificateItem.getSubject()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SUBJECT") + " " + ((DNItem)object3).toStringWithoutTag());
                }
                object2 = certificateItem.getValidNotBefore();
                String string6 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format((Date)object2);
                Date date = certificateItem.getValidNotAfter();
                String string7 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date);
                if (object2 != null && date != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VALID") + " " + string6 + " " + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_TO") + " " + string7);
                }
                if ((string5 = certificateItem.getFingerPrint()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_FINGER") + " " + string5);
                }
                if ((string4 = certificateItem.getSigAlgorithmIdOID()) != null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_SIG") + " " + string4);
                }
                if (keyItem.isTrusted()) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_ENABLED"));
                } else {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_DISABLED"));
                }
                System.out.println("\n");
            }
        } else {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_GET_KEY_BY_LABEL"));
            System.exit(1);
        }
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from show details cert ok\n");
    }

    public static void delete(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.delete.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.delete.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.delete.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        keyStoreManager.open();
        if (keyStoreManager.getType() == 2) {
            String string4 = null;
            string4 = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getMyCertLabelList(), string3);
            if (string4 == null || string4.equals("")) {
                string4 = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getCaCertLabelList(), string3);
            }
            string3 = string4;
        }
        if (string3 == null || string3.equals("")) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_KEYDB_NULL"));
        }
        ikeycmd.debugMsg("Deleteing Label: " + string3 + "\n");
        keyStoreManager.deleteKeyByLabel(string3);
        keyStoreManager.close();
    }

    public static void modify(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.modify.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.modify.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.modify.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        boolean bl = cLICertificateInfo.getTrust();
        String string3 = cLICertificateInfo.getLabel();
        keyStoreManager.open();
        ikeycmd.debugMsg("Calling setKeyTrust(" + string3 + ", " + bl + ")\n");
        Vector vector = keyStoreManager.getMyCertLabelList();
        if (vector != null && vector.contains(string3)) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_TRUST_STATUS_NOT_APPLY"));
        } else {
            keyStoreManager.setKeyTrust(string3, bl);
        }
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from modify cert ok\n");
    }

    public static void importCert(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        String[] stringArray;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.databaseName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.databasePassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.dbType:  " + n);
        ikeycmd.debugMsg("\n");
        String string3 = cLICertificateInfo.getTargetDb();
        String string4 = cLICertificateInfo.getTargetPassword();
        int n2 = cLICertificateInfo.getTargetDbType();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.KeyDbFileName: " + string3);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.keyDbPassword: " + string4);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.keyDbType:  " + n2);
        ikeycmd.debugMsg("\n");
        String string5 = cLICertificateInfo.getLabel();
        int n3 = cLICertificateInfo.getEncryption();
        boolean bl = cLICertificateInfo.getFormat();
        String[] stringArray2 = null;
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.importCert.label:  " + string5);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        KeyStoreManager keyStoreManager2 = CLIKeyStoreManager.makeKeyDatabase(n2, string3, string4, 0L);
        keyStoreManager.open();
        keyStoreManager2.open();
        if (n == 8 || string5 == null) {
            stringArray = new String[keyStoreManager.getKeyLabelList().size()];
            int n4 = 0;
            Enumeration enumeration = keyStoreManager.getKeyLabelList().elements();
            while (enumeration.hasMoreElements()) {
                stringArray[n4] = enumeration.nextElement().toString();
                ++n4;
            }
            stringArray2 = stringArray;
        } else {
            stringArray = new String[]{string5.toString()};
            stringArray2 = stringArray;
        }
        int n5 = 0;
        while (n5 < stringArray2.length) {
            if (keyStoreManager2.getMyCertLabelList() != null && keyStoreManager2.getMyCertLabelList().size() > 0 && keyStoreManager2.getMyCertLabelList().contains(stringArray2[n5])) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                System.exit(1);
            }
            ++n5;
        }
        if (keyStoreManager2.getReqKeyLabelList() != null && keyStoreManager2.getReqKeyLabelList().size() > 0 && keyStoreManager2.getReqKeyLabelList().contains(string5)) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
            System.exit(1);
        }
        if (keyStoreManager2.getCaCertLabelList() != null && keyStoreManager2.getCaCertLabelList().size() > 0 && keyStoreManager2.getCaCertLabelList().contains(string5)) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
            System.exit(1);
        }
        keyStoreManager2.importKeyFromKeyStore(keyStoreManager, stringArray2, stringArray2);
        keyStoreManager2.close();
        keyStoreManager.close();
    }

    public static void export(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        Object object;
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        String string3 = cLICertificateInfo.getTargetDb();
        String string4 = cLICertificateInfo.getTargetPassword();
        int n2 = cLICertificateInfo.getTargetDbType();
        Object object2 = cLICertificateInfo.getLabel();
        int n3 = cLICertificateInfo.getEncryption();
        boolean bl = cLICertificateInfo.getFormat();
        boolean bl2 = cLICertificateInfo.getDefault();
        String[] stringArray = new String[]{((String)object2).toString()};
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.exportCert.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.exportCert.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.exportCert.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        keyStoreManager.open();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.exportCert.targetFileName: " + string3);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.exportCert.targetPassword: " + string4);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.exportCert.targetDbType:  " + n2);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager2 = CLIKeyStoreManager.makeKeyDatabase(n2, string3, string4, 0L);
        if (n2 != 8) {
            keyStoreManager2.open();
            if (keyStoreManager2.getMyCertLabelList() != null && keyStoreManager2.getMyCertLabelList().size() > 0 && keyStoreManager2.getMyCertLabelList().contains(object2)) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                System.exit(1);
            }
            if (keyStoreManager2.getReqKeyLabelList() != null && keyStoreManager2.getReqKeyLabelList().size() > 0 && keyStoreManager2.getReqKeyLabelList().contains(object2)) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                System.exit(1);
            }
            if (keyStoreManager2.getCaCertLabelList() != null && keyStoreManager2.getCaCertLabelList().size() > 0 && keyStoreManager2.getCaCertLabelList().contains(object2)) {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                System.exit(1);
            }
        } else {
            object = new File(string3);
            try {
                Cipher cipher = Cipher.getInstance("DES", KeyStoreManager.JCEProvider);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                KMUtil.debugMsg("KeyStoreManager::save() 0510-5-1, NoSuchPaddingException=" + noSuchPaddingException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
            }
            catch (NoSuchProviderException noSuchProviderException) {
                KMUtil.debugMsg("KeyStoreManager::save() 0510-5-2, NoSuchProviderException=" + noSuchProviderException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_EXPORT_KEY_TO_PFX"));
            }
            if (!((File)object).exists()) {
                keyStoreManager2.createKeyStoreWithoutIkeymanCaCerts();
            } else {
                keyStoreManager2.open();
            }
        }
        if (keyStoreManager.getType() == 2) {
            object = null;
            object = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getMyCertLabelList(), (String)object2);
            if (object == null || ((String)object).equals("")) {
                object = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getCaCertLabelList(), (String)object2);
            }
            stringArray[0] = object2 = object;
        }
        keyStoreManager.exportKeyToKeyStore(keyStoreManager2, stringArray, null);
        keyStoreManager2.close();
        keyStoreManager.close();
    }

    public static void extract(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.extract.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.extract.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.extract.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        String string4 = cLICertificateInfo.getExtractTarget();
        boolean bl = cLICertificateInfo.getFormat();
        keyStoreManager.open();
        if (keyStoreManager.getType() == 2) {
            String string5 = null;
            string5 = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getMyCertLabelList(), string3);
            if (string5 == null || string5.equals("")) {
                string5 = CLIKeyStoreManager.getMSKeyLabel(keyStoreManager.getCaCertLabelList(), string3);
            }
            string3 = string5;
        }
        ikeycmd.debugMsg("Calling extractCertificate(" + string3 + ", " + string4 + ", " + bl + ")\n");
        keyStoreManager.extractCertificate(string3, string4, bl);
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from modify cert ok\n");
    }

    public static void sign(CLICertificateInfo cLICertificateInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.sign.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.sign.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.sign.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        ikeycmd.debugMsg("Verifying that we have a CMS database\n");
        if (n != 1) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_CLI_ERR_SIGN_DB_TYPE"));
        }
        CMSKeyDatabase cMSKeyDatabase = new CMSKeyDatabase(string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        int n2 = cLICertificateInfo.getVersion();
        cMSKeyDatabase.getKeyDatabaseOperator().open();
        KeyItem keyItem = cMSKeyDatabase.getKeyItemByLabel(string3);
        if (keyItem != null && keyItem.hasCertificate()) {
            Vector vector = keyItem.getCertificateChain();
            if (vector != null && vector.size() > 0) {
                CertificateItem certificateItem = (CertificateItem)vector.elementAt(0);
                String string4 = certificateItem.getSerialNumber();
                int n3 = (int)cLICertificateInfo.getExpire();
                String string5 = cLICertificateInfo.getTargetDb();
                String string6 = cLICertificateInfo.getFileName();
                boolean bl = cLICertificateInfo.getFormat();
                ikeycmd.debugMsg("Calling issueCertificate with params: ");
                ikeycmd.debugMsg("label: " + string3 + " \nversion: " + n2 + " \nserialNumber: " + string4 + " \nexpire: " + n3 + " \ntarget: " + string5 + " \ncertFileName: " + string6 + " \nis base 64 armored: " + bl + "\n");
                cMSKeyDatabase.issueCertificate(string3, n2, string4, n3, string6, string5, bl);
                cMSKeyDatabase.getKeyDatabaseOperator().close();
            }
        } else {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
        }
    }

    public static void setDefault(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.setDefault.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.setDefault.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.setDefault.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLICertificateInfo.getLabel();
        keyStoreManager.open();
        ikeycmd.debugMsg("Calling setDefaultKey(" + string3 + ")\n");
        keyStoreManager.setDefaultKey(string3);
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from setDefault ok\n");
    }

    public static void getDefault(CLICertificateInfo cLICertificateInfo) throws KeyStoreManagerException, KMException, Exception {
        cLICertificateInfo.init();
        String string = cLICertificateInfo.cliDb.getName();
        String string2 = cLICertificateInfo.cliDb.getPassword();
        int n = cLICertificateInfo.cliDb.getDbType();
        long l = cLICertificateInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.getDefault.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.getDefault.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreCertificateManager.getDefault.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        keyStoreManager.open();
        KeyItem keyItem = keyStoreManager.getDefaultKeyItem();
        String string3 = keyItem.getKeyLabel();
        ikeycmd.debugMsg("Calling setLabel(" + string3 + ")\n");
        cLICertificateInfo.setLabel(string3);
        CLIKeyStoreCertificateManager.details(cLICertificateInfo);
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from getDefault ok\n");
    }

    public static int signatureAlg() {
        int n = KMSystem.getDefaultSignatureAlg();
        ikeycmd.debugMsg("254 CLI message returned check for slected algorithm= " + n);
        return n;
    }
}

