/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Fragment;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.ProjectionDocument;
import org.eclipse.jface.text.ProjectionPosition;
import org.eclipse.jface.text.Region;

public class CoordinatesTranslator
implements IDocumentInformationMapping {
    private IDocument fParentDocument;
    private String fParentCategory;
    private ProjectionDocument fProjectionDocument;
    private String fProjectionCategory;

    public CoordinatesTranslator(IDocument parent, String parentCategory, ProjectionDocument projection, String projectionCategory) {
        this.fParentDocument = parent;
        this.fParentCategory = parentCategory;
        this.fProjectionDocument = projection;
        this.fProjectionCategory = projectionCategory;
    }

    public int toOriginOffset(int imageOffset) throws BadLocationException {
        Fragment fragment = (Fragment)this.getPositionOfOffset(this.fProjectionDocument, "__fragment_category", imageOffset);
        if (fragment == null) {
            if (imageOffset == 0) {
                return 0;
            }
            throw new BadLocationException();
        }
        int relative = imageOffset - fragment.offset;
        return fragment.getOrigin().offset + relative;
    }

    public IRegion toOriginRegion(IRegion imageRegion) throws BadLocationException {
        int projectionOffset = imageRegion.getOffset();
        int projectionLength = imageRegion.getLength();
        if (projectionLength == 0) {
            if (projectionOffset == 0 && projectionLength == this.fProjectionDocument.getLength()) {
                return new Region(0, this.fParentDocument.getLength());
            }
            return new Region(this.toOriginOffset(projectionOffset), 0);
        }
        int o1 = this.toOriginOffset(projectionOffset);
        int o2 = this.toOriginOffset(projectionOffset + projectionLength - 1);
        return new Region(o1, o2 - o1 + 1);
    }

    public IRegion toOriginLines(int imageLine) throws BadLocationException {
        IRegion projectionDocumentRegion = this.fProjectionDocument.getLineInformation(imageLine);
        IRegion parentDocumentRegion = this.toOriginRegion(projectionDocumentRegion);
        int startLine = this.fParentDocument.getLineOfOffset(parentDocumentRegion.getOffset());
        if (parentDocumentRegion.getLength() == 0) {
            return new Region(startLine, 0);
        }
        int endLine = this.fParentDocument.getLineOfOffset(parentDocumentRegion.getOffset() + parentDocumentRegion.getLength() - 1);
        return new Region(startLine, endLine - startLine);
    }

    public int toOriginLine(int imageLine) throws BadLocationException {
        IRegion lines = this.toOriginLines(imageLine);
        if (lines.getLength() > 0) {
            throw new IllegalStateException();
        }
        return lines.getOffset();
    }

    public int toImageOffset(int originOffset) throws BadLocationException {
        ProjectionPosition projection = (ProjectionPosition)this.getPositionOfOffset(this.fParentDocument, "__projectiondocuments", originOffset);
        if (projection != null) {
            return this.translateOffset(projection, originOffset, projection.getFragment());
        }
        return -1;
    }

    public IRegion toImageRegion(IRegion originRegion) throws BadLocationException {
        if (originRegion.getLength() == 0) {
            int projectionOffset = this.toImageOffset(originRegion.getOffset());
            return projectionOffset == -1 ? null : new Region(projectionOffset, 0);
        }
        Position[] positions = this.getPositionsOfRange(this.fParentDocument, "__projectiondocuments", originRegion, null);
        if (positions != null && positions.length > 0) {
            ProjectionPosition projection = (ProjectionPosition)positions[0];
            int offset = originRegion.getOffset();
            int length = originRegion.getLength();
            int delta = projection.getOffset() - offset;
            if (delta > 0) {
                offset += delta;
                length -= delta;
            }
            int start = this.translateOffset(projection, offset, projection.getFragment());
            projection = (ProjectionPosition)positions[positions.length - 1];
            int decrease = 0;
            int endOffset = offset + length;
            if (length > 0) {
                decrease = 1;
            }
            if ((delta = (endOffset -= decrease) - (projection.getOffset() + Math.max(projection.getLength() - 1, 0))) > 0) {
                endOffset -= delta;
            }
            int end = this.translateOffset(projection, endOffset, projection.getFragment());
            return new Region(start, end - start + decrease);
        }
        return null;
    }

    public int toImageLine(int originLine) throws BadLocationException {
        IRegion parentDocumentRegion = this.fParentDocument.getLineInformation(originLine);
        IRegion projectionDocumentRegion = this.toImageRegion(parentDocumentRegion);
        if (projectionDocumentRegion == null) {
            return -1;
        }
        int startLine = this.fProjectionDocument.getLineOfOffset(projectionDocumentRegion.getOffset());
        if (projectionDocumentRegion.getLength() == 0) {
            return startLine;
        }
        int endLine = this.fProjectionDocument.getLineOfOffset(projectionDocumentRegion.getOffset() + projectionDocumentRegion.getLength() - 1);
        if (endLine != startLine) {
            throw new IllegalStateException();
        }
        return startLine;
    }

    private int translateOffset(Position origin, int originOffset, Position target) {
        int relative = originOffset - origin.offset;
        return target.offset + relative;
    }

    private Position getPositionOfOffset(IDocument document, String category, int offset) throws BadLocationException {
        try {
            int index = this.getPositionIndexOfOffset(document, category, offset, 0);
            if (index > -1) {
                Position[] positions = document.getPositions(category);
                return positions[index];
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    private Position[] getPositionsOfRange(IDocument document, String category, IRegion range, Comparator comparator) {
        int offset = range.getOffset();
        int length = range.getLength();
        try {
            int start = this.getPositionIndexOfOffset(document, category, offset, length);
            int end = this.getPositionIndexOfOffset(document, category, offset + length - 1, 1 - length);
            if (start > -1 && end > -1) {
                Position[] positions = document.getPositions(category);
                if (start == end) {
                    return new Position[]{positions[start]};
                }
                Position[] result = new Position[end - start + 1];
                int i = start;
                while (i <= end) {
                    result[i - start] = positions[i];
                    ++i;
                }
                if (comparator != null) {
                    Arrays.sort(result, comparator);
                }
                return result;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return new Position[0];
    }

    private int getPositionIndexOfOffset(IDocument document, String category, int offset, int direction) throws BadPositionCategoryException, BadLocationException {
        Position[] positions = document.getPositions(category);
        if (positions != null && positions.length > 0) {
            int index = document.computeIndexInCategory(category, offset);
            if (index < positions.length && positions[index].includes(offset)) {
                return index;
            }
            if (index > 0 && positions[index - 1].includes(offset)) {
                return index - 1;
            }
            if (direction != 0) {
                if (direction > 0) {
                    if (index < positions.length && positions[index].overlapsWith(offset, direction)) {
                        return index;
                    }
                } else if (index > 0 && positions[index - 1].overlapsWith(offset + direction, -direction)) {
                    return index - 1;
                }
            }
        }
        return -1;
    }

    public IRegion getCoverage() {
        Position coverage = this.fProjectionDocument.getParentDocumentCoverage();
        return new Region(coverage.getOffset(), coverage.getLength());
    }

    public int toClosestImageLine(int originLine) throws BadLocationException {
        try {
            int modelLineOffset = this.fParentDocument.getLineOffset(originLine);
            int index = this.fParentDocument.computeIndexInCategory("__projectiondocuments", modelLineOffset);
            Position[] projections = this.fParentDocument.getPositions("__projectiondocuments");
            if (index < projections.length) {
                int delta2;
                Position p = projections[index - 1];
                int delta1 = modelLineOffset - (p.getOffset() + p.getLength());
                if (delta1 < (delta2 = modelLineOffset - ((p = projections[index]).getOffset() + p.getLength()))) {
                    p = projections[index - 1];
                    originLine = this.fParentDocument.getLineOfOffset(p.getOffset() + Math.max(p.getLength() - 1, 0));
                } else {
                    originLine = this.fParentDocument.getLineOfOffset(p.getOffset());
                }
            } else if (projections.length > 0) {
                Position p = projections[index - 1];
                originLine = this.fParentDocument.getLineOfOffset(p.getOffset() + Math.max(p.getLength() - 1, 0));
            } else {
                return 0;
            }
            return this.toImageLine(originLine);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return 0;
    }
}

