/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.client.runtime;

import java.beans.Beans;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public abstract class AbstractEJBFactory
implements EJBHome {
    private EJBHome ejbHome;
    private InitialContext initialContext;
    private Hashtable initialContextFactoryEnvironment;
    private String jndiName;
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY_NAME = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private static Object INITIAL_CONTEXT_FACTORY_KEY = "java.naming.factory.initial";
    private static final String INITIAL_CONTEXT_FACTORY_PROPERTY = "java.naming.factory.initial";
    public static final String DEFAULT_INITIAL_CONTEXT_PROVIDER_URL = "IIOP:///";
    private static Object INITIAL_CONTEXT_PROVIDER_URL_KEY = "java.naming.provider.url";
    private static final String INITIAL_CONTEXT_PROVIDER_URL_PROPERTY = "java.naming.provider.url";

    public AbstractEJBFactory() {
        this.initialize();
    }

    protected EJBHome _acquireEJBHome() throws RemoteException {
        try {
            return this.acquireEJBHome();
        }
        catch (NamingException namingExc) {
            throw new RemoteException("Cannot acquire home.", namingExc);
        }
    }

    protected EJBHome acquireEJBHome() throws NamingException {
        if (this.ejbHome == null) {
            this.ejbHome = AbstractEJBFactory.lookupEJBHome(this.getHomeInterface(), this.acquireInitialContext(), this.getJNDIName());
        }
        return this.ejbHome;
    }

    public InitialContext acquireInitialContext() throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext(this.getInitialContextFactoryEnvironment());
        }
        return this.initialContext;
    }

    public void addToInitialContextFactoryEnvironment(Object key, Object value) {
        this.resetInitialContext();
        this.getInitialContextFactoryEnvironment().put(key, value);
    }

    protected abstract String getDefaultJNDIName();

    public EJBMetaData getEJBMetaData() throws RemoteException {
        if (Beans.isDesignTime()) {
            return null;
        }
        return this._acquireEJBHome().getEJBMetaData();
    }

    public HomeHandle getHomeHandle() {
        return null;
    }

    protected abstract Class getHomeInterface();

    public Hashtable getInitialContextFactoryEnvironment() {
        if (this.initialContextFactoryEnvironment == null) {
            this.initialContextFactoryEnvironment = new Hashtable(8, 0.075f);
            this.getInitialContextFactoryName();
            this.getInitialContextProviderURL();
        }
        return this.initialContextFactoryEnvironment;
    }

    public String getInitialContextFactoryName() {
        Hashtable env = this.getInitialContextFactoryEnvironment();
        String result = (String)env.get(INITIAL_CONTEXT_FACTORY_KEY);
        if (result == null) {
            result = System.getProperty(INITIAL_CONTEXT_FACTORY_PROPERTY, DEFAULT_INITIAL_CONTEXT_FACTORY_NAME);
            env.put(INITIAL_CONTEXT_FACTORY_KEY, result);
        }
        return result;
    }

    public String getInitialContextProviderURL() {
        Hashtable env = this.getInitialContextFactoryEnvironment();
        String result = (String)env.get(INITIAL_CONTEXT_PROVIDER_URL_KEY);
        if (result == null) {
            result = System.getProperty(INITIAL_CONTEXT_PROVIDER_URL_PROPERTY, DEFAULT_INITIAL_CONTEXT_PROVIDER_URL);
            env.put(INITIAL_CONTEXT_PROVIDER_URL_KEY, result);
        }
        return result;
    }

    public String getJNDIName() {
        if (this.jndiName == null) {
            this.jndiName = this.getDefaultJNDIName();
        }
        return this.jndiName;
    }

    private void initialize() {
        this.reset();
    }

    protected static final synchronized EJBHome lookupEJBHome(Class homeInterface, InitialContext initContext, String jndiName) throws NamingException, ClassCastException {
        EJBHome result = null;
        if (initContext != null) {
            Object nsEntry = initContext.lookup(jndiName);
            result = (EJBHome)PortableRemoteObject.narrow((Object)nsEntry, (Class)homeInterface);
        }
        return result;
    }

    public void remove(Object object) throws RemoteException, RemoveException {
        this._acquireEJBHome().remove(object);
    }

    public void remove(Handle handle) throws RemoteException, RemoveException {
        this._acquireEJBHome().remove(handle);
    }

    public void reset() {
        this.ejbHome = null;
        this.initialContext = null;
        this.initialContextFactoryEnvironment = null;
        this.jndiName = null;
    }

    protected void resetEJBHome() {
        this.ejbHome = null;
    }

    public void resetInitialContext() {
        this.ejbHome = null;
        this.initialContext = null;
    }

    protected void setEJBHome(EJBHome ejbHome) {
        this.resetInitialContext();
        this.ejbHome = ejbHome;
    }

    public void setInitialContext(InitialContext initContext) {
        this.resetInitialContext();
        this.initialContext = initContext;
    }

    public void setInitialContextFactoryEnvironment(Hashtable environment) {
        this.resetInitialContext();
        this.initialContextFactoryEnvironment = environment;
    }

    public void setInitialContextFactoryName(String newFactoryName) {
        this.addToInitialContextFactoryEnvironment(INITIAL_CONTEXT_FACTORY_KEY, newFactoryName);
    }

    public void setInitialContextProviderURL(String newProviderURL) {
        this.addToInitialContextFactoryEnvironment(INITIAL_CONTEXT_PROVIDER_URL_KEY, newProviderURL);
    }

    public void setJNDIName(String newJndiName) {
        this.resetEJBHome();
        this.jndiName = newJndiName;
    }
}

