/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.appserver;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.Platform;

public class PluginClassLoaderWrapper
extends URLClassLoader {
    private ClassLoader pluginLoader;
    private String plugin;

    public PluginClassLoaderWrapper(String plugin) {
        super(new URL[0]);
        ClassLoader pluginLoader;
        this.plugin = plugin;
        this.pluginLoader = pluginLoader = Platform.getPluginRegistry().getPluginDescriptor(plugin).getPluginClassLoader();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.pluginLoader.loadClass(className);
    }

    public URL getResource(String resName) {
        return this.pluginLoader.getResource(resName);
    }

    public URL[] getURLs() {
        ArrayList urlList = new ArrayList();
        this.addAllNoDup(urlList, this.getPluginClasspath("org.eclipse.core.runtime"));
        this.addAllNoDup(urlList, this.getPluginClasspath(this.plugin));
        return urlList.toArray(new URL[urlList.size()]);
    }

    private void addAllNoDup(List set, List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (set.contains(o)) continue;
            set.add(o);
        }
    }

    private List getPluginClasspath(String pluginId) {
        ArrayList<URL> urls = new ArrayList<URL>();
        IPluginDescriptor pd = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        if (pd == null) {
            return urls;
        }
        ClassLoader loader = pd.getPluginClassLoader();
        if (loader instanceof URLClassLoader) {
            URL[] pluginURLs = ((URLClassLoader)loader).getURLs();
            int i = 0;
            while (i < pluginURLs.length) {
                urls.add(pluginURLs[i]);
                ++i;
            }
        }
        urls.addAll(this.getPrereqClasspath(pd));
        return urls;
    }

    private List getPrereqClasspath(IPluginDescriptor plugin) {
        ArrayList<URL> urls = new ArrayList<URL>();
        IPluginPrerequisite[] prereqs = plugin.getPluginPrerequisites();
        int i = 0;
        while (i < prereqs.length) {
            String id = prereqs[i].getUniqueIdentifier();
            IPluginDescriptor pd = Platform.getPluginRegistry().getPluginDescriptor(id);
            ClassLoader loader = pd.getPluginClassLoader();
            URL[] prereqURLs = null;
            if (loader instanceof URLClassLoader) {
                prereqURLs = ((URLClassLoader)loader).getURLs();
            }
            int j = 0;
            while (j < prereqURLs.length) {
                if (new File(prereqURLs[j].getFile()).exists()) {
                    urls.add(prereqURLs[j]);
                }
                ++j;
            }
            ++i;
        }
        return urls;
    }
}

