/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

class AsciiOutputStream
extends OutputStream {
    private boolean breakOnNonAscii;
    private int ascii = 0;
    private int non_ascii = 0;
    private int linelen = 0;
    private boolean longLine = false;
    private int ret = 0;

    public AsciiOutputStream(boolean bl) {
        this.breakOnNonAscii = bl;
    }

    public void write(int n) throws IOException {
        this.check(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        n2 += n;
        int n3 = n;
        while (n3 < n2) {
            this.check(byArray[n3]);
            ++n3;
        }
    }

    private final void check(int n) throws IOException {
        if ((n &= 0xFF) == 13 || n == 10) {
            this.linelen = 0;
        } else {
            ++this.linelen;
            if (this.linelen > 998) {
                this.longLine = true;
            }
        }
        if (n > 127) {
            ++this.non_ascii;
            if (this.breakOnNonAscii) {
                this.ret = 3;
                throw new EOFException();
            }
        } else {
            ++this.ascii;
        }
    }

    public int getAscii() {
        if (this.ret != 0) {
            return this.ret;
        }
        if (this.non_ascii == 0) {
            if (this.longLine) {
                return 2;
            }
            return 1;
        }
        if (this.ascii > this.non_ascii) {
            return 2;
        }
        return 3;
    }
}

