/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    protected String address;
    protected String personal;
    protected String encodedPersonal;
    private static final String rfc822phrase = "()<>@,;:\\\"\t .[]".replace(' ', '\u0000').replace('\t', '\u0000');
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    public InternetAddress() {
    }

    public InternetAddress(String string) throws AddressException {
        InternetAddress[] internetAddressArray = InternetAddress.parse(string, true);
        if (internetAddressArray.length != 1) {
            throw new AddressException("Illegal address", string);
        }
        this.address = internetAddressArray[0].address;
        this.personal = internetAddressArray[0].personal;
        this.encodedPersonal = internetAddressArray[0].encodedPersonal;
    }

    private InternetAddress(String string, boolean bl) throws AddressException {
        this(string);
        if (bl) {
            InternetAddress.checkAddress(this.address, true, true);
        }
    }

    public InternetAddress(String string, String string2) throws UnsupportedEncodingException {
        this(string, string2, null);
    }

    public InternetAddress(String string, String string2, String string3) throws UnsupportedEncodingException {
        this.address = string;
        this.setPersonal(string2, string3);
    }

    public Object clone() {
        InternetAddress internetAddress = null;
        try {
            internetAddress = (InternetAddress)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return internetAddress;
    }

    public String getType() {
        return "rfc822";
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setPersonal(String string, String string2) throws UnsupportedEncodingException {
        this.personal = string;
        this.encodedPersonal = string != null ? MimeUtility.encodeWord(string, string2, null) : null;
    }

    public void setPersonal(String string) throws UnsupportedEncodingException {
        this.personal = string;
        this.encodedPersonal = string != null ? MimeUtility.encodeWord(string) : null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        if (this.personal != null) {
            return this.personal;
        }
        if (this.encodedPersonal != null) {
            try {
                this.personal = MimeUtility.decodeText(this.encodedPersonal);
                return this.personal;
            }
            catch (Exception exception) {
                return this.encodedPersonal;
            }
        }
        return null;
    }

    public String toString() {
        if (this.encodedPersonal == null && this.personal != null) {
            try {
                this.encodedPersonal = MimeUtility.encodeWord(this.personal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.encodedPersonal != null) {
            return InternetAddress.quotePhrase(this.encodedPersonal) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    public String toUnicodeString() {
        if (this.getPersonal() != null) {
            return InternetAddress.quotePhrase(this.personal) + " <" + this.address + ">";
        }
        if (this.isGroup() || this.isSimple()) {
            return this.address;
        }
        return "<" + this.address + ">";
    }

    private static String quotePhrase(String string) {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\\') {
                StringBuffer stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append('\"');
                int n3 = 0;
                while (n3 < n) {
                    char c2 = string.charAt(n3);
                    if (c2 == '\"' || c2 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    ++n3;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c < ' ' && c != '\r' && c != '\n' && c != '\t' || c >= '\u007f' || rfc822phrase.indexOf(c) >= 0) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && (string = string.substring(1, string.length() - 1)).indexOf(92) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\\' && n < string.length() - 1) {
                    c = string.charAt(++n);
                }
                stringBuffer.append(c);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InternetAddress)) {
            return false;
        }
        String string = ((InternetAddress)object).getAddress();
        if (string == this.address) {
            return true;
        }
        return this.address != null && this.address.equalsIgnoreCase(string);
    }

    public int hashCode() {
        if (this.address == null) {
            return 0;
        }
        return this.address.toLowerCase().hashCode();
    }

    public static String toString(Address[] addressArray) {
        return InternetAddress.toString(addressArray, 0);
    }

    public static String toString(Address[] addressArray, int n) {
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < addressArray.length) {
            String string;
            int n3;
            if (n2 != 0) {
                stringBuffer.append(", ");
                n += 2;
            }
            if (n + (n3 = InternetAddress.lengthOfFirstSegment(string = addressArray[n2].toString())) > 76) {
                stringBuffer.append("\r\n\t");
                n = 8;
            }
            stringBuffer.append(string);
            n = InternetAddress.lengthOfLastSegment(string, n);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static int lengthOfFirstSegment(String string) {
        int n = string.indexOf("\r\n");
        if (n != -1) {
            return n;
        }
        return string.length();
    }

    private static int lengthOfLastSegment(String string, int n) {
        int n2 = string.lastIndexOf("\r\n");
        if (n2 != -1) {
            return string.length() - n2 - 2;
        }
        return string.length() + n;
    }

    public static InternetAddress getLocalAddress(Session session) {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            if (session == null) {
                string = System.getProperty("user.name");
                string2 = InetAddress.getLocalHost().getHostName();
            } else {
                string3 = session.getProperty("mail.from");
                if (string3 == null) {
                    InetAddress inetAddress;
                    string = session.getProperty("mail.user");
                    if (string == null || string.length() == 0) {
                        string = session.getProperty("user.name");
                    }
                    if (string == null || string.length() == 0) {
                        string = System.getProperty("user.name");
                    }
                    if (((string2 = session.getProperty("mail.host")) == null || string2.length() == 0) && (inetAddress = InetAddress.getLocalHost()) != null) {
                        string2 = inetAddress.getHostName();
                    }
                }
            }
            if (string3 == null && string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                string3 = string + "@" + string2;
            }
            if (string3 != null) {
                return new InternetAddress(string3);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (AddressException addressException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InternetAddress[] parse(String string) throws AddressException {
        return InternetAddress.parse(string, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static InternetAddress[] parse(String string, boolean bl) throws AddressException {
        Object object;
        InternetAddress internetAddress;
        Object object2;
        int n = -1;
        int n2 = -1;
        int n3 = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Vector<InternetAddress> vector = new Vector<InternetAddress>();
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n3) {
            char c = string.charAt(n6);
            switch (c) {
                case '(': {
                    bl4 = true;
                    if (n5 >= 0 && n4 == -1) {
                        n4 = n6;
                    }
                    if (n == -1) {
                        n = n6 + 1;
                    }
                    ++n6;
                    int n7 = 1;
                    while (true) {
                        if (n6 >= n3 || n7 <= 0) {
                            if (n7 <= 0) break;
                            throw new AddressException("Missing ')'", string, n6);
                        }
                        c = string.charAt(n6);
                        switch (c) {
                            case '\\': {
                                ++n6;
                                break;
                            }
                            case '(': {
                                ++n7;
                                break;
                            }
                            case ')': {
                                --n7;
                                break;
                            }
                        }
                        ++n6;
                    }
                    --n6;
                    if (n2 != -1) break;
                    n2 = n6;
                    break;
                }
                case ')': {
                    throw new AddressException("Missing '('", string, n6);
                }
                case '<': {
                    bl4 = true;
                    if (bl3) {
                        throw new AddressException("Extra route-addr", string, n6);
                    }
                    if (!bl2) {
                        n = n5;
                        if (n >= 0) {
                            n2 = n6;
                        }
                        n5 = n6 + 1;
                    }
                    boolean bl5 = false;
                    ++n6;
                    block32: while (n6 < n3) {
                        c = string.charAt(n6);
                        switch (c) {
                            case '\\': {
                                ++n6;
                                break;
                            }
                            case '\"': {
                                bl5 = !bl5;
                                break;
                            }
                            case '>': {
                                if (!bl5) break block32;
                            }
                        }
                        ++n6;
                    }
                    if (n6 >= n3) {
                        if (bl5) {
                            throw new AddressException("Missing '\"'", string, n6);
                        }
                        throw new AddressException("Missing '>'", string, n6);
                    }
                    bl3 = true;
                    n4 = n6;
                    break;
                }
                case '>': {
                    throw new AddressException("Missing '<'", string, n6);
                }
                case '\"': {
                    bl4 = true;
                    if (n5 == -1) {
                        n5 = n6;
                    }
                    ++n6;
                    block33: while (n6 < n3) {
                        c = string.charAt(n6);
                        switch (c) {
                            case '\\': {
                                ++n6;
                                break;
                            }
                            case '\"': {
                                break block33;
                            }
                        }
                        ++n6;
                    }
                    if (n6 < n3) break;
                    throw new AddressException("Missing '\"'", string, n6);
                }
                case '[': {
                    bl4 = true;
                    ++n6;
                    block34: while (n6 < n3) {
                        c = string.charAt(n6);
                        switch (c) {
                            case '\\': {
                                ++n6;
                                break;
                            }
                            case ']': {
                                break block34;
                            }
                        }
                        ++n6;
                    }
                    if (n6 < n3) break;
                    throw new AddressException("Missing ']'", string, n6);
                }
                case ',': {
                    if (n5 == -1) {
                        bl3 = false;
                        bl4 = false;
                        n4 = -1;
                        n5 = -1;
                        break;
                    }
                    if (bl2) break;
                    if (n4 == -1) {
                        n4 = n6;
                    }
                    object2 = string.substring(n5, n4).trim();
                    if (bl4 || bl) {
                        InternetAddress.checkAddress((String)object2, bl3, bl);
                        internetAddress = new InternetAddress();
                        internetAddress.setAddress((String)object2);
                        if (n >= 0) {
                            internetAddress.encodedPersonal = InternetAddress.unquote(string.substring(n, n2).trim());
                            n2 = -1;
                            n = -1;
                        }
                        vector.addElement(internetAddress);
                    } else {
                        object = new StringTokenizer((String)object2);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            String string2 = ((StringTokenizer)object).nextToken();
                            InternetAddress.checkAddress(string2, false, bl);
                            internetAddress = new InternetAddress();
                            internetAddress.setAddress(string2);
                            vector.addElement(internetAddress);
                        }
                    }
                    bl3 = false;
                    bl4 = false;
                    n4 = -1;
                    n5 = -1;
                    break;
                }
                case ':': {
                    bl4 = true;
                    if (bl2) {
                        throw new AddressException("Nested group", string, n6);
                    }
                    bl2 = true;
                    break;
                }
                case ';': {
                    if (!bl2) {
                        throw new AddressException("Illegal semicolon, not in group", string, n6);
                    }
                    bl2 = false;
                    internetAddress = new InternetAddress();
                    n4 = n6 + 1;
                    internetAddress.setAddress(string.substring(n5, n4).trim());
                    vector.addElement(internetAddress);
                    bl3 = false;
                    n4 = -1;
                    n5 = -1;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    if (n5 != -1) break;
                    n5 = n6;
                }
            }
            ++n6;
        }
        if (n5 >= 0) {
            if (n4 == -1) {
                n4 = n6;
            }
            String string3 = string.substring(n5, n4).trim();
            if (bl4 || bl) {
                InternetAddress.checkAddress(string3, bl3, bl);
                internetAddress = new InternetAddress();
                internetAddress.setAddress(string3);
                if (n >= 0) {
                    internetAddress.encodedPersonal = InternetAddress.unquote(string.substring(n, n2).trim());
                }
                vector.addElement(internetAddress);
            } else {
                object2 = new StringTokenizer(string3);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    InternetAddress.checkAddress((String)object, false, bl);
                    internetAddress = new InternetAddress();
                    internetAddress.setAddress((String)object);
                    vector.addElement(internetAddress);
                }
            }
        }
        Object[] objectArray = new InternetAddress[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void checkAddress(String string, boolean bl, boolean bl2) throws AddressException {
        String string2;
        String string3;
        int n;
        int n2 = 0;
        if (string.indexOf(34) >= 0) {
            return;
        }
        if (!bl2 || bl) {
            n2 = 0;
            while ((n = InternetAddress.indexOfAny(string, ",:", n2)) >= 0) {
                if (string.charAt(n2) != '@') {
                    throw new AddressException("Illegal route-addr", string);
                }
                if (string.charAt(n) == ':') {
                    n2 = n + 1;
                    break;
                }
                n2 = n + 1;
            }
        }
        if ((n = string.indexOf(64, n2)) >= 0) {
            if (n == n2) {
                throw new AddressException("Missing local name", string);
            }
            if (n == string.length() - 1) {
                throw new AddressException("Missing domain", string);
            }
            string3 = string.substring(n2, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = null;
        }
        if (InternetAddress.indexOfAny(string, " \t\n\r") >= 0) {
            throw new AddressException("Illegal whitespace in address", string);
        }
        if (InternetAddress.indexOfAny(string3, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in local name", string);
        }
        if (string2 != null && string2.indexOf(91) < 0 && InternetAddress.indexOfAny(string2, specialsNoDot) >= 0) {
            throw new AddressException("Illegal character in domain", string);
        }
    }

    private boolean isSimple() {
        return InternetAddress.indexOfAny(this.address, specialsNoDotNoAt) < 0;
    }

    private boolean isGroup() {
        return this.address.endsWith(";") && this.address.indexOf(58) > 0;
    }

    private static int indexOfAny(String string, String string2) {
        return InternetAddress.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n) {
        try {
            int n2 = string.length();
            int n3 = n;
            while (n3 < n2) {
                if (string2.indexOf(string.charAt(n3)) >= 0) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }
}

