/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    protected DataSource ds = null;
    protected boolean parsed = true;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        ContentType contentType = new ContentType("multipart", string, null);
        contentType.setParameter("boundary", string2);
        this.contentType = contentType.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        if (dataSource instanceof MessageAware) {
            MessageContext messageContext = ((MessageAware)((Object)dataSource)).getMessageContext();
            this.setParent(messageContext.getPart());
        }
        if (dataSource instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)dataSource);
            return;
        }
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = dataSource.getContentType();
    }

    public synchronized void setSubType(String string) throws MessagingException {
        ContentType contentType = new ContentType(this.contentType);
        contentType.setSubType(string);
        this.contentType = contentType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int n) throws MessagingException {
        this.parse();
        return super.getBodyPart(n);
    }

    public synchronized BodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n = this.getCount();
        int n2 = 0;
        while (n2 < n) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)this.getBodyPart(n2);
            String string2 = mimeBodyPart.getContentID();
            if (string2 != null && string2.equals(string)) {
                return mimeBodyPart;
            }
            ++n2;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        int n = 0;
        while (n < this.parts.size()) {
            ((MimeBodyPart)this.parts.elementAt(n)).updateHeaders();
            ++n;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        int n = 0;
        while (n < this.parts.size()) {
            lineOutputStream.writeln(string);
            ((MimeBodyPart)this.parts.elementAt(n)).writeTo(outputStream);
            lineOutputStream.writeln();
            ++n;
        }
        lineOutputStream.writeln(string + "--");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = "--" + contentType.getParameter("boundary");
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        try {
            String string2;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            while ((string2 = lineInputStream.readLine()) != null && !string2.trim().equals(string)) {
            }
            if (string2 == null) {
                throw new MessagingException("Missing start boundary");
            }
            boolean bl = false;
            while (!bl) {
                InternetHeaders internetHeaders = null;
                if (sharedInputStream != null) {
                    l = sharedInputStream.getPosition();
                    while ((string2 = lineInputStream.readLine()) != null && string2.length() > 0) {
                    }
                    if (string2 == null) {
                        throw new MessagingException("EOF skipping headers");
                    }
                } else {
                    internetHeaders = this.createInternetHeaders(inputStream);
                }
                if (!inputStream.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream byteArrayOutputStream = null;
                if (sharedInputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                boolean bl2 = true;
                int n2 = -1;
                int n3 = -1;
                block7: while (true) {
                    int n4;
                    if (bl2) {
                        inputStream.mark(n + 4 + 1000);
                        int n5 = 0;
                        while (n5 < n && inputStream.read() == byArray[n5]) {
                            ++n5;
                        }
                        if (n5 == n) {
                            int n6 = inputStream.read();
                            if (n6 == 45 && inputStream.read() == 45) {
                                bl = true;
                                break;
                            }
                            while (true) {
                                if (n6 != 32 && n6 != 9) {
                                    if (n6 != 10) break;
                                    break block7;
                                }
                                n6 = inputStream.read();
                            }
                            if (n6 == 13) {
                                inputStream.mark(1);
                                if (inputStream.read() == 10) break;
                                inputStream.reset();
                                break;
                            }
                        }
                        inputStream.reset();
                        if (byteArrayOutputStream != null && n2 != -1) {
                            byteArrayOutputStream.write(n2);
                            if (n3 != -1) {
                                byteArrayOutputStream.write(n3);
                            }
                            n3 = -1;
                            n2 = -1;
                        }
                    }
                    if ((n4 = inputStream.read()) < 0) {
                        bl = true;
                        break;
                    }
                    if (n4 == 13 || n4 == 10) {
                        bl2 = true;
                        if (sharedInputStream != null) {
                            l2 = sharedInputStream.getPosition() - 1L;
                        }
                        n2 = n4;
                        if (n4 != 13) continue;
                        inputStream.mark(1);
                        n4 = inputStream.read();
                        if (n4 == 10) {
                            n3 = n4;
                            continue;
                        }
                        inputStream.reset();
                        continue;
                    }
                    bl2 = false;
                    if (byteArrayOutputStream == null) continue;
                    byteArrayOutputStream.write(n4);
                }
                MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l, l2)) : this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                this.addBodyPart(mimeBodyPart);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IO Error", iOException);
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        return new MimeBodyPart(internetHeaders, byArray);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }
}

